# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZeroTrustTunnelCloudflaredRoutesResult',
    'AwaitableGetZeroTrustTunnelCloudflaredRoutesResult',
    'get_zero_trust_tunnel_cloudflared_routes',
    'get_zero_trust_tunnel_cloudflared_routes_output',
]

@pulumi.output_type
class GetZeroTrustTunnelCloudflaredRoutesResult:
    """
    A collection of values returned by getZeroTrustTunnelCloudflaredRoutes.
    """
    def __init__(__self__, account_id=None, comment=None, existed_at=None, id=None, is_deleted=None, max_items=None, network_subset=None, network_superset=None, results=None, route_id=None, tun_types=None, tunnel_id=None, virtual_network_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if existed_at and not isinstance(existed_at, str):
            raise TypeError("Expected argument 'existed_at' to be a str")
        pulumi.set(__self__, "existed_at", existed_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_deleted and not isinstance(is_deleted, bool):
            raise TypeError("Expected argument 'is_deleted' to be a bool")
        pulumi.set(__self__, "is_deleted", is_deleted)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if network_subset and not isinstance(network_subset, str):
            raise TypeError("Expected argument 'network_subset' to be a str")
        pulumi.set(__self__, "network_subset", network_subset)
        if network_superset and not isinstance(network_superset, str):
            raise TypeError("Expected argument 'network_superset' to be a str")
        pulumi.set(__self__, "network_superset", network_superset)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if route_id and not isinstance(route_id, str):
            raise TypeError("Expected argument 'route_id' to be a str")
        pulumi.set(__self__, "route_id", route_id)
        if tun_types and not isinstance(tun_types, list):
            raise TypeError("Expected argument 'tun_types' to be a list")
        pulumi.set(__self__, "tun_types", tun_types)
        if tunnel_id and not isinstance(tunnel_id, str):
            raise TypeError("Expected argument 'tunnel_id' to be a str")
        pulumi.set(__self__, "tunnel_id", tunnel_id)
        if virtual_network_id and not isinstance(virtual_network_id, str):
            raise TypeError("Expected argument 'virtual_network_id' to be a str")
        pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def comment(self) -> Optional[builtins.str]:
        """
        Optional remark describing the route.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="existedAt")
    def existed_at(self) -> Optional[builtins.str]:
        """
        If provided, include only resources that were created (and not deleted) before this time. URL encoded.
        """
        return pulumi.get(self, "existed_at")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDeleted")
    def is_deleted(self) -> Optional[builtins.bool]:
        """
        If `true`, only include deleted routes. If `false`, exclude deleted routes. If empty, all routes will be included.
        """
        return pulumi.get(self, "is_deleted")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter(name="networkSubset")
    def network_subset(self) -> Optional[builtins.str]:
        """
        If set, only list routes that are contained within this IP range.
        """
        return pulumi.get(self, "network_subset")

    @property
    @pulumi.getter(name="networkSuperset")
    def network_superset(self) -> Optional[builtins.str]:
        """
        If set, only list routes that contain this IP range.
        """
        return pulumi.get(self, "network_superset")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetZeroTrustTunnelCloudflaredRoutesResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="routeId")
    def route_id(self) -> Optional[builtins.str]:
        """
        UUID of the route.
        """
        return pulumi.get(self, "route_id")

    @property
    @pulumi.getter(name="tunTypes")
    def tun_types(self) -> Optional[Sequence[builtins.str]]:
        """
        The types of tunnels to filter by, separated by commas.
        """
        return pulumi.get(self, "tun_types")

    @property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> Optional[builtins.str]:
        """
        UUID of the tunnel.
        """
        return pulumi.get(self, "tunnel_id")

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[builtins.str]:
        """
        UUID of the virtual network.
        """
        return pulumi.get(self, "virtual_network_id")


class AwaitableGetZeroTrustTunnelCloudflaredRoutesResult(GetZeroTrustTunnelCloudflaredRoutesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZeroTrustTunnelCloudflaredRoutesResult(
            account_id=self.account_id,
            comment=self.comment,
            existed_at=self.existed_at,
            id=self.id,
            is_deleted=self.is_deleted,
            max_items=self.max_items,
            network_subset=self.network_subset,
            network_superset=self.network_superset,
            results=self.results,
            route_id=self.route_id,
            tun_types=self.tun_types,
            tunnel_id=self.tunnel_id,
            virtual_network_id=self.virtual_network_id)


def get_zero_trust_tunnel_cloudflared_routes(account_id: Optional[builtins.str] = None,
                                             comment: Optional[builtins.str] = None,
                                             existed_at: Optional[builtins.str] = None,
                                             is_deleted: Optional[builtins.bool] = None,
                                             max_items: Optional[builtins.int] = None,
                                             network_subset: Optional[builtins.str] = None,
                                             network_superset: Optional[builtins.str] = None,
                                             route_id: Optional[builtins.str] = None,
                                             tun_types: Optional[Sequence[builtins.str]] = None,
                                             tunnel_id: Optional[builtins.str] = None,
                                             virtual_network_id: Optional[builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZeroTrustTunnelCloudflaredRoutesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_tunnel_cloudflared_routes = cloudflare.get_zero_trust_tunnel_cloudflared_routes(account_id="699d98642c564d2e855e9661899b7252",
        comment="Example comment for this route.",
        existed_at="2019-10-12T07%3A20%3A50.52Z",
        is_deleted=True,
        network_subset="172.16.0.0/16",
        network_superset="172.16.0.0/16",
        route_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
        tun_types=["cfd_tunnel"],
        tunnel_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
        virtual_network_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415")
    ```


    :param builtins.str account_id: Cloudflare account ID
    :param builtins.str comment: Optional remark describing the route.
    :param builtins.str existed_at: If provided, include only resources that were created (and not deleted) before this time. URL encoded.
    :param builtins.bool is_deleted: If `true`, only include deleted routes. If `false`, exclude deleted routes. If empty, all routes will be included.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str network_subset: If set, only list routes that are contained within this IP range.
    :param builtins.str network_superset: If set, only list routes that contain this IP range.
    :param builtins.str route_id: UUID of the route.
    :param Sequence[builtins.str] tun_types: The types of tunnels to filter by, separated by commas.
    :param builtins.str tunnel_id: UUID of the tunnel.
    :param builtins.str virtual_network_id: UUID of the virtual network.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['comment'] = comment
    __args__['existedAt'] = existed_at
    __args__['isDeleted'] = is_deleted
    __args__['maxItems'] = max_items
    __args__['networkSubset'] = network_subset
    __args__['networkSuperset'] = network_superset
    __args__['routeId'] = route_id
    __args__['tunTypes'] = tun_types
    __args__['tunnelId'] = tunnel_id
    __args__['virtualNetworkId'] = virtual_network_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZeroTrustTunnelCloudflaredRoutes:getZeroTrustTunnelCloudflaredRoutes', __args__, opts=opts, typ=GetZeroTrustTunnelCloudflaredRoutesResult).value

    return AwaitableGetZeroTrustTunnelCloudflaredRoutesResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        comment=pulumi.get(__ret__, 'comment'),
        existed_at=pulumi.get(__ret__, 'existed_at'),
        id=pulumi.get(__ret__, 'id'),
        is_deleted=pulumi.get(__ret__, 'is_deleted'),
        max_items=pulumi.get(__ret__, 'max_items'),
        network_subset=pulumi.get(__ret__, 'network_subset'),
        network_superset=pulumi.get(__ret__, 'network_superset'),
        results=pulumi.get(__ret__, 'results'),
        route_id=pulumi.get(__ret__, 'route_id'),
        tun_types=pulumi.get(__ret__, 'tun_types'),
        tunnel_id=pulumi.get(__ret__, 'tunnel_id'),
        virtual_network_id=pulumi.get(__ret__, 'virtual_network_id'))
def get_zero_trust_tunnel_cloudflared_routes_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                                    comment: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                    existed_at: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                    is_deleted: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                                    max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                                    network_subset: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                    network_superset: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                    route_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                    tun_types: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                                    tunnel_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                    virtual_network_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZeroTrustTunnelCloudflaredRoutesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zero_trust_tunnel_cloudflared_routes = cloudflare.get_zero_trust_tunnel_cloudflared_routes(account_id="699d98642c564d2e855e9661899b7252",
        comment="Example comment for this route.",
        existed_at="2019-10-12T07%3A20%3A50.52Z",
        is_deleted=True,
        network_subset="172.16.0.0/16",
        network_superset="172.16.0.0/16",
        route_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
        tun_types=["cfd_tunnel"],
        tunnel_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
        virtual_network_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415")
    ```


    :param builtins.str account_id: Cloudflare account ID
    :param builtins.str comment: Optional remark describing the route.
    :param builtins.str existed_at: If provided, include only resources that were created (and not deleted) before this time. URL encoded.
    :param builtins.bool is_deleted: If `true`, only include deleted routes. If `false`, exclude deleted routes. If empty, all routes will be included.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str network_subset: If set, only list routes that are contained within this IP range.
    :param builtins.str network_superset: If set, only list routes that contain this IP range.
    :param builtins.str route_id: UUID of the route.
    :param Sequence[builtins.str] tun_types: The types of tunnels to filter by, separated by commas.
    :param builtins.str tunnel_id: UUID of the tunnel.
    :param builtins.str virtual_network_id: UUID of the virtual network.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['comment'] = comment
    __args__['existedAt'] = existed_at
    __args__['isDeleted'] = is_deleted
    __args__['maxItems'] = max_items
    __args__['networkSubset'] = network_subset
    __args__['networkSuperset'] = network_superset
    __args__['routeId'] = route_id
    __args__['tunTypes'] = tun_types
    __args__['tunnelId'] = tunnel_id
    __args__['virtualNetworkId'] = virtual_network_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZeroTrustTunnelCloudflaredRoutes:getZeroTrustTunnelCloudflaredRoutes', __args__, opts=opts, typ=GetZeroTrustTunnelCloudflaredRoutesResult)
    return __ret__.apply(lambda __response__: GetZeroTrustTunnelCloudflaredRoutesResult(
        account_id=pulumi.get(__response__, 'account_id'),
        comment=pulumi.get(__response__, 'comment'),
        existed_at=pulumi.get(__response__, 'existed_at'),
        id=pulumi.get(__response__, 'id'),
        is_deleted=pulumi.get(__response__, 'is_deleted'),
        max_items=pulumi.get(__response__, 'max_items'),
        network_subset=pulumi.get(__response__, 'network_subset'),
        network_superset=pulumi.get(__response__, 'network_superset'),
        results=pulumi.get(__response__, 'results'),
        route_id=pulumi.get(__response__, 'route_id'),
        tun_types=pulumi.get(__response__, 'tun_types'),
        tunnel_id=pulumi.get(__response__, 'tunnel_id'),
        virtual_network_id=pulumi.get(__response__, 'virtual_network_id')))
