# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetZoneResult',
    'AwaitableGetZoneResult',
    'get_zone',
    'get_zone_output',
]

@pulumi.output_type
class GetZoneResult:
    """
    A collection of values returned by getZone.
    """
    def __init__(__self__, account=None, activated_on=None, cname_suffix=None, created_on=None, development_mode=None, filter=None, id=None, meta=None, modified_on=None, name=None, name_servers=None, original_dnshost=None, original_name_servers=None, original_registrar=None, owner=None, paused=None, permissions=None, plan=None, status=None, tenant=None, tenant_unit=None, type=None, vanity_name_servers=None, verification_key=None, zone_id=None):
        if account and not isinstance(account, dict):
            raise TypeError("Expected argument 'account' to be a dict")
        pulumi.set(__self__, "account", account)
        if activated_on and not isinstance(activated_on, str):
            raise TypeError("Expected argument 'activated_on' to be a str")
        pulumi.set(__self__, "activated_on", activated_on)
        if cname_suffix and not isinstance(cname_suffix, str):
            raise TypeError("Expected argument 'cname_suffix' to be a str")
        pulumi.set(__self__, "cname_suffix", cname_suffix)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if development_mode and not isinstance(development_mode, float):
            raise TypeError("Expected argument 'development_mode' to be a float")
        pulumi.set(__self__, "development_mode", development_mode)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if meta and not isinstance(meta, dict):
            raise TypeError("Expected argument 'meta' to be a dict")
        pulumi.set(__self__, "meta", meta)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_servers and not isinstance(name_servers, list):
            raise TypeError("Expected argument 'name_servers' to be a list")
        pulumi.set(__self__, "name_servers", name_servers)
        if original_dnshost and not isinstance(original_dnshost, str):
            raise TypeError("Expected argument 'original_dnshost' to be a str")
        pulumi.set(__self__, "original_dnshost", original_dnshost)
        if original_name_servers and not isinstance(original_name_servers, list):
            raise TypeError("Expected argument 'original_name_servers' to be a list")
        pulumi.set(__self__, "original_name_servers", original_name_servers)
        if original_registrar and not isinstance(original_registrar, str):
            raise TypeError("Expected argument 'original_registrar' to be a str")
        pulumi.set(__self__, "original_registrar", original_registrar)
        if owner and not isinstance(owner, dict):
            raise TypeError("Expected argument 'owner' to be a dict")
        pulumi.set(__self__, "owner", owner)
        if paused and not isinstance(paused, bool):
            raise TypeError("Expected argument 'paused' to be a bool")
        pulumi.set(__self__, "paused", paused)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if plan and not isinstance(plan, dict):
            raise TypeError("Expected argument 'plan' to be a dict")
        pulumi.set(__self__, "plan", plan)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tenant and not isinstance(tenant, dict):
            raise TypeError("Expected argument 'tenant' to be a dict")
        pulumi.set(__self__, "tenant", tenant)
        if tenant_unit and not isinstance(tenant_unit, dict):
            raise TypeError("Expected argument 'tenant_unit' to be a dict")
        pulumi.set(__self__, "tenant_unit", tenant_unit)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vanity_name_servers and not isinstance(vanity_name_servers, list):
            raise TypeError("Expected argument 'vanity_name_servers' to be a list")
        pulumi.set(__self__, "vanity_name_servers", vanity_name_servers)
        if verification_key and not isinstance(verification_key, str):
            raise TypeError("Expected argument 'verification_key' to be a str")
        pulumi.set(__self__, "verification_key", verification_key)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def account(self) -> 'outputs.GetZoneAccountResult':
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="activatedOn")
    def activated_on(self) -> builtins.str:
        return pulumi.get(self, "activated_on")

    @property
    @pulumi.getter(name="cnameSuffix")
    def cname_suffix(self) -> builtins.str:
        return pulumi.get(self, "cname_suffix")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> builtins.str:
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="developmentMode")
    def development_mode(self) -> builtins.float:
        return pulumi.get(self, "development_mode")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetZoneFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def meta(self) -> 'outputs.GetZoneMetaResult':
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> builtins.str:
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "name_servers")

    @property
    @pulumi.getter(name="originalDnshost")
    def original_dnshost(self) -> builtins.str:
        return pulumi.get(self, "original_dnshost")

    @property
    @pulumi.getter(name="originalNameServers")
    def original_name_servers(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "original_name_servers")

    @property
    @pulumi.getter(name="originalRegistrar")
    def original_registrar(self) -> builtins.str:
        return pulumi.get(self, "original_registrar")

    @property
    @pulumi.getter
    def owner(self) -> 'outputs.GetZoneOwnerResult':
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def paused(self) -> builtins.bool:
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def permissions(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def plan(self) -> 'outputs.GetZonePlanResult':
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tenant(self) -> 'outputs.GetZoneTenantResult':
        return pulumi.get(self, "tenant")

    @property
    @pulumi.getter(name="tenantUnit")
    def tenant_unit(self) -> 'outputs.GetZoneTenantUnitResult':
        return pulumi.get(self, "tenant_unit")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vanityNameServers")
    def vanity_name_servers(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "vanity_name_servers")

    @property
    @pulumi.getter(name="verificationKey")
    def verification_key(self) -> builtins.str:
        return pulumi.get(self, "verification_key")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "zone_id")


class AwaitableGetZoneResult(GetZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneResult(
            account=self.account,
            activated_on=self.activated_on,
            cname_suffix=self.cname_suffix,
            created_on=self.created_on,
            development_mode=self.development_mode,
            filter=self.filter,
            id=self.id,
            meta=self.meta,
            modified_on=self.modified_on,
            name=self.name,
            name_servers=self.name_servers,
            original_dnshost=self.original_dnshost,
            original_name_servers=self.original_name_servers,
            original_registrar=self.original_registrar,
            owner=self.owner,
            paused=self.paused,
            permissions=self.permissions,
            plan=self.plan,
            status=self.status,
            tenant=self.tenant,
            tenant_unit=self.tenant_unit,
            type=self.type,
            vanity_name_servers=self.vanity_name_servers,
            verification_key=self.verification_key,
            zone_id=self.zone_id)


def get_zone(filter: Optional[Union['GetZoneFilterArgs', 'GetZoneFilterArgsDict']] = None,
             zone_id: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone = cloudflare.get_zone(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZone:getZone', __args__, opts=opts, typ=GetZoneResult).value

    return AwaitableGetZoneResult(
        account=pulumi.get(__ret__, 'account'),
        activated_on=pulumi.get(__ret__, 'activated_on'),
        cname_suffix=pulumi.get(__ret__, 'cname_suffix'),
        created_on=pulumi.get(__ret__, 'created_on'),
        development_mode=pulumi.get(__ret__, 'development_mode'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        meta=pulumi.get(__ret__, 'meta'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        name=pulumi.get(__ret__, 'name'),
        name_servers=pulumi.get(__ret__, 'name_servers'),
        original_dnshost=pulumi.get(__ret__, 'original_dnshost'),
        original_name_servers=pulumi.get(__ret__, 'original_name_servers'),
        original_registrar=pulumi.get(__ret__, 'original_registrar'),
        owner=pulumi.get(__ret__, 'owner'),
        paused=pulumi.get(__ret__, 'paused'),
        permissions=pulumi.get(__ret__, 'permissions'),
        plan=pulumi.get(__ret__, 'plan'),
        status=pulumi.get(__ret__, 'status'),
        tenant=pulumi.get(__ret__, 'tenant'),
        tenant_unit=pulumi.get(__ret__, 'tenant_unit'),
        type=pulumi.get(__ret__, 'type'),
        vanity_name_servers=pulumi.get(__ret__, 'vanity_name_servers'),
        verification_key=pulumi.get(__ret__, 'verification_key'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zone_output(filter: Optional[pulumi.Input[Optional[Union['GetZoneFilterArgs', 'GetZoneFilterArgsDict']]]] = None,
                    zone_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone = cloudflare.get_zone(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZone:getZone', __args__, opts=opts, typ=GetZoneResult)
    return __ret__.apply(lambda __response__: GetZoneResult(
        account=pulumi.get(__response__, 'account'),
        activated_on=pulumi.get(__response__, 'activated_on'),
        cname_suffix=pulumi.get(__response__, 'cname_suffix'),
        created_on=pulumi.get(__response__, 'created_on'),
        development_mode=pulumi.get(__response__, 'development_mode'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        meta=pulumi.get(__response__, 'meta'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        name=pulumi.get(__response__, 'name'),
        name_servers=pulumi.get(__response__, 'name_servers'),
        original_dnshost=pulumi.get(__response__, 'original_dnshost'),
        original_name_servers=pulumi.get(__response__, 'original_name_servers'),
        original_registrar=pulumi.get(__response__, 'original_registrar'),
        owner=pulumi.get(__response__, 'owner'),
        paused=pulumi.get(__response__, 'paused'),
        permissions=pulumi.get(__response__, 'permissions'),
        plan=pulumi.get(__response__, 'plan'),
        status=pulumi.get(__response__, 'status'),
        tenant=pulumi.get(__response__, 'tenant'),
        tenant_unit=pulumi.get(__response__, 'tenant_unit'),
        type=pulumi.get(__response__, 'type'),
        vanity_name_servers=pulumi.get(__response__, 'vanity_name_servers'),
        verification_key=pulumi.get(__response__, 'verification_key'),
        zone_id=pulumi.get(__response__, 'zone_id')))
