# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZoneDnsSettingsResult',
    'AwaitableGetZoneDnsSettingsResult',
    'get_zone_dns_settings',
    'get_zone_dns_settings_output',
]

@pulumi.output_type
class GetZoneDnsSettingsResult:
    """
    A collection of values returned by getZoneDnsSettings.
    """
    def __init__(__self__, flatten_all_cnames=None, foundation_dns=None, id=None, internal_dns=None, multi_provider=None, nameservers=None, ns_ttl=None, secondary_overrides=None, soa=None, zone_id=None, zone_mode=None):
        if flatten_all_cnames and not isinstance(flatten_all_cnames, bool):
            raise TypeError("Expected argument 'flatten_all_cnames' to be a bool")
        pulumi.set(__self__, "flatten_all_cnames", flatten_all_cnames)
        if foundation_dns and not isinstance(foundation_dns, bool):
            raise TypeError("Expected argument 'foundation_dns' to be a bool")
        pulumi.set(__self__, "foundation_dns", foundation_dns)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_dns and not isinstance(internal_dns, dict):
            raise TypeError("Expected argument 'internal_dns' to be a dict")
        pulumi.set(__self__, "internal_dns", internal_dns)
        if multi_provider and not isinstance(multi_provider, bool):
            raise TypeError("Expected argument 'multi_provider' to be a bool")
        pulumi.set(__self__, "multi_provider", multi_provider)
        if nameservers and not isinstance(nameservers, dict):
            raise TypeError("Expected argument 'nameservers' to be a dict")
        pulumi.set(__self__, "nameservers", nameservers)
        if ns_ttl and not isinstance(ns_ttl, float):
            raise TypeError("Expected argument 'ns_ttl' to be a float")
        pulumi.set(__self__, "ns_ttl", ns_ttl)
        if secondary_overrides and not isinstance(secondary_overrides, bool):
            raise TypeError("Expected argument 'secondary_overrides' to be a bool")
        pulumi.set(__self__, "secondary_overrides", secondary_overrides)
        if soa and not isinstance(soa, dict):
            raise TypeError("Expected argument 'soa' to be a dict")
        pulumi.set(__self__, "soa", soa)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)
        if zone_mode and not isinstance(zone_mode, str):
            raise TypeError("Expected argument 'zone_mode' to be a str")
        pulumi.set(__self__, "zone_mode", zone_mode)

    @property
    @pulumi.getter(name="flattenAllCnames")
    def flatten_all_cnames(self) -> builtins.bool:
        """
        Whether to flatten all CNAME records in the zone. Note that, due to DNS limitations, a CNAME record at the zone apex will always be flattened.
        """
        return pulumi.get(self, "flatten_all_cnames")

    @property
    @pulumi.getter(name="foundationDns")
    def foundation_dns(self) -> builtins.bool:
        """
        Whether to enable Foundation DNS Advanced Nameservers on the zone.
        """
        return pulumi.get(self, "foundation_dns")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalDns")
    def internal_dns(self) -> 'outputs.GetZoneDnsSettingsInternalDnsResult':
        """
        Settings for this internal zone.
        """
        return pulumi.get(self, "internal_dns")

    @property
    @pulumi.getter(name="multiProvider")
    def multi_provider(self) -> builtins.bool:
        """
        Whether to enable multi-provider DNS, which causes Cloudflare to activate the zone even when non-Cloudflare NS records exist, and to respect NS records at the zone apex during outbound zone transfers.
        """
        return pulumi.get(self, "multi_provider")

    @property
    @pulumi.getter
    def nameservers(self) -> 'outputs.GetZoneDnsSettingsNameserversResult':
        """
        Settings determining the nameservers through which the zone should be available.
        """
        return pulumi.get(self, "nameservers")

    @property
    @pulumi.getter(name="nsTtl")
    def ns_ttl(self) -> builtins.float:
        """
        The time to live (TTL) of the zone's nameserver (NS) records.
        """
        return pulumi.get(self, "ns_ttl")

    @property
    @pulumi.getter(name="secondaryOverrides")
    def secondary_overrides(self) -> builtins.bool:
        """
        Allows a Secondary DNS zone to use (proxied) override records and CNAME flattening at the zone apex.
        """
        return pulumi.get(self, "secondary_overrides")

    @property
    @pulumi.getter
    def soa(self) -> 'outputs.GetZoneDnsSettingsSoaResult':
        """
        Components of the zone's SOA record.
        """
        return pulumi.get(self, "soa")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @property
    @pulumi.getter(name="zoneMode")
    def zone_mode(self) -> builtins.str:
        """
        Whether the zone mode is a regular or CDN/DNS only zone.
        Available values: "standard", "cdn*only", "dns*only".
        """
        return pulumi.get(self, "zone_mode")


class AwaitableGetZoneDnsSettingsResult(GetZoneDnsSettingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneDnsSettingsResult(
            flatten_all_cnames=self.flatten_all_cnames,
            foundation_dns=self.foundation_dns,
            id=self.id,
            internal_dns=self.internal_dns,
            multi_provider=self.multi_provider,
            nameservers=self.nameservers,
            ns_ttl=self.ns_ttl,
            secondary_overrides=self.secondary_overrides,
            soa=self.soa,
            zone_id=self.zone_id,
            zone_mode=self.zone_mode)


def get_zone_dns_settings(zone_id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneDnsSettingsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone_dns_settings = cloudflare.get_zone_dns_settings(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZoneDnsSettings:getZoneDnsSettings', __args__, opts=opts, typ=GetZoneDnsSettingsResult).value

    return AwaitableGetZoneDnsSettingsResult(
        flatten_all_cnames=pulumi.get(__ret__, 'flatten_all_cnames'),
        foundation_dns=pulumi.get(__ret__, 'foundation_dns'),
        id=pulumi.get(__ret__, 'id'),
        internal_dns=pulumi.get(__ret__, 'internal_dns'),
        multi_provider=pulumi.get(__ret__, 'multi_provider'),
        nameservers=pulumi.get(__ret__, 'nameservers'),
        ns_ttl=pulumi.get(__ret__, 'ns_ttl'),
        secondary_overrides=pulumi.get(__ret__, 'secondary_overrides'),
        soa=pulumi.get(__ret__, 'soa'),
        zone_id=pulumi.get(__ret__, 'zone_id'),
        zone_mode=pulumi.get(__ret__, 'zone_mode'))
def get_zone_dns_settings_output(zone_id: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneDnsSettingsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone_dns_settings = cloudflare.get_zone_dns_settings(zone_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZoneDnsSettings:getZoneDnsSettings', __args__, opts=opts, typ=GetZoneDnsSettingsResult)
    return __ret__.apply(lambda __response__: GetZoneDnsSettingsResult(
        flatten_all_cnames=pulumi.get(__response__, 'flatten_all_cnames'),
        foundation_dns=pulumi.get(__response__, 'foundation_dns'),
        id=pulumi.get(__response__, 'id'),
        internal_dns=pulumi.get(__response__, 'internal_dns'),
        multi_provider=pulumi.get(__response__, 'multi_provider'),
        nameservers=pulumi.get(__response__, 'nameservers'),
        ns_ttl=pulumi.get(__response__, 'ns_ttl'),
        secondary_overrides=pulumi.get(__response__, 'secondary_overrides'),
        soa=pulumi.get(__response__, 'soa'),
        zone_id=pulumi.get(__response__, 'zone_id'),
        zone_mode=pulumi.get(__response__, 'zone_mode')))
