# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetZoneLockdownResult',
    'AwaitableGetZoneLockdownResult',
    'get_zone_lockdown',
    'get_zone_lockdown_output',
]

@pulumi.output_type
class GetZoneLockdownResult:
    """
    A collection of values returned by getZoneLockdown.
    """
    def __init__(__self__, configurations=None, created_on=None, description=None, filter=None, id=None, lock_downs_id=None, modified_on=None, paused=None, urls=None, zone_id=None):
        if configurations and not isinstance(configurations, list):
            raise TypeError("Expected argument 'configurations' to be a list")
        pulumi.set(__self__, "configurations", configurations)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lock_downs_id and not isinstance(lock_downs_id, str):
            raise TypeError("Expected argument 'lock_downs_id' to be a str")
        pulumi.set(__self__, "lock_downs_id", lock_downs_id)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if paused and not isinstance(paused, bool):
            raise TypeError("Expected argument 'paused' to be a bool")
        pulumi.set(__self__, "paused", paused)
        if urls and not isinstance(urls, list):
            raise TypeError("Expected argument 'urls' to be a list")
        pulumi.set(__self__, "urls", urls)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetZoneLockdownConfigurationResult']:
        """
        A list of IP addresses or CIDR ranges that will be allowed to access the URLs specified in the Zone Lockdown rule. You can include any number of `ip` or `ip_range` configurations.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> builtins.str:
        """
        The timestamp of when the rule was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        An informative summary of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetZoneLockdownFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The unique identifier of the Zone Lockdown rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lockDownsId")
    def lock_downs_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the Zone Lockdown rule.
        """
        return pulumi.get(self, "lock_downs_id")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> builtins.str:
        """
        The timestamp of when the rule was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def paused(self) -> builtins.bool:
        """
        When true, indicates that the rule is currently paused.
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter
    def urls(self) -> Sequence[builtins.str]:
        """
        The URLs to include in the rule definition. You can use wildcards. Each entered URL will be escaped before use, which means you can only use simple wildcard patterns.
        """
        return pulumi.get(self, "urls")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZoneLockdownResult(GetZoneLockdownResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneLockdownResult(
            configurations=self.configurations,
            created_on=self.created_on,
            description=self.description,
            filter=self.filter,
            id=self.id,
            lock_downs_id=self.lock_downs_id,
            modified_on=self.modified_on,
            paused=self.paused,
            urls=self.urls,
            zone_id=self.zone_id)


def get_zone_lockdown(filter: Optional[Union['GetZoneLockdownFilterArgs', 'GetZoneLockdownFilterArgsDict']] = None,
                      lock_downs_id: Optional[builtins.str] = None,
                      zone_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneLockdownResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone_lockdown = cloudflare.get_zone_lockdown(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        lock_downs_id="372e67954025e0ba6aaa6d586b9e0b59")
    ```


    :param builtins.str lock_downs_id: The unique identifier of the Zone Lockdown rule.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['lockDownsId'] = lock_downs_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZoneLockdown:getZoneLockdown', __args__, opts=opts, typ=GetZoneLockdownResult).value

    return AwaitableGetZoneLockdownResult(
        configurations=pulumi.get(__ret__, 'configurations'),
        created_on=pulumi.get(__ret__, 'created_on'),
        description=pulumi.get(__ret__, 'description'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        lock_downs_id=pulumi.get(__ret__, 'lock_downs_id'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        paused=pulumi.get(__ret__, 'paused'),
        urls=pulumi.get(__ret__, 'urls'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zone_lockdown_output(filter: Optional[pulumi.Input[Optional[Union['GetZoneLockdownFilterArgs', 'GetZoneLockdownFilterArgsDict']]]] = None,
                             lock_downs_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             zone_id: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneLockdownResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone_lockdown = cloudflare.get_zone_lockdown(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        lock_downs_id="372e67954025e0ba6aaa6d586b9e0b59")
    ```


    :param builtins.str lock_downs_id: The unique identifier of the Zone Lockdown rule.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['lockDownsId'] = lock_downs_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZoneLockdown:getZoneLockdown', __args__, opts=opts, typ=GetZoneLockdownResult)
    return __ret__.apply(lambda __response__: GetZoneLockdownResult(
        configurations=pulumi.get(__response__, 'configurations'),
        created_on=pulumi.get(__response__, 'created_on'),
        description=pulumi.get(__response__, 'description'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        lock_downs_id=pulumi.get(__response__, 'lock_downs_id'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        paused=pulumi.get(__response__, 'paused'),
        urls=pulumi.get(__response__, 'urls'),
        zone_id=pulumi.get(__response__, 'zone_id')))
