# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetZoneLockdownsResult',
    'AwaitableGetZoneLockdownsResult',
    'get_zone_lockdowns',
    'get_zone_lockdowns_output',
]

@pulumi.output_type
class GetZoneLockdownsResult:
    """
    A collection of values returned by getZoneLockdowns.
    """
    def __init__(__self__, created_on=None, description=None, description_search=None, id=None, ip=None, ip_range_search=None, ip_search=None, max_items=None, modified_on=None, priority=None, results=None, uri_search=None, zone_id=None):
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if description_search and not isinstance(description_search, str):
            raise TypeError("Expected argument 'description_search' to be a str")
        pulumi.set(__self__, "description_search", description_search)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if ip_range_search and not isinstance(ip_range_search, str):
            raise TypeError("Expected argument 'ip_range_search' to be a str")
        pulumi.set(__self__, "ip_range_search", ip_range_search)
        if ip_search and not isinstance(ip_search, str):
            raise TypeError("Expected argument 'ip_search' to be a str")
        pulumi.set(__self__, "ip_search", ip_search)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if priority and not isinstance(priority, float):
            raise TypeError("Expected argument 'priority' to be a float")
        pulumi.set(__self__, "priority", priority)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if uri_search and not isinstance(uri_search, str):
            raise TypeError("Expected argument 'uri_search' to be a str")
        pulumi.set(__self__, "uri_search", uri_search)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[builtins.str]:
        """
        The timestamp of when the rule was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A string to search for in the description of existing rules.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="descriptionSearch")
    def description_search(self) -> Optional[builtins.str]:
        """
        A string to search for in the description of existing rules.
        """
        return pulumi.get(self, "description_search")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> Optional[builtins.str]:
        """
        A single IP address to search for in existing rules.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipRangeSearch")
    def ip_range_search(self) -> Optional[builtins.str]:
        """
        A single IP address range to search for in existing rules.
        """
        return pulumi.get(self, "ip_range_search")

    @property
    @pulumi.getter(name="ipSearch")
    def ip_search(self) -> Optional[builtins.str]:
        """
        A single IP address to search for in existing rules.
        """
        return pulumi.get(self, "ip_search")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[builtins.str]:
        """
        The timestamp of when the rule was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def priority(self) -> Optional[builtins.float]:
        """
        The priority of the rule to control the processing order. A lower number indicates higher priority. If not provided, any rules with a configured priority will be processed before rules without a priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetZoneLockdownsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="uriSearch")
    def uri_search(self) -> Optional[builtins.str]:
        """
        A single URI to search for in the list of URLs of existing rules.
        """
        return pulumi.get(self, "uri_search")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZoneLockdownsResult(GetZoneLockdownsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneLockdownsResult(
            created_on=self.created_on,
            description=self.description,
            description_search=self.description_search,
            id=self.id,
            ip=self.ip,
            ip_range_search=self.ip_range_search,
            ip_search=self.ip_search,
            max_items=self.max_items,
            modified_on=self.modified_on,
            priority=self.priority,
            results=self.results,
            uri_search=self.uri_search,
            zone_id=self.zone_id)


def get_zone_lockdowns(created_on: Optional[builtins.str] = None,
                       description: Optional[builtins.str] = None,
                       description_search: Optional[builtins.str] = None,
                       ip: Optional[builtins.str] = None,
                       ip_range_search: Optional[builtins.str] = None,
                       ip_search: Optional[builtins.str] = None,
                       max_items: Optional[builtins.int] = None,
                       modified_on: Optional[builtins.str] = None,
                       priority: Optional[builtins.float] = None,
                       uri_search: Optional[builtins.str] = None,
                       zone_id: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneLockdownsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone_lockdowns = cloudflare.get_zone_lockdowns(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        created_on="2014-01-01T05:20:00.12345Z",
        description="endpoints",
        description_search="endpoints",
        ip="1.2.3.4",
        ip_range_search="1.2.3.0/16",
        ip_search="1.2.3.4",
        modified_on="2014-01-01T05:20:00.12345Z",
        priority=5,
        uri_search="/some/path")
    ```


    :param builtins.str created_on: The timestamp of when the rule was created.
    :param builtins.str description: A string to search for in the description of existing rules.
    :param builtins.str description_search: A string to search for in the description of existing rules.
    :param builtins.str ip: A single IP address to search for in existing rules.
    :param builtins.str ip_range_search: A single IP address range to search for in existing rules.
    :param builtins.str ip_search: A single IP address to search for in existing rules.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str modified_on: The timestamp of when the rule was last modified.
    :param builtins.float priority: The priority of the rule to control the processing order. A lower number indicates higher priority. If not provided, any rules with a configured priority will be processed before rules without a priority.
    :param builtins.str uri_search: A single URI to search for in the list of URLs of existing rules.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['createdOn'] = created_on
    __args__['description'] = description
    __args__['descriptionSearch'] = description_search
    __args__['ip'] = ip
    __args__['ipRangeSearch'] = ip_range_search
    __args__['ipSearch'] = ip_search
    __args__['maxItems'] = max_items
    __args__['modifiedOn'] = modified_on
    __args__['priority'] = priority
    __args__['uriSearch'] = uri_search
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZoneLockdowns:getZoneLockdowns', __args__, opts=opts, typ=GetZoneLockdownsResult).value

    return AwaitableGetZoneLockdownsResult(
        created_on=pulumi.get(__ret__, 'created_on'),
        description=pulumi.get(__ret__, 'description'),
        description_search=pulumi.get(__ret__, 'description_search'),
        id=pulumi.get(__ret__, 'id'),
        ip=pulumi.get(__ret__, 'ip'),
        ip_range_search=pulumi.get(__ret__, 'ip_range_search'),
        ip_search=pulumi.get(__ret__, 'ip_search'),
        max_items=pulumi.get(__ret__, 'max_items'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        priority=pulumi.get(__ret__, 'priority'),
        results=pulumi.get(__ret__, 'results'),
        uri_search=pulumi.get(__ret__, 'uri_search'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zone_lockdowns_output(created_on: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              description: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              description_search: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              ip: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              ip_range_search: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              ip_search: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                              modified_on: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              priority: Optional[pulumi.Input[Optional[builtins.float]]] = None,
                              uri_search: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              zone_id: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneLockdownsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone_lockdowns = cloudflare.get_zone_lockdowns(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        created_on="2014-01-01T05:20:00.12345Z",
        description="endpoints",
        description_search="endpoints",
        ip="1.2.3.4",
        ip_range_search="1.2.3.0/16",
        ip_search="1.2.3.4",
        modified_on="2014-01-01T05:20:00.12345Z",
        priority=5,
        uri_search="/some/path")
    ```


    :param builtins.str created_on: The timestamp of when the rule was created.
    :param builtins.str description: A string to search for in the description of existing rules.
    :param builtins.str description_search: A string to search for in the description of existing rules.
    :param builtins.str ip: A single IP address to search for in existing rules.
    :param builtins.str ip_range_search: A single IP address range to search for in existing rules.
    :param builtins.str ip_search: A single IP address to search for in existing rules.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str modified_on: The timestamp of when the rule was last modified.
    :param builtins.float priority: The priority of the rule to control the processing order. A lower number indicates higher priority. If not provided, any rules with a configured priority will be processed before rules without a priority.
    :param builtins.str uri_search: A single URI to search for in the list of URLs of existing rules.
    :param builtins.str zone_id: Defines an identifier.
    """
    __args__ = dict()
    __args__['createdOn'] = created_on
    __args__['description'] = description
    __args__['descriptionSearch'] = description_search
    __args__['ip'] = ip
    __args__['ipRangeSearch'] = ip_range_search
    __args__['ipSearch'] = ip_search
    __args__['maxItems'] = max_items
    __args__['modifiedOn'] = modified_on
    __args__['priority'] = priority
    __args__['uriSearch'] = uri_search
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZoneLockdowns:getZoneLockdowns', __args__, opts=opts, typ=GetZoneLockdownsResult)
    return __ret__.apply(lambda __response__: GetZoneLockdownsResult(
        created_on=pulumi.get(__response__, 'created_on'),
        description=pulumi.get(__response__, 'description'),
        description_search=pulumi.get(__response__, 'description_search'),
        id=pulumi.get(__response__, 'id'),
        ip=pulumi.get(__response__, 'ip'),
        ip_range_search=pulumi.get(__response__, 'ip_range_search'),
        ip_search=pulumi.get(__response__, 'ip_search'),
        max_items=pulumi.get(__response__, 'max_items'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        priority=pulumi.get(__response__, 'priority'),
        results=pulumi.get(__response__, 'results'),
        uri_search=pulumi.get(__response__, 'uri_search'),
        zone_id=pulumi.get(__response__, 'zone_id')))
