# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetZoneSettingResult',
    'AwaitableGetZoneSettingResult',
    'get_zone_setting',
    'get_zone_setting_output',
]

@pulumi.output_type
class GetZoneSettingResult:
    """
    A collection of values returned by getZoneSetting.
    """
    def __init__(__self__, editable=None, enabled=None, id=None, modified_on=None, setting_id=None, time_remaining=None, value=None, zone_id=None):
        if editable and not isinstance(editable, bool):
            raise TypeError("Expected argument 'editable' to be a bool")
        pulumi.set(__self__, "editable", editable)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if setting_id and not isinstance(setting_id, str):
            raise TypeError("Expected argument 'setting_id' to be a str")
        pulumi.set(__self__, "setting_id", setting_id)
        if time_remaining and not isinstance(time_remaining, float):
            raise TypeError("Expected argument 'time_remaining' to be a float")
        pulumi.set(__self__, "time_remaining", time_remaining)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def editable(self) -> builtins.bool:
        """
        Whether or not this setting can be modified for this zone (based on your Cloudflare plan level).
        """
        return pulumi.get(self, "editable")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        ssl-recommender enrollment setting.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the zone setting.
        Available values: "0rtt", "advanced*ddos", "aegis", "always*online", "always*use*https", "automatic*https*rewrites", "brotli", "browser*cache*ttl", "browser*check", "cache*level", "challenge*ttl", "china*network*enabled", "ciphers", "cname*flattening", "development*mode", "early*hints", "edge*cache*ttl", "email*obfuscation", "h2*prioritization", "hotlink*protection", "http2", "http3", "image*resizing", "ip*geolocation", "ipv6", "max*upload", "min*tls*version", "mirage", "nel", "opportunistic*encryption", "opportunistic*onion", "orange*to*orange", "origin*error*page*pass*thru", "origin*h2*max*streams", "origin*max*http*version", "polish", "prefetch*preload", "privacy*pass", "proxy*read*timeout", "pseudo*ipv4", "replace*insecure*js", "response*buffering", "rocket*loader", "automatic*platform*optimization", "security*header", "security*level", "server*side*exclude", "sha1*support", "sort*query*string*for*cache", "ssl", "ssl*recommender", "tls*1*2*only", "tls*1*3", "tls*client*auth", "transformations", "transformations*allowed*origins", "true*client*ip_header", "waf", "webp", "websockets".
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> builtins.str:
        """
        last time this setting was modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="settingId")
    def setting_id(self) -> builtins.str:
        """
        Setting name
        """
        return pulumi.get(self, "setting_id")

    @property
    @pulumi.getter(name="timeRemaining")
    def time_remaining(self) -> builtins.float:
        """
        Value of the zone setting.
        Notes: The interval (in seconds) from when development mode expires (positive integer) or last expired (negative integer) for the domain. If development mode has never been enabled, this value is false.
        """
        return pulumi.get(self, "time_remaining")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Current value of the zone setting.
        Available values: "on", "off".
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZoneSettingResult(GetZoneSettingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneSettingResult(
            editable=self.editable,
            enabled=self.enabled,
            id=self.id,
            modified_on=self.modified_on,
            setting_id=self.setting_id,
            time_remaining=self.time_remaining,
            value=self.value,
            zone_id=self.zone_id)


def get_zone_setting(setting_id: Optional[builtins.str] = None,
                     zone_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneSettingResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone_setting = cloudflare.get_zone_setting(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        setting_id="always_online")
    ```


    :param builtins.str setting_id: Setting name
    :param builtins.str zone_id: Identifier
    """
    __args__ = dict()
    __args__['settingId'] = setting_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getZoneSetting:getZoneSetting', __args__, opts=opts, typ=GetZoneSettingResult).value

    return AwaitableGetZoneSettingResult(
        editable=pulumi.get(__ret__, 'editable'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        setting_id=pulumi.get(__ret__, 'setting_id'),
        time_remaining=pulumi.get(__ret__, 'time_remaining'),
        value=pulumi.get(__ret__, 'value'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_zone_setting_output(setting_id: Optional[pulumi.Input[builtins.str]] = None,
                            zone_id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetZoneSettingResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_zone_setting = cloudflare.get_zone_setting(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        setting_id="always_online")
    ```


    :param builtins.str setting_id: Setting name
    :param builtins.str zone_id: Identifier
    """
    __args__ = dict()
    __args__['settingId'] = setting_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getZoneSetting:getZoneSetting', __args__, opts=opts, typ=GetZoneSettingResult)
    return __ret__.apply(lambda __response__: GetZoneSettingResult(
        editable=pulumi.get(__response__, 'editable'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        setting_id=pulumi.get(__response__, 'setting_id'),
        time_remaining=pulumi.get(__response__, 'time_remaining'),
        value=pulumi.get(__response__, 'value'),
        zone_id=pulumi.get(__response__, 'zone_id')))
