# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HealthcheckArgs', 'Healthcheck']

@pulumi.input_type
class HealthcheckArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 zone_id: pulumi.Input[builtins.str],
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 consecutive_fails: Optional[pulumi.Input[builtins.int]] = None,
                 consecutive_successes: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 http_config: Optional[pulumi.Input['HealthcheckHttpConfigArgs']] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None,
                 tcp_config: Optional[pulumi.Input['HealthcheckTcpConfigArgs']] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Healthcheck resource.
        :param pulumi.Input[builtins.str] address: The hostname or IP address of the origin server to run health checks on.
        :param pulumi.Input[builtins.str] name: A short name to identify the health check. Only alphanumeric characters, hyphens and underscores are allowed.
        :param pulumi.Input[builtins.str] zone_id: Identifier
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] check_regions: A list of regions from which to run health checks. Null means Cloudflare will pick a default region.
        :param pulumi.Input[builtins.int] consecutive_fails: The number of consecutive fails required from a health check before changing the health to unhealthy.
        :param pulumi.Input[builtins.int] consecutive_successes: The number of consecutive successes required from a health check before changing the health to healthy.
        :param pulumi.Input[builtins.str] description: A human-readable description of the health check.
        :param pulumi.Input['HealthcheckHttpConfigArgs'] http_config: Parameters specific to an HTTP or HTTPS health check.
        :param pulumi.Input[builtins.int] interval: The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase load on the origin as we check from multiple locations.
        :param pulumi.Input[builtins.int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        :param pulumi.Input[builtins.bool] suspended: If suspended, no health checks are sent to the origin.
        :param pulumi.Input['HealthcheckTcpConfigArgs'] tcp_config: Parameters specific to TCP health check.
        :param pulumi.Input[builtins.int] timeout: The timeout (in seconds) before marking the health check as failed.
        :param pulumi.Input[builtins.str] type: The protocol to use for the health check. Currently supported protocols are 'HTTP', 'HTTPS' and 'TCP'.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "zone_id", zone_id)
        if check_regions is not None:
            pulumi.set(__self__, "check_regions", check_regions)
        if consecutive_fails is not None:
            pulumi.set(__self__, "consecutive_fails", consecutive_fails)
        if consecutive_successes is not None:
            pulumi.set(__self__, "consecutive_successes", consecutive_successes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if http_config is not None:
            pulumi.set(__self__, "http_config", http_config)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if tcp_config is not None:
            pulumi.set(__self__, "tcp_config", tcp_config)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[builtins.str]:
        """
        The hostname or IP address of the origin server to run health checks on.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        A short name to identify the health check. Only alphanumeric characters, hyphens and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of regions from which to run health checks. Null means Cloudflare will pick a default region.
        """
        return pulumi.get(self, "check_regions")

    @check_regions.setter
    def check_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "check_regions", value)

    @property
    @pulumi.getter(name="consecutiveFails")
    def consecutive_fails(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of consecutive fails required from a health check before changing the health to unhealthy.
        """
        return pulumi.get(self, "consecutive_fails")

    @consecutive_fails.setter
    def consecutive_fails(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "consecutive_fails", value)

    @property
    @pulumi.getter(name="consecutiveSuccesses")
    def consecutive_successes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of consecutive successes required from a health check before changing the health to healthy.
        """
        return pulumi.get(self, "consecutive_successes")

    @consecutive_successes.setter
    def consecutive_successes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "consecutive_successes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description of the health check.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="httpConfig")
    def http_config(self) -> Optional[pulumi.Input['HealthcheckHttpConfigArgs']]:
        """
        Parameters specific to an HTTP or HTTPS health check.
        """
        return pulumi.get(self, "http_config")

    @http_config.setter
    def http_config(self, value: Optional[pulumi.Input['HealthcheckHttpConfigArgs']]):
        pulumi.set(self, "http_config", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase load on the origin as we check from multiple locations.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If suspended, no health checks are sent to the origin.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @property
    @pulumi.getter(name="tcpConfig")
    def tcp_config(self) -> Optional[pulumi.Input['HealthcheckTcpConfigArgs']]:
        """
        Parameters specific to TCP health check.
        """
        return pulumi.get(self, "tcp_config")

    @tcp_config.setter
    def tcp_config(self, value: Optional[pulumi.Input['HealthcheckTcpConfigArgs']]):
        pulumi.set(self, "tcp_config", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The timeout (in seconds) before marking the health check as failed.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protocol to use for the health check. Currently supported protocols are 'HTTP', 'HTTPS' and 'TCP'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _HealthcheckState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 consecutive_fails: Optional[pulumi.Input[builtins.int]] = None,
                 consecutive_successes: Optional[pulumi.Input[builtins.int]] = None,
                 created_on: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 failure_reason: Optional[pulumi.Input[builtins.str]] = None,
                 http_config: Optional[pulumi.Input['HealthcheckHttpConfigArgs']] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 modified_on: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None,
                 tcp_config: Optional[pulumi.Input['HealthcheckTcpConfigArgs']] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Healthcheck resources.
        :param pulumi.Input[builtins.str] address: The hostname or IP address of the origin server to run health checks on.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] check_regions: A list of regions from which to run health checks. Null means Cloudflare will pick a default region.
        :param pulumi.Input[builtins.int] consecutive_fails: The number of consecutive fails required from a health check before changing the health to unhealthy.
        :param pulumi.Input[builtins.int] consecutive_successes: The number of consecutive successes required from a health check before changing the health to healthy.
        :param pulumi.Input[builtins.str] description: A human-readable description of the health check.
        :param pulumi.Input[builtins.str] failure_reason: The current failure reason if status is unhealthy.
        :param pulumi.Input['HealthcheckHttpConfigArgs'] http_config: Parameters specific to an HTTP or HTTPS health check.
        :param pulumi.Input[builtins.int] interval: The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase load on the origin as we check from multiple locations.
        :param pulumi.Input[builtins.str] name: A short name to identify the health check. Only alphanumeric characters, hyphens and underscores are allowed.
        :param pulumi.Input[builtins.int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        :param pulumi.Input[builtins.str] status: The current status of the origin server according to the health check.
               Available values: "unknown", "healthy", "unhealthy", "suspended".
        :param pulumi.Input[builtins.bool] suspended: If suspended, no health checks are sent to the origin.
        :param pulumi.Input['HealthcheckTcpConfigArgs'] tcp_config: Parameters specific to TCP health check.
        :param pulumi.Input[builtins.int] timeout: The timeout (in seconds) before marking the health check as failed.
        :param pulumi.Input[builtins.str] type: The protocol to use for the health check. Currently supported protocols are 'HTTP', 'HTTPS' and 'TCP'.
        :param pulumi.Input[builtins.str] zone_id: Identifier
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if check_regions is not None:
            pulumi.set(__self__, "check_regions", check_regions)
        if consecutive_fails is not None:
            pulumi.set(__self__, "consecutive_fails", consecutive_fails)
        if consecutive_successes is not None:
            pulumi.set(__self__, "consecutive_successes", consecutive_successes)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if failure_reason is not None:
            pulumi.set(__self__, "failure_reason", failure_reason)
        if http_config is not None:
            pulumi.set(__self__, "http_config", http_config)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if tcp_config is not None:
            pulumi.set(__self__, "tcp_config", tcp_config)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname or IP address of the origin server to run health checks on.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of regions from which to run health checks. Null means Cloudflare will pick a default region.
        """
        return pulumi.get(self, "check_regions")

    @check_regions.setter
    def check_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "check_regions", value)

    @property
    @pulumi.getter(name="consecutiveFails")
    def consecutive_fails(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of consecutive fails required from a health check before changing the health to unhealthy.
        """
        return pulumi.get(self, "consecutive_fails")

    @consecutive_fails.setter
    def consecutive_fails(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "consecutive_fails", value)

    @property
    @pulumi.getter(name="consecutiveSuccesses")
    def consecutive_successes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of consecutive successes required from a health check before changing the health to healthy.
        """
        return pulumi.get(self, "consecutive_successes")

    @consecutive_successes.setter
    def consecutive_successes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "consecutive_successes", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description of the health check.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current failure reason if status is unhealthy.
        """
        return pulumi.get(self, "failure_reason")

    @failure_reason.setter
    def failure_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "failure_reason", value)

    @property
    @pulumi.getter(name="httpConfig")
    def http_config(self) -> Optional[pulumi.Input['HealthcheckHttpConfigArgs']]:
        """
        Parameters specific to an HTTP or HTTPS health check.
        """
        return pulumi.get(self, "http_config")

    @http_config.setter
    def http_config(self, value: Optional[pulumi.Input['HealthcheckHttpConfigArgs']]):
        pulumi.set(self, "http_config", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase load on the origin as we check from multiple locations.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A short name to identify the health check. Only alphanumeric characters, hyphens and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current status of the origin server according to the health check.
        Available values: "unknown", "healthy", "unhealthy", "suspended".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If suspended, no health checks are sent to the origin.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @property
    @pulumi.getter(name="tcpConfig")
    def tcp_config(self) -> Optional[pulumi.Input['HealthcheckTcpConfigArgs']]:
        """
        Parameters specific to TCP health check.
        """
        return pulumi.get(self, "tcp_config")

    @tcp_config.setter
    def tcp_config(self, value: Optional[pulumi.Input['HealthcheckTcpConfigArgs']]):
        pulumi.set(self, "tcp_config", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The timeout (in seconds) before marking the health check as failed.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protocol to use for the health check. Currently supported protocols are 'HTTP', 'HTTPS' and 'TCP'.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/healthcheck:Healthcheck")
class Healthcheck(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 consecutive_fails: Optional[pulumi.Input[builtins.int]] = None,
                 consecutive_successes: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 http_config: Optional[pulumi.Input[Union['HealthcheckHttpConfigArgs', 'HealthcheckHttpConfigArgsDict']]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None,
                 tcp_config: Optional[pulumi.Input[Union['HealthcheckTcpConfigArgs', 'HealthcheckTcpConfigArgsDict']]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/healthcheck:Healthcheck example '<zone_id>/<healthcheck_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address: The hostname or IP address of the origin server to run health checks on.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] check_regions: A list of regions from which to run health checks. Null means Cloudflare will pick a default region.
        :param pulumi.Input[builtins.int] consecutive_fails: The number of consecutive fails required from a health check before changing the health to unhealthy.
        :param pulumi.Input[builtins.int] consecutive_successes: The number of consecutive successes required from a health check before changing the health to healthy.
        :param pulumi.Input[builtins.str] description: A human-readable description of the health check.
        :param pulumi.Input[Union['HealthcheckHttpConfigArgs', 'HealthcheckHttpConfigArgsDict']] http_config: Parameters specific to an HTTP or HTTPS health check.
        :param pulumi.Input[builtins.int] interval: The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase load on the origin as we check from multiple locations.
        :param pulumi.Input[builtins.str] name: A short name to identify the health check. Only alphanumeric characters, hyphens and underscores are allowed.
        :param pulumi.Input[builtins.int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        :param pulumi.Input[builtins.bool] suspended: If suspended, no health checks are sent to the origin.
        :param pulumi.Input[Union['HealthcheckTcpConfigArgs', 'HealthcheckTcpConfigArgsDict']] tcp_config: Parameters specific to TCP health check.
        :param pulumi.Input[builtins.int] timeout: The timeout (in seconds) before marking the health check as failed.
        :param pulumi.Input[builtins.str] type: The protocol to use for the health check. Currently supported protocols are 'HTTP', 'HTTPS' and 'TCP'.
        :param pulumi.Input[builtins.str] zone_id: Identifier
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HealthcheckArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/healthcheck:Healthcheck example '<zone_id>/<healthcheck_id>'
        ```

        :param str resource_name: The name of the resource.
        :param HealthcheckArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HealthcheckArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 consecutive_fails: Optional[pulumi.Input[builtins.int]] = None,
                 consecutive_successes: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 http_config: Optional[pulumi.Input[Union['HealthcheckHttpConfigArgs', 'HealthcheckHttpConfigArgsDict']]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None,
                 tcp_config: Optional[pulumi.Input[Union['HealthcheckTcpConfigArgs', 'HealthcheckTcpConfigArgsDict']]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HealthcheckArgs.__new__(HealthcheckArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["check_regions"] = check_regions
            __props__.__dict__["consecutive_fails"] = consecutive_fails
            __props__.__dict__["consecutive_successes"] = consecutive_successes
            __props__.__dict__["description"] = description
            __props__.__dict__["http_config"] = http_config
            __props__.__dict__["interval"] = interval
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["retries"] = retries
            __props__.__dict__["suspended"] = suspended
            __props__.__dict__["tcp_config"] = tcp_config
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["type"] = type
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["failure_reason"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["status"] = None
        super(Healthcheck, __self__).__init__(
            'cloudflare:index/healthcheck:Healthcheck',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[builtins.str]] = None,
            check_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            consecutive_fails: Optional[pulumi.Input[builtins.int]] = None,
            consecutive_successes: Optional[pulumi.Input[builtins.int]] = None,
            created_on: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            failure_reason: Optional[pulumi.Input[builtins.str]] = None,
            http_config: Optional[pulumi.Input[Union['HealthcheckHttpConfigArgs', 'HealthcheckHttpConfigArgsDict']]] = None,
            interval: Optional[pulumi.Input[builtins.int]] = None,
            modified_on: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            retries: Optional[pulumi.Input[builtins.int]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            suspended: Optional[pulumi.Input[builtins.bool]] = None,
            tcp_config: Optional[pulumi.Input[Union['HealthcheckTcpConfigArgs', 'HealthcheckTcpConfigArgsDict']]] = None,
            timeout: Optional[pulumi.Input[builtins.int]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Healthcheck':
        """
        Get an existing Healthcheck resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address: The hostname or IP address of the origin server to run health checks on.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] check_regions: A list of regions from which to run health checks. Null means Cloudflare will pick a default region.
        :param pulumi.Input[builtins.int] consecutive_fails: The number of consecutive fails required from a health check before changing the health to unhealthy.
        :param pulumi.Input[builtins.int] consecutive_successes: The number of consecutive successes required from a health check before changing the health to healthy.
        :param pulumi.Input[builtins.str] description: A human-readable description of the health check.
        :param pulumi.Input[builtins.str] failure_reason: The current failure reason if status is unhealthy.
        :param pulumi.Input[Union['HealthcheckHttpConfigArgs', 'HealthcheckHttpConfigArgsDict']] http_config: Parameters specific to an HTTP or HTTPS health check.
        :param pulumi.Input[builtins.int] interval: The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase load on the origin as we check from multiple locations.
        :param pulumi.Input[builtins.str] name: A short name to identify the health check. Only alphanumeric characters, hyphens and underscores are allowed.
        :param pulumi.Input[builtins.int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        :param pulumi.Input[builtins.str] status: The current status of the origin server according to the health check.
               Available values: "unknown", "healthy", "unhealthy", "suspended".
        :param pulumi.Input[builtins.bool] suspended: If suspended, no health checks are sent to the origin.
        :param pulumi.Input[Union['HealthcheckTcpConfigArgs', 'HealthcheckTcpConfigArgsDict']] tcp_config: Parameters specific to TCP health check.
        :param pulumi.Input[builtins.int] timeout: The timeout (in seconds) before marking the health check as failed.
        :param pulumi.Input[builtins.str] type: The protocol to use for the health check. Currently supported protocols are 'HTTP', 'HTTPS' and 'TCP'.
        :param pulumi.Input[builtins.str] zone_id: Identifier
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HealthcheckState.__new__(_HealthcheckState)

        __props__.__dict__["address"] = address
        __props__.__dict__["check_regions"] = check_regions
        __props__.__dict__["consecutive_fails"] = consecutive_fails
        __props__.__dict__["consecutive_successes"] = consecutive_successes
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["description"] = description
        __props__.__dict__["failure_reason"] = failure_reason
        __props__.__dict__["http_config"] = http_config
        __props__.__dict__["interval"] = interval
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["retries"] = retries
        __props__.__dict__["status"] = status
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["tcp_config"] = tcp_config
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["type"] = type
        __props__.__dict__["zone_id"] = zone_id
        return Healthcheck(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[builtins.str]:
        """
        The hostname or IP address of the origin server to run health checks on.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="checkRegions")
    def check_regions(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of regions from which to run health checks. Null means Cloudflare will pick a default region.
        """
        return pulumi.get(self, "check_regions")

    @property
    @pulumi.getter(name="consecutiveFails")
    def consecutive_fails(self) -> pulumi.Output[builtins.int]:
        """
        The number of consecutive fails required from a health check before changing the health to unhealthy.
        """
        return pulumi.get(self, "consecutive_fails")

    @property
    @pulumi.getter(name="consecutiveSuccesses")
    def consecutive_successes(self) -> pulumi.Output[builtins.int]:
        """
        The number of consecutive successes required from a health check before changing the health to healthy.
        """
        return pulumi.get(self, "consecutive_successes")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A human-readable description of the health check.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> pulumi.Output[builtins.str]:
        """
        The current failure reason if status is unhealthy.
        """
        return pulumi.get(self, "failure_reason")

    @property
    @pulumi.getter(name="httpConfig")
    def http_config(self) -> pulumi.Output['outputs.HealthcheckHttpConfig']:
        """
        Parameters specific to an HTTP or HTTPS health check.
        """
        return pulumi.get(self, "http_config")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[builtins.int]:
        """
        The interval between each health check. Shorter intervals may give quicker notifications if the origin status changes, but will increase load on the origin as we check from multiple locations.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A short name to identify the health check. Only alphanumeric characters, hyphens and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def retries(self) -> pulumi.Output[builtins.int]:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The current status of the origin server according to the health check.
        Available values: "unknown", "healthy", "unhealthy", "suspended".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[builtins.bool]:
        """
        If suspended, no health checks are sent to the origin.
        """
        return pulumi.get(self, "suspended")

    @property
    @pulumi.getter(name="tcpConfig")
    def tcp_config(self) -> pulumi.Output['outputs.HealthcheckTcpConfig']:
        """
        Parameters specific to TCP health check.
        """
        return pulumi.get(self, "tcp_config")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[builtins.int]:
        """
        The timeout (in seconds) before marking the health check as failed.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The protocol to use for the health check. Currently supported protocols are 'HTTP', 'HTTPS' and 'TCP'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")

