# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ImageArgs', 'Image']

@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 file: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[builtins.str]] = None,
                 require_signed_urls: Optional[pulumi.Input[builtins.bool]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Image resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.str] file: An image binary data. Only needed when type is uploading a file.
        :param pulumi.Input[builtins.str] metadata: User modifiable key-value store. Can use used for keeping references to another system of record for managing images.
        :param pulumi.Input[builtins.bool] require_signed_urls: Indicates whether the image requires a signature token for the access.
        :param pulumi.Input[builtins.str] url: A URL to fetch an image from origin. Only needed when type is uploading from a URL.
        """
        pulumi.set(__self__, "account_id", account_id)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if require_signed_urls is not None:
            pulumi.set(__self__, "require_signed_urls", require_signed_urls)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An image binary data. Only needed when type is uploading a file.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User modifiable key-value store. Can use used for keeping references to another system of record for managing images.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="requireSignedUrls")
    def require_signed_urls(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the image requires a signature token for the access.
        """
        return pulumi.get(self, "require_signed_urls")

    @require_signed_urls.setter
    def require_signed_urls(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "require_signed_urls", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A URL to fetch an image from origin. Only needed when type is uploading from a URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class _ImageState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 file: Optional[pulumi.Input[builtins.str]] = None,
                 filename: Optional[pulumi.Input[builtins.str]] = None,
                 meta: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[builtins.str]] = None,
                 require_signed_urls: Optional[pulumi.Input[builtins.bool]] = None,
                 uploaded: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 variants: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Image resources.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.str] file: An image binary data. Only needed when type is uploading a file.
        :param pulumi.Input[builtins.str] filename: Image file name.
        :param pulumi.Input[builtins.str] meta: User modifiable key-value store. Can be used for keeping references to another system of record for managing images. Metadata must not exceed 1024 bytes.
        :param pulumi.Input[builtins.str] metadata: User modifiable key-value store. Can use used for keeping references to another system of record for managing images.
        :param pulumi.Input[builtins.bool] require_signed_urls: Indicates whether the image requires a signature token for the access.
        :param pulumi.Input[builtins.str] uploaded: When the media item was uploaded.
        :param pulumi.Input[builtins.str] url: A URL to fetch an image from origin. Only needed when type is uploading from a URL.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] variants: Object specifying available variants for an image.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if require_signed_urls is not None:
            pulumi.set(__self__, "require_signed_urls", require_signed_urls)
        if uploaded is not None:
            pulumi.set(__self__, "uploaded", uploaded)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if variants is not None:
            pulumi.set(__self__, "variants", variants)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An image binary data. Only needed when type is uploading a file.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Image file name.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filename", value)

    @property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User modifiable key-value store. Can be used for keeping references to another system of record for managing images. Metadata must not exceed 1024 bytes.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "meta", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User modifiable key-value store. Can use used for keeping references to another system of record for managing images.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="requireSignedUrls")
    def require_signed_urls(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the image requires a signature token for the access.
        """
        return pulumi.get(self, "require_signed_urls")

    @require_signed_urls.setter
    def require_signed_urls(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "require_signed_urls", value)

    @property
    @pulumi.getter
    def uploaded(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the media item was uploaded.
        """
        return pulumi.get(self, "uploaded")

    @uploaded.setter
    def uploaded(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uploaded", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A URL to fetch an image from origin. Only needed when type is uploading from a URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def variants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Object specifying available variants for an image.
        """
        return pulumi.get(self, "variants")

    @variants.setter
    def variants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "variants", value)


@pulumi.type_token("cloudflare:index/image:Image")
class Image(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 file: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[builtins.str]] = None,
                 require_signed_urls: Optional[pulumi.Input[builtins.bool]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_image = cloudflare.Image("example_image",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            file={},
            metadata={},
            require_signed_urls=True,
            url="https://example.com/path/to/logo.png")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/image:Image example '<account_id>/<image_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.str] file: An image binary data. Only needed when type is uploading a file.
        :param pulumi.Input[builtins.str] metadata: User modifiable key-value store. Can use used for keeping references to another system of record for managing images.
        :param pulumi.Input[builtins.bool] require_signed_urls: Indicates whether the image requires a signature token for the access.
        :param pulumi.Input[builtins.str] url: A URL to fetch an image from origin. Only needed when type is uploading from a URL.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_image = cloudflare.Image("example_image",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            file={},
            metadata={},
            require_signed_urls=True,
            url="https://example.com/path/to/logo.png")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/image:Image example '<account_id>/<image_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 file: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[builtins.str]] = None,
                 require_signed_urls: Optional[pulumi.Input[builtins.bool]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageArgs.__new__(ImageArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["file"] = file
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["require_signed_urls"] = require_signed_urls
            __props__.__dict__["url"] = url
            __props__.__dict__["filename"] = None
            __props__.__dict__["meta"] = None
            __props__.__dict__["uploaded"] = None
            __props__.__dict__["variants"] = None
        super(Image, __self__).__init__(
            'cloudflare:index/image:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            file: Optional[pulumi.Input[builtins.str]] = None,
            filename: Optional[pulumi.Input[builtins.str]] = None,
            meta: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[builtins.str]] = None,
            require_signed_urls: Optional[pulumi.Input[builtins.bool]] = None,
            uploaded: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None,
            variants: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Image':
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.str] file: An image binary data. Only needed when type is uploading a file.
        :param pulumi.Input[builtins.str] filename: Image file name.
        :param pulumi.Input[builtins.str] meta: User modifiable key-value store. Can be used for keeping references to another system of record for managing images. Metadata must not exceed 1024 bytes.
        :param pulumi.Input[builtins.str] metadata: User modifiable key-value store. Can use used for keeping references to another system of record for managing images.
        :param pulumi.Input[builtins.bool] require_signed_urls: Indicates whether the image requires a signature token for the access.
        :param pulumi.Input[builtins.str] uploaded: When the media item was uploaded.
        :param pulumi.Input[builtins.str] url: A URL to fetch an image from origin. Only needed when type is uploading from a URL.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] variants: Object specifying available variants for an image.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageState.__new__(_ImageState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["file"] = file
        __props__.__dict__["filename"] = filename
        __props__.__dict__["meta"] = meta
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["require_signed_urls"] = require_signed_urls
        __props__.__dict__["uploaded"] = uploaded
        __props__.__dict__["url"] = url
        __props__.__dict__["variants"] = variants
        return Image(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def file(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An image binary data. Only needed when type is uploading a file.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def filename(self) -> pulumi.Output[builtins.str]:
        """
        Image file name.
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter
    def meta(self) -> pulumi.Output[builtins.str]:
        """
        User modifiable key-value store. Can be used for keeping references to another system of record for managing images. Metadata must not exceed 1024 bytes.
        """
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User modifiable key-value store. Can use used for keeping references to another system of record for managing images.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="requireSignedUrls")
    def require_signed_urls(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether the image requires a signature token for the access.
        """
        return pulumi.get(self, "require_signed_urls")

    @property
    @pulumi.getter
    def uploaded(self) -> pulumi.Output[builtins.str]:
        """
        When the media item was uploaded.
        """
        return pulumi.get(self, "uploaded")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A URL to fetch an image from origin. Only needed when type is uploading from a URL.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def variants(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Object specifying available variants for an image.
        """
        return pulumi.get(self, "variants")

