# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageVariantArgs', 'ImageVariant']

@pulumi.input_type
class ImageVariantArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 options: pulumi.Input['ImageVariantOptionsArgs'],
                 never_require_signed_urls: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ImageVariant resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input['ImageVariantOptionsArgs'] options: Allows you to define image resizing sizes for different use cases.
        :param pulumi.Input[builtins.bool] never_require_signed_urls: Indicates whether the variant can access an image without a signature, regardless of image access control.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "options", options)
        if never_require_signed_urls is not None:
            pulumi.set(__self__, "never_require_signed_urls", never_require_signed_urls)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def options(self) -> pulumi.Input['ImageVariantOptionsArgs']:
        """
        Allows you to define image resizing sizes for different use cases.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: pulumi.Input['ImageVariantOptionsArgs']):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="neverRequireSignedUrls")
    def never_require_signed_urls(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the variant can access an image without a signature, regardless of image access control.
        """
        return pulumi.get(self, "never_require_signed_urls")

    @never_require_signed_urls.setter
    def never_require_signed_urls(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "never_require_signed_urls", value)


@pulumi.input_type
class _ImageVariantState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 never_require_signed_urls: Optional[pulumi.Input[builtins.bool]] = None,
                 options: Optional[pulumi.Input['ImageVariantOptionsArgs']] = None,
                 variant: Optional[pulumi.Input['ImageVariantVariantArgs']] = None):
        """
        Input properties used for looking up and filtering ImageVariant resources.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.bool] never_require_signed_urls: Indicates whether the variant can access an image without a signature, regardless of image access control.
        :param pulumi.Input['ImageVariantOptionsArgs'] options: Allows you to define image resizing sizes for different use cases.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if never_require_signed_urls is not None:
            pulumi.set(__self__, "never_require_signed_urls", never_require_signed_urls)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if variant is not None:
            pulumi.set(__self__, "variant", variant)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="neverRequireSignedUrls")
    def never_require_signed_urls(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the variant can access an image without a signature, regardless of image access control.
        """
        return pulumi.get(self, "never_require_signed_urls")

    @never_require_signed_urls.setter
    def never_require_signed_urls(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "never_require_signed_urls", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['ImageVariantOptionsArgs']]:
        """
        Allows you to define image resizing sizes for different use cases.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['ImageVariantOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def variant(self) -> Optional[pulumi.Input['ImageVariantVariantArgs']]:
        return pulumi.get(self, "variant")

    @variant.setter
    def variant(self, value: Optional[pulumi.Input['ImageVariantVariantArgs']]):
        pulumi.set(self, "variant", value)


@pulumi.type_token("cloudflare:index/imageVariant:ImageVariant")
class ImageVariant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 never_require_signed_urls: Optional[pulumi.Input[builtins.bool]] = None,
                 options: Optional[pulumi.Input[Union['ImageVariantOptionsArgs', 'ImageVariantOptionsArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/imageVariant:ImageVariant example '<account_id>/<variant_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.bool] never_require_signed_urls: Indicates whether the variant can access an image without a signature, regardless of image access control.
        :param pulumi.Input[Union['ImageVariantOptionsArgs', 'ImageVariantOptionsArgsDict']] options: Allows you to define image resizing sizes for different use cases.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageVariantArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/imageVariant:ImageVariant example '<account_id>/<variant_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ImageVariantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageVariantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 never_require_signed_urls: Optional[pulumi.Input[builtins.bool]] = None,
                 options: Optional[pulumi.Input[Union['ImageVariantOptionsArgs', 'ImageVariantOptionsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageVariantArgs.__new__(ImageVariantArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["never_require_signed_urls"] = never_require_signed_urls
            if options is None and not opts.urn:
                raise TypeError("Missing required property 'options'")
            __props__.__dict__["options"] = options
            __props__.__dict__["variant"] = None
        super(ImageVariant, __self__).__init__(
            'cloudflare:index/imageVariant:ImageVariant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            never_require_signed_urls: Optional[pulumi.Input[builtins.bool]] = None,
            options: Optional[pulumi.Input[Union['ImageVariantOptionsArgs', 'ImageVariantOptionsArgsDict']]] = None,
            variant: Optional[pulumi.Input[Union['ImageVariantVariantArgs', 'ImageVariantVariantArgsDict']]] = None) -> 'ImageVariant':
        """
        Get an existing ImageVariant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.bool] never_require_signed_urls: Indicates whether the variant can access an image without a signature, regardless of image access control.
        :param pulumi.Input[Union['ImageVariantOptionsArgs', 'ImageVariantOptionsArgsDict']] options: Allows you to define image resizing sizes for different use cases.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageVariantState.__new__(_ImageVariantState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["never_require_signed_urls"] = never_require_signed_urls
        __props__.__dict__["options"] = options
        __props__.__dict__["variant"] = variant
        return ImageVariant(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="neverRequireSignedUrls")
    def never_require_signed_urls(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether the variant can access an image without a signature, regardless of image access control.
        """
        return pulumi.get(self, "never_require_signed_urls")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output['outputs.ImageVariantOptions']:
        """
        Allows you to define image resizing sizes for different use cases.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def variant(self) -> pulumi.Output['outputs.ImageVariantVariant']:
        return pulumi.get(self, "variant")

