# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 default_pools: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 fallback_pool: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 zone_id: pulumi.Input[builtins.str],
                 adaptive_routing: Optional[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']] = None,
                 country_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location_strategy: Optional[pulumi.Input['LoadBalancerLocationStrategyArgs']] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 pop_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 proxied: Optional[pulumi.Input[builtins.bool]] = None,
                 random_steering: Optional[pulumi.Input['LoadBalancerRandomSteeringArgs']] = None,
                 region_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]] = None,
                 session_affinity: Optional[pulumi.Input[builtins.str]] = None,
                 session_affinity_attributes: Optional[pulumi.Input['LoadBalancerSessionAffinityAttributesArgs']] = None,
                 session_affinity_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 steering_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.float]] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] default_pools: A list of pool IDs ordered by their failover priority. Pools defined here are used by default, or when region_pools are not configured for a given region.
        :param pulumi.Input[builtins.str] fallback_pool: The pool ID to use when all other pools are detected as unhealthy.
        :param pulumi.Input[builtins.str] name: The DNS hostname to associate with your Load Balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the Load Balancer will take precedence and the DNS record will not be used.
        :param pulumi.Input['LoadBalancerAdaptiveRoutingArgs'] adaptive_routing: Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests. For example, zero-downtime failover occurs immediately when an origin becomes unavailable due to HTTP 521, 522, or 523 response codes. If there is another healthy origin in the same pool, the request is retried once against this alternate origin.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] country_pools: A mapping of country codes to a list of pool IDs (ordered by their failover priority) for the given country. Any country not explicitly defined will fall back to using the corresponding region*pool mapping if it exists else to default*pools.
        :param pulumi.Input[builtins.str] description: Object description.
        :param pulumi.Input[builtins.bool] enabled: Whether to enable (the default) this load balancer.
        :param pulumi.Input['LoadBalancerLocationStrategyArgs'] location_strategy: Controls location-based steering for non-proxied requests. See `steering_policy` to learn how steering is affected.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] networks: List of networks where Load Balancer or Pool is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] pop_pools: (Enterprise only): A mapping of Cloudflare PoP identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). Any PoPs not explicitly defined will fall back to using the corresponding country*pool, then region*pool mapping if it exists else to default_pools.
        :param pulumi.Input[builtins.bool] proxied: Whether the hostname should be gray clouded (false) or orange clouded (true).
        :param pulumi.Input['LoadBalancerRandomSteeringArgs'] random_steering: Configures pool weights.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] region_pools: A mapping of region codes to a list of pool IDs (ordered by their failover priority) for the given region. Any regions not explicitly defined will fall back to using default_pools.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]] rules: BETA Field Not General Access: A list of rules for this load balancer to execute.
        :param pulumi.Input[builtins.str] session_affinity: Specifies the type of session affinity the load balancer should use unless specified as `"none"`. The supported types are:
        :param pulumi.Input['LoadBalancerSessionAffinityAttributesArgs'] session_affinity_attributes: Configures attributes for session affinity.
        :param pulumi.Input[builtins.float] session_affinity_ttl: Time, in seconds, until a client's session expires after being created. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. The accepted ranges per `session_affinity` policy are:
        :param pulumi.Input[builtins.str] steering_policy: Steering Policy for this load balancer.
        :param pulumi.Input[builtins.float] ttl: Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This only applies to gray-clouded (unproxied) load balancers.
        """
        pulumi.set(__self__, "default_pools", default_pools)
        pulumi.set(__self__, "fallback_pool", fallback_pool)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "zone_id", zone_id)
        if adaptive_routing is not None:
            pulumi.set(__self__, "adaptive_routing", adaptive_routing)
        if country_pools is not None:
            pulumi.set(__self__, "country_pools", country_pools)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location_strategy is not None:
            pulumi.set(__self__, "location_strategy", location_strategy)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if pop_pools is not None:
            pulumi.set(__self__, "pop_pools", pop_pools)
        if proxied is not None:
            pulumi.set(__self__, "proxied", proxied)
        if random_steering is not None:
            pulumi.set(__self__, "random_steering", random_steering)
        if region_pools is not None:
            pulumi.set(__self__, "region_pools", region_pools)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if session_affinity_attributes is not None:
            pulumi.set(__self__, "session_affinity_attributes", session_affinity_attributes)
        if session_affinity_ttl is not None:
            pulumi.set(__self__, "session_affinity_ttl", session_affinity_ttl)
        if steering_policy is not None:
            pulumi.set(__self__, "steering_policy", steering_policy)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="defaultPools")
    def default_pools(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of pool IDs ordered by their failover priority. Pools defined here are used by default, or when region_pools are not configured for a given region.
        """
        return pulumi.get(self, "default_pools")

    @default_pools.setter
    def default_pools(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "default_pools", value)

    @property
    @pulumi.getter(name="fallbackPool")
    def fallback_pool(self) -> pulumi.Input[builtins.str]:
        """
        The pool ID to use when all other pools are detected as unhealthy.
        """
        return pulumi.get(self, "fallback_pool")

    @fallback_pool.setter
    def fallback_pool(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "fallback_pool", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The DNS hostname to associate with your Load Balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the Load Balancer will take precedence and the DNS record will not be used.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="adaptiveRouting")
    def adaptive_routing(self) -> Optional[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]:
        """
        Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests. For example, zero-downtime failover occurs immediately when an origin becomes unavailable due to HTTP 521, 522, or 523 response codes. If there is another healthy origin in the same pool, the request is retried once against this alternate origin.
        """
        return pulumi.get(self, "adaptive_routing")

    @adaptive_routing.setter
    def adaptive_routing(self, value: Optional[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]):
        pulumi.set(self, "adaptive_routing", value)

    @property
    @pulumi.getter(name="countryPools")
    def country_pools(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        A mapping of country codes to a list of pool IDs (ordered by their failover priority) for the given country. Any country not explicitly defined will fall back to using the corresponding region*pool mapping if it exists else to default*pools.
        """
        return pulumi.get(self, "country_pools")

    @country_pools.setter
    def country_pools(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "country_pools", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Object description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable (the default) this load balancer.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="locationStrategy")
    def location_strategy(self) -> Optional[pulumi.Input['LoadBalancerLocationStrategyArgs']]:
        """
        Controls location-based steering for non-proxied requests. See `steering_policy` to learn how steering is affected.
        """
        return pulumi.get(self, "location_strategy")

    @location_strategy.setter
    def location_strategy(self, value: Optional[pulumi.Input['LoadBalancerLocationStrategyArgs']]):
        pulumi.set(self, "location_strategy", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of networks where Load Balancer or Pool is enabled.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="popPools")
    def pop_pools(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        (Enterprise only): A mapping of Cloudflare PoP identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). Any PoPs not explicitly defined will fall back to using the corresponding country*pool, then region*pool mapping if it exists else to default_pools.
        """
        return pulumi.get(self, "pop_pools")

    @pop_pools.setter
    def pop_pools(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "pop_pools", value)

    @property
    @pulumi.getter
    def proxied(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the hostname should be gray clouded (false) or orange clouded (true).
        """
        return pulumi.get(self, "proxied")

    @proxied.setter
    def proxied(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "proxied", value)

    @property
    @pulumi.getter(name="randomSteering")
    def random_steering(self) -> Optional[pulumi.Input['LoadBalancerRandomSteeringArgs']]:
        """
        Configures pool weights.
        """
        return pulumi.get(self, "random_steering")

    @random_steering.setter
    def random_steering(self, value: Optional[pulumi.Input['LoadBalancerRandomSteeringArgs']]):
        pulumi.set(self, "random_steering", value)

    @property
    @pulumi.getter(name="regionPools")
    def region_pools(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        A mapping of region codes to a list of pool IDs (ordered by their failover priority) for the given region. Any regions not explicitly defined will fall back to using default_pools.
        """
        return pulumi.get(self, "region_pools")

    @region_pools.setter
    def region_pools(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "region_pools", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]]:
        """
        BETA Field Not General Access: A list of rules for this load balancer to execute.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of session affinity the load balancer should use unless specified as `"none"`. The supported types are:
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_affinity", value)

    @property
    @pulumi.getter(name="sessionAffinityAttributes")
    def session_affinity_attributes(self) -> Optional[pulumi.Input['LoadBalancerSessionAffinityAttributesArgs']]:
        """
        Configures attributes for session affinity.
        """
        return pulumi.get(self, "session_affinity_attributes")

    @session_affinity_attributes.setter
    def session_affinity_attributes(self, value: Optional[pulumi.Input['LoadBalancerSessionAffinityAttributesArgs']]):
        pulumi.set(self, "session_affinity_attributes", value)

    @property
    @pulumi.getter(name="sessionAffinityTtl")
    def session_affinity_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Time, in seconds, until a client's session expires after being created. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. The accepted ranges per `session_affinity` policy are:
        """
        return pulumi.get(self, "session_affinity_ttl")

    @session_affinity_ttl.setter
    def session_affinity_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "session_affinity_ttl", value)

    @property
    @pulumi.getter(name="steeringPolicy")
    def steering_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Steering Policy for this load balancer.
        """
        return pulumi.get(self, "steering_policy")

    @steering_policy.setter
    def steering_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "steering_policy", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This only applies to gray-clouded (unproxied) load balancers.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 adaptive_routing: Optional[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']] = None,
                 country_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 created_on: Optional[pulumi.Input[builtins.str]] = None,
                 default_pools: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 fallback_pool: Optional[pulumi.Input[builtins.str]] = None,
                 location_strategy: Optional[pulumi.Input['LoadBalancerLocationStrategyArgs']] = None,
                 modified_on: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 pop_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 proxied: Optional[pulumi.Input[builtins.bool]] = None,
                 random_steering: Optional[pulumi.Input['LoadBalancerRandomSteeringArgs']] = None,
                 region_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]] = None,
                 session_affinity: Optional[pulumi.Input[builtins.str]] = None,
                 session_affinity_attributes: Optional[pulumi.Input['LoadBalancerSessionAffinityAttributesArgs']] = None,
                 session_affinity_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 steering_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.float]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input['LoadBalancerAdaptiveRoutingArgs'] adaptive_routing: Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests. For example, zero-downtime failover occurs immediately when an origin becomes unavailable due to HTTP 521, 522, or 523 response codes. If there is another healthy origin in the same pool, the request is retried once against this alternate origin.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] country_pools: A mapping of country codes to a list of pool IDs (ordered by their failover priority) for the given country. Any country not explicitly defined will fall back to using the corresponding region*pool mapping if it exists else to default*pools.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] default_pools: A list of pool IDs ordered by their failover priority. Pools defined here are used by default, or when region_pools are not configured for a given region.
        :param pulumi.Input[builtins.str] description: Object description.
        :param pulumi.Input[builtins.bool] enabled: Whether to enable (the default) this load balancer.
        :param pulumi.Input[builtins.str] fallback_pool: The pool ID to use when all other pools are detected as unhealthy.
        :param pulumi.Input['LoadBalancerLocationStrategyArgs'] location_strategy: Controls location-based steering for non-proxied requests. See `steering_policy` to learn how steering is affected.
        :param pulumi.Input[builtins.str] name: The DNS hostname to associate with your Load Balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the Load Balancer will take precedence and the DNS record will not be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] networks: List of networks where Load Balancer or Pool is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] pop_pools: (Enterprise only): A mapping of Cloudflare PoP identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). Any PoPs not explicitly defined will fall back to using the corresponding country*pool, then region*pool mapping if it exists else to default_pools.
        :param pulumi.Input[builtins.bool] proxied: Whether the hostname should be gray clouded (false) or orange clouded (true).
        :param pulumi.Input['LoadBalancerRandomSteeringArgs'] random_steering: Configures pool weights.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] region_pools: A mapping of region codes to a list of pool IDs (ordered by their failover priority) for the given region. Any regions not explicitly defined will fall back to using default_pools.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]] rules: BETA Field Not General Access: A list of rules for this load balancer to execute.
        :param pulumi.Input[builtins.str] session_affinity: Specifies the type of session affinity the load balancer should use unless specified as `"none"`. The supported types are:
        :param pulumi.Input['LoadBalancerSessionAffinityAttributesArgs'] session_affinity_attributes: Configures attributes for session affinity.
        :param pulumi.Input[builtins.float] session_affinity_ttl: Time, in seconds, until a client's session expires after being created. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. The accepted ranges per `session_affinity` policy are:
        :param pulumi.Input[builtins.str] steering_policy: Steering Policy for this load balancer.
        :param pulumi.Input[builtins.float] ttl: Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This only applies to gray-clouded (unproxied) load balancers.
        """
        if adaptive_routing is not None:
            pulumi.set(__self__, "adaptive_routing", adaptive_routing)
        if country_pools is not None:
            pulumi.set(__self__, "country_pools", country_pools)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if default_pools is not None:
            pulumi.set(__self__, "default_pools", default_pools)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fallback_pool is not None:
            pulumi.set(__self__, "fallback_pool", fallback_pool)
        if location_strategy is not None:
            pulumi.set(__self__, "location_strategy", location_strategy)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if pop_pools is not None:
            pulumi.set(__self__, "pop_pools", pop_pools)
        if proxied is not None:
            pulumi.set(__self__, "proxied", proxied)
        if random_steering is not None:
            pulumi.set(__self__, "random_steering", random_steering)
        if region_pools is not None:
            pulumi.set(__self__, "region_pools", region_pools)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if session_affinity_attributes is not None:
            pulumi.set(__self__, "session_affinity_attributes", session_affinity_attributes)
        if session_affinity_ttl is not None:
            pulumi.set(__self__, "session_affinity_ttl", session_affinity_ttl)
        if steering_policy is not None:
            pulumi.set(__self__, "steering_policy", steering_policy)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)
        if zone_name is not None:
            pulumi.set(__self__, "zone_name", zone_name)

    @property
    @pulumi.getter(name="adaptiveRouting")
    def adaptive_routing(self) -> Optional[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]:
        """
        Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests. For example, zero-downtime failover occurs immediately when an origin becomes unavailable due to HTTP 521, 522, or 523 response codes. If there is another healthy origin in the same pool, the request is retried once against this alternate origin.
        """
        return pulumi.get(self, "adaptive_routing")

    @adaptive_routing.setter
    def adaptive_routing(self, value: Optional[pulumi.Input['LoadBalancerAdaptiveRoutingArgs']]):
        pulumi.set(self, "adaptive_routing", value)

    @property
    @pulumi.getter(name="countryPools")
    def country_pools(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        A mapping of country codes to a list of pool IDs (ordered by their failover priority) for the given country. Any country not explicitly defined will fall back to using the corresponding region*pool mapping if it exists else to default*pools.
        """
        return pulumi.get(self, "country_pools")

    @country_pools.setter
    def country_pools(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "country_pools", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter(name="defaultPools")
    def default_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of pool IDs ordered by their failover priority. Pools defined here are used by default, or when region_pools are not configured for a given region.
        """
        return pulumi.get(self, "default_pools")

    @default_pools.setter
    def default_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "default_pools", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Object description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable (the default) this load balancer.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="fallbackPool")
    def fallback_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The pool ID to use when all other pools are detected as unhealthy.
        """
        return pulumi.get(self, "fallback_pool")

    @fallback_pool.setter
    def fallback_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fallback_pool", value)

    @property
    @pulumi.getter(name="locationStrategy")
    def location_strategy(self) -> Optional[pulumi.Input['LoadBalancerLocationStrategyArgs']]:
        """
        Controls location-based steering for non-proxied requests. See `steering_policy` to learn how steering is affected.
        """
        return pulumi.get(self, "location_strategy")

    @location_strategy.setter
    def location_strategy(self, value: Optional[pulumi.Input['LoadBalancerLocationStrategyArgs']]):
        pulumi.set(self, "location_strategy", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS hostname to associate with your Load Balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the Load Balancer will take precedence and the DNS record will not be used.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of networks where Load Balancer or Pool is enabled.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter(name="popPools")
    def pop_pools(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        (Enterprise only): A mapping of Cloudflare PoP identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). Any PoPs not explicitly defined will fall back to using the corresponding country*pool, then region*pool mapping if it exists else to default_pools.
        """
        return pulumi.get(self, "pop_pools")

    @pop_pools.setter
    def pop_pools(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "pop_pools", value)

    @property
    @pulumi.getter
    def proxied(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the hostname should be gray clouded (false) or orange clouded (true).
        """
        return pulumi.get(self, "proxied")

    @proxied.setter
    def proxied(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "proxied", value)

    @property
    @pulumi.getter(name="randomSteering")
    def random_steering(self) -> Optional[pulumi.Input['LoadBalancerRandomSteeringArgs']]:
        """
        Configures pool weights.
        """
        return pulumi.get(self, "random_steering")

    @random_steering.setter
    def random_steering(self, value: Optional[pulumi.Input['LoadBalancerRandomSteeringArgs']]):
        pulumi.set(self, "random_steering", value)

    @property
    @pulumi.getter(name="regionPools")
    def region_pools(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        A mapping of region codes to a list of pool IDs (ordered by their failover priority) for the given region. Any regions not explicitly defined will fall back to using default_pools.
        """
        return pulumi.get(self, "region_pools")

    @region_pools.setter
    def region_pools(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "region_pools", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]]:
        """
        BETA Field Not General Access: A list of rules for this load balancer to execute.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the type of session affinity the load balancer should use unless specified as `"none"`. The supported types are:
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_affinity", value)

    @property
    @pulumi.getter(name="sessionAffinityAttributes")
    def session_affinity_attributes(self) -> Optional[pulumi.Input['LoadBalancerSessionAffinityAttributesArgs']]:
        """
        Configures attributes for session affinity.
        """
        return pulumi.get(self, "session_affinity_attributes")

    @session_affinity_attributes.setter
    def session_affinity_attributes(self, value: Optional[pulumi.Input['LoadBalancerSessionAffinityAttributesArgs']]):
        pulumi.set(self, "session_affinity_attributes", value)

    @property
    @pulumi.getter(name="sessionAffinityTtl")
    def session_affinity_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Time, in seconds, until a client's session expires after being created. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. The accepted ranges per `session_affinity` policy are:
        """
        return pulumi.get(self, "session_affinity_ttl")

    @session_affinity_ttl.setter
    def session_affinity_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "session_affinity_ttl", value)

    @property
    @pulumi.getter(name="steeringPolicy")
    def steering_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Steering Policy for this load balancer.
        """
        return pulumi.get(self, "steering_policy")

    @steering_policy.setter
    def steering_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "steering_policy", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This only applies to gray-clouded (unproxied) load balancers.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "zone_name")

    @zone_name.setter
    def zone_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_name", value)


@pulumi.type_token("cloudflare:index/loadBalancer:LoadBalancer")
class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adaptive_routing: Optional[pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']]] = None,
                 country_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 default_pools: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 fallback_pool: Optional[pulumi.Input[builtins.str]] = None,
                 location_strategy: Optional[pulumi.Input[Union['LoadBalancerLocationStrategyArgs', 'LoadBalancerLocationStrategyArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 pop_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 proxied: Optional[pulumi.Input[builtins.bool]] = None,
                 random_steering: Optional[pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']]] = None,
                 region_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]]] = None,
                 session_affinity: Optional[pulumi.Input[builtins.str]] = None,
                 session_affinity_attributes: Optional[pulumi.Input[Union['LoadBalancerSessionAffinityAttributesArgs', 'LoadBalancerSessionAffinityAttributesArgsDict']]] = None,
                 session_affinity_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 steering_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.float]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/loadBalancer:LoadBalancer example '<zone_id>/<load_balancer_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']] adaptive_routing: Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests. For example, zero-downtime failover occurs immediately when an origin becomes unavailable due to HTTP 521, 522, or 523 response codes. If there is another healthy origin in the same pool, the request is retried once against this alternate origin.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] country_pools: A mapping of country codes to a list of pool IDs (ordered by their failover priority) for the given country. Any country not explicitly defined will fall back to using the corresponding region*pool mapping if it exists else to default*pools.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] default_pools: A list of pool IDs ordered by their failover priority. Pools defined here are used by default, or when region_pools are not configured for a given region.
        :param pulumi.Input[builtins.str] description: Object description.
        :param pulumi.Input[builtins.bool] enabled: Whether to enable (the default) this load balancer.
        :param pulumi.Input[builtins.str] fallback_pool: The pool ID to use when all other pools are detected as unhealthy.
        :param pulumi.Input[Union['LoadBalancerLocationStrategyArgs', 'LoadBalancerLocationStrategyArgsDict']] location_strategy: Controls location-based steering for non-proxied requests. See `steering_policy` to learn how steering is affected.
        :param pulumi.Input[builtins.str] name: The DNS hostname to associate with your Load Balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the Load Balancer will take precedence and the DNS record will not be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] networks: List of networks where Load Balancer or Pool is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] pop_pools: (Enterprise only): A mapping of Cloudflare PoP identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). Any PoPs not explicitly defined will fall back to using the corresponding country*pool, then region*pool mapping if it exists else to default_pools.
        :param pulumi.Input[builtins.bool] proxied: Whether the hostname should be gray clouded (false) or orange clouded (true).
        :param pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']] random_steering: Configures pool weights.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] region_pools: A mapping of region codes to a list of pool IDs (ordered by their failover priority) for the given region. Any regions not explicitly defined will fall back to using default_pools.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]] rules: BETA Field Not General Access: A list of rules for this load balancer to execute.
        :param pulumi.Input[builtins.str] session_affinity: Specifies the type of session affinity the load balancer should use unless specified as `"none"`. The supported types are:
        :param pulumi.Input[Union['LoadBalancerSessionAffinityAttributesArgs', 'LoadBalancerSessionAffinityAttributesArgsDict']] session_affinity_attributes: Configures attributes for session affinity.
        :param pulumi.Input[builtins.float] session_affinity_ttl: Time, in seconds, until a client's session expires after being created. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. The accepted ranges per `session_affinity` policy are:
        :param pulumi.Input[builtins.str] steering_policy: Steering Policy for this load balancer.
        :param pulumi.Input[builtins.float] ttl: Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This only applies to gray-clouded (unproxied) load balancers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/loadBalancer:LoadBalancer example '<zone_id>/<load_balancer_id>'
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adaptive_routing: Optional[pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']]] = None,
                 country_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 default_pools: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 fallback_pool: Optional[pulumi.Input[builtins.str]] = None,
                 location_strategy: Optional[pulumi.Input[Union['LoadBalancerLocationStrategyArgs', 'LoadBalancerLocationStrategyArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 pop_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 proxied: Optional[pulumi.Input[builtins.bool]] = None,
                 random_steering: Optional[pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']]] = None,
                 region_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]]] = None,
                 session_affinity: Optional[pulumi.Input[builtins.str]] = None,
                 session_affinity_attributes: Optional[pulumi.Input[Union['LoadBalancerSessionAffinityAttributesArgs', 'LoadBalancerSessionAffinityAttributesArgsDict']]] = None,
                 session_affinity_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 steering_policy: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.float]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            __props__.__dict__["adaptive_routing"] = adaptive_routing
            __props__.__dict__["country_pools"] = country_pools
            if default_pools is None and not opts.urn:
                raise TypeError("Missing required property 'default_pools'")
            __props__.__dict__["default_pools"] = default_pools
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            if fallback_pool is None and not opts.urn:
                raise TypeError("Missing required property 'fallback_pool'")
            __props__.__dict__["fallback_pool"] = fallback_pool
            __props__.__dict__["location_strategy"] = location_strategy
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["networks"] = networks
            __props__.__dict__["pop_pools"] = pop_pools
            __props__.__dict__["proxied"] = proxied
            __props__.__dict__["random_steering"] = random_steering
            __props__.__dict__["region_pools"] = region_pools
            __props__.__dict__["rules"] = rules
            __props__.__dict__["session_affinity"] = session_affinity
            __props__.__dict__["session_affinity_attributes"] = session_affinity_attributes
            __props__.__dict__["session_affinity_ttl"] = session_affinity_ttl
            __props__.__dict__["steering_policy"] = steering_policy
            __props__.__dict__["ttl"] = ttl
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["zone_name"] = None
        super(LoadBalancer, __self__).__init__(
            'cloudflare:index/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            adaptive_routing: Optional[pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']]] = None,
            country_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
            created_on: Optional[pulumi.Input[builtins.str]] = None,
            default_pools: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            fallback_pool: Optional[pulumi.Input[builtins.str]] = None,
            location_strategy: Optional[pulumi.Input[Union['LoadBalancerLocationStrategyArgs', 'LoadBalancerLocationStrategyArgsDict']]] = None,
            modified_on: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            pop_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
            proxied: Optional[pulumi.Input[builtins.bool]] = None,
            random_steering: Optional[pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']]] = None,
            region_pools: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]]] = None,
            session_affinity: Optional[pulumi.Input[builtins.str]] = None,
            session_affinity_attributes: Optional[pulumi.Input[Union['LoadBalancerSessionAffinityAttributesArgs', 'LoadBalancerSessionAffinityAttributesArgsDict']]] = None,
            session_affinity_ttl: Optional[pulumi.Input[builtins.float]] = None,
            steering_policy: Optional[pulumi.Input[builtins.str]] = None,
            ttl: Optional[pulumi.Input[builtins.float]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None,
            zone_name: Optional[pulumi.Input[builtins.str]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadBalancerAdaptiveRoutingArgs', 'LoadBalancerAdaptiveRoutingArgsDict']] adaptive_routing: Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests. For example, zero-downtime failover occurs immediately when an origin becomes unavailable due to HTTP 521, 522, or 523 response codes. If there is another healthy origin in the same pool, the request is retried once against this alternate origin.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] country_pools: A mapping of country codes to a list of pool IDs (ordered by their failover priority) for the given country. Any country not explicitly defined will fall back to using the corresponding region*pool mapping if it exists else to default*pools.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] default_pools: A list of pool IDs ordered by their failover priority. Pools defined here are used by default, or when region_pools are not configured for a given region.
        :param pulumi.Input[builtins.str] description: Object description.
        :param pulumi.Input[builtins.bool] enabled: Whether to enable (the default) this load balancer.
        :param pulumi.Input[builtins.str] fallback_pool: The pool ID to use when all other pools are detected as unhealthy.
        :param pulumi.Input[Union['LoadBalancerLocationStrategyArgs', 'LoadBalancerLocationStrategyArgsDict']] location_strategy: Controls location-based steering for non-proxied requests. See `steering_policy` to learn how steering is affected.
        :param pulumi.Input[builtins.str] name: The DNS hostname to associate with your Load Balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the Load Balancer will take precedence and the DNS record will not be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] networks: List of networks where Load Balancer or Pool is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] pop_pools: (Enterprise only): A mapping of Cloudflare PoP identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). Any PoPs not explicitly defined will fall back to using the corresponding country*pool, then region*pool mapping if it exists else to default_pools.
        :param pulumi.Input[builtins.bool] proxied: Whether the hostname should be gray clouded (false) or orange clouded (true).
        :param pulumi.Input[Union['LoadBalancerRandomSteeringArgs', 'LoadBalancerRandomSteeringArgsDict']] random_steering: Configures pool weights.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] region_pools: A mapping of region codes to a list of pool IDs (ordered by their failover priority) for the given region. Any regions not explicitly defined will fall back to using default_pools.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerRuleArgs', 'LoadBalancerRuleArgsDict']]]] rules: BETA Field Not General Access: A list of rules for this load balancer to execute.
        :param pulumi.Input[builtins.str] session_affinity: Specifies the type of session affinity the load balancer should use unless specified as `"none"`. The supported types are:
        :param pulumi.Input[Union['LoadBalancerSessionAffinityAttributesArgs', 'LoadBalancerSessionAffinityAttributesArgsDict']] session_affinity_attributes: Configures attributes for session affinity.
        :param pulumi.Input[builtins.float] session_affinity_ttl: Time, in seconds, until a client's session expires after being created. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. The accepted ranges per `session_affinity` policy are:
        :param pulumi.Input[builtins.str] steering_policy: Steering Policy for this load balancer.
        :param pulumi.Input[builtins.float] ttl: Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This only applies to gray-clouded (unproxied) load balancers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["adaptive_routing"] = adaptive_routing
        __props__.__dict__["country_pools"] = country_pools
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["default_pools"] = default_pools
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["fallback_pool"] = fallback_pool
        __props__.__dict__["location_strategy"] = location_strategy
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["pop_pools"] = pop_pools
        __props__.__dict__["proxied"] = proxied
        __props__.__dict__["random_steering"] = random_steering
        __props__.__dict__["region_pools"] = region_pools
        __props__.__dict__["rules"] = rules
        __props__.__dict__["session_affinity"] = session_affinity
        __props__.__dict__["session_affinity_attributes"] = session_affinity_attributes
        __props__.__dict__["session_affinity_ttl"] = session_affinity_ttl
        __props__.__dict__["steering_policy"] = steering_policy
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["zone_id"] = zone_id
        __props__.__dict__["zone_name"] = zone_name
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adaptiveRouting")
    def adaptive_routing(self) -> pulumi.Output['outputs.LoadBalancerAdaptiveRouting']:
        """
        Controls features that modify the routing of requests to pools and origins in response to dynamic conditions, such as during the interval between active health monitoring requests. For example, zero-downtime failover occurs immediately when an origin becomes unavailable due to HTTP 521, 522, or 523 response codes. If there is another healthy origin in the same pool, the request is retried once against this alternate origin.
        """
        return pulumi.get(self, "adaptive_routing")

    @property
    @pulumi.getter(name="countryPools")
    def country_pools(self) -> pulumi.Output[Mapping[str, Sequence[builtins.str]]]:
        """
        A mapping of country codes to a list of pool IDs (ordered by their failover priority) for the given country. Any country not explicitly defined will fall back to using the corresponding region*pool mapping if it exists else to default*pools.
        """
        return pulumi.get(self, "country_pools")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="defaultPools")
    def default_pools(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of pool IDs ordered by their failover priority. Pools defined here are used by default, or when region_pools are not configured for a given region.
        """
        return pulumi.get(self, "default_pools")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Object description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to enable (the default) this load balancer.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="fallbackPool")
    def fallback_pool(self) -> pulumi.Output[builtins.str]:
        """
        The pool ID to use when all other pools are detected as unhealthy.
        """
        return pulumi.get(self, "fallback_pool")

    @property
    @pulumi.getter(name="locationStrategy")
    def location_strategy(self) -> pulumi.Output['outputs.LoadBalancerLocationStrategy']:
        """
        Controls location-based steering for non-proxied requests. See `steering_policy` to learn how steering is affected.
        """
        return pulumi.get(self, "location_strategy")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The DNS hostname to associate with your Load Balancer. If this hostname already exists as a DNS record in Cloudflare's DNS, the Load Balancer will take precedence and the DNS record will not be used.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of networks where Load Balancer or Pool is enabled.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="popPools")
    def pop_pools(self) -> pulumi.Output[Mapping[str, Sequence[builtins.str]]]:
        """
        (Enterprise only): A mapping of Cloudflare PoP identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). Any PoPs not explicitly defined will fall back to using the corresponding country*pool, then region*pool mapping if it exists else to default_pools.
        """
        return pulumi.get(self, "pop_pools")

    @property
    @pulumi.getter
    def proxied(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the hostname should be gray clouded (false) or orange clouded (true).
        """
        return pulumi.get(self, "proxied")

    @property
    @pulumi.getter(name="randomSteering")
    def random_steering(self) -> pulumi.Output['outputs.LoadBalancerRandomSteering']:
        """
        Configures pool weights.
        """
        return pulumi.get(self, "random_steering")

    @property
    @pulumi.getter(name="regionPools")
    def region_pools(self) -> pulumi.Output[Mapping[str, Sequence[builtins.str]]]:
        """
        A mapping of region codes to a list of pool IDs (ordered by their failover priority) for the given region. Any regions not explicitly defined will fall back to using default_pools.
        """
        return pulumi.get(self, "region_pools")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.LoadBalancerRule']]:
        """
        BETA Field Not General Access: A list of rules for this load balancer to execute.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the type of session affinity the load balancer should use unless specified as `"none"`. The supported types are:
        """
        return pulumi.get(self, "session_affinity")

    @property
    @pulumi.getter(name="sessionAffinityAttributes")
    def session_affinity_attributes(self) -> pulumi.Output['outputs.LoadBalancerSessionAffinityAttributes']:
        """
        Configures attributes for session affinity.
        """
        return pulumi.get(self, "session_affinity_attributes")

    @property
    @pulumi.getter(name="sessionAffinityTtl")
    def session_affinity_ttl(self) -> pulumi.Output[builtins.float]:
        """
        Time, in seconds, until a client's session expires after being created. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. The accepted ranges per `session_affinity` policy are:
        """
        return pulumi.get(self, "session_affinity_ttl")

    @property
    @pulumi.getter(name="steeringPolicy")
    def steering_policy(self) -> pulumi.Output[builtins.str]:
        """
        Steering Policy for this load balancer.
        """
        return pulumi.get(self, "steering_policy")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[builtins.float]:
        """
        Time to live (TTL) of the DNS entry for the IP address returned by this load balancer. This only applies to gray-clouded (unproxied) load balancers.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "zone_id")

    @property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "zone_name")

