# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LoadBalancerMonitorArgs', 'LoadBalancerMonitor']

@pulumi.input_type
class LoadBalancerMonitorArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 allow_insecure: Optional[pulumi.Input[builtins.bool]] = None,
                 consecutive_down: Optional[pulumi.Input[builtins.int]] = None,
                 consecutive_up: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 expected_body: Optional[pulumi.Input[builtins.str]] = None,
                 expected_codes: Optional[pulumi.Input[builtins.str]] = None,
                 follow_redirects: Optional[pulumi.Input[builtins.bool]] = None,
                 header: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 probe_zone: Optional[pulumi.Input[builtins.str]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a LoadBalancerMonitor resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.bool] allow_insecure: Do not validate the certificate when monitor use HTTPS. This parameter is currently only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] consecutive_down: To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times.
        :param pulumi.Input[builtins.int] consecutive_up: To be marked healthy the monitored origin must pass this healthcheck N consecutive times.
        :param pulumi.Input[builtins.str] description: Object description.
        :param pulumi.Input[builtins.str] expected_body: A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.str] expected_codes: The expected HTTP response code or code range of the health check. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.bool] follow_redirects: Follow redirects if returned by the origin. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] header: The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] interval: The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations.
        :param pulumi.Input[builtins.str] method: The method to use for the health check. This defaults to 'GET' for HTTP/HTTPS based checks and 'connection_established' for TCP based health checks.
        :param pulumi.Input[builtins.str] path: The endpoint path you want to conduct a health check against. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] port: The port number to connect to for the health check. Required for TCP, UDP, and SMTP checks. HTTP and HTTPS checks should only define the port when using a non-standard port (HTTP: default 80, HTTPS: default 443).
        :param pulumi.Input[builtins.str] probe_zone: Assign this monitor to emulate the specified zone while probing. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        :param pulumi.Input[builtins.int] timeout: The timeout (in seconds) before marking the health check as failed.
        :param pulumi.Input[builtins.str] type: The protocol to use for the health check. Currently supported protocols are 'HTTP','HTTPS', 'TCP', 'ICMP-PING', 'UDP-ICMP', and 'SMTP'.
               Available values: "http", "https", "tcp", "udp*icmp", "icmp*ping", "smtp".
        """
        pulumi.set(__self__, "account_id", account_id)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if consecutive_down is not None:
            pulumi.set(__self__, "consecutive_down", consecutive_down)
        if consecutive_up is not None:
            pulumi.set(__self__, "consecutive_up", consecutive_up)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expected_body is not None:
            pulumi.set(__self__, "expected_body", expected_body)
        if expected_codes is not None:
            pulumi.set(__self__, "expected_codes", expected_codes)
        if follow_redirects is not None:
            pulumi.set(__self__, "follow_redirects", follow_redirects)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if probe_zone is not None:
            pulumi.set(__self__, "probe_zone", probe_zone)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Do not validate the certificate when monitor use HTTPS. This parameter is currently only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_insecure", value)

    @property
    @pulumi.getter(name="consecutiveDown")
    def consecutive_down(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times.
        """
        return pulumi.get(self, "consecutive_down")

    @consecutive_down.setter
    def consecutive_down(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "consecutive_down", value)

    @property
    @pulumi.getter(name="consecutiveUp")
    def consecutive_up(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        To be marked healthy the monitored origin must pass this healthcheck N consecutive times.
        """
        return pulumi.get(self, "consecutive_up")

    @consecutive_up.setter
    def consecutive_up(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "consecutive_up", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Object description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expectedBody")
    def expected_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "expected_body")

    @expected_body.setter
    def expected_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expected_body", value)

    @property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The expected HTTP response code or code range of the health check. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "expected_codes")

    @expected_codes.setter
    def expected_codes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expected_codes", value)

    @property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Follow redirects if returned by the origin. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "follow_redirects")

    @follow_redirects.setter
    def follow_redirects(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "follow_redirects", value)

    @property
    @pulumi.getter
    def header(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The method to use for the health check. This defaults to 'GET' for HTTP/HTTPS based checks and 'connection_established' for TCP based health checks.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint path you want to conduct a health check against. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port number to connect to for the health check. Required for TCP, UDP, and SMTP checks. HTTP and HTTPS checks should only define the port when using a non-standard port (HTTP: default 80, HTTPS: default 443).
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="probeZone")
    def probe_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Assign this monitor to emulate the specified zone while probing. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "probe_zone")

    @probe_zone.setter
    def probe_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "probe_zone", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The timeout (in seconds) before marking the health check as failed.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protocol to use for the health check. Currently supported protocols are 'HTTP','HTTPS', 'TCP', 'ICMP-PING', 'UDP-ICMP', and 'SMTP'.
        Available values: "http", "https", "tcp", "udp*icmp", "icmp*ping", "smtp".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _LoadBalancerMonitorState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 allow_insecure: Optional[pulumi.Input[builtins.bool]] = None,
                 consecutive_down: Optional[pulumi.Input[builtins.int]] = None,
                 consecutive_up: Optional[pulumi.Input[builtins.int]] = None,
                 created_on: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 expected_body: Optional[pulumi.Input[builtins.str]] = None,
                 expected_codes: Optional[pulumi.Input[builtins.str]] = None,
                 follow_redirects: Optional[pulumi.Input[builtins.bool]] = None,
                 header: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 probe_zone: Optional[pulumi.Input[builtins.str]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancerMonitor resources.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.bool] allow_insecure: Do not validate the certificate when monitor use HTTPS. This parameter is currently only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] consecutive_down: To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times.
        :param pulumi.Input[builtins.int] consecutive_up: To be marked healthy the monitored origin must pass this healthcheck N consecutive times.
        :param pulumi.Input[builtins.str] description: Object description.
        :param pulumi.Input[builtins.str] expected_body: A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.str] expected_codes: The expected HTTP response code or code range of the health check. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.bool] follow_redirects: Follow redirects if returned by the origin. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] header: The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] interval: The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations.
        :param pulumi.Input[builtins.str] method: The method to use for the health check. This defaults to 'GET' for HTTP/HTTPS based checks and 'connection_established' for TCP based health checks.
        :param pulumi.Input[builtins.str] path: The endpoint path you want to conduct a health check against. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] port: The port number to connect to for the health check. Required for TCP, UDP, and SMTP checks. HTTP and HTTPS checks should only define the port when using a non-standard port (HTTP: default 80, HTTPS: default 443).
        :param pulumi.Input[builtins.str] probe_zone: Assign this monitor to emulate the specified zone while probing. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        :param pulumi.Input[builtins.int] timeout: The timeout (in seconds) before marking the health check as failed.
        :param pulumi.Input[builtins.str] type: The protocol to use for the health check. Currently supported protocols are 'HTTP','HTTPS', 'TCP', 'ICMP-PING', 'UDP-ICMP', and 'SMTP'.
               Available values: "http", "https", "tcp", "udp*icmp", "icmp*ping", "smtp".
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if consecutive_down is not None:
            pulumi.set(__self__, "consecutive_down", consecutive_down)
        if consecutive_up is not None:
            pulumi.set(__self__, "consecutive_up", consecutive_up)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expected_body is not None:
            pulumi.set(__self__, "expected_body", expected_body)
        if expected_codes is not None:
            pulumi.set(__self__, "expected_codes", expected_codes)
        if follow_redirects is not None:
            pulumi.set(__self__, "follow_redirects", follow_redirects)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if probe_zone is not None:
            pulumi.set(__self__, "probe_zone", probe_zone)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Do not validate the certificate when monitor use HTTPS. This parameter is currently only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_insecure", value)

    @property
    @pulumi.getter(name="consecutiveDown")
    def consecutive_down(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times.
        """
        return pulumi.get(self, "consecutive_down")

    @consecutive_down.setter
    def consecutive_down(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "consecutive_down", value)

    @property
    @pulumi.getter(name="consecutiveUp")
    def consecutive_up(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        To be marked healthy the monitored origin must pass this healthcheck N consecutive times.
        """
        return pulumi.get(self, "consecutive_up")

    @consecutive_up.setter
    def consecutive_up(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "consecutive_up", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Object description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expectedBody")
    def expected_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "expected_body")

    @expected_body.setter
    def expected_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expected_body", value)

    @property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The expected HTTP response code or code range of the health check. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "expected_codes")

    @expected_codes.setter
    def expected_codes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expected_codes", value)

    @property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Follow redirects if returned by the origin. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "follow_redirects")

    @follow_redirects.setter
    def follow_redirects(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "follow_redirects", value)

    @property
    @pulumi.getter
    def header(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The method to use for the health check. This defaults to 'GET' for HTTP/HTTPS based checks and 'connection_established' for TCP based health checks.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint path you want to conduct a health check against. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port number to connect to for the health check. Required for TCP, UDP, and SMTP checks. HTTP and HTTPS checks should only define the port when using a non-standard port (HTTP: default 80, HTTPS: default 443).
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="probeZone")
    def probe_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Assign this monitor to emulate the specified zone while probing. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "probe_zone")

    @probe_zone.setter
    def probe_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "probe_zone", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The timeout (in seconds) before marking the health check as failed.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protocol to use for the health check. Currently supported protocols are 'HTTP','HTTPS', 'TCP', 'ICMP-PING', 'UDP-ICMP', and 'SMTP'.
        Available values: "http", "https", "tcp", "udp*icmp", "icmp*ping", "smtp".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("cloudflare:index/loadBalancerMonitor:LoadBalancerMonitor")
class LoadBalancerMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 allow_insecure: Optional[pulumi.Input[builtins.bool]] = None,
                 consecutive_down: Optional[pulumi.Input[builtins.int]] = None,
                 consecutive_up: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 expected_body: Optional[pulumi.Input[builtins.str]] = None,
                 expected_codes: Optional[pulumi.Input[builtins.str]] = None,
                 follow_redirects: Optional[pulumi.Input[builtins.bool]] = None,
                 header: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 probe_zone: Optional[pulumi.Input[builtins.str]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_load_balancer_monitor = cloudflare.LoadBalancerMonitor("example_load_balancer_monitor",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            allow_insecure=True,
            consecutive_down=0,
            consecutive_up=0,
            description="Login page monitor",
            expected_body="alive",
            expected_codes="2xx",
            follow_redirects=True,
            header={
                "Host": ["example.com"],
                "X-App-ID": ["abc123"],
            },
            interval=0,
            method="GET",
            path="/health",
            port=0,
            probe_zone="example.com",
            retries=0,
            timeout=0,
            type="https")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/loadBalancerMonitor:LoadBalancerMonitor example '<account_id>/<monitor_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.bool] allow_insecure: Do not validate the certificate when monitor use HTTPS. This parameter is currently only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] consecutive_down: To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times.
        :param pulumi.Input[builtins.int] consecutive_up: To be marked healthy the monitored origin must pass this healthcheck N consecutive times.
        :param pulumi.Input[builtins.str] description: Object description.
        :param pulumi.Input[builtins.str] expected_body: A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.str] expected_codes: The expected HTTP response code or code range of the health check. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.bool] follow_redirects: Follow redirects if returned by the origin. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] header: The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] interval: The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations.
        :param pulumi.Input[builtins.str] method: The method to use for the health check. This defaults to 'GET' for HTTP/HTTPS based checks and 'connection_established' for TCP based health checks.
        :param pulumi.Input[builtins.str] path: The endpoint path you want to conduct a health check against. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] port: The port number to connect to for the health check. Required for TCP, UDP, and SMTP checks. HTTP and HTTPS checks should only define the port when using a non-standard port (HTTP: default 80, HTTPS: default 443).
        :param pulumi.Input[builtins.str] probe_zone: Assign this monitor to emulate the specified zone while probing. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        :param pulumi.Input[builtins.int] timeout: The timeout (in seconds) before marking the health check as failed.
        :param pulumi.Input[builtins.str] type: The protocol to use for the health check. Currently supported protocols are 'HTTP','HTTPS', 'TCP', 'ICMP-PING', 'UDP-ICMP', and 'SMTP'.
               Available values: "http", "https", "tcp", "udp*icmp", "icmp*ping", "smtp".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_load_balancer_monitor = cloudflare.LoadBalancerMonitor("example_load_balancer_monitor",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            allow_insecure=True,
            consecutive_down=0,
            consecutive_up=0,
            description="Login page monitor",
            expected_body="alive",
            expected_codes="2xx",
            follow_redirects=True,
            header={
                "Host": ["example.com"],
                "X-App-ID": ["abc123"],
            },
            interval=0,
            method="GET",
            path="/health",
            port=0,
            probe_zone="example.com",
            retries=0,
            timeout=0,
            type="https")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/loadBalancerMonitor:LoadBalancerMonitor example '<account_id>/<monitor_id>'
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 allow_insecure: Optional[pulumi.Input[builtins.bool]] = None,
                 consecutive_down: Optional[pulumi.Input[builtins.int]] = None,
                 consecutive_up: Optional[pulumi.Input[builtins.int]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 expected_body: Optional[pulumi.Input[builtins.str]] = None,
                 expected_codes: Optional[pulumi.Input[builtins.str]] = None,
                 follow_redirects: Optional[pulumi.Input[builtins.bool]] = None,
                 header: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 probe_zone: Optional[pulumi.Input[builtins.str]] = None,
                 retries: Optional[pulumi.Input[builtins.int]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerMonitorArgs.__new__(LoadBalancerMonitorArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["allow_insecure"] = allow_insecure
            __props__.__dict__["consecutive_down"] = consecutive_down
            __props__.__dict__["consecutive_up"] = consecutive_up
            __props__.__dict__["description"] = description
            __props__.__dict__["expected_body"] = expected_body
            __props__.__dict__["expected_codes"] = expected_codes
            __props__.__dict__["follow_redirects"] = follow_redirects
            __props__.__dict__["header"] = header
            __props__.__dict__["interval"] = interval
            __props__.__dict__["method"] = method
            __props__.__dict__["path"] = path
            __props__.__dict__["port"] = port
            __props__.__dict__["probe_zone"] = probe_zone
            __props__.__dict__["retries"] = retries
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["type"] = type
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        super(LoadBalancerMonitor, __self__).__init__(
            'cloudflare:index/loadBalancerMonitor:LoadBalancerMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            allow_insecure: Optional[pulumi.Input[builtins.bool]] = None,
            consecutive_down: Optional[pulumi.Input[builtins.int]] = None,
            consecutive_up: Optional[pulumi.Input[builtins.int]] = None,
            created_on: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            expected_body: Optional[pulumi.Input[builtins.str]] = None,
            expected_codes: Optional[pulumi.Input[builtins.str]] = None,
            follow_redirects: Optional[pulumi.Input[builtins.bool]] = None,
            header: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
            interval: Optional[pulumi.Input[builtins.int]] = None,
            method: Optional[pulumi.Input[builtins.str]] = None,
            modified_on: Optional[pulumi.Input[builtins.str]] = None,
            path: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            probe_zone: Optional[pulumi.Input[builtins.str]] = None,
            retries: Optional[pulumi.Input[builtins.int]] = None,
            timeout: Optional[pulumi.Input[builtins.int]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'LoadBalancerMonitor':
        """
        Get an existing LoadBalancerMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.bool] allow_insecure: Do not validate the certificate when monitor use HTTPS. This parameter is currently only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] consecutive_down: To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times.
        :param pulumi.Input[builtins.int] consecutive_up: To be marked healthy the monitored origin must pass this healthcheck N consecutive times.
        :param pulumi.Input[builtins.str] description: Object description.
        :param pulumi.Input[builtins.str] expected_body: A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.str] expected_codes: The expected HTTP response code or code range of the health check. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.bool] follow_redirects: Follow redirects if returned by the origin. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] header: The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] interval: The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations.
        :param pulumi.Input[builtins.str] method: The method to use for the health check. This defaults to 'GET' for HTTP/HTTPS based checks and 'connection_established' for TCP based health checks.
        :param pulumi.Input[builtins.str] path: The endpoint path you want to conduct a health check against. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] port: The port number to connect to for the health check. Required for TCP, UDP, and SMTP checks. HTTP and HTTPS checks should only define the port when using a non-standard port (HTTP: default 80, HTTPS: default 443).
        :param pulumi.Input[builtins.str] probe_zone: Assign this monitor to emulate the specified zone while probing. This parameter is only valid for HTTP and HTTPS monitors.
        :param pulumi.Input[builtins.int] retries: The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        :param pulumi.Input[builtins.int] timeout: The timeout (in seconds) before marking the health check as failed.
        :param pulumi.Input[builtins.str] type: The protocol to use for the health check. Currently supported protocols are 'HTTP','HTTPS', 'TCP', 'ICMP-PING', 'UDP-ICMP', and 'SMTP'.
               Available values: "http", "https", "tcp", "udp*icmp", "icmp*ping", "smtp".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerMonitorState.__new__(_LoadBalancerMonitorState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["allow_insecure"] = allow_insecure
        __props__.__dict__["consecutive_down"] = consecutive_down
        __props__.__dict__["consecutive_up"] = consecutive_up
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["description"] = description
        __props__.__dict__["expected_body"] = expected_body
        __props__.__dict__["expected_codes"] = expected_codes
        __props__.__dict__["follow_redirects"] = follow_redirects
        __props__.__dict__["header"] = header
        __props__.__dict__["interval"] = interval
        __props__.__dict__["method"] = method
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["path"] = path
        __props__.__dict__["port"] = port
        __props__.__dict__["probe_zone"] = probe_zone
        __props__.__dict__["retries"] = retries
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["type"] = type
        return LoadBalancerMonitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> pulumi.Output[builtins.bool]:
        """
        Do not validate the certificate when monitor use HTTPS. This parameter is currently only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter(name="consecutiveDown")
    def consecutive_down(self) -> pulumi.Output[builtins.int]:
        """
        To be marked unhealthy the monitored origin must fail this healthcheck N consecutive times.
        """
        return pulumi.get(self, "consecutive_down")

    @property
    @pulumi.getter(name="consecutiveUp")
    def consecutive_up(self) -> pulumi.Output[builtins.int]:
        """
        To be marked healthy the monitored origin must pass this healthcheck N consecutive times.
        """
        return pulumi.get(self, "consecutive_up")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Object description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expectedBody")
    def expected_body(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A case-insensitive sub-string to look for in the response body. If this string is not found, the origin will be marked as unhealthy. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "expected_body")

    @property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The expected HTTP response code or code range of the health check. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "expected_codes")

    @property
    @pulumi.getter(name="followRedirects")
    def follow_redirects(self) -> pulumi.Output[builtins.bool]:
        """
        Follow redirects if returned by the origin. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "follow_redirects")

    @property
    @pulumi.getter
    def header(self) -> pulumi.Output[Optional[Mapping[str, Sequence[builtins.str]]]]:
        """
        The HTTP request headers to send in the health check. It is recommended you set a Host header by default. The User-Agent header cannot be overridden. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[builtins.int]:
        """
        The interval between each health check. Shorter intervals may improve failover time, but will increase load on the origins as we check from multiple locations.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def method(self) -> pulumi.Output[builtins.str]:
        """
        The method to use for the health check. This defaults to 'GET' for HTTP/HTTPS based checks and 'connection_established' for TCP based health checks.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint path you want to conduct a health check against. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        The port number to connect to for the health check. Required for TCP, UDP, and SMTP checks. HTTP and HTTPS checks should only define the port when using a non-standard port (HTTP: default 80, HTTPS: default 443).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="probeZone")
    def probe_zone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Assign this monitor to emulate the specified zone while probing. This parameter is only valid for HTTP and HTTPS monitors.
        """
        return pulumi.get(self, "probe_zone")

    @property
    @pulumi.getter
    def retries(self) -> pulumi.Output[builtins.int]:
        """
        The number of retries to attempt in case of a timeout before marking the origin as unhealthy. Retries are attempted immediately.
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[builtins.int]:
        """
        The timeout (in seconds) before marking the health check as failed.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The protocol to use for the health check. Currently supported protocols are 'HTTP','HTTPS', 'TCP', 'ICMP-PING', 'UDP-ICMP', and 'SMTP'.
        Available values: "http", "https", "tcp", "udp*icmp", "icmp*ping", "smtp".
        """
        return pulumi.get(self, "type")

