# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LogpullRetentionArgs', 'LogpullRetention']

@pulumi.input_type
class LogpullRetentionArgs:
    def __init__(__self__, *,
                 zone_id: pulumi.Input[builtins.str],
                 flag: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a LogpullRetention resource.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        :param pulumi.Input[builtins.bool] flag: The log retention flag for Logpull API.
        """
        pulumi.set(__self__, "zone_id", zone_id)
        if flag is not None:
            pulumi.set(__self__, "flag", flag)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter
    def flag(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The log retention flag for Logpull API.
        """
        return pulumi.get(self, "flag")

    @flag.setter
    def flag(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "flag", value)


@pulumi.input_type
class _LogpullRetentionState:
    def __init__(__self__, *,
                 flag: Optional[pulumi.Input[builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogpullRetention resources.
        :param pulumi.Input[builtins.bool] flag: The log retention flag for Logpull API.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        if flag is not None:
            pulumi.set(__self__, "flag", flag)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def flag(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The log retention flag for Logpull API.
        """
        return pulumi.get(self, "flag")

    @flag.setter
    def flag(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "flag", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/logpullRetention:LogpullRetention")
class LogpullRetention(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 flag: Optional[pulumi.Input[builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_logpull_retention = cloudflare.LogpullRetention("example_logpull_retention",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            flag=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] flag: The log retention flag for Logpull API.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogpullRetentionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_logpull_retention = cloudflare.LogpullRetention("example_logpull_retention",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            flag=True)
        ```

        :param str resource_name: The name of the resource.
        :param LogpullRetentionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogpullRetentionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 flag: Optional[pulumi.Input[builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogpullRetentionArgs.__new__(LogpullRetentionArgs)

            __props__.__dict__["flag"] = flag
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(LogpullRetention, __self__).__init__(
            'cloudflare:index/logpullRetention:LogpullRetention',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            flag: Optional[pulumi.Input[builtins.bool]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'LogpullRetention':
        """
        Get an existing LogpullRetention resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] flag: The log retention flag for Logpull API.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogpullRetentionState.__new__(_LogpullRetentionState)

        __props__.__dict__["flag"] = flag
        __props__.__dict__["zone_id"] = zone_id
        return LogpullRetention(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def flag(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        The log retention flag for Logpull API.
        """
        return pulumi.get(self, "flag")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

