# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogpushJobArgs', 'LogpushJob']

@pulumi.input_type
class LogpushJobArgs:
    def __init__(__self__, *,
                 destination_conf: pulumi.Input[builtins.str],
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 dataset: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 logpull_options: Optional[pulumi.Input[builtins.str]] = None,
                 max_upload_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 max_upload_interval_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 max_upload_records: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 output_options: Optional[pulumi.Input['LogpushJobOutputOptionsArgs']] = None,
                 ownership_challenge: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a LogpushJob resource.
        :param pulumi.Input[builtins.str] destination_conf: Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[builtins.str] dataset: Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
               Available values: "access*requests", "audit*logs", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
        :param pulumi.Input[builtins.bool] enabled: Flag that indicates if the job is enabled.
        :param pulumi.Input[builtins.str] filter: The filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/filters/).
        :param pulumi.Input[builtins.str] frequency: This field is deprecated. Please use `max_upload_*` parameters instead. The frequency at which Cloudflare sends batches of logs to your destination. Setting frequency to high sends your logs in larger quantities of smaller files. Setting frequency to low sends logs in smaller quantities of larger files.
               Available values: "high", "low".
        :param pulumi.Input[builtins.str] kind: The kind parameter (optional) is used to differentiate between Logpush and Edge Log Delivery jobs. Currently, Edge Log Delivery is only supported for the `http_requests` dataset.
               Available values: "edge".
        :param pulumi.Input[builtins.str] logpull_options: This field is deprecated. Use `output_options` instead. Configuration string. It specifies things like requested fields and timestamp formats. If migrating from the logpull api, copy the url (full url or just the query string) of your call here, and logpush will keep on making this call for you, setting start and end times appropriately.
        :param pulumi.Input[builtins.int] max_upload_bytes: The maximum uncompressed file size of a batch of logs. This setting value must be between `5 MB` and `1 GB`, or `0` to disable it. Note that you cannot set a minimum file size; this means that log files may be much smaller than this batch size. This parameter is not available for jobs with `edge` as its kind.
        :param pulumi.Input[builtins.int] max_upload_interval_seconds: The maximum interval in seconds for log batches. This setting must be between 30 and 300 seconds (5 minutes), or `0` to disable it. Note that you cannot specify a minimum interval for log batches; this means that log files may be sent in shorter intervals than this. This parameter is only used for jobs with `edge` as its kind.
        :param pulumi.Input[builtins.int] max_upload_records: The maximum number of log lines per batch. This setting must be between 1000 and 1,000,000 lines, or `0` to disable it. Note that you cannot specify a minimum number of log lines per batch; this means that log files may contain many fewer lines than this. This parameter is not available for jobs with `edge` as its kind.
        :param pulumi.Input[builtins.str] name: Optional human readable job name. Not unique. Cloudflare suggests that you set this to a meaningful string, like the domain name, to make it easier to identify your job.
        :param pulumi.Input['LogpushJobOutputOptionsArgs'] output_options: The structured replacement for `logpull_options`. When including this field, the `logpull_option` field will be ignored.
        :param pulumi.Input[builtins.str] ownership_challenge: Ownership challenge token to prove destination ownership.
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        pulumi.set(__self__, "destination_conf", destination_conf)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if frequency is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""frequency is deprecated: This attribute is deprecated.""")
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if logpull_options is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""logpull_options is deprecated: This attribute is deprecated.""")
        if logpull_options is not None:
            pulumi.set(__self__, "logpull_options", logpull_options)
        if max_upload_bytes is not None:
            pulumi.set(__self__, "max_upload_bytes", max_upload_bytes)
        if max_upload_interval_seconds is not None:
            pulumi.set(__self__, "max_upload_interval_seconds", max_upload_interval_seconds)
        if max_upload_records is not None:
            pulumi.set(__self__, "max_upload_records", max_upload_records)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_options is not None:
            pulumi.set(__self__, "output_options", output_options)
        if ownership_challenge is not None:
            pulumi.set(__self__, "ownership_challenge", ownership_challenge)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="destinationConf")
    def destination_conf(self) -> pulumi.Input[builtins.str]:
        """
        Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included.
        """
        return pulumi.get(self, "destination_conf")

    @destination_conf.setter
    def destination_conf(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination_conf", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
        Available values: "access*requests", "audit*logs", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates if the job is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/filters/).
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field is deprecated. Please use `max_upload_*` parameters instead. The frequency at which Cloudflare sends batches of logs to your destination. Setting frequency to high sends your logs in larger quantities of smaller files. Setting frequency to low sends logs in smaller quantities of larger files.
        Available values: "high", "low".
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind parameter (optional) is used to differentiate between Logpush and Edge Log Delivery jobs. Currently, Edge Log Delivery is only supported for the `http_requests` dataset.
        Available values: "edge".
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="logpullOptions")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def logpull_options(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field is deprecated. Use `output_options` instead. Configuration string. It specifies things like requested fields and timestamp formats. If migrating from the logpull api, copy the url (full url or just the query string) of your call here, and logpush will keep on making this call for you, setting start and end times appropriately.
        """
        return pulumi.get(self, "logpull_options")

    @logpull_options.setter
    def logpull_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logpull_options", value)

    @property
    @pulumi.getter(name="maxUploadBytes")
    def max_upload_bytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum uncompressed file size of a batch of logs. This setting value must be between `5 MB` and `1 GB`, or `0` to disable it. Note that you cannot set a minimum file size; this means that log files may be much smaller than this batch size. This parameter is not available for jobs with `edge` as its kind.
        """
        return pulumi.get(self, "max_upload_bytes")

    @max_upload_bytes.setter
    def max_upload_bytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_upload_bytes", value)

    @property
    @pulumi.getter(name="maxUploadIntervalSeconds")
    def max_upload_interval_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum interval in seconds for log batches. This setting must be between 30 and 300 seconds (5 minutes), or `0` to disable it. Note that you cannot specify a minimum interval for log batches; this means that log files may be sent in shorter intervals than this. This parameter is only used for jobs with `edge` as its kind.
        """
        return pulumi.get(self, "max_upload_interval_seconds")

    @max_upload_interval_seconds.setter
    def max_upload_interval_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_upload_interval_seconds", value)

    @property
    @pulumi.getter(name="maxUploadRecords")
    def max_upload_records(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of log lines per batch. This setting must be between 1000 and 1,000,000 lines, or `0` to disable it. Note that you cannot specify a minimum number of log lines per batch; this means that log files may contain many fewer lines than this. This parameter is not available for jobs with `edge` as its kind.
        """
        return pulumi.get(self, "max_upload_records")

    @max_upload_records.setter
    def max_upload_records(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_upload_records", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional human readable job name. Not unique. Cloudflare suggests that you set this to a meaningful string, like the domain name, to make it easier to identify your job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputOptions")
    def output_options(self) -> Optional[pulumi.Input['LogpushJobOutputOptionsArgs']]:
        """
        The structured replacement for `logpull_options`. When including this field, the `logpull_option` field will be ignored.
        """
        return pulumi.get(self, "output_options")

    @output_options.setter
    def output_options(self, value: Optional[pulumi.Input['LogpushJobOutputOptionsArgs']]):
        pulumi.set(self, "output_options", value)

    @property
    @pulumi.getter(name="ownershipChallenge")
    def ownership_challenge(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Ownership challenge token to prove destination ownership.
        """
        return pulumi.get(self, "ownership_challenge")

    @ownership_challenge.setter
    def ownership_challenge(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ownership_challenge", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _LogpushJobState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 dataset: Optional[pulumi.Input[builtins.str]] = None,
                 destination_conf: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 error_message: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 last_complete: Optional[pulumi.Input[builtins.str]] = None,
                 last_error: Optional[pulumi.Input[builtins.str]] = None,
                 logpull_options: Optional[pulumi.Input[builtins.str]] = None,
                 max_upload_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 max_upload_interval_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 max_upload_records: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 output_options: Optional[pulumi.Input['LogpushJobOutputOptionsArgs']] = None,
                 ownership_challenge: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogpushJob resources.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[builtins.str] dataset: Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
               Available values: "access*requests", "audit*logs", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
        :param pulumi.Input[builtins.str] destination_conf: Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included.
        :param pulumi.Input[builtins.bool] enabled: Flag that indicates if the job is enabled.
        :param pulumi.Input[builtins.str] error_message: If not null, the job is currently failing. Failures are usually repetitive (example: no permissions to write to destination bucket). Only the last failure is recorded. On successful execution of a job the error*message and last*error are set to null.
        :param pulumi.Input[builtins.str] filter: The filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/filters/).
        :param pulumi.Input[builtins.str] frequency: This field is deprecated. Please use `max_upload_*` parameters instead. The frequency at which Cloudflare sends batches of logs to your destination. Setting frequency to high sends your logs in larger quantities of smaller files. Setting frequency to low sends logs in smaller quantities of larger files.
               Available values: "high", "low".
        :param pulumi.Input[builtins.str] kind: The kind parameter (optional) is used to differentiate between Logpush and Edge Log Delivery jobs. Currently, Edge Log Delivery is only supported for the `http_requests` dataset.
               Available values: "edge".
        :param pulumi.Input[builtins.str] last_complete: Records the last time for which logs have been successfully pushed. If the last successful push was for logs range 2018-07-23T10:00:00Z to 2018-07-23T10:01:00Z then the value of this field will be 2018-07-23T10:01:00Z. If the job has never run or has just been enabled and hasn't run yet then the field will be empty.
        :param pulumi.Input[builtins.str] last_error: Records the last time the job failed. If not null, the job is currently failing. If null, the job has either never failed or has run successfully at least once since last failure. See also the error_message field.
        :param pulumi.Input[builtins.str] logpull_options: This field is deprecated. Use `output_options` instead. Configuration string. It specifies things like requested fields and timestamp formats. If migrating from the logpull api, copy the url (full url or just the query string) of your call here, and logpush will keep on making this call for you, setting start and end times appropriately.
        :param pulumi.Input[builtins.int] max_upload_bytes: The maximum uncompressed file size of a batch of logs. This setting value must be between `5 MB` and `1 GB`, or `0` to disable it. Note that you cannot set a minimum file size; this means that log files may be much smaller than this batch size. This parameter is not available for jobs with `edge` as its kind.
        :param pulumi.Input[builtins.int] max_upload_interval_seconds: The maximum interval in seconds for log batches. This setting must be between 30 and 300 seconds (5 minutes), or `0` to disable it. Note that you cannot specify a minimum interval for log batches; this means that log files may be sent in shorter intervals than this. This parameter is only used for jobs with `edge` as its kind.
        :param pulumi.Input[builtins.int] max_upload_records: The maximum number of log lines per batch. This setting must be between 1000 and 1,000,000 lines, or `0` to disable it. Note that you cannot specify a minimum number of log lines per batch; this means that log files may contain many fewer lines than this. This parameter is not available for jobs with `edge` as its kind.
        :param pulumi.Input[builtins.str] name: Optional human readable job name. Not unique. Cloudflare suggests that you set this to a meaningful string, like the domain name, to make it easier to identify your job.
        :param pulumi.Input['LogpushJobOutputOptionsArgs'] output_options: The structured replacement for `logpull_options`. When including this field, the `logpull_option` field will be ignored.
        :param pulumi.Input[builtins.str] ownership_challenge: Ownership challenge token to prove destination ownership.
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if destination_conf is not None:
            pulumi.set(__self__, "destination_conf", destination_conf)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if frequency is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""frequency is deprecated: This attribute is deprecated.""")
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if last_complete is not None:
            pulumi.set(__self__, "last_complete", last_complete)
        if last_error is not None:
            pulumi.set(__self__, "last_error", last_error)
        if logpull_options is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""logpull_options is deprecated: This attribute is deprecated.""")
        if logpull_options is not None:
            pulumi.set(__self__, "logpull_options", logpull_options)
        if max_upload_bytes is not None:
            pulumi.set(__self__, "max_upload_bytes", max_upload_bytes)
        if max_upload_interval_seconds is not None:
            pulumi.set(__self__, "max_upload_interval_seconds", max_upload_interval_seconds)
        if max_upload_records is not None:
            pulumi.set(__self__, "max_upload_records", max_upload_records)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_options is not None:
            pulumi.set(__self__, "output_options", output_options)
        if ownership_challenge is not None:
            pulumi.set(__self__, "ownership_challenge", ownership_challenge)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
        Available values: "access*requests", "audit*logs", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="destinationConf")
    def destination_conf(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included.
        """
        return pulumi.get(self, "destination_conf")

    @destination_conf.setter
    def destination_conf(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_conf", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag that indicates if the job is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If not null, the job is currently failing. Failures are usually repetitive (example: no permissions to write to destination bucket). Only the last failure is recorded. On successful execution of a job the error*message and last*error are set to null.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "error_message", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/filters/).
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field is deprecated. Please use `max_upload_*` parameters instead. The frequency at which Cloudflare sends batches of logs to your destination. Setting frequency to high sends your logs in larger quantities of smaller files. Setting frequency to low sends logs in smaller quantities of larger files.
        Available values: "high", "low".
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind parameter (optional) is used to differentiate between Logpush and Edge Log Delivery jobs. Currently, Edge Log Delivery is only supported for the `http_requests` dataset.
        Available values: "edge".
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="lastComplete")
    def last_complete(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Records the last time for which logs have been successfully pushed. If the last successful push was for logs range 2018-07-23T10:00:00Z to 2018-07-23T10:01:00Z then the value of this field will be 2018-07-23T10:01:00Z. If the job has never run or has just been enabled and hasn't run yet then the field will be empty.
        """
        return pulumi.get(self, "last_complete")

    @last_complete.setter
    def last_complete(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_complete", value)

    @property
    @pulumi.getter(name="lastError")
    def last_error(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Records the last time the job failed. If not null, the job is currently failing. If null, the job has either never failed or has run successfully at least once since last failure. See also the error_message field.
        """
        return pulumi.get(self, "last_error")

    @last_error.setter
    def last_error(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_error", value)

    @property
    @pulumi.getter(name="logpullOptions")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def logpull_options(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This field is deprecated. Use `output_options` instead. Configuration string. It specifies things like requested fields and timestamp formats. If migrating from the logpull api, copy the url (full url or just the query string) of your call here, and logpush will keep on making this call for you, setting start and end times appropriately.
        """
        return pulumi.get(self, "logpull_options")

    @logpull_options.setter
    def logpull_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logpull_options", value)

    @property
    @pulumi.getter(name="maxUploadBytes")
    def max_upload_bytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum uncompressed file size of a batch of logs. This setting value must be between `5 MB` and `1 GB`, or `0` to disable it. Note that you cannot set a minimum file size; this means that log files may be much smaller than this batch size. This parameter is not available for jobs with `edge` as its kind.
        """
        return pulumi.get(self, "max_upload_bytes")

    @max_upload_bytes.setter
    def max_upload_bytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_upload_bytes", value)

    @property
    @pulumi.getter(name="maxUploadIntervalSeconds")
    def max_upload_interval_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum interval in seconds for log batches. This setting must be between 30 and 300 seconds (5 minutes), or `0` to disable it. Note that you cannot specify a minimum interval for log batches; this means that log files may be sent in shorter intervals than this. This parameter is only used for jobs with `edge` as its kind.
        """
        return pulumi.get(self, "max_upload_interval_seconds")

    @max_upload_interval_seconds.setter
    def max_upload_interval_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_upload_interval_seconds", value)

    @property
    @pulumi.getter(name="maxUploadRecords")
    def max_upload_records(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of log lines per batch. This setting must be between 1000 and 1,000,000 lines, or `0` to disable it. Note that you cannot specify a minimum number of log lines per batch; this means that log files may contain many fewer lines than this. This parameter is not available for jobs with `edge` as its kind.
        """
        return pulumi.get(self, "max_upload_records")

    @max_upload_records.setter
    def max_upload_records(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_upload_records", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional human readable job name. Not unique. Cloudflare suggests that you set this to a meaningful string, like the domain name, to make it easier to identify your job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputOptions")
    def output_options(self) -> Optional[pulumi.Input['LogpushJobOutputOptionsArgs']]:
        """
        The structured replacement for `logpull_options`. When including this field, the `logpull_option` field will be ignored.
        """
        return pulumi.get(self, "output_options")

    @output_options.setter
    def output_options(self, value: Optional[pulumi.Input['LogpushJobOutputOptionsArgs']]):
        pulumi.set(self, "output_options", value)

    @property
    @pulumi.getter(name="ownershipChallenge")
    def ownership_challenge(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Ownership challenge token to prove destination ownership.
        """
        return pulumi.get(self, "ownership_challenge")

    @ownership_challenge.setter
    def ownership_challenge(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ownership_challenge", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/logpushJob:LogpushJob")
class LogpushJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 dataset: Optional[pulumi.Input[builtins.str]] = None,
                 destination_conf: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 logpull_options: Optional[pulumi.Input[builtins.str]] = None,
                 max_upload_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 max_upload_interval_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 max_upload_records: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 output_options: Optional[pulumi.Input[Union['LogpushJobOutputOptionsArgs', 'LogpushJobOutputOptionsArgsDict']]] = None,
                 ownership_challenge: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/logpushJob:LogpushJob example '<{accounts|zones}/{account_id|zone_id}>/<job_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[builtins.str] dataset: Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
               Available values: "access*requests", "audit*logs", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
        :param pulumi.Input[builtins.str] destination_conf: Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included.
        :param pulumi.Input[builtins.bool] enabled: Flag that indicates if the job is enabled.
        :param pulumi.Input[builtins.str] filter: The filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/filters/).
        :param pulumi.Input[builtins.str] frequency: This field is deprecated. Please use `max_upload_*` parameters instead. The frequency at which Cloudflare sends batches of logs to your destination. Setting frequency to high sends your logs in larger quantities of smaller files. Setting frequency to low sends logs in smaller quantities of larger files.
               Available values: "high", "low".
        :param pulumi.Input[builtins.str] kind: The kind parameter (optional) is used to differentiate between Logpush and Edge Log Delivery jobs. Currently, Edge Log Delivery is only supported for the `http_requests` dataset.
               Available values: "edge".
        :param pulumi.Input[builtins.str] logpull_options: This field is deprecated. Use `output_options` instead. Configuration string. It specifies things like requested fields and timestamp formats. If migrating from the logpull api, copy the url (full url or just the query string) of your call here, and logpush will keep on making this call for you, setting start and end times appropriately.
        :param pulumi.Input[builtins.int] max_upload_bytes: The maximum uncompressed file size of a batch of logs. This setting value must be between `5 MB` and `1 GB`, or `0` to disable it. Note that you cannot set a minimum file size; this means that log files may be much smaller than this batch size. This parameter is not available for jobs with `edge` as its kind.
        :param pulumi.Input[builtins.int] max_upload_interval_seconds: The maximum interval in seconds for log batches. This setting must be between 30 and 300 seconds (5 minutes), or `0` to disable it. Note that you cannot specify a minimum interval for log batches; this means that log files may be sent in shorter intervals than this. This parameter is only used for jobs with `edge` as its kind.
        :param pulumi.Input[builtins.int] max_upload_records: The maximum number of log lines per batch. This setting must be between 1000 and 1,000,000 lines, or `0` to disable it. Note that you cannot specify a minimum number of log lines per batch; this means that log files may contain many fewer lines than this. This parameter is not available for jobs with `edge` as its kind.
        :param pulumi.Input[builtins.str] name: Optional human readable job name. Not unique. Cloudflare suggests that you set this to a meaningful string, like the domain name, to make it easier to identify your job.
        :param pulumi.Input[Union['LogpushJobOutputOptionsArgs', 'LogpushJobOutputOptionsArgsDict']] output_options: The structured replacement for `logpull_options`. When including this field, the `logpull_option` field will be ignored.
        :param pulumi.Input[builtins.str] ownership_challenge: Ownership challenge token to prove destination ownership.
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogpushJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/logpushJob:LogpushJob example '<{accounts|zones}/{account_id|zone_id}>/<job_id>'
        ```

        :param str resource_name: The name of the resource.
        :param LogpushJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogpushJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 dataset: Optional[pulumi.Input[builtins.str]] = None,
                 destination_conf: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 logpull_options: Optional[pulumi.Input[builtins.str]] = None,
                 max_upload_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 max_upload_interval_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 max_upload_records: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 output_options: Optional[pulumi.Input[Union['LogpushJobOutputOptionsArgs', 'LogpushJobOutputOptionsArgsDict']]] = None,
                 ownership_challenge: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogpushJobArgs.__new__(LogpushJobArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["dataset"] = dataset
            if destination_conf is None and not opts.urn:
                raise TypeError("Missing required property 'destination_conf'")
            __props__.__dict__["destination_conf"] = destination_conf
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["filter"] = filter
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["kind"] = kind
            __props__.__dict__["logpull_options"] = logpull_options
            __props__.__dict__["max_upload_bytes"] = max_upload_bytes
            __props__.__dict__["max_upload_interval_seconds"] = max_upload_interval_seconds
            __props__.__dict__["max_upload_records"] = max_upload_records
            __props__.__dict__["name"] = name
            __props__.__dict__["output_options"] = output_options
            __props__.__dict__["ownership_challenge"] = None if ownership_challenge is None else pulumi.Output.secret(ownership_challenge)
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["error_message"] = None
            __props__.__dict__["last_complete"] = None
            __props__.__dict__["last_error"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["ownershipChallenge"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LogpushJob, __self__).__init__(
            'cloudflare:index/logpushJob:LogpushJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            dataset: Optional[pulumi.Input[builtins.str]] = None,
            destination_conf: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            error_message: Optional[pulumi.Input[builtins.str]] = None,
            filter: Optional[pulumi.Input[builtins.str]] = None,
            frequency: Optional[pulumi.Input[builtins.str]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            last_complete: Optional[pulumi.Input[builtins.str]] = None,
            last_error: Optional[pulumi.Input[builtins.str]] = None,
            logpull_options: Optional[pulumi.Input[builtins.str]] = None,
            max_upload_bytes: Optional[pulumi.Input[builtins.int]] = None,
            max_upload_interval_seconds: Optional[pulumi.Input[builtins.int]] = None,
            max_upload_records: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            output_options: Optional[pulumi.Input[Union['LogpushJobOutputOptionsArgs', 'LogpushJobOutputOptionsArgsDict']]] = None,
            ownership_challenge: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'LogpushJob':
        """
        Get an existing LogpushJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[builtins.str] dataset: Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
               Available values: "access*requests", "audit*logs", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
        :param pulumi.Input[builtins.str] destination_conf: Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included.
        :param pulumi.Input[builtins.bool] enabled: Flag that indicates if the job is enabled.
        :param pulumi.Input[builtins.str] error_message: If not null, the job is currently failing. Failures are usually repetitive (example: no permissions to write to destination bucket). Only the last failure is recorded. On successful execution of a job the error*message and last*error are set to null.
        :param pulumi.Input[builtins.str] filter: The filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/filters/).
        :param pulumi.Input[builtins.str] frequency: This field is deprecated. Please use `max_upload_*` parameters instead. The frequency at which Cloudflare sends batches of logs to your destination. Setting frequency to high sends your logs in larger quantities of smaller files. Setting frequency to low sends logs in smaller quantities of larger files.
               Available values: "high", "low".
        :param pulumi.Input[builtins.str] kind: The kind parameter (optional) is used to differentiate between Logpush and Edge Log Delivery jobs. Currently, Edge Log Delivery is only supported for the `http_requests` dataset.
               Available values: "edge".
        :param pulumi.Input[builtins.str] last_complete: Records the last time for which logs have been successfully pushed. If the last successful push was for logs range 2018-07-23T10:00:00Z to 2018-07-23T10:01:00Z then the value of this field will be 2018-07-23T10:01:00Z. If the job has never run or has just been enabled and hasn't run yet then the field will be empty.
        :param pulumi.Input[builtins.str] last_error: Records the last time the job failed. If not null, the job is currently failing. If null, the job has either never failed or has run successfully at least once since last failure. See also the error_message field.
        :param pulumi.Input[builtins.str] logpull_options: This field is deprecated. Use `output_options` instead. Configuration string. It specifies things like requested fields and timestamp formats. If migrating from the logpull api, copy the url (full url or just the query string) of your call here, and logpush will keep on making this call for you, setting start and end times appropriately.
        :param pulumi.Input[builtins.int] max_upload_bytes: The maximum uncompressed file size of a batch of logs. This setting value must be between `5 MB` and `1 GB`, or `0` to disable it. Note that you cannot set a minimum file size; this means that log files may be much smaller than this batch size. This parameter is not available for jobs with `edge` as its kind.
        :param pulumi.Input[builtins.int] max_upload_interval_seconds: The maximum interval in seconds for log batches. This setting must be between 30 and 300 seconds (5 minutes), or `0` to disable it. Note that you cannot specify a minimum interval for log batches; this means that log files may be sent in shorter intervals than this. This parameter is only used for jobs with `edge` as its kind.
        :param pulumi.Input[builtins.int] max_upload_records: The maximum number of log lines per batch. This setting must be between 1000 and 1,000,000 lines, or `0` to disable it. Note that you cannot specify a minimum number of log lines per batch; this means that log files may contain many fewer lines than this. This parameter is not available for jobs with `edge` as its kind.
        :param pulumi.Input[builtins.str] name: Optional human readable job name. Not unique. Cloudflare suggests that you set this to a meaningful string, like the domain name, to make it easier to identify your job.
        :param pulumi.Input[Union['LogpushJobOutputOptionsArgs', 'LogpushJobOutputOptionsArgsDict']] output_options: The structured replacement for `logpull_options`. When including this field, the `logpull_option` field will be ignored.
        :param pulumi.Input[builtins.str] ownership_challenge: Ownership challenge token to prove destination ownership.
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogpushJobState.__new__(_LogpushJobState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["destination_conf"] = destination_conf
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["error_message"] = error_message
        __props__.__dict__["filter"] = filter
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["kind"] = kind
        __props__.__dict__["last_complete"] = last_complete
        __props__.__dict__["last_error"] = last_error
        __props__.__dict__["logpull_options"] = logpull_options
        __props__.__dict__["max_upload_bytes"] = max_upload_bytes
        __props__.__dict__["max_upload_interval_seconds"] = max_upload_interval_seconds
        __props__.__dict__["max_upload_records"] = max_upload_records
        __props__.__dict__["name"] = name
        __props__.__dict__["output_options"] = output_options
        __props__.__dict__["ownership_challenge"] = ownership_challenge
        __props__.__dict__["zone_id"] = zone_id
        return LogpushJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[builtins.str]:
        """
        Name of the dataset. A list of supported datasets can be found on the [Developer Docs](https://developers.cloudflare.com/logs/reference/log-fields/).
        Available values: "access*requests", "audit*logs", "biso*user*actions", "casb*findings", "device*posture*results", "dlp*forensic*copies", "dns*firewall*logs", "dns*logs", "email*security*alerts", "firewall*events", "gateway*dns", "gateway*http", "gateway*network", "http*requests", "magic*ids*detections", "nel*reports", "network*analytics*logs", "page*shield*events", "sinkhole*http*logs", "spectrum*events", "ssh*logs", "workers*trace*events", "zaraz*events", "zero*trust*network*sessions".
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="destinationConf")
    def destination_conf(self) -> pulumi.Output[builtins.str]:
        """
        Uniquely identifies a resource (such as an s3 bucket) where data will be pushed. Additional configuration parameters supported by the destination may be included.
        """
        return pulumi.get(self, "destination_conf")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Flag that indicates if the job is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[builtins.str]:
        """
        If not null, the job is currently failing. Failures are usually repetitive (example: no permissions to write to destination bucket). Only the last failure is recorded. On successful execution of a job the error*message and last*error are set to null.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The filters to select the events to include and/or remove from your logs. For more information, refer to [Filters](https://developers.cloudflare.com/logs/reference/filters/).
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def frequency(self) -> pulumi.Output[builtins.str]:
        """
        This field is deprecated. Please use `max_upload_*` parameters instead. The frequency at which Cloudflare sends batches of logs to your destination. Setting frequency to high sends your logs in larger quantities of smaller files. Setting frequency to low sends logs in smaller quantities of larger files.
        Available values: "high", "low".
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[builtins.str]:
        """
        The kind parameter (optional) is used to differentiate between Logpush and Edge Log Delivery jobs. Currently, Edge Log Delivery is only supported for the `http_requests` dataset.
        Available values: "edge".
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="lastComplete")
    def last_complete(self) -> pulumi.Output[builtins.str]:
        """
        Records the last time for which logs have been successfully pushed. If the last successful push was for logs range 2018-07-23T10:00:00Z to 2018-07-23T10:01:00Z then the value of this field will be 2018-07-23T10:01:00Z. If the job has never run or has just been enabled and hasn't run yet then the field will be empty.
        """
        return pulumi.get(self, "last_complete")

    @property
    @pulumi.getter(name="lastError")
    def last_error(self) -> pulumi.Output[builtins.str]:
        """
        Records the last time the job failed. If not null, the job is currently failing. If null, the job has either never failed or has run successfully at least once since last failure. See also the error_message field.
        """
        return pulumi.get(self, "last_error")

    @property
    @pulumi.getter(name="logpullOptions")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def logpull_options(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This field is deprecated. Use `output_options` instead. Configuration string. It specifies things like requested fields and timestamp formats. If migrating from the logpull api, copy the url (full url or just the query string) of your call here, and logpush will keep on making this call for you, setting start and end times appropriately.
        """
        return pulumi.get(self, "logpull_options")

    @property
    @pulumi.getter(name="maxUploadBytes")
    def max_upload_bytes(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum uncompressed file size of a batch of logs. This setting value must be between `5 MB` and `1 GB`, or `0` to disable it. Note that you cannot set a minimum file size; this means that log files may be much smaller than this batch size. This parameter is not available for jobs with `edge` as its kind.
        """
        return pulumi.get(self, "max_upload_bytes")

    @property
    @pulumi.getter(name="maxUploadIntervalSeconds")
    def max_upload_interval_seconds(self) -> pulumi.Output[builtins.int]:
        """
        The maximum interval in seconds for log batches. This setting must be between 30 and 300 seconds (5 minutes), or `0` to disable it. Note that you cannot specify a minimum interval for log batches; this means that log files may be sent in shorter intervals than this. This parameter is only used for jobs with `edge` as its kind.
        """
        return pulumi.get(self, "max_upload_interval_seconds")

    @property
    @pulumi.getter(name="maxUploadRecords")
    def max_upload_records(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of log lines per batch. This setting must be between 1000 and 1,000,000 lines, or `0` to disable it. Note that you cannot specify a minimum number of log lines per batch; this means that log files may contain many fewer lines than this. This parameter is not available for jobs with `edge` as its kind.
        """
        return pulumi.get(self, "max_upload_records")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional human readable job name. Not unique. Cloudflare suggests that you set this to a meaningful string, like the domain name, to make it easier to identify your job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputOptions")
    def output_options(self) -> pulumi.Output['outputs.LogpushJobOutputOptions']:
        """
        The structured replacement for `logpull_options`. When including this field, the `logpull_option` field will be ignored.
        """
        return pulumi.get(self, "output_options")

    @property
    @pulumi.getter(name="ownershipChallenge")
    def ownership_challenge(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Ownership challenge token to prove destination ownership.
        """
        return pulumi.get(self, "ownership_challenge")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

