# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MagicTransitConnectorArgs', 'MagicTransitConnector']

@pulumi.input_type
class MagicTransitConnectorArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 connector_id: pulumi.Input[builtins.str],
                 activated: Optional[pulumi.Input[builtins.bool]] = None,
                 interrupt_window_duration_hours: Optional[pulumi.Input[builtins.float]] = None,
                 interrupt_window_hour_of_day: Optional[pulumi.Input[builtins.float]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MagicTransitConnector resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "connector_id", connector_id)
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if interrupt_window_duration_hours is not None:
            pulumi.set(__self__, "interrupt_window_duration_hours", interrupt_window_duration_hours)
        if interrupt_window_hour_of_day is not None:
            pulumi.set(__self__, "interrupt_window_hour_of_day", interrupt_window_hour_of_day)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Account identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connector_id", value)

    @property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter(name="interruptWindowDurationHours")
    def interrupt_window_duration_hours(self) -> Optional[pulumi.Input[builtins.float]]:
        return pulumi.get(self, "interrupt_window_duration_hours")

    @interrupt_window_duration_hours.setter
    def interrupt_window_duration_hours(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "interrupt_window_duration_hours", value)

    @property
    @pulumi.getter(name="interruptWindowHourOfDay")
    def interrupt_window_hour_of_day(self) -> Optional[pulumi.Input[builtins.float]]:
        return pulumi.get(self, "interrupt_window_hour_of_day")

    @interrupt_window_hour_of_day.setter
    def interrupt_window_hour_of_day(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "interrupt_window_hour_of_day", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class _MagicTransitConnectorState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 activated: Optional[pulumi.Input[builtins.bool]] = None,
                 connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 device: Optional[pulumi.Input['MagicTransitConnectorDeviceArgs']] = None,
                 interrupt_window_duration_hours: Optional[pulumi.Input[builtins.float]] = None,
                 interrupt_window_hour_of_day: Optional[pulumi.Input[builtins.float]] = None,
                 last_heartbeat: Optional[pulumi.Input[builtins.str]] = None,
                 last_seen_version: Optional[pulumi.Input[builtins.str]] = None,
                 last_updated: Optional[pulumi.Input[builtins.str]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MagicTransitConnector resources.
        :param pulumi.Input[builtins.str] account_id: Account identifier
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if interrupt_window_duration_hours is not None:
            pulumi.set(__self__, "interrupt_window_duration_hours", interrupt_window_duration_hours)
        if interrupt_window_hour_of_day is not None:
            pulumi.set(__self__, "interrupt_window_hour_of_day", interrupt_window_hour_of_day)
        if last_heartbeat is not None:
            pulumi.set(__self__, "last_heartbeat", last_heartbeat)
        if last_seen_version is not None:
            pulumi.set(__self__, "last_seen_version", last_seen_version)
        if last_updated is not None:
            pulumi.set(__self__, "last_updated", last_updated)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "activated", value)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connector_id", value)

    @property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input['MagicTransitConnectorDeviceArgs']]:
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input['MagicTransitConnectorDeviceArgs']]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter(name="interruptWindowDurationHours")
    def interrupt_window_duration_hours(self) -> Optional[pulumi.Input[builtins.float]]:
        return pulumi.get(self, "interrupt_window_duration_hours")

    @interrupt_window_duration_hours.setter
    def interrupt_window_duration_hours(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "interrupt_window_duration_hours", value)

    @property
    @pulumi.getter(name="interruptWindowHourOfDay")
    def interrupt_window_hour_of_day(self) -> Optional[pulumi.Input[builtins.float]]:
        return pulumi.get(self, "interrupt_window_hour_of_day")

    @interrupt_window_hour_of_day.setter
    def interrupt_window_hour_of_day(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "interrupt_window_hour_of_day", value)

    @property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "last_heartbeat")

    @last_heartbeat.setter
    def last_heartbeat(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_heartbeat", value)

    @property
    @pulumi.getter(name="lastSeenVersion")
    def last_seen_version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "last_seen_version")

    @last_seen_version.setter
    def last_seen_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_seen_version", value)

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "last_updated")

    @last_updated.setter
    def last_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_updated", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.type_token("cloudflare:index/magicTransitConnector:MagicTransitConnector")
class MagicTransitConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 activated: Optional[pulumi.Input[builtins.bool]] = None,
                 connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 interrupt_window_duration_hours: Optional[pulumi.Input[builtins.float]] = None,
                 interrupt_window_hour_of_day: Optional[pulumi.Input[builtins.float]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_magic_transit_connector = cloudflare.MagicTransitConnector("example_magic_transit_connector",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            connector_id="connector_id",
            activated=True,
            interrupt_window_duration_hours=0,
            interrupt_window_hour_of_day=0,
            notes="notes",
            timezone="timezone")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicTransitConnector:MagicTransitConnector example '<account_id>/<connector_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MagicTransitConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_magic_transit_connector = cloudflare.MagicTransitConnector("example_magic_transit_connector",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            connector_id="connector_id",
            activated=True,
            interrupt_window_duration_hours=0,
            interrupt_window_hour_of_day=0,
            notes="notes",
            timezone="timezone")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicTransitConnector:MagicTransitConnector example '<account_id>/<connector_id>'
        ```

        :param str resource_name: The name of the resource.
        :param MagicTransitConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MagicTransitConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 activated: Optional[pulumi.Input[builtins.bool]] = None,
                 connector_id: Optional[pulumi.Input[builtins.str]] = None,
                 interrupt_window_duration_hours: Optional[pulumi.Input[builtins.float]] = None,
                 interrupt_window_hour_of_day: Optional[pulumi.Input[builtins.float]] = None,
                 notes: Optional[pulumi.Input[builtins.str]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MagicTransitConnectorArgs.__new__(MagicTransitConnectorArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["activated"] = activated
            if connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'connector_id'")
            __props__.__dict__["connector_id"] = connector_id
            __props__.__dict__["interrupt_window_duration_hours"] = interrupt_window_duration_hours
            __props__.__dict__["interrupt_window_hour_of_day"] = interrupt_window_hour_of_day
            __props__.__dict__["notes"] = notes
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["device"] = None
            __props__.__dict__["last_heartbeat"] = None
            __props__.__dict__["last_seen_version"] = None
            __props__.__dict__["last_updated"] = None
        super(MagicTransitConnector, __self__).__init__(
            'cloudflare:index/magicTransitConnector:MagicTransitConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            activated: Optional[pulumi.Input[builtins.bool]] = None,
            connector_id: Optional[pulumi.Input[builtins.str]] = None,
            device: Optional[pulumi.Input[Union['MagicTransitConnectorDeviceArgs', 'MagicTransitConnectorDeviceArgsDict']]] = None,
            interrupt_window_duration_hours: Optional[pulumi.Input[builtins.float]] = None,
            interrupt_window_hour_of_day: Optional[pulumi.Input[builtins.float]] = None,
            last_heartbeat: Optional[pulumi.Input[builtins.str]] = None,
            last_seen_version: Optional[pulumi.Input[builtins.str]] = None,
            last_updated: Optional[pulumi.Input[builtins.str]] = None,
            notes: Optional[pulumi.Input[builtins.str]] = None,
            timezone: Optional[pulumi.Input[builtins.str]] = None) -> 'MagicTransitConnector':
        """
        Get an existing MagicTransitConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MagicTransitConnectorState.__new__(_MagicTransitConnectorState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["activated"] = activated
        __props__.__dict__["connector_id"] = connector_id
        __props__.__dict__["device"] = device
        __props__.__dict__["interrupt_window_duration_hours"] = interrupt_window_duration_hours
        __props__.__dict__["interrupt_window_hour_of_day"] = interrupt_window_hour_of_day
        __props__.__dict__["last_heartbeat"] = last_heartbeat
        __props__.__dict__["last_seen_version"] = last_seen_version
        __props__.__dict__["last_updated"] = last_updated
        __props__.__dict__["notes"] = notes
        __props__.__dict__["timezone"] = timezone
        return MagicTransitConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Account identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def activated(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "activated")

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "connector_id")

    @property
    @pulumi.getter
    def device(self) -> pulumi.Output['outputs.MagicTransitConnectorDevice']:
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="interruptWindowDurationHours")
    def interrupt_window_duration_hours(self) -> pulumi.Output[Optional[builtins.float]]:
        return pulumi.get(self, "interrupt_window_duration_hours")

    @property
    @pulumi.getter(name="interruptWindowHourOfDay")
    def interrupt_window_hour_of_day(self) -> pulumi.Output[Optional[builtins.float]]:
        return pulumi.get(self, "interrupt_window_hour_of_day")

    @property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "last_heartbeat")

    @property
    @pulumi.getter(name="lastSeenVersion")
    def last_seen_version(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "last_seen_version")

    @property
    @pulumi.getter(name="lastUpdated")
    def last_updated(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "last_updated")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "timezone")

