# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MagicTransitSiteWanArgs', 'MagicTransitSiteWan']

@pulumi.input_type
class MagicTransitSiteWanArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 physport: pulumi.Input[builtins.int],
                 site_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 static_addressing: Optional[pulumi.Input['MagicTransitSiteWanStaticAddressingArgs']] = None,
                 vlan_tag: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a MagicTransitSiteWan resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] site_id: Identifier
        :param pulumi.Input['MagicTransitSiteWanStaticAddressingArgs'] static_addressing: (optional) if omitted, use DHCP. Submit secondary*address when site is in high availability mode.
        :param pulumi.Input[builtins.int] vlan_tag: VLAN ID. Use zero for untagged.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "physport", physport)
        pulumi.set(__self__, "site_id", site_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if static_addressing is not None:
            pulumi.set(__self__, "static_addressing", static_addressing)
        if vlan_tag is not None:
            pulumi.set(__self__, "vlan_tag", vlan_tag)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def physport(self) -> pulumi.Input[builtins.int]:
        return pulumi.get(self, "physport")

    @physport.setter
    def physport(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "physport", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="staticAddressing")
    def static_addressing(self) -> Optional[pulumi.Input['MagicTransitSiteWanStaticAddressingArgs']]:
        """
        (optional) if omitted, use DHCP. Submit secondary*address when site is in high availability mode.
        """
        return pulumi.get(self, "static_addressing")

    @static_addressing.setter
    def static_addressing(self, value: Optional[pulumi.Input['MagicTransitSiteWanStaticAddressingArgs']]):
        pulumi.set(self, "static_addressing", value)

    @property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        VLAN ID. Use zero for untagged.
        """
        return pulumi.get(self, "vlan_tag")

    @vlan_tag.setter
    def vlan_tag(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan_tag", value)


@pulumi.input_type
class _MagicTransitSiteWanState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 health_check_rate: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 physport: Optional[pulumi.Input[builtins.int]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 static_addressing: Optional[pulumi.Input['MagicTransitSiteWanStaticAddressingArgs']] = None,
                 vlan_tag: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering MagicTransitSiteWan resources.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] health_check_rate: Magic WAN health check rate for tunnels created on this link. The default value is `mid`.
               Available values: "low", "mid", "high".
        :param pulumi.Input[builtins.str] site_id: Identifier
        :param pulumi.Input['MagicTransitSiteWanStaticAddressingArgs'] static_addressing: (optional) if omitted, use DHCP. Submit secondary*address when site is in high availability mode.
        :param pulumi.Input[builtins.int] vlan_tag: VLAN ID. Use zero for untagged.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if health_check_rate is not None:
            pulumi.set(__self__, "health_check_rate", health_check_rate)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if physport is not None:
            pulumi.set(__self__, "physport", physport)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if static_addressing is not None:
            pulumi.set(__self__, "static_addressing", static_addressing)
        if vlan_tag is not None:
            pulumi.set(__self__, "vlan_tag", vlan_tag)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="healthCheckRate")
    def health_check_rate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Magic WAN health check rate for tunnels created on this link. The default value is `mid`.
        Available values: "low", "mid", "high".
        """
        return pulumi.get(self, "health_check_rate")

    @health_check_rate.setter
    def health_check_rate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "health_check_rate", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def physport(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "physport")

    @physport.setter
    def physport(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "physport", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="staticAddressing")
    def static_addressing(self) -> Optional[pulumi.Input['MagicTransitSiteWanStaticAddressingArgs']]:
        """
        (optional) if omitted, use DHCP. Submit secondary*address when site is in high availability mode.
        """
        return pulumi.get(self, "static_addressing")

    @static_addressing.setter
    def static_addressing(self, value: Optional[pulumi.Input['MagicTransitSiteWanStaticAddressingArgs']]):
        pulumi.set(self, "static_addressing", value)

    @property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        VLAN ID. Use zero for untagged.
        """
        return pulumi.get(self, "vlan_tag")

    @vlan_tag.setter
    def vlan_tag(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan_tag", value)


@pulumi.type_token("cloudflare:index/magicTransitSiteWan:MagicTransitSiteWan")
class MagicTransitSiteWan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 physport: Optional[pulumi.Input[builtins.int]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 static_addressing: Optional[pulumi.Input[Union['MagicTransitSiteWanStaticAddressingArgs', 'MagicTransitSiteWanStaticAddressingArgsDict']]] = None,
                 vlan_tag: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicTransitSiteWan:MagicTransitSiteWan example '<account_id>/<site_id>/<wan_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] site_id: Identifier
        :param pulumi.Input[Union['MagicTransitSiteWanStaticAddressingArgs', 'MagicTransitSiteWanStaticAddressingArgsDict']] static_addressing: (optional) if omitted, use DHCP. Submit secondary*address when site is in high availability mode.
        :param pulumi.Input[builtins.int] vlan_tag: VLAN ID. Use zero for untagged.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MagicTransitSiteWanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicTransitSiteWan:MagicTransitSiteWan example '<account_id>/<site_id>/<wan_id>'
        ```

        :param str resource_name: The name of the resource.
        :param MagicTransitSiteWanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MagicTransitSiteWanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 physport: Optional[pulumi.Input[builtins.int]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 static_addressing: Optional[pulumi.Input[Union['MagicTransitSiteWanStaticAddressingArgs', 'MagicTransitSiteWanStaticAddressingArgsDict']]] = None,
                 vlan_tag: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MagicTransitSiteWanArgs.__new__(MagicTransitSiteWanArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["name"] = name
            if physport is None and not opts.urn:
                raise TypeError("Missing required property 'physport'")
            __props__.__dict__["physport"] = physport
            __props__.__dict__["priority"] = priority
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["static_addressing"] = static_addressing
            __props__.__dict__["vlan_tag"] = vlan_tag
            __props__.__dict__["health_check_rate"] = None
        super(MagicTransitSiteWan, __self__).__init__(
            'cloudflare:index/magicTransitSiteWan:MagicTransitSiteWan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            health_check_rate: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            physport: Optional[pulumi.Input[builtins.int]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None,
            site_id: Optional[pulumi.Input[builtins.str]] = None,
            static_addressing: Optional[pulumi.Input[Union['MagicTransitSiteWanStaticAddressingArgs', 'MagicTransitSiteWanStaticAddressingArgsDict']]] = None,
            vlan_tag: Optional[pulumi.Input[builtins.int]] = None) -> 'MagicTransitSiteWan':
        """
        Get an existing MagicTransitSiteWan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] health_check_rate: Magic WAN health check rate for tunnels created on this link. The default value is `mid`.
               Available values: "low", "mid", "high".
        :param pulumi.Input[builtins.str] site_id: Identifier
        :param pulumi.Input[Union['MagicTransitSiteWanStaticAddressingArgs', 'MagicTransitSiteWanStaticAddressingArgsDict']] static_addressing: (optional) if omitted, use DHCP. Submit secondary*address when site is in high availability mode.
        :param pulumi.Input[builtins.int] vlan_tag: VLAN ID. Use zero for untagged.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MagicTransitSiteWanState.__new__(_MagicTransitSiteWanState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["health_check_rate"] = health_check_rate
        __props__.__dict__["name"] = name
        __props__.__dict__["physport"] = physport
        __props__.__dict__["priority"] = priority
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["static_addressing"] = static_addressing
        __props__.__dict__["vlan_tag"] = vlan_tag
        return MagicTransitSiteWan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="healthCheckRate")
    def health_check_rate(self) -> pulumi.Output[builtins.str]:
        """
        Magic WAN health check rate for tunnels created on this link. The default value is `mid`.
        Available values: "low", "mid", "high".
        """
        return pulumi.get(self, "health_check_rate")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def physport(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "physport")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[builtins.int]]:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="staticAddressing")
    def static_addressing(self) -> pulumi.Output[Optional['outputs.MagicTransitSiteWanStaticAddressing']]:
        """
        (optional) if omitted, use DHCP. Submit secondary*address when site is in high availability mode.
        """
        return pulumi.get(self, "static_addressing")

    @property
    @pulumi.getter(name="vlanTag")
    def vlan_tag(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        VLAN ID. Use zero for untagged.
        """
        return pulumi.get(self, "vlan_tag")

