# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MagicWanIpsecTunnelArgs', 'MagicWanIpsecTunnel']

@pulumi.input_type
class MagicWanIpsecTunnelArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 cloudflare_endpoint: pulumi.Input[builtins.str],
                 interface_address: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 customer_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 health_check: Optional[pulumi.Input['MagicWanIpsecTunnelHealthCheckArgs']] = None,
                 psk: Optional[pulumi.Input[builtins.str]] = None,
                 replay_protection: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a MagicWanIpsecTunnel resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] cloudflare_endpoint: The IP address assigned to the Cloudflare side of the IPsec tunnel.
        :param pulumi.Input[builtins.str] interface_address: A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        :param pulumi.Input[builtins.str] name: The name of the IPsec tunnel. The name cannot share a name with other tunnels.
        :param pulumi.Input[builtins.str] customer_endpoint: The IP address assigned to the customer side of the IPsec tunnel. Not required, but must be set for proactive traceroutes to work.
        :param pulumi.Input[builtins.str] description: An optional description forthe IPsec tunnel.
        :param pulumi.Input[builtins.str] psk: A randomly generated or provided string for use in the IPsec tunnel.
        :param pulumi.Input[builtins.bool] replay_protection: If `true`, then IPsec replay protection will be supported in the Cloudflare-to-customer direction.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "cloudflare_endpoint", cloudflare_endpoint)
        pulumi.set(__self__, "interface_address", interface_address)
        pulumi.set(__self__, "name", name)
        if customer_endpoint is not None:
            pulumi.set(__self__, "customer_endpoint", customer_endpoint)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if replay_protection is not None:
            pulumi.set(__self__, "replay_protection", replay_protection)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="cloudflareEndpoint")
    def cloudflare_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The IP address assigned to the Cloudflare side of the IPsec tunnel.
        """
        return pulumi.get(self, "cloudflare_endpoint")

    @cloudflare_endpoint.setter
    def cloudflare_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloudflare_endpoint", value)

    @property
    @pulumi.getter(name="interfaceAddress")
    def interface_address(self) -> pulumi.Input[builtins.str]:
        """
        A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        """
        return pulumi.get(self, "interface_address")

    @interface_address.setter
    def interface_address(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "interface_address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the IPsec tunnel. The name cannot share a name with other tunnels.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="customerEndpoint")
    def customer_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address assigned to the customer side of the IPsec tunnel. Not required, but must be set for proactive traceroutes to work.
        """
        return pulumi.get(self, "customer_endpoint")

    @customer_endpoint.setter
    def customer_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_endpoint", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description forthe IPsec tunnel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['MagicWanIpsecTunnelHealthCheckArgs']]:
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['MagicWanIpsecTunnelHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A randomly generated or provided string for use in the IPsec tunnel.
        """
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "psk", value)

    @property
    @pulumi.getter(name="replayProtection")
    def replay_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If `true`, then IPsec replay protection will be supported in the Cloudflare-to-customer direction.
        """
        return pulumi.get(self, "replay_protection")

    @replay_protection.setter
    def replay_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "replay_protection", value)


@pulumi.input_type
class _MagicWanIpsecTunnelState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 allow_null_cipher: Optional[pulumi.Input[builtins.bool]] = None,
                 cloudflare_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 created_on: Optional[pulumi.Input[builtins.str]] = None,
                 customer_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 health_check: Optional[pulumi.Input['MagicWanIpsecTunnelHealthCheckArgs']] = None,
                 interface_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_tunnel: Optional[pulumi.Input['MagicWanIpsecTunnelIpsecTunnelArgs']] = None,
                 modified: Optional[pulumi.Input[builtins.bool]] = None,
                 modified_ipsec_tunnel: Optional[pulumi.Input['MagicWanIpsecTunnelModifiedIpsecTunnelArgs']] = None,
                 modified_on: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 psk: Optional[pulumi.Input[builtins.str]] = None,
                 psk_metadata: Optional[pulumi.Input['MagicWanIpsecTunnelPskMetadataArgs']] = None,
                 replay_protection: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering MagicWanIpsecTunnel resources.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.bool] allow_null_cipher: When `true`, the tunnel can use a null-cipher (`ENCR_NULL`) in the ESP tunnel (Phase 2).
        :param pulumi.Input[builtins.str] cloudflare_endpoint: The IP address assigned to the Cloudflare side of the IPsec tunnel.
        :param pulumi.Input[builtins.str] created_on: The date and time the tunnel was created.
        :param pulumi.Input[builtins.str] customer_endpoint: The IP address assigned to the customer side of the IPsec tunnel. Not required, but must be set for proactive traceroutes to work.
        :param pulumi.Input[builtins.str] description: An optional description forthe IPsec tunnel.
        :param pulumi.Input[builtins.str] interface_address: A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        :param pulumi.Input[builtins.str] modified_on: The date and time the tunnel was last modified.
        :param pulumi.Input[builtins.str] name: The name of the IPsec tunnel. The name cannot share a name with other tunnels.
        :param pulumi.Input[builtins.str] psk: A randomly generated or provided string for use in the IPsec tunnel.
        :param pulumi.Input['MagicWanIpsecTunnelPskMetadataArgs'] psk_metadata: The PSK metadata that includes when the PSK was generated.
        :param pulumi.Input[builtins.bool] replay_protection: If `true`, then IPsec replay protection will be supported in the Cloudflare-to-customer direction.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allow_null_cipher is not None:
            pulumi.set(__self__, "allow_null_cipher", allow_null_cipher)
        if cloudflare_endpoint is not None:
            pulumi.set(__self__, "cloudflare_endpoint", cloudflare_endpoint)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if customer_endpoint is not None:
            pulumi.set(__self__, "customer_endpoint", customer_endpoint)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if interface_address is not None:
            pulumi.set(__self__, "interface_address", interface_address)
        if ipsec_tunnel is not None:
            pulumi.set(__self__, "ipsec_tunnel", ipsec_tunnel)
        if modified is not None:
            pulumi.set(__self__, "modified", modified)
        if modified_ipsec_tunnel is not None:
            pulumi.set(__self__, "modified_ipsec_tunnel", modified_ipsec_tunnel)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if psk_metadata is not None:
            pulumi.set(__self__, "psk_metadata", psk_metadata)
        if replay_protection is not None:
            pulumi.set(__self__, "replay_protection", replay_protection)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowNullCipher")
    def allow_null_cipher(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When `true`, the tunnel can use a null-cipher (`ENCR_NULL`) in the ESP tunnel (Phase 2).
        """
        return pulumi.get(self, "allow_null_cipher")

    @allow_null_cipher.setter
    def allow_null_cipher(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_null_cipher", value)

    @property
    @pulumi.getter(name="cloudflareEndpoint")
    def cloudflare_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address assigned to the Cloudflare side of the IPsec tunnel.
        """
        return pulumi.get(self, "cloudflare_endpoint")

    @cloudflare_endpoint.setter
    def cloudflare_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloudflare_endpoint", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the tunnel was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter(name="customerEndpoint")
    def customer_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address assigned to the customer side of the IPsec tunnel. Not required, but must be set for proactive traceroutes to work.
        """
        return pulumi.get(self, "customer_endpoint")

    @customer_endpoint.setter
    def customer_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_endpoint", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description forthe IPsec tunnel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['MagicWanIpsecTunnelHealthCheckArgs']]:
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['MagicWanIpsecTunnelHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="interfaceAddress")
    def interface_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        """
        return pulumi.get(self, "interface_address")

    @interface_address.setter
    def interface_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_address", value)

    @property
    @pulumi.getter(name="ipsecTunnel")
    def ipsec_tunnel(self) -> Optional[pulumi.Input['MagicWanIpsecTunnelIpsecTunnelArgs']]:
        return pulumi.get(self, "ipsec_tunnel")

    @ipsec_tunnel.setter
    def ipsec_tunnel(self, value: Optional[pulumi.Input['MagicWanIpsecTunnelIpsecTunnelArgs']]):
        pulumi.set(self, "ipsec_tunnel", value)

    @property
    @pulumi.getter
    def modified(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "modified")

    @modified.setter
    def modified(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "modified", value)

    @property
    @pulumi.getter(name="modifiedIpsecTunnel")
    def modified_ipsec_tunnel(self) -> Optional[pulumi.Input['MagicWanIpsecTunnelModifiedIpsecTunnelArgs']]:
        return pulumi.get(self, "modified_ipsec_tunnel")

    @modified_ipsec_tunnel.setter
    def modified_ipsec_tunnel(self, value: Optional[pulumi.Input['MagicWanIpsecTunnelModifiedIpsecTunnelArgs']]):
        pulumi.set(self, "modified_ipsec_tunnel", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the tunnel was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the IPsec tunnel. The name cannot share a name with other tunnels.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def psk(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A randomly generated or provided string for use in the IPsec tunnel.
        """
        return pulumi.get(self, "psk")

    @psk.setter
    def psk(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "psk", value)

    @property
    @pulumi.getter(name="pskMetadata")
    def psk_metadata(self) -> Optional[pulumi.Input['MagicWanIpsecTunnelPskMetadataArgs']]:
        """
        The PSK metadata that includes when the PSK was generated.
        """
        return pulumi.get(self, "psk_metadata")

    @psk_metadata.setter
    def psk_metadata(self, value: Optional[pulumi.Input['MagicWanIpsecTunnelPskMetadataArgs']]):
        pulumi.set(self, "psk_metadata", value)

    @property
    @pulumi.getter(name="replayProtection")
    def replay_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If `true`, then IPsec replay protection will be supported in the Cloudflare-to-customer direction.
        """
        return pulumi.get(self, "replay_protection")

    @replay_protection.setter
    def replay_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "replay_protection", value)


@pulumi.type_token("cloudflare:index/magicWanIpsecTunnel:MagicWanIpsecTunnel")
class MagicWanIpsecTunnel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 cloudflare_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 customer_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 health_check: Optional[pulumi.Input[Union['MagicWanIpsecTunnelHealthCheckArgs', 'MagicWanIpsecTunnelHealthCheckArgsDict']]] = None,
                 interface_address: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 psk: Optional[pulumi.Input[builtins.str]] = None,
                 replay_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_magic_wan_ipsec_tunnel = cloudflare.MagicWanIpsecTunnel("example_magic_wan_ipsec_tunnel",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            cloudflare_endpoint="203.0.113.1",
            interface_address="192.0.2.0/31",
            name="IPsec_1",
            customer_endpoint="203.0.113.1",
            description="Tunnel for ISP X",
            health_check={
                "direction": "bidirectional",
                "enabled": True,
                "rate": "low",
                "target": {
                    "saved": "203.0.113.1",
                },
                "type": "request",
            },
            psk="O3bwKSjnaoCxDoUxjcq4Rk8ZKkezQUiy",
            replay_protection=False)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicWanIpsecTunnel:MagicWanIpsecTunnel example '<account_id>/<ipsec_tunnel_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] cloudflare_endpoint: The IP address assigned to the Cloudflare side of the IPsec tunnel.
        :param pulumi.Input[builtins.str] customer_endpoint: The IP address assigned to the customer side of the IPsec tunnel. Not required, but must be set for proactive traceroutes to work.
        :param pulumi.Input[builtins.str] description: An optional description forthe IPsec tunnel.
        :param pulumi.Input[builtins.str] interface_address: A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        :param pulumi.Input[builtins.str] name: The name of the IPsec tunnel. The name cannot share a name with other tunnels.
        :param pulumi.Input[builtins.str] psk: A randomly generated or provided string for use in the IPsec tunnel.
        :param pulumi.Input[builtins.bool] replay_protection: If `true`, then IPsec replay protection will be supported in the Cloudflare-to-customer direction.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MagicWanIpsecTunnelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_magic_wan_ipsec_tunnel = cloudflare.MagicWanIpsecTunnel("example_magic_wan_ipsec_tunnel",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            cloudflare_endpoint="203.0.113.1",
            interface_address="192.0.2.0/31",
            name="IPsec_1",
            customer_endpoint="203.0.113.1",
            description="Tunnel for ISP X",
            health_check={
                "direction": "bidirectional",
                "enabled": True,
                "rate": "low",
                "target": {
                    "saved": "203.0.113.1",
                },
                "type": "request",
            },
            psk="O3bwKSjnaoCxDoUxjcq4Rk8ZKkezQUiy",
            replay_protection=False)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/magicWanIpsecTunnel:MagicWanIpsecTunnel example '<account_id>/<ipsec_tunnel_id>'
        ```

        :param str resource_name: The name of the resource.
        :param MagicWanIpsecTunnelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MagicWanIpsecTunnelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 cloudflare_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 customer_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 health_check: Optional[pulumi.Input[Union['MagicWanIpsecTunnelHealthCheckArgs', 'MagicWanIpsecTunnelHealthCheckArgsDict']]] = None,
                 interface_address: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 psk: Optional[pulumi.Input[builtins.str]] = None,
                 replay_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MagicWanIpsecTunnelArgs.__new__(MagicWanIpsecTunnelArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if cloudflare_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'cloudflare_endpoint'")
            __props__.__dict__["cloudflare_endpoint"] = cloudflare_endpoint
            __props__.__dict__["customer_endpoint"] = customer_endpoint
            __props__.__dict__["description"] = description
            __props__.__dict__["health_check"] = health_check
            if interface_address is None and not opts.urn:
                raise TypeError("Missing required property 'interface_address'")
            __props__.__dict__["interface_address"] = interface_address
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["psk"] = psk
            __props__.__dict__["replay_protection"] = replay_protection
            __props__.__dict__["allow_null_cipher"] = None
            __props__.__dict__["created_on"] = None
            __props__.__dict__["ipsec_tunnel"] = None
            __props__.__dict__["modified"] = None
            __props__.__dict__["modified_ipsec_tunnel"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["psk_metadata"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/ipsecTunnel:IpsecTunnel")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(MagicWanIpsecTunnel, __self__).__init__(
            'cloudflare:index/magicWanIpsecTunnel:MagicWanIpsecTunnel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            allow_null_cipher: Optional[pulumi.Input[builtins.bool]] = None,
            cloudflare_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            created_on: Optional[pulumi.Input[builtins.str]] = None,
            customer_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            health_check: Optional[pulumi.Input[Union['MagicWanIpsecTunnelHealthCheckArgs', 'MagicWanIpsecTunnelHealthCheckArgsDict']]] = None,
            interface_address: Optional[pulumi.Input[builtins.str]] = None,
            ipsec_tunnel: Optional[pulumi.Input[Union['MagicWanIpsecTunnelIpsecTunnelArgs', 'MagicWanIpsecTunnelIpsecTunnelArgsDict']]] = None,
            modified: Optional[pulumi.Input[builtins.bool]] = None,
            modified_ipsec_tunnel: Optional[pulumi.Input[Union['MagicWanIpsecTunnelModifiedIpsecTunnelArgs', 'MagicWanIpsecTunnelModifiedIpsecTunnelArgsDict']]] = None,
            modified_on: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            psk: Optional[pulumi.Input[builtins.str]] = None,
            psk_metadata: Optional[pulumi.Input[Union['MagicWanIpsecTunnelPskMetadataArgs', 'MagicWanIpsecTunnelPskMetadataArgsDict']]] = None,
            replay_protection: Optional[pulumi.Input[builtins.bool]] = None) -> 'MagicWanIpsecTunnel':
        """
        Get an existing MagicWanIpsecTunnel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.bool] allow_null_cipher: When `true`, the tunnel can use a null-cipher (`ENCR_NULL`) in the ESP tunnel (Phase 2).
        :param pulumi.Input[builtins.str] cloudflare_endpoint: The IP address assigned to the Cloudflare side of the IPsec tunnel.
        :param pulumi.Input[builtins.str] created_on: The date and time the tunnel was created.
        :param pulumi.Input[builtins.str] customer_endpoint: The IP address assigned to the customer side of the IPsec tunnel. Not required, but must be set for proactive traceroutes to work.
        :param pulumi.Input[builtins.str] description: An optional description forthe IPsec tunnel.
        :param pulumi.Input[builtins.str] interface_address: A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        :param pulumi.Input[builtins.str] modified_on: The date and time the tunnel was last modified.
        :param pulumi.Input[builtins.str] name: The name of the IPsec tunnel. The name cannot share a name with other tunnels.
        :param pulumi.Input[builtins.str] psk: A randomly generated or provided string for use in the IPsec tunnel.
        :param pulumi.Input[Union['MagicWanIpsecTunnelPskMetadataArgs', 'MagicWanIpsecTunnelPskMetadataArgsDict']] psk_metadata: The PSK metadata that includes when the PSK was generated.
        :param pulumi.Input[builtins.bool] replay_protection: If `true`, then IPsec replay protection will be supported in the Cloudflare-to-customer direction.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MagicWanIpsecTunnelState.__new__(_MagicWanIpsecTunnelState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["allow_null_cipher"] = allow_null_cipher
        __props__.__dict__["cloudflare_endpoint"] = cloudflare_endpoint
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["customer_endpoint"] = customer_endpoint
        __props__.__dict__["description"] = description
        __props__.__dict__["health_check"] = health_check
        __props__.__dict__["interface_address"] = interface_address
        __props__.__dict__["ipsec_tunnel"] = ipsec_tunnel
        __props__.__dict__["modified"] = modified
        __props__.__dict__["modified_ipsec_tunnel"] = modified_ipsec_tunnel
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["psk"] = psk
        __props__.__dict__["psk_metadata"] = psk_metadata
        __props__.__dict__["replay_protection"] = replay_protection
        return MagicWanIpsecTunnel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="allowNullCipher")
    def allow_null_cipher(self) -> pulumi.Output[builtins.bool]:
        """
        When `true`, the tunnel can use a null-cipher (`ENCR_NULL`) in the ESP tunnel (Phase 2).
        """
        return pulumi.get(self, "allow_null_cipher")

    @property
    @pulumi.getter(name="cloudflareEndpoint")
    def cloudflare_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The IP address assigned to the Cloudflare side of the IPsec tunnel.
        """
        return pulumi.get(self, "cloudflare_endpoint")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the tunnel was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="customerEndpoint")
    def customer_endpoint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The IP address assigned to the customer side of the IPsec tunnel. Not required, but must be set for proactive traceroutes to work.
        """
        return pulumi.get(self, "customer_endpoint")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description forthe IPsec tunnel.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Output['outputs.MagicWanIpsecTunnelHealthCheck']:
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="interfaceAddress")
    def interface_address(self) -> pulumi.Output[builtins.str]:
        """
        A 31-bit prefix (/31 in CIDR notation) supporting two hosts, one for each side of the tunnel. Select the subnet from the following private IP space: 10.0.0.0–10.255.255.255, 172.16.0.0–172.31.255.255, 192.168.0.0–192.168.255.255.
        """
        return pulumi.get(self, "interface_address")

    @property
    @pulumi.getter(name="ipsecTunnel")
    def ipsec_tunnel(self) -> pulumi.Output['outputs.MagicWanIpsecTunnelIpsecTunnel']:
        return pulumi.get(self, "ipsec_tunnel")

    @property
    @pulumi.getter
    def modified(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "modified")

    @property
    @pulumi.getter(name="modifiedIpsecTunnel")
    def modified_ipsec_tunnel(self) -> pulumi.Output['outputs.MagicWanIpsecTunnelModifiedIpsecTunnel']:
        return pulumi.get(self, "modified_ipsec_tunnel")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the tunnel was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the IPsec tunnel. The name cannot share a name with other tunnels.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def psk(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A randomly generated or provided string for use in the IPsec tunnel.
        """
        return pulumi.get(self, "psk")

    @property
    @pulumi.getter(name="pskMetadata")
    def psk_metadata(self) -> pulumi.Output['outputs.MagicWanIpsecTunnelPskMetadata']:
        """
        The PSK metadata that includes when the PSK was generated.
        """
        return pulumi.get(self, "psk_metadata")

    @property
    @pulumi.getter(name="replayProtection")
    def replay_protection(self) -> pulumi.Output[builtins.bool]:
        """
        If `true`, then IPsec replay protection will be supported in the Cloudflare-to-customer direction.
        """
        return pulumi.get(self, "replay_protection")

