# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OriginCaCertificateArgs', 'OriginCaCertificate']

@pulumi.input_type
class OriginCaCertificateArgs:
    def __init__(__self__, *,
                 csr: Optional[pulumi.Input[builtins.str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 request_type: Optional[pulumi.Input[builtins.str]] = None,
                 requested_validity: Optional[pulumi.Input[builtins.float]] = None):
        """
        The set of arguments for constructing a OriginCaCertificate resource.
        :param pulumi.Input[builtins.str] csr: The Certificate Signing Request (CSR). Must be newline-encoded.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hostnames: Array of hostnames or wildcard names (e.g., *.example.com) bound to the certificate.
        :param pulumi.Input[builtins.str] request_type: Signature type desired on certificate ("origin-rsa" (rsa), "origin-ecc" (ecdsa), or "keyless-certificate" (for Keyless SSL servers).
               Available values: "origin-rsa", "origin-ecc", "keyless-certificate".
        :param pulumi.Input[builtins.float] requested_validity: The number of days for which the certificate should be valid.
               Available values: 7, 30, 90, 365, 730, 1095, 5475.
        """
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if request_type is not None:
            pulumi.set(__self__, "request_type", request_type)
        if requested_validity is not None:
            pulumi.set(__self__, "requested_validity", requested_validity)

    @property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Certificate Signing Request (CSR). Must be newline-encoded.
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "csr", value)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Array of hostnames or wildcard names (e.g., *.example.com) bound to the certificate.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter(name="requestType")
    def request_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Signature type desired on certificate ("origin-rsa" (rsa), "origin-ecc" (ecdsa), or "keyless-certificate" (for Keyless SSL servers).
        Available values: "origin-rsa", "origin-ecc", "keyless-certificate".
        """
        return pulumi.get(self, "request_type")

    @request_type.setter
    def request_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request_type", value)

    @property
    @pulumi.getter(name="requestedValidity")
    def requested_validity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of days for which the certificate should be valid.
        Available values: 7, 30, 90, 365, 730, 1095, 5475.
        """
        return pulumi.get(self, "requested_validity")

    @requested_validity.setter
    def requested_validity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "requested_validity", value)


@pulumi.input_type
class _OriginCaCertificateState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[builtins.str]] = None,
                 csr: Optional[pulumi.Input[builtins.str]] = None,
                 expires_on: Optional[pulumi.Input[builtins.str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 request_type: Optional[pulumi.Input[builtins.str]] = None,
                 requested_validity: Optional[pulumi.Input[builtins.float]] = None):
        """
        Input properties used for looking up and filtering OriginCaCertificate resources.
        :param pulumi.Input[builtins.str] certificate: The Origin CA certificate. Will be newline-encoded.
        :param pulumi.Input[builtins.str] csr: The Certificate Signing Request (CSR). Must be newline-encoded.
        :param pulumi.Input[builtins.str] expires_on: When the certificate will expire.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hostnames: Array of hostnames or wildcard names (e.g., *.example.com) bound to the certificate.
        :param pulumi.Input[builtins.str] request_type: Signature type desired on certificate ("origin-rsa" (rsa), "origin-ecc" (ecdsa), or "keyless-certificate" (for Keyless SSL servers).
               Available values: "origin-rsa", "origin-ecc", "keyless-certificate".
        :param pulumi.Input[builtins.float] requested_validity: The number of days for which the certificate should be valid.
               Available values: 7, 30, 90, 365, 730, 1095, 5475.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if expires_on is not None:
            pulumi.set(__self__, "expires_on", expires_on)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if request_type is not None:
            pulumi.set(__self__, "request_type", request_type)
        if requested_validity is not None:
            pulumi.set(__self__, "requested_validity", requested_validity)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Origin CA certificate. Will be newline-encoded.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Certificate Signing Request (CSR). Must be newline-encoded.
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "csr", value)

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the certificate will expire.
        """
        return pulumi.get(self, "expires_on")

    @expires_on.setter
    def expires_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expires_on", value)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Array of hostnames or wildcard names (e.g., *.example.com) bound to the certificate.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter(name="requestType")
    def request_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Signature type desired on certificate ("origin-rsa" (rsa), "origin-ecc" (ecdsa), or "keyless-certificate" (for Keyless SSL servers).
        Available values: "origin-rsa", "origin-ecc", "keyless-certificate".
        """
        return pulumi.get(self, "request_type")

    @request_type.setter
    def request_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request_type", value)

    @property
    @pulumi.getter(name="requestedValidity")
    def requested_validity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of days for which the certificate should be valid.
        Available values: 7, 30, 90, 365, 730, 1095, 5475.
        """
        return pulumi.get(self, "requested_validity")

    @requested_validity.setter
    def requested_validity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "requested_validity", value)


@pulumi.type_token("cloudflare:index/originCaCertificate:OriginCaCertificate")
class OriginCaCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 csr: Optional[pulumi.Input[builtins.str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 request_type: Optional[pulumi.Input[builtins.str]] = None,
                 requested_validity: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_origin_ca_certificate = cloudflare.OriginCaCertificate("example_origin_ca_certificate",
            csr=\"\"\"  -----BEGIN CERTIFICATE REQUEST-----
          MIICxzCCAa8CAQAwSDELMAkGA1UEBhMCVVMxFjAUBgNVBAgTDVNhbiBGcmFuY2lz
          Y28xCzAJBgNVBAcTAkNBMRQwEgYDVQQDEwtleGFtcGxlLm5ldDCCASIwDQYJKoZI
          hvcNAQEBBQADggEPADCCAQoCggEBALxejtu4b+jPdFeFi6OUsye8TYJQBm3WfCvL
          Hu5EvijMO/4Z2TImwASbwUF7Ir8OLgH+mGlQZeqyNvGoSOMEaZVXcYfpR1hlVak8
          4GGVr+04IGfOCqaBokaBFIwzclGZbzKmLGwIQioNxGfqFm6RGYGA3be2Je2iseBc
          N8GV1wYmvYE0RR+yWweJCTJ157exyRzu7sVxaEW9F87zBQLyOnwXc64rflXslRqi
          g7F7w5IaQYOl8yvmk/jEPCAha7fkiUfEpj4N12+oPRiMvleJF98chxjD4MH39c5I
          uOslULhrWunfh7GB1jwWNA9y44H0snrf+xvoy2TcHmxvma9Eln8CAwEAAaA6MDgG
          CSqGSIb3DQEJDjErMCkwJwYDVR0RBCAwHoILZXhhbXBsZS5uZXSCD3d3dy5leGFt
          cGxlLm5ldDANBgkqhkiG9w0BAQsFAAOCAQEAcBaX6dOnI8ncARrI9ZSF2AJX+8mx
          pTHY2+Y2C0VvrVDGMtbBRH8R9yMbqWtlxeeNGf//LeMkSKSFa4kbpdx226lfui8/
          auRDBTJGx2R1ccUxmLZXx4my0W5iIMxunu+kez+BDlu7bTT2io0uXMRHue4i6quH
          yc5ibxvbJMjR7dqbcanVE10/34oprzXQsJ/VmSuZNXtjbtSKDlmcpw6To/eeAJ+J
          hXykcUihvHyG4A1m2R6qpANBjnA0pHexfwM/SgfzvpbvUg0T1ubmer8BgTwCKIWs
          dcWYTthM51JIqRBfNqy4QcBnX+GY05yltEEswQI55wdiS3CjTTA67sdbcQ==
          -----END CERTIFICATE REQUEST-----
        \"\"\",
            hostnames=[
                "example.com",
                "*.example.com",
            ],
            request_type="origin-rsa",
            requested_validity=5475)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/originCaCertificate:OriginCaCertificate example '<certificate_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] csr: The Certificate Signing Request (CSR). Must be newline-encoded.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hostnames: Array of hostnames or wildcard names (e.g., *.example.com) bound to the certificate.
        :param pulumi.Input[builtins.str] request_type: Signature type desired on certificate ("origin-rsa" (rsa), "origin-ecc" (ecdsa), or "keyless-certificate" (for Keyless SSL servers).
               Available values: "origin-rsa", "origin-ecc", "keyless-certificate".
        :param pulumi.Input[builtins.float] requested_validity: The number of days for which the certificate should be valid.
               Available values: 7, 30, 90, 365, 730, 1095, 5475.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[OriginCaCertificateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_origin_ca_certificate = cloudflare.OriginCaCertificate("example_origin_ca_certificate",
            csr=\"\"\"  -----BEGIN CERTIFICATE REQUEST-----
          MIICxzCCAa8CAQAwSDELMAkGA1UEBhMCVVMxFjAUBgNVBAgTDVNhbiBGcmFuY2lz
          Y28xCzAJBgNVBAcTAkNBMRQwEgYDVQQDEwtleGFtcGxlLm5ldDCCASIwDQYJKoZI
          hvcNAQEBBQADggEPADCCAQoCggEBALxejtu4b+jPdFeFi6OUsye8TYJQBm3WfCvL
          Hu5EvijMO/4Z2TImwASbwUF7Ir8OLgH+mGlQZeqyNvGoSOMEaZVXcYfpR1hlVak8
          4GGVr+04IGfOCqaBokaBFIwzclGZbzKmLGwIQioNxGfqFm6RGYGA3be2Je2iseBc
          N8GV1wYmvYE0RR+yWweJCTJ157exyRzu7sVxaEW9F87zBQLyOnwXc64rflXslRqi
          g7F7w5IaQYOl8yvmk/jEPCAha7fkiUfEpj4N12+oPRiMvleJF98chxjD4MH39c5I
          uOslULhrWunfh7GB1jwWNA9y44H0snrf+xvoy2TcHmxvma9Eln8CAwEAAaA6MDgG
          CSqGSIb3DQEJDjErMCkwJwYDVR0RBCAwHoILZXhhbXBsZS5uZXSCD3d3dy5leGFt
          cGxlLm5ldDANBgkqhkiG9w0BAQsFAAOCAQEAcBaX6dOnI8ncARrI9ZSF2AJX+8mx
          pTHY2+Y2C0VvrVDGMtbBRH8R9yMbqWtlxeeNGf//LeMkSKSFa4kbpdx226lfui8/
          auRDBTJGx2R1ccUxmLZXx4my0W5iIMxunu+kez+BDlu7bTT2io0uXMRHue4i6quH
          yc5ibxvbJMjR7dqbcanVE10/34oprzXQsJ/VmSuZNXtjbtSKDlmcpw6To/eeAJ+J
          hXykcUihvHyG4A1m2R6qpANBjnA0pHexfwM/SgfzvpbvUg0T1ubmer8BgTwCKIWs
          dcWYTthM51JIqRBfNqy4QcBnX+GY05yltEEswQI55wdiS3CjTTA67sdbcQ==
          -----END CERTIFICATE REQUEST-----
        \"\"\",
            hostnames=[
                "example.com",
                "*.example.com",
            ],
            request_type="origin-rsa",
            requested_validity=5475)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/originCaCertificate:OriginCaCertificate example '<certificate_id>'
        ```

        :param str resource_name: The name of the resource.
        :param OriginCaCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OriginCaCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 csr: Optional[pulumi.Input[builtins.str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 request_type: Optional[pulumi.Input[builtins.str]] = None,
                 requested_validity: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OriginCaCertificateArgs.__new__(OriginCaCertificateArgs)

            __props__.__dict__["csr"] = csr
            __props__.__dict__["hostnames"] = hostnames
            __props__.__dict__["request_type"] = request_type
            __props__.__dict__["requested_validity"] = requested_validity
            __props__.__dict__["certificate"] = None
            __props__.__dict__["expires_on"] = None
        super(OriginCaCertificate, __self__).__init__(
            'cloudflare:index/originCaCertificate:OriginCaCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[builtins.str]] = None,
            csr: Optional[pulumi.Input[builtins.str]] = None,
            expires_on: Optional[pulumi.Input[builtins.str]] = None,
            hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            request_type: Optional[pulumi.Input[builtins.str]] = None,
            requested_validity: Optional[pulumi.Input[builtins.float]] = None) -> 'OriginCaCertificate':
        """
        Get an existing OriginCaCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate: The Origin CA certificate. Will be newline-encoded.
        :param pulumi.Input[builtins.str] csr: The Certificate Signing Request (CSR). Must be newline-encoded.
        :param pulumi.Input[builtins.str] expires_on: When the certificate will expire.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] hostnames: Array of hostnames or wildcard names (e.g., *.example.com) bound to the certificate.
        :param pulumi.Input[builtins.str] request_type: Signature type desired on certificate ("origin-rsa" (rsa), "origin-ecc" (ecdsa), or "keyless-certificate" (for Keyless SSL servers).
               Available values: "origin-rsa", "origin-ecc", "keyless-certificate".
        :param pulumi.Input[builtins.float] requested_validity: The number of days for which the certificate should be valid.
               Available values: 7, 30, 90, 365, 730, 1095, 5475.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OriginCaCertificateState.__new__(_OriginCaCertificateState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["csr"] = csr
        __props__.__dict__["expires_on"] = expires_on
        __props__.__dict__["hostnames"] = hostnames
        __props__.__dict__["request_type"] = request_type
        __props__.__dict__["requested_validity"] = requested_validity
        return OriginCaCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[builtins.str]:
        """
        The Origin CA certificate. Will be newline-encoded.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def csr(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Certificate Signing Request (CSR). Must be newline-encoded.
        """
        return pulumi.get(self, "csr")

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> pulumi.Output[builtins.str]:
        """
        When the certificate will expire.
        """
        return pulumi.get(self, "expires_on")

    @property
    @pulumi.getter
    def hostnames(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Array of hostnames or wildcard names (e.g., *.example.com) bound to the certificate.
        """
        return pulumi.get(self, "hostnames")

    @property
    @pulumi.getter(name="requestType")
    def request_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Signature type desired on certificate ("origin-rsa" (rsa), "origin-ecc" (ecdsa), or "keyless-certificate" (for Keyless SSL servers).
        Available values: "origin-rsa", "origin-ecc", "keyless-certificate".
        """
        return pulumi.get(self, "request_type")

    @property
    @pulumi.getter(name="requestedValidity")
    def requested_validity(self) -> pulumi.Output[builtins.float]:
        """
        The number of days for which the certificate should be valid.
        Available values: 7, 30, 90, 365, 730, 1095, 5475.
        """
        return pulumi.get(self, "requested_validity")

