# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PageShieldPolicyArgs', 'PageShieldPolicy']

@pulumi.input_type
class PageShieldPolicyArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 description: pulumi.Input[builtins.str],
                 enabled: pulumi.Input[builtins.bool],
                 expression: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str],
                 zone_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a PageShieldPolicy resource.
        :param pulumi.Input[builtins.str] action: The action to take if the expression matches
               Available values: "allow", "log".
        :param pulumi.Input[builtins.str] description: A description for the policy
        :param pulumi.Input[builtins.bool] enabled: Whether the policy is enabled
        :param pulumi.Input[builtins.str] expression: The expression which must match for the policy to be applied, using the Cloudflare Firewall rule expression syntax
        :param pulumi.Input[builtins.str] value: The policy which will be applied
        :param pulumi.Input[builtins.str] zone_id: Identifier
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        The action to take if the expression matches
        Available values: "allow", "log".
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        A description for the policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Whether the policy is enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        """
        The expression which must match for the policy to be applied, using the Cloudflare Firewall rule expression syntax
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The policy which will be applied
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _PageShieldPolicyState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 expression: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PageShieldPolicy resources.
        :param pulumi.Input[builtins.str] action: The action to take if the expression matches
               Available values: "allow", "log".
        :param pulumi.Input[builtins.str] description: A description for the policy
        :param pulumi.Input[builtins.bool] enabled: Whether the policy is enabled
        :param pulumi.Input[builtins.str] expression: The expression which must match for the policy to be applied, using the Cloudflare Firewall rule expression syntax
        :param pulumi.Input[builtins.str] value: The policy which will be applied
        :param pulumi.Input[builtins.str] zone_id: Identifier
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take if the expression matches
        Available values: "allow", "log".
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the policy is enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The expression which must match for the policy to be applied, using the Cloudflare Firewall rule expression syntax
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The policy which will be applied
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/pageShieldPolicy:PageShieldPolicy")
class PageShieldPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 expression: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/pageShieldPolicy:PageShieldPolicy example '<zone_id>/<policy_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: The action to take if the expression matches
               Available values: "allow", "log".
        :param pulumi.Input[builtins.str] description: A description for the policy
        :param pulumi.Input[builtins.bool] enabled: Whether the policy is enabled
        :param pulumi.Input[builtins.str] expression: The expression which must match for the policy to be applied, using the Cloudflare Firewall rule expression syntax
        :param pulumi.Input[builtins.str] value: The policy which will be applied
        :param pulumi.Input[builtins.str] zone_id: Identifier
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PageShieldPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/pageShieldPolicy:PageShieldPolicy example '<zone_id>/<policy_id>'
        ```

        :param str resource_name: The name of the resource.
        :param PageShieldPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PageShieldPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 expression: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PageShieldPolicyArgs.__new__(PageShieldPolicyArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if expression is None and not opts.urn:
                raise TypeError("Missing required property 'expression'")
            __props__.__dict__["expression"] = expression
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(PageShieldPolicy, __self__).__init__(
            'cloudflare:index/pageShieldPolicy:PageShieldPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            expression: Optional[pulumi.Input[builtins.str]] = None,
            value: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'PageShieldPolicy':
        """
        Get an existing PageShieldPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: The action to take if the expression matches
               Available values: "allow", "log".
        :param pulumi.Input[builtins.str] description: A description for the policy
        :param pulumi.Input[builtins.bool] enabled: Whether the policy is enabled
        :param pulumi.Input[builtins.str] expression: The expression which must match for the policy to be applied, using the Cloudflare Firewall rule expression syntax
        :param pulumi.Input[builtins.str] value: The policy which will be applied
        :param pulumi.Input[builtins.str] zone_id: Identifier
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PageShieldPolicyState.__new__(_PageShieldPolicyState)

        __props__.__dict__["action"] = action
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["expression"] = expression
        __props__.__dict__["value"] = value
        __props__.__dict__["zone_id"] = zone_id
        return PageShieldPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[builtins.str]:
        """
        The action to take if the expression matches
        Available values: "allow", "log".
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        A description for the policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the policy is enabled
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Output[builtins.str]:
        """
        The expression which must match for the policy to be applied, using the Cloudflare Firewall rule expression syntax
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[builtins.str]:
        """
        The policy which will be applied
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")

