# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PagesDomainArgs', 'PagesDomain']

@pulumi.input_type
class PagesDomainArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 project_name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a PagesDomain resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] project_name: Name of the project.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_name", project_name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the project.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_name", value)


@pulumi.input_type
class _PagesDomainState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_authority: Optional[pulumi.Input[builtins.str]] = None,
                 created_on: Optional[pulumi.Input[builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_name: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 validation_data: Optional[pulumi.Input['PagesDomainValidationDataArgs']] = None,
                 verification_data: Optional[pulumi.Input['PagesDomainVerificationDataArgs']] = None,
                 zone_tag: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PagesDomain resources.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] certificate_authority: Available values: "google", "lets_encrypt".
        :param pulumi.Input[builtins.str] project_name: Name of the project.
        :param pulumi.Input[builtins.str] status: Available values: "initializing", "pending", "active", "deactivated", "blocked", "error".
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if verification_data is not None:
            pulumi.set(__self__, "verification_data", verification_data)
        if zone_tag is not None:
            pulumi.set(__self__, "zone_tag", zone_tag)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Available values: "google", "lets_encrypt".
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_authority", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the project.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Available values: "initializing", "pending", "active", "deactivated", "blocked", "error".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input['PagesDomainValidationDataArgs']]:
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input['PagesDomainValidationDataArgs']]):
        pulumi.set(self, "validation_data", value)

    @property
    @pulumi.getter(name="verificationData")
    def verification_data(self) -> Optional[pulumi.Input['PagesDomainVerificationDataArgs']]:
        return pulumi.get(self, "verification_data")

    @verification_data.setter
    def verification_data(self, value: Optional[pulumi.Input['PagesDomainVerificationDataArgs']]):
        pulumi.set(self, "verification_data", value)

    @property
    @pulumi.getter(name="zoneTag")
    def zone_tag(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "zone_tag")

    @zone_tag.setter
    def zone_tag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_tag", value)


@pulumi.type_token("cloudflare:index/pagesDomain:PagesDomain")
class PagesDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        > A DNS record for the domain is not automatically created. You need to create
           a `cloudflare_record` resource for the domain you want to use.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_pages_domain = cloudflare.PagesDomain("example_pages_domain",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            project_name="this-is-my-project-01",
            name="example.com")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/pagesDomain:PagesDomain example '<account_id>/<project_name>/<domain_name>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] project_name: Name of the project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PagesDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > A DNS record for the domain is not automatically created. You need to create
           a `cloudflare_record` resource for the domain you want to use.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_pages_domain = cloudflare.PagesDomain("example_pages_domain",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            project_name="this-is-my-project-01",
            name="example.com")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/pagesDomain:PagesDomain example '<account_id>/<project_name>/<domain_name>'
        ```

        :param str resource_name: The name of the resource.
        :param PagesDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PagesDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PagesDomainArgs.__new__(PagesDomainArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["certificate_authority"] = None
            __props__.__dict__["created_on"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["validation_data"] = None
            __props__.__dict__["verification_data"] = None
            __props__.__dict__["zone_tag"] = None
        super(PagesDomain, __self__).__init__(
            'cloudflare:index/pagesDomain:PagesDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            certificate_authority: Optional[pulumi.Input[builtins.str]] = None,
            created_on: Optional[pulumi.Input[builtins.str]] = None,
            domain_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project_name: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            validation_data: Optional[pulumi.Input[Union['PagesDomainValidationDataArgs', 'PagesDomainValidationDataArgsDict']]] = None,
            verification_data: Optional[pulumi.Input[Union['PagesDomainVerificationDataArgs', 'PagesDomainVerificationDataArgsDict']]] = None,
            zone_tag: Optional[pulumi.Input[builtins.str]] = None) -> 'PagesDomain':
        """
        Get an existing PagesDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] certificate_authority: Available values: "google", "lets_encrypt".
        :param pulumi.Input[builtins.str] project_name: Name of the project.
        :param pulumi.Input[builtins.str] status: Available values: "initializing", "pending", "active", "deactivated", "blocked", "error".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PagesDomainState.__new__(_PagesDomainState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["certificate_authority"] = certificate_authority
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["status"] = status
        __props__.__dict__["validation_data"] = validation_data
        __props__.__dict__["verification_data"] = verification_data
        __props__.__dict__["zone_tag"] = zone_tag
        return PagesDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> pulumi.Output[builtins.str]:
        """
        Available values: "google", "lets_encrypt".
        """
        return pulumi.get(self, "certificate_authority")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the project.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Available values: "initializing", "pending", "active", "deactivated", "blocked", "error".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> pulumi.Output['outputs.PagesDomainValidationData']:
        return pulumi.get(self, "validation_data")

    @property
    @pulumi.getter(name="verificationData")
    def verification_data(self) -> pulumi.Output['outputs.PagesDomainVerificationData']:
        return pulumi.get(self, "verification_data")

    @property
    @pulumi.getter(name="zoneTag")
    def zone_tag(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "zone_tag")

