# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 api_token: Optional[pulumi.Input[builtins.str]] = None,
                 api_user_service_key: Optional[pulumi.Input[builtins.str]] = None,
                 base_url: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 user_agent_operator_suffix: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[builtins.str] api_key: The API key for operations. Alternatively, can be configured using the `CLOUDFLARE_API_KEY` environment variable. API
               keys are [now considered legacy by
               Cloudflare](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#limitations), API tokens should be used
               instead. Must provide only one of `api_key`, `api_token`, `api_user_service_key`.
        :param pulumi.Input[builtins.str] api_token: The API Token for operations. Alternatively, can be configured using the `CLOUDFLARE_API_TOKEN` environment variable.
               Must provide only one of `api_key`, `api_token`, `api_user_service_key`.
        :param pulumi.Input[builtins.str] api_user_service_key: A special Cloudflare API key good for a restricted set of endpoints. Alternatively, can be configured using the
               `CLOUDFLARE_API_USER_SERVICE_KEY` environment variable. Must provide only one of `api_key`, `api_token`,
               `api_user_service_key`.
        :param pulumi.Input[builtins.str] base_url: Value to override the default HTTP client base URL. Alternatively, can be configured using the `base_url` environment
               variable.
        :param pulumi.Input[builtins.str] email: A registered Cloudflare email address. Alternatively, can be configured using the `CLOUDFLARE_EMAIL` environment
               variable. Required when using `api_key`. Conflicts with `api_token`.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if api_token is not None:
            pulumi.set(__self__, "api_token", api_token)
        if api_user_service_key is not None:
            pulumi.set(__self__, "api_user_service_key", api_user_service_key)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if user_agent_operator_suffix is not None:
            pulumi.set(__self__, "user_agent_operator_suffix", user_agent_operator_suffix)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The API key for operations. Alternatively, can be configured using the `CLOUDFLARE_API_KEY` environment variable. API
        keys are [now considered legacy by
        Cloudflare](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#limitations), API tokens should be used
        instead. Must provide only one of `api_key`, `api_token`, `api_user_service_key`.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The API Token for operations. Alternatively, can be configured using the `CLOUDFLARE_API_TOKEN` environment variable.
        Must provide only one of `api_key`, `api_token`, `api_user_service_key`.
        """
        return pulumi.get(self, "api_token")

    @api_token.setter
    def api_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_token", value)

    @property
    @pulumi.getter(name="apiUserServiceKey")
    def api_user_service_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A special Cloudflare API key good for a restricted set of endpoints. Alternatively, can be configured using the
        `CLOUDFLARE_API_USER_SERVICE_KEY` environment variable. Must provide only one of `api_key`, `api_token`,
        `api_user_service_key`.
        """
        return pulumi.get(self, "api_user_service_key")

    @api_user_service_key.setter
    def api_user_service_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_user_service_key", value)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value to override the default HTTP client base URL. Alternatively, can be configured using the `base_url` environment
        variable.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A registered Cloudflare email address. Alternatively, can be configured using the `CLOUDFLARE_EMAIL` environment
        variable. Required when using `api_key`. Conflicts with `api_token`.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="userAgentOperatorSuffix")
    def user_agent_operator_suffix(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "user_agent_operator_suffix")

    @user_agent_operator_suffix.setter
    def user_agent_operator_suffix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_agent_operator_suffix", value)


@pulumi.type_token("pulumi:providers:cloudflare")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 api_token: Optional[pulumi.Input[builtins.str]] = None,
                 api_user_service_key: Optional[pulumi.Input[builtins.str]] = None,
                 base_url: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 user_agent_operator_suffix: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the cloudflare package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_key: The API key for operations. Alternatively, can be configured using the `CLOUDFLARE_API_KEY` environment variable. API
               keys are [now considered legacy by
               Cloudflare](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#limitations), API tokens should be used
               instead. Must provide only one of `api_key`, `api_token`, `api_user_service_key`.
        :param pulumi.Input[builtins.str] api_token: The API Token for operations. Alternatively, can be configured using the `CLOUDFLARE_API_TOKEN` environment variable.
               Must provide only one of `api_key`, `api_token`, `api_user_service_key`.
        :param pulumi.Input[builtins.str] api_user_service_key: A special Cloudflare API key good for a restricted set of endpoints. Alternatively, can be configured using the
               `CLOUDFLARE_API_USER_SERVICE_KEY` environment variable. Must provide only one of `api_key`, `api_token`,
               `api_user_service_key`.
        :param pulumi.Input[builtins.str] base_url: Value to override the default HTTP client base URL. Alternatively, can be configured using the `base_url` environment
               variable.
        :param pulumi.Input[builtins.str] email: A registered Cloudflare email address. Alternatively, can be configured using the `CLOUDFLARE_EMAIL` environment
               variable. Required when using `api_key`. Conflicts with `api_token`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the cloudflare package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[builtins.str]] = None,
                 api_token: Optional[pulumi.Input[builtins.str]] = None,
                 api_user_service_key: Optional[pulumi.Input[builtins.str]] = None,
                 base_url: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 user_agent_operator_suffix: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            __props__.__dict__["api_token"] = None if api_token is None else pulumi.Output.secret(api_token)
            __props__.__dict__["api_user_service_key"] = None if api_user_service_key is None else pulumi.Output.secret(api_user_service_key)
            __props__.__dict__["base_url"] = base_url
            __props__.__dict__["email"] = email
            __props__.__dict__["user_agent_operator_suffix"] = user_agent_operator_suffix
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "apiToken", "apiUserServiceKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'cloudflare',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The API key for operations. Alternatively, can be configured using the `CLOUDFLARE_API_KEY` environment variable. API
        keys are [now considered legacy by
        Cloudflare](https://developers.cloudflare.com/fundamentals/api/get-started/keys/#limitations), API tokens should be used
        instead. Must provide only one of `api_key`, `api_token`, `api_user_service_key`.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The API Token for operations. Alternatively, can be configured using the `CLOUDFLARE_API_TOKEN` environment variable.
        Must provide only one of `api_key`, `api_token`, `api_user_service_key`.
        """
        return pulumi.get(self, "api_token")

    @property
    @pulumi.getter(name="apiUserServiceKey")
    def api_user_service_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A special Cloudflare API key good for a restricted set of endpoints. Alternatively, can be configured using the
        `CLOUDFLARE_API_USER_SERVICE_KEY` environment variable. Must provide only one of `api_key`, `api_token`,
        `api_user_service_key`.
        """
        return pulumi.get(self, "api_user_service_key")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Value to override the default HTTP client base URL. Alternatively, can be configured using the `base_url` environment
        variable.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A registered Cloudflare email address. Alternatively, can be configured using the `CLOUDFLARE_EMAIL` environment
        variable. Required when using `api_key`. Conflicts with `api_token`.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="userAgentOperatorSuffix")
    def user_agent_operator_suffix(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "user_agent_operator_suffix")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:cloudflare/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

