# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['R2BucketArgs', 'R2Bucket']

@pulumi.input_type
class R2BucketArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 jurisdiction: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a R2Bucket resource.
        :param pulumi.Input[builtins.str] account_id: Account ID.
        :param pulumi.Input[builtins.str] name: Name of the bucket.
        :param pulumi.Input[builtins.str] jurisdiction: Jurisdiction where objects in this bucket are guaranteed to be stored.
               Available values: "default", "eu", "fedramp".
        :param pulumi.Input[builtins.str] location: Location of the bucket.
               Available values: "apac", "eeur", "enam", "weur", "wnam", "oc".
        :param pulumi.Input[builtins.str] storage_class: Storage class for newly uploaded objects, unless specified otherwise.
               Available values: "Standard", "InfrequentAccess".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        if jurisdiction is not None:
            pulumi.set(__self__, "jurisdiction", jurisdiction)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def jurisdiction(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Jurisdiction where objects in this bucket are guaranteed to be stored.
        Available values: "default", "eu", "fedramp".
        """
        return pulumi.get(self, "jurisdiction")

    @jurisdiction.setter
    def jurisdiction(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "jurisdiction", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of the bucket.
        Available values: "apac", "eeur", "enam", "weur", "wnam", "oc".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Storage class for newly uploaded objects, unless specified otherwise.
        Available values: "Standard", "InfrequentAccess".
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_class", value)


@pulumi.input_type
class _R2BucketState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 creation_date: Optional[pulumi.Input[builtins.str]] = None,
                 jurisdiction: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering R2Bucket resources.
        :param pulumi.Input[builtins.str] account_id: Account ID.
        :param pulumi.Input[builtins.str] creation_date: Creation timestamp.
        :param pulumi.Input[builtins.str] jurisdiction: Jurisdiction where objects in this bucket are guaranteed to be stored.
               Available values: "default", "eu", "fedramp".
        :param pulumi.Input[builtins.str] location: Location of the bucket.
               Available values: "apac", "eeur", "enam", "weur", "wnam", "oc".
        :param pulumi.Input[builtins.str] name: Name of the bucket.
        :param pulumi.Input[builtins.str] storage_class: Storage class for newly uploaded objects, unless specified otherwise.
               Available values: "Standard", "InfrequentAccess".
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if jurisdiction is not None:
            pulumi.set(__self__, "jurisdiction", jurisdiction)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_date", value)

    @property
    @pulumi.getter
    def jurisdiction(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Jurisdiction where objects in this bucket are guaranteed to be stored.
        Available values: "default", "eu", "fedramp".
        """
        return pulumi.get(self, "jurisdiction")

    @jurisdiction.setter
    def jurisdiction(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "jurisdiction", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of the bucket.
        Available values: "apac", "eeur", "enam", "weur", "wnam", "oc".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Storage class for newly uploaded objects, unless specified otherwise.
        Available values: "Standard", "InfrequentAccess".
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_class", value)


@pulumi.type_token("cloudflare:index/r2Bucket:R2Bucket")
class R2Bucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 jurisdiction: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_r2_bucket = cloudflare.R2Bucket("example_r2_bucket",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            name="example-bucket",
            location="apac",
            storage_class="Standard")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/r2Bucket:R2Bucket example '<account_id>/<bucket_name>/<jurisdiction>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account ID.
        :param pulumi.Input[builtins.str] jurisdiction: Jurisdiction where objects in this bucket are guaranteed to be stored.
               Available values: "default", "eu", "fedramp".
        :param pulumi.Input[builtins.str] location: Location of the bucket.
               Available values: "apac", "eeur", "enam", "weur", "wnam", "oc".
        :param pulumi.Input[builtins.str] name: Name of the bucket.
        :param pulumi.Input[builtins.str] storage_class: Storage class for newly uploaded objects, unless specified otherwise.
               Available values: "Standard", "InfrequentAccess".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: R2BucketArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_r2_bucket = cloudflare.R2Bucket("example_r2_bucket",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            name="example-bucket",
            location="apac",
            storage_class="Standard")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/r2Bucket:R2Bucket example '<account_id>/<bucket_name>/<jurisdiction>'
        ```

        :param str resource_name: The name of the resource.
        :param R2BucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(R2BucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 jurisdiction: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_class: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = R2BucketArgs.__new__(R2BucketArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["jurisdiction"] = jurisdiction
            __props__.__dict__["location"] = location
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["storage_class"] = storage_class
            __props__.__dict__["creation_date"] = None
        super(R2Bucket, __self__).__init__(
            'cloudflare:index/r2Bucket:R2Bucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            creation_date: Optional[pulumi.Input[builtins.str]] = None,
            jurisdiction: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            storage_class: Optional[pulumi.Input[builtins.str]] = None) -> 'R2Bucket':
        """
        Get an existing R2Bucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account ID.
        :param pulumi.Input[builtins.str] creation_date: Creation timestamp.
        :param pulumi.Input[builtins.str] jurisdiction: Jurisdiction where objects in this bucket are guaranteed to be stored.
               Available values: "default", "eu", "fedramp".
        :param pulumi.Input[builtins.str] location: Location of the bucket.
               Available values: "apac", "eeur", "enam", "weur", "wnam", "oc".
        :param pulumi.Input[builtins.str] name: Name of the bucket.
        :param pulumi.Input[builtins.str] storage_class: Storage class for newly uploaded objects, unless specified otherwise.
               Available values: "Standard", "InfrequentAccess".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _R2BucketState.__new__(_R2BucketState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["jurisdiction"] = jurisdiction
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["storage_class"] = storage_class
        return R2Bucket(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter
    def jurisdiction(self) -> pulumi.Output[builtins.str]:
        """
        Jurisdiction where objects in this bucket are guaranteed to be stored.
        Available values: "default", "eu", "fedramp".
        """
        return pulumi.get(self, "jurisdiction")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Location of the bucket.
        Available values: "apac", "eeur", "enam", "weur", "wnam", "oc".
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[builtins.str]:
        """
        Storage class for newly uploaded objects, unless specified otherwise.
        Available values: "Standard", "InfrequentAccess".
        """
        return pulumi.get(self, "storage_class")

