# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['R2BucketLockArgs', 'R2BucketLock']

@pulumi.input_type
class R2BucketLockArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 bucket_name: pulumi.Input[builtins.str],
                 jurisdiction: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['R2BucketLockRuleArgs']]]] = None):
        """
        The set of arguments for constructing a R2BucketLock resource.
        :param pulumi.Input[builtins.str] account_id: Account ID.
        :param pulumi.Input[builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[builtins.str] jurisdiction: Jurisdiction of the bucket
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "bucket_name", bucket_name)
        if jurisdiction is not None:
            pulumi.set(__self__, "jurisdiction", jurisdiction)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def jurisdiction(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @jurisdiction.setter
    def jurisdiction(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "jurisdiction", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['R2BucketLockRuleArgs']]]]:
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['R2BucketLockRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _R2BucketLockState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 jurisdiction: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['R2BucketLockRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering R2BucketLock resources.
        :param pulumi.Input[builtins.str] account_id: Account ID.
        :param pulumi.Input[builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[builtins.str] jurisdiction: Jurisdiction of the bucket
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if jurisdiction is not None:
            pulumi.set(__self__, "jurisdiction", jurisdiction)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def jurisdiction(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @jurisdiction.setter
    def jurisdiction(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "jurisdiction", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['R2BucketLockRuleArgs']]]]:
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['R2BucketLockRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.type_token("cloudflare:index/r2BucketLock:R2BucketLock")
class R2BucketLock(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 jurisdiction: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['R2BucketLockRuleArgs', 'R2BucketLockRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_r2_bucket_lock = cloudflare.R2BucketLock("example_r2_bucket_lock",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            bucket_name="example-bucket",
            rules=[{
                "id": "Lock all objects for 24 hours",
                "condition": {
                    "max_age_seconds": 100,
                    "type": "Age",
                },
                "enabled": True,
                "prefix": "prefix",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account ID.
        :param pulumi.Input[builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[builtins.str] jurisdiction: Jurisdiction of the bucket
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: R2BucketLockArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_r2_bucket_lock = cloudflare.R2BucketLock("example_r2_bucket_lock",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            bucket_name="example-bucket",
            rules=[{
                "id": "Lock all objects for 24 hours",
                "condition": {
                    "max_age_seconds": 100,
                    "type": "Age",
                },
                "enabled": True,
                "prefix": "prefix",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param R2BucketLockArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(R2BucketLockArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 jurisdiction: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['R2BucketLockRuleArgs', 'R2BucketLockRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = R2BucketLockArgs.__new__(R2BucketLockArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            __props__.__dict__["jurisdiction"] = jurisdiction
            __props__.__dict__["rules"] = rules
        super(R2BucketLock, __self__).__init__(
            'cloudflare:index/r2BucketLock:R2BucketLock',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            bucket_name: Optional[pulumi.Input[builtins.str]] = None,
            jurisdiction: Optional[pulumi.Input[builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['R2BucketLockRuleArgs', 'R2BucketLockRuleArgsDict']]]]] = None) -> 'R2BucketLock':
        """
        Get an existing R2BucketLock resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account ID.
        :param pulumi.Input[builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[builtins.str] jurisdiction: Jurisdiction of the bucket
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _R2BucketLockState.__new__(_R2BucketLockState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["jurisdiction"] = jurisdiction
        __props__.__dict__["rules"] = rules
        return R2BucketLock(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def jurisdiction(self) -> pulumi.Output[builtins.str]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.R2BucketLockRule']]]:
        return pulumi.get(self, "rules")

