# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RegistrarDomainArgs', 'RegistrarDomain']

@pulumi.input_type
class RegistrarDomainArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 domain_name: pulumi.Input[builtins.str],
                 auto_renew: Optional[pulumi.Input[builtins.bool]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 privacy: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a RegistrarDomain resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] domain_name: Domain name.
        :param pulumi.Input[builtins.bool] auto_renew: Auto-renew controls whether subscription is automatically renewed upon domain expiration.
        :param pulumi.Input[builtins.bool] locked: Shows whether a registrar lock is in place for a domain.
        :param pulumi.Input[builtins.bool] privacy: Privacy option controls redacting WHOIS information.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "domain_name", domain_name)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if privacy is not None:
            pulumi.set(__self__, "privacy", privacy)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[builtins.str]:
        """
        Domain name.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Auto-renew controls whether subscription is automatically renewed upon domain expiration.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Shows whether a registrar lock is in place for a domain.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter
    def privacy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Privacy option controls redacting WHOIS information.
        """
        return pulumi.get(self, "privacy")

    @privacy.setter
    def privacy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "privacy", value)


@pulumi.input_type
class _RegistrarDomainState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 privacy: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering RegistrarDomain resources.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.bool] auto_renew: Auto-renew controls whether subscription is automatically renewed upon domain expiration.
        :param pulumi.Input[builtins.str] domain_name: Domain name.
        :param pulumi.Input[builtins.bool] locked: Shows whether a registrar lock is in place for a domain.
        :param pulumi.Input[builtins.bool] privacy: Privacy option controls redacting WHOIS information.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if privacy is not None:
            pulumi.set(__self__, "privacy", privacy)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Auto-renew controls whether subscription is automatically renewed upon domain expiration.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Domain name.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Shows whether a registrar lock is in place for a domain.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter
    def privacy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Privacy option controls redacting WHOIS information.
        """
        return pulumi.get(self, "privacy")

    @privacy.setter
    def privacy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "privacy", value)


@pulumi.type_token("cloudflare:index/registrarDomain:RegistrarDomain")
class RegistrarDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_registrar_domain = cloudflare.RegistrarDomain("example_registrar_domain",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            domain_name="cloudflare.com",
            auto_renew=True,
            locked=False,
            privacy=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.bool] auto_renew: Auto-renew controls whether subscription is automatically renewed upon domain expiration.
        :param pulumi.Input[builtins.str] domain_name: Domain name.
        :param pulumi.Input[builtins.bool] locked: Shows whether a registrar lock is in place for a domain.
        :param pulumi.Input[builtins.bool] privacy: Privacy option controls redacting WHOIS information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistrarDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_registrar_domain = cloudflare.RegistrarDomain("example_registrar_domain",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            domain_name="cloudflare.com",
            auto_renew=True,
            locked=False,
            privacy=True)
        ```

        :param str resource_name: The name of the resource.
        :param RegistrarDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistrarDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 locked: Optional[pulumi.Input[builtins.bool]] = None,
                 privacy: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistrarDomainArgs.__new__(RegistrarDomainArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["auto_renew"] = auto_renew
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["locked"] = locked
            __props__.__dict__["privacy"] = privacy
        super(RegistrarDomain, __self__).__init__(
            'cloudflare:index/registrarDomain:RegistrarDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[builtins.bool]] = None,
            domain_name: Optional[pulumi.Input[builtins.str]] = None,
            locked: Optional[pulumi.Input[builtins.bool]] = None,
            privacy: Optional[pulumi.Input[builtins.bool]] = None) -> 'RegistrarDomain':
        """
        Get an existing RegistrarDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.bool] auto_renew: Auto-renew controls whether subscription is automatically renewed upon domain expiration.
        :param pulumi.Input[builtins.str] domain_name: Domain name.
        :param pulumi.Input[builtins.bool] locked: Shows whether a registrar lock is in place for a domain.
        :param pulumi.Input[builtins.bool] privacy: Privacy option controls redacting WHOIS information.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistrarDomainState.__new__(_RegistrarDomainState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["locked"] = locked
        __props__.__dict__["privacy"] = privacy
        return RegistrarDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Auto-renew controls whether subscription is automatically renewed upon domain expiration.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[builtins.str]:
        """
        Domain name.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def locked(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Shows whether a registrar lock is in place for a domain.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def privacy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Privacy option controls redacting WHOIS information.
        """
        return pulumi.get(self, "privacy")

