# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnippetsArgs', 'Snippets']

@pulumi.input_type
class SnippetsArgs:
    def __init__(__self__, *,
                 snippet_name: pulumi.Input[builtins.str],
                 zone_id: pulumi.Input[builtins.str],
                 files: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['SnippetsMetadataArgs']] = None):
        """
        The set of arguments for constructing a Snippets resource.
        :param pulumi.Input[builtins.str] snippet_name: Snippet identifying name
        :param pulumi.Input[builtins.str] zone_id: Identifier
        :param pulumi.Input[builtins.str] files: Content files of uploaded snippet
        """
        pulumi.set(__self__, "snippet_name", snippet_name)
        pulumi.set(__self__, "zone_id", zone_id)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter(name="snippetName")
    def snippet_name(self) -> pulumi.Input[builtins.str]:
        """
        Snippet identifying name
        """
        return pulumi.get(self, "snippet_name")

    @snippet_name.setter
    def snippet_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "snippet_name", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Content files of uploaded snippet
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['SnippetsMetadataArgs']]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['SnippetsMetadataArgs']]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class _SnippetsState:
    def __init__(__self__, *,
                 created_on: Optional[pulumi.Input[builtins.str]] = None,
                 files: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['SnippetsMetadataArgs']] = None,
                 modified_on: Optional[pulumi.Input[builtins.str]] = None,
                 snippet_name: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Snippets resources.
        :param pulumi.Input[builtins.str] created_on: Creation time of the snippet
        :param pulumi.Input[builtins.str] files: Content files of uploaded snippet
        :param pulumi.Input[builtins.str] modified_on: Modification time of the snippet
        :param pulumi.Input[builtins.str] snippet_name: Snippet identifying name
        :param pulumi.Input[builtins.str] zone_id: Identifier
        """
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if snippet_name is not None:
            pulumi.set(__self__, "snippet_name", snippet_name)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation time of the snippet
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Content files of uploaded snippet
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['SnippetsMetadataArgs']]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['SnippetsMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Modification time of the snippet
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter(name="snippetName")
    def snippet_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Snippet identifying name
        """
        return pulumi.get(self, "snippet_name")

    @snippet_name.setter
    def snippet_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snippet_name", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/snippets:Snippets")
class Snippets(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 files: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['SnippetsMetadataArgs', 'SnippetsMetadataArgsDict']]] = None,
                 snippet_name: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] files: Content files of uploaded snippet
        :param pulumi.Input[builtins.str] snippet_name: Snippet identifying name
        :param pulumi.Input[builtins.str] zone_id: Identifier
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnippetsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param SnippetsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnippetsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 files: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['SnippetsMetadataArgs', 'SnippetsMetadataArgsDict']]] = None,
                 snippet_name: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnippetsArgs.__new__(SnippetsArgs)

            __props__.__dict__["files"] = files
            __props__.__dict__["metadata"] = metadata
            if snippet_name is None and not opts.urn:
                raise TypeError("Missing required property 'snippet_name'")
            __props__.__dict__["snippet_name"] = snippet_name
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        super(Snippets, __self__).__init__(
            'cloudflare:index/snippets:Snippets',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_on: Optional[pulumi.Input[builtins.str]] = None,
            files: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[Union['SnippetsMetadataArgs', 'SnippetsMetadataArgsDict']]] = None,
            modified_on: Optional[pulumi.Input[builtins.str]] = None,
            snippet_name: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Snippets':
        """
        Get an existing Snippets resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_on: Creation time of the snippet
        :param pulumi.Input[builtins.str] files: Content files of uploaded snippet
        :param pulumi.Input[builtins.str] modified_on: Modification time of the snippet
        :param pulumi.Input[builtins.str] snippet_name: Snippet identifying name
        :param pulumi.Input[builtins.str] zone_id: Identifier
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnippetsState.__new__(_SnippetsState)

        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["files"] = files
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["snippet_name"] = snippet_name
        __props__.__dict__["zone_id"] = zone_id
        return Snippets(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[builtins.str]:
        """
        Creation time of the snippet
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def files(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Content files of uploaded snippet
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional['outputs.SnippetsMetadata']]:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[builtins.str]:
        """
        Modification time of the snippet
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter(name="snippetName")
    def snippet_name(self) -> pulumi.Output[builtins.str]:
        """
        Snippet identifying name
        """
        return pulumi.get(self, "snippet_name")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "zone_id")

