# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['StreamWatermarkInitArgs', 'StreamWatermark']

@pulumi.input_type
class StreamWatermarkInitArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 file: pulumi.Input[builtins.str],
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 opacity: Optional[pulumi.Input[builtins.float]] = None,
                 padding: Optional[pulumi.Input[builtins.float]] = None,
                 position: Optional[pulumi.Input[builtins.str]] = None,
                 scale: Optional[pulumi.Input[builtins.float]] = None):
        """
        The set of arguments for constructing a StreamWatermark resource.
        :param pulumi.Input[builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[builtins.str] file: The image file to upload.
        :param pulumi.Input[builtins.str] identifier: The unique identifier for a watermark profile.
        :param pulumi.Input[builtins.str] name: A short description of the watermark profile.
        :param pulumi.Input[builtins.float] opacity: The translucency of the image. A value of `0.0` makes the image completely transparent, and `1.0` makes the image completely opaque. Note that if the image is already semi-transparent, setting this to `1.0` will not make the image completely opaque.
        :param pulumi.Input[builtins.float] padding: The whitespace between the adjacent edges (determined by position) of the video and the image. `0.0` indicates no padding, and `1.0` indicates a fully padded video width or length, as determined by the algorithm.
        :param pulumi.Input[builtins.str] position: The location of the image. Valid positions are: `upperRight`, `upperLeft`, `lowerLeft`, `lowerRight`, and `center`. Note that `center` ignores the `padding` parameter.
        :param pulumi.Input[builtins.float] scale: The size of the image relative to the overall size of the video. This parameter will adapt to horizontal and vertical videos automatically. `0.0` indicates no scaling (use the size of the image as-is), and `1.0`fills the entire video.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "file", file)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opacity is not None:
            pulumi.set(__self__, "opacity", opacity)
        if padding is not None:
            pulumi.set(__self__, "padding", padding)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def file(self) -> pulumi.Input[builtins.str]:
        """
        The image file to upload.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for a watermark profile.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A short description of the watermark profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def opacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The translucency of the image. A value of `0.0` makes the image completely transparent, and `1.0` makes the image completely opaque. Note that if the image is already semi-transparent, setting this to `1.0` will not make the image completely opaque.
        """
        return pulumi.get(self, "opacity")

    @opacity.setter
    def opacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "opacity", value)

    @property
    @pulumi.getter
    def padding(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The whitespace between the adjacent edges (determined by position) of the video and the image. `0.0` indicates no padding, and `1.0` indicates a fully padded video width or length, as determined by the algorithm.
        """
        return pulumi.get(self, "padding")

    @padding.setter
    def padding(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "padding", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the image. Valid positions are: `upperRight`, `upperLeft`, `lowerLeft`, `lowerRight`, and `center`. Note that `center` ignores the `padding` parameter.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The size of the image relative to the overall size of the video. This parameter will adapt to horizontal and vertical videos automatically. `0.0` indicates no scaling (use the size of the image as-is), and `1.0`fills the entire video.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "scale", value)


@pulumi.input_type
class _StreamWatermarkState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 created: Optional[pulumi.Input[builtins.str]] = None,
                 downloaded_from: Optional[pulumi.Input[builtins.str]] = None,
                 file: Optional[pulumi.Input[builtins.str]] = None,
                 height: Optional[pulumi.Input[builtins.int]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 opacity: Optional[pulumi.Input[builtins.float]] = None,
                 padding: Optional[pulumi.Input[builtins.float]] = None,
                 position: Optional[pulumi.Input[builtins.str]] = None,
                 scale: Optional[pulumi.Input[builtins.float]] = None,
                 size: Optional[pulumi.Input[builtins.float]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 width: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering StreamWatermark resources.
        :param pulumi.Input[builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[builtins.str] created: The date and a time a watermark profile was created.
        :param pulumi.Input[builtins.str] downloaded_from: The source URL for a downloaded image. If the watermark profile was created via direct upload, this field is null.
        :param pulumi.Input[builtins.str] file: The image file to upload.
        :param pulumi.Input[builtins.int] height: The height of the image in pixels.
        :param pulumi.Input[builtins.str] identifier: The unique identifier for a watermark profile.
        :param pulumi.Input[builtins.str] name: A short description of the watermark profile.
        :param pulumi.Input[builtins.float] opacity: The translucency of the image. A value of `0.0` makes the image completely transparent, and `1.0` makes the image completely opaque. Note that if the image is already semi-transparent, setting this to `1.0` will not make the image completely opaque.
        :param pulumi.Input[builtins.float] padding: The whitespace between the adjacent edges (determined by position) of the video and the image. `0.0` indicates no padding, and `1.0` indicates a fully padded video width or length, as determined by the algorithm.
        :param pulumi.Input[builtins.str] position: The location of the image. Valid positions are: `upperRight`, `upperLeft`, `lowerLeft`, `lowerRight`, and `center`. Note that `center` ignores the `padding` parameter.
        :param pulumi.Input[builtins.float] scale: The size of the image relative to the overall size of the video. This parameter will adapt to horizontal and vertical videos automatically. `0.0` indicates no scaling (use the size of the image as-is), and `1.0`fills the entire video.
        :param pulumi.Input[builtins.float] size: The size of the image in bytes.
        :param pulumi.Input[builtins.str] uid: The unique identifier for a watermark profile.
        :param pulumi.Input[builtins.int] width: The width of the image in pixels.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if downloaded_from is not None:
            pulumi.set(__self__, "downloaded_from", downloaded_from)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opacity is not None:
            pulumi.set(__self__, "opacity", opacity)
        if padding is not None:
            pulumi.set(__self__, "padding", padding)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and a time a watermark profile was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter(name="downloadedFrom")
    def downloaded_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source URL for a downloaded image. If the watermark profile was created via direct upload, this field is null.
        """
        return pulumi.get(self, "downloaded_from")

    @downloaded_from.setter
    def downloaded_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "downloaded_from", value)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The image file to upload.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The height of the image in pixels.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for a watermark profile.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A short description of the watermark profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def opacity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The translucency of the image. A value of `0.0` makes the image completely transparent, and `1.0` makes the image completely opaque. Note that if the image is already semi-transparent, setting this to `1.0` will not make the image completely opaque.
        """
        return pulumi.get(self, "opacity")

    @opacity.setter
    def opacity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "opacity", value)

    @property
    @pulumi.getter
    def padding(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The whitespace between the adjacent edges (determined by position) of the video and the image. `0.0` indicates no padding, and `1.0` indicates a fully padded video width or length, as determined by the algorithm.
        """
        return pulumi.get(self, "padding")

    @padding.setter
    def padding(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "padding", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the image. Valid positions are: `upperRight`, `upperLeft`, `lowerLeft`, `lowerRight`, and `center`. Note that `center` ignores the `padding` parameter.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The size of the image relative to the overall size of the video. This parameter will adapt to horizontal and vertical videos automatically. `0.0` indicates no scaling (use the size of the image as-is), and `1.0`fills the entire video.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "scale", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The size of the image in bytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for a watermark profile.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The width of the image in pixels.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "width", value)


@pulumi.type_token("cloudflare:index/streamWatermark:StreamWatermark")
class StreamWatermark(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 file: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 opacity: Optional[pulumi.Input[builtins.float]] = None,
                 padding: Optional[pulumi.Input[builtins.float]] = None,
                 position: Optional[pulumi.Input[builtins.str]] = None,
                 scale: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_stream_watermark = cloudflare.StreamWatermark("example_stream_watermark",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            file="@/Users/rchen/Downloads/watermark.png",
            name="Marketing Videos",
            opacity=0.75,
            padding=0.1,
            position="center",
            scale=0.1)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[builtins.str] file: The image file to upload.
        :param pulumi.Input[builtins.str] identifier: The unique identifier for a watermark profile.
        :param pulumi.Input[builtins.str] name: A short description of the watermark profile.
        :param pulumi.Input[builtins.float] opacity: The translucency of the image. A value of `0.0` makes the image completely transparent, and `1.0` makes the image completely opaque. Note that if the image is already semi-transparent, setting this to `1.0` will not make the image completely opaque.
        :param pulumi.Input[builtins.float] padding: The whitespace between the adjacent edges (determined by position) of the video and the image. `0.0` indicates no padding, and `1.0` indicates a fully padded video width or length, as determined by the algorithm.
        :param pulumi.Input[builtins.str] position: The location of the image. Valid positions are: `upperRight`, `upperLeft`, `lowerLeft`, `lowerRight`, and `center`. Note that `center` ignores the `padding` parameter.
        :param pulumi.Input[builtins.float] scale: The size of the image relative to the overall size of the video. This parameter will adapt to horizontal and vertical videos automatically. `0.0` indicates no scaling (use the size of the image as-is), and `1.0`fills the entire video.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamWatermarkInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_stream_watermark = cloudflare.StreamWatermark("example_stream_watermark",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            file="@/Users/rchen/Downloads/watermark.png",
            name="Marketing Videos",
            opacity=0.75,
            padding=0.1,
            position="center",
            scale=0.1)
        ```

        :param str resource_name: The name of the resource.
        :param StreamWatermarkInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamWatermarkInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 file: Optional[pulumi.Input[builtins.str]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 opacity: Optional[pulumi.Input[builtins.float]] = None,
                 padding: Optional[pulumi.Input[builtins.float]] = None,
                 position: Optional[pulumi.Input[builtins.str]] = None,
                 scale: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamWatermarkInitArgs.__new__(StreamWatermarkInitArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if file is None and not opts.urn:
                raise TypeError("Missing required property 'file'")
            __props__.__dict__["file"] = file
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["name"] = name
            __props__.__dict__["opacity"] = opacity
            __props__.__dict__["padding"] = padding
            __props__.__dict__["position"] = position
            __props__.__dict__["scale"] = scale
            __props__.__dict__["created"] = None
            __props__.__dict__["downloaded_from"] = None
            __props__.__dict__["height"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["width"] = None
        super(StreamWatermark, __self__).__init__(
            'cloudflare:index/streamWatermark:StreamWatermark',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            created: Optional[pulumi.Input[builtins.str]] = None,
            downloaded_from: Optional[pulumi.Input[builtins.str]] = None,
            file: Optional[pulumi.Input[builtins.str]] = None,
            height: Optional[pulumi.Input[builtins.int]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            opacity: Optional[pulumi.Input[builtins.float]] = None,
            padding: Optional[pulumi.Input[builtins.float]] = None,
            position: Optional[pulumi.Input[builtins.str]] = None,
            scale: Optional[pulumi.Input[builtins.float]] = None,
            size: Optional[pulumi.Input[builtins.float]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            width: Optional[pulumi.Input[builtins.int]] = None) -> 'StreamWatermark':
        """
        Get an existing StreamWatermark resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[builtins.str] created: The date and a time a watermark profile was created.
        :param pulumi.Input[builtins.str] downloaded_from: The source URL for a downloaded image. If the watermark profile was created via direct upload, this field is null.
        :param pulumi.Input[builtins.str] file: The image file to upload.
        :param pulumi.Input[builtins.int] height: The height of the image in pixels.
        :param pulumi.Input[builtins.str] identifier: The unique identifier for a watermark profile.
        :param pulumi.Input[builtins.str] name: A short description of the watermark profile.
        :param pulumi.Input[builtins.float] opacity: The translucency of the image. A value of `0.0` makes the image completely transparent, and `1.0` makes the image completely opaque. Note that if the image is already semi-transparent, setting this to `1.0` will not make the image completely opaque.
        :param pulumi.Input[builtins.float] padding: The whitespace between the adjacent edges (determined by position) of the video and the image. `0.0` indicates no padding, and `1.0` indicates a fully padded video width or length, as determined by the algorithm.
        :param pulumi.Input[builtins.str] position: The location of the image. Valid positions are: `upperRight`, `upperLeft`, `lowerLeft`, `lowerRight`, and `center`. Note that `center` ignores the `padding` parameter.
        :param pulumi.Input[builtins.float] scale: The size of the image relative to the overall size of the video. This parameter will adapt to horizontal and vertical videos automatically. `0.0` indicates no scaling (use the size of the image as-is), and `1.0`fills the entire video.
        :param pulumi.Input[builtins.float] size: The size of the image in bytes.
        :param pulumi.Input[builtins.str] uid: The unique identifier for a watermark profile.
        :param pulumi.Input[builtins.int] width: The width of the image in pixels.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamWatermarkState.__new__(_StreamWatermarkState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["created"] = created
        __props__.__dict__["downloaded_from"] = downloaded_from
        __props__.__dict__["file"] = file
        __props__.__dict__["height"] = height
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["name"] = name
        __props__.__dict__["opacity"] = opacity
        __props__.__dict__["padding"] = padding
        __props__.__dict__["position"] = position
        __props__.__dict__["scale"] = scale
        __props__.__dict__["size"] = size
        __props__.__dict__["uid"] = uid
        __props__.__dict__["width"] = width
        return StreamWatermark(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[builtins.str]:
        """
        The date and a time a watermark profile was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="downloadedFrom")
    def downloaded_from(self) -> pulumi.Output[builtins.str]:
        """
        The source URL for a downloaded image. If the watermark profile was created via direct upload, this field is null.
        """
        return pulumi.get(self, "downloaded_from")

    @property
    @pulumi.getter
    def file(self) -> pulumi.Output[builtins.str]:
        """
        The image file to upload.
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def height(self) -> pulumi.Output[builtins.int]:
        """
        The height of the image in pixels.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The unique identifier for a watermark profile.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A short description of the watermark profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def opacity(self) -> pulumi.Output[builtins.float]:
        """
        The translucency of the image. A value of `0.0` makes the image completely transparent, and `1.0` makes the image completely opaque. Note that if the image is already semi-transparent, setting this to `1.0` will not make the image completely opaque.
        """
        return pulumi.get(self, "opacity")

    @property
    @pulumi.getter
    def padding(self) -> pulumi.Output[builtins.float]:
        """
        The whitespace between the adjacent edges (determined by position) of the video and the image. `0.0` indicates no padding, and `1.0` indicates a fully padded video width or length, as determined by the algorithm.
        """
        return pulumi.get(self, "padding")

    @property
    @pulumi.getter
    def position(self) -> pulumi.Output[builtins.str]:
        """
        The location of the image. Valid positions are: `upperRight`, `upperLeft`, `lowerLeft`, `lowerRight`, and `center`. Note that `center` ignores the `padding` parameter.
        """
        return pulumi.get(self, "position")

    @property
    @pulumi.getter
    def scale(self) -> pulumi.Output[builtins.float]:
        """
        The size of the image relative to the overall size of the video. This parameter will adapt to horizontal and vertical videos automatically. `0.0` indicates no scaling (use the size of the image as-is), and `1.0`fills the entire video.
        """
        return pulumi.get(self, "scale")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[builtins.float]:
        """
        The size of the image in bytes.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for a watermark profile.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def width(self) -> pulumi.Output[builtins.int]:
        """
        The width of the image in pixels.
        """
        return pulumi.get(self, "width")

