# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 telephone: Optional[pulumi.Input[builtins.str]] = None,
                 zipcode: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[builtins.str] country: The country in which the user lives.
        :param pulumi.Input[builtins.str] first_name: User's first name
        :param pulumi.Input[builtins.str] last_name: User's last name
        :param pulumi.Input[builtins.str] telephone: User's telephone number
        :param pulumi.Input[builtins.str] zipcode: The zipcode or postal code where the user lives.
        """
        if country is not None:
            pulumi.set(__self__, "country", country)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if telephone is not None:
            pulumi.set(__self__, "telephone", telephone)
        if zipcode is not None:
            pulumi.set(__self__, "zipcode", zipcode)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The country in which the user lives.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User's first name
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User's last name
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def telephone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User's telephone number
        """
        return pulumi.get(self, "telephone")

    @telephone.setter
    def telephone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "telephone", value)

    @property
    @pulumi.getter
    def zipcode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zipcode or postal code where the user lives.
        """
        return pulumi.get(self, "zipcode")

    @zipcode.setter
    def zipcode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zipcode", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 betas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 has_business_zones: Optional[pulumi.Input[builtins.bool]] = None,
                 has_enterprise_zones: Optional[pulumi.Input[builtins.bool]] = None,
                 has_pro_zones: Optional[pulumi.Input[builtins.bool]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 organizations: Optional[pulumi.Input[Sequence[pulumi.Input['UserOrganizationArgs']]]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None,
                 telephone: Optional[pulumi.Input[builtins.str]] = None,
                 two_factor_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 two_factor_authentication_locked: Optional[pulumi.Input[builtins.bool]] = None,
                 zipcode: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] betas: Lists the betas that the user is participating in.
        :param pulumi.Input[builtins.str] country: The country in which the user lives.
        :param pulumi.Input[builtins.str] first_name: User's first name
        :param pulumi.Input[builtins.bool] has_business_zones: Indicates whether user has any business zones
        :param pulumi.Input[builtins.bool] has_enterprise_zones: Indicates whether user has any enterprise zones
        :param pulumi.Input[builtins.bool] has_pro_zones: Indicates whether user has any pro zones
        :param pulumi.Input[builtins.str] last_name: User's last name
        :param pulumi.Input[builtins.bool] suspended: Indicates whether user has been suspended
        :param pulumi.Input[builtins.str] telephone: User's telephone number
        :param pulumi.Input[builtins.bool] two_factor_authentication_enabled: Indicates whether two-factor authentication is enabled for the user account. Does not apply to API authentication.
        :param pulumi.Input[builtins.bool] two_factor_authentication_locked: Indicates whether two-factor authentication is required by one of the accounts that the user is a member of.
        :param pulumi.Input[builtins.str] zipcode: The zipcode or postal code where the user lives.
        """
        if betas is not None:
            pulumi.set(__self__, "betas", betas)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if has_business_zones is not None:
            pulumi.set(__self__, "has_business_zones", has_business_zones)
        if has_enterprise_zones is not None:
            pulumi.set(__self__, "has_enterprise_zones", has_enterprise_zones)
        if has_pro_zones is not None:
            pulumi.set(__self__, "has_pro_zones", has_pro_zones)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if organizations is not None:
            pulumi.set(__self__, "organizations", organizations)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if telephone is not None:
            pulumi.set(__self__, "telephone", telephone)
        if two_factor_authentication_enabled is not None:
            pulumi.set(__self__, "two_factor_authentication_enabled", two_factor_authentication_enabled)
        if two_factor_authentication_locked is not None:
            pulumi.set(__self__, "two_factor_authentication_locked", two_factor_authentication_locked)
        if zipcode is not None:
            pulumi.set(__self__, "zipcode", zipcode)

    @property
    @pulumi.getter
    def betas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Lists the betas that the user is participating in.
        """
        return pulumi.get(self, "betas")

    @betas.setter
    def betas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "betas", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The country in which the user lives.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User's first name
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="hasBusinessZones")
    def has_business_zones(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether user has any business zones
        """
        return pulumi.get(self, "has_business_zones")

    @has_business_zones.setter
    def has_business_zones(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "has_business_zones", value)

    @property
    @pulumi.getter(name="hasEnterpriseZones")
    def has_enterprise_zones(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether user has any enterprise zones
        """
        return pulumi.get(self, "has_enterprise_zones")

    @has_enterprise_zones.setter
    def has_enterprise_zones(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "has_enterprise_zones", value)

    @property
    @pulumi.getter(name="hasProZones")
    def has_pro_zones(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether user has any pro zones
        """
        return pulumi.get(self, "has_pro_zones")

    @has_pro_zones.setter
    def has_pro_zones(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "has_pro_zones", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User's last name
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def organizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserOrganizationArgs']]]]:
        return pulumi.get(self, "organizations")

    @organizations.setter
    def organizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserOrganizationArgs']]]]):
        pulumi.set(self, "organizations", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether user has been suspended
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @property
    @pulumi.getter
    def telephone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User's telephone number
        """
        return pulumi.get(self, "telephone")

    @telephone.setter
    def telephone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "telephone", value)

    @property
    @pulumi.getter(name="twoFactorAuthenticationEnabled")
    def two_factor_authentication_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether two-factor authentication is enabled for the user account. Does not apply to API authentication.
        """
        return pulumi.get(self, "two_factor_authentication_enabled")

    @two_factor_authentication_enabled.setter
    def two_factor_authentication_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "two_factor_authentication_enabled", value)

    @property
    @pulumi.getter(name="twoFactorAuthenticationLocked")
    def two_factor_authentication_locked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether two-factor authentication is required by one of the accounts that the user is a member of.
        """
        return pulumi.get(self, "two_factor_authentication_locked")

    @two_factor_authentication_locked.setter
    def two_factor_authentication_locked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "two_factor_authentication_locked", value)

    @property
    @pulumi.getter
    def zipcode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zipcode or postal code where the user lives.
        """
        return pulumi.get(self, "zipcode")

    @zipcode.setter
    def zipcode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zipcode", value)


@pulumi.type_token("cloudflare:index/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 telephone: Optional[pulumi.Input[builtins.str]] = None,
                 zipcode: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_user = cloudflare.User("example_user",
            country="US",
            first_name="John",
            last_name="Appleseed",
            telephone="+1 123-123-1234",
            zipcode="12345")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] country: The country in which the user lives.
        :param pulumi.Input[builtins.str] first_name: User's first name
        :param pulumi.Input[builtins.str] last_name: User's last name
        :param pulumi.Input[builtins.str] telephone: User's telephone number
        :param pulumi.Input[builtins.str] zipcode: The zipcode or postal code where the user lives.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[UserArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_user = cloudflare.User("example_user",
            country="US",
            first_name="John",
            last_name="Appleseed",
            telephone="+1 123-123-1234",
            zipcode="12345")
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 telephone: Optional[pulumi.Input[builtins.str]] = None,
                 zipcode: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["country"] = country
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["telephone"] = telephone
            __props__.__dict__["zipcode"] = zipcode
            __props__.__dict__["betas"] = None
            __props__.__dict__["has_business_zones"] = None
            __props__.__dict__["has_enterprise_zones"] = None
            __props__.__dict__["has_pro_zones"] = None
            __props__.__dict__["organizations"] = None
            __props__.__dict__["suspended"] = None
            __props__.__dict__["two_factor_authentication_enabled"] = None
            __props__.__dict__["two_factor_authentication_locked"] = None
        super(User, __self__).__init__(
            'cloudflare:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            betas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            country: Optional[pulumi.Input[builtins.str]] = None,
            first_name: Optional[pulumi.Input[builtins.str]] = None,
            has_business_zones: Optional[pulumi.Input[builtins.bool]] = None,
            has_enterprise_zones: Optional[pulumi.Input[builtins.bool]] = None,
            has_pro_zones: Optional[pulumi.Input[builtins.bool]] = None,
            last_name: Optional[pulumi.Input[builtins.str]] = None,
            organizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserOrganizationArgs', 'UserOrganizationArgsDict']]]]] = None,
            suspended: Optional[pulumi.Input[builtins.bool]] = None,
            telephone: Optional[pulumi.Input[builtins.str]] = None,
            two_factor_authentication_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            two_factor_authentication_locked: Optional[pulumi.Input[builtins.bool]] = None,
            zipcode: Optional[pulumi.Input[builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] betas: Lists the betas that the user is participating in.
        :param pulumi.Input[builtins.str] country: The country in which the user lives.
        :param pulumi.Input[builtins.str] first_name: User's first name
        :param pulumi.Input[builtins.bool] has_business_zones: Indicates whether user has any business zones
        :param pulumi.Input[builtins.bool] has_enterprise_zones: Indicates whether user has any enterprise zones
        :param pulumi.Input[builtins.bool] has_pro_zones: Indicates whether user has any pro zones
        :param pulumi.Input[builtins.str] last_name: User's last name
        :param pulumi.Input[builtins.bool] suspended: Indicates whether user has been suspended
        :param pulumi.Input[builtins.str] telephone: User's telephone number
        :param pulumi.Input[builtins.bool] two_factor_authentication_enabled: Indicates whether two-factor authentication is enabled for the user account. Does not apply to API authentication.
        :param pulumi.Input[builtins.bool] two_factor_authentication_locked: Indicates whether two-factor authentication is required by one of the accounts that the user is a member of.
        :param pulumi.Input[builtins.str] zipcode: The zipcode or postal code where the user lives.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["betas"] = betas
        __props__.__dict__["country"] = country
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["has_business_zones"] = has_business_zones
        __props__.__dict__["has_enterprise_zones"] = has_enterprise_zones
        __props__.__dict__["has_pro_zones"] = has_pro_zones
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["organizations"] = organizations
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["telephone"] = telephone
        __props__.__dict__["two_factor_authentication_enabled"] = two_factor_authentication_enabled
        __props__.__dict__["two_factor_authentication_locked"] = two_factor_authentication_locked
        __props__.__dict__["zipcode"] = zipcode
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def betas(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Lists the betas that the user is participating in.
        """
        return pulumi.get(self, "betas")

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The country in which the user lives.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User's first name
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="hasBusinessZones")
    def has_business_zones(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether user has any business zones
        """
        return pulumi.get(self, "has_business_zones")

    @property
    @pulumi.getter(name="hasEnterpriseZones")
    def has_enterprise_zones(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether user has any enterprise zones
        """
        return pulumi.get(self, "has_enterprise_zones")

    @property
    @pulumi.getter(name="hasProZones")
    def has_pro_zones(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether user has any pro zones
        """
        return pulumi.get(self, "has_pro_zones")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User's last name
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def organizations(self) -> pulumi.Output[Sequence['outputs.UserOrganization']]:
        return pulumi.get(self, "organizations")

    @property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether user has been suspended
        """
        return pulumi.get(self, "suspended")

    @property
    @pulumi.getter
    def telephone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User's telephone number
        """
        return pulumi.get(self, "telephone")

    @property
    @pulumi.getter(name="twoFactorAuthenticationEnabled")
    def two_factor_authentication_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether two-factor authentication is enabled for the user account. Does not apply to API authentication.
        """
        return pulumi.get(self, "two_factor_authentication_enabled")

    @property
    @pulumi.getter(name="twoFactorAuthenticationLocked")
    def two_factor_authentication_locked(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether two-factor authentication is required by one of the accounts that the user is a member of.
        """
        return pulumi.get(self, "two_factor_authentication_locked")

    @property
    @pulumi.getter
    def zipcode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The zipcode or postal code where the user lives.
        """
        return pulumi.get(self, "zipcode")

