# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WaitingRoomEventArgs', 'WaitingRoomEvent']

@pulumi.input_type
class WaitingRoomEventArgs:
    def __init__(__self__, *,
                 event_end_time: pulumi.Input[builtins.str],
                 event_start_time: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 waiting_room_id: pulumi.Input[builtins.str],
                 zone_id: pulumi.Input[builtins.str],
                 custom_page_html: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[builtins.bool]] = None,
                 new_users_per_minute: Optional[pulumi.Input[builtins.int]] = None,
                 prequeue_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 queueing_method: Optional[pulumi.Input[builtins.str]] = None,
                 session_duration: Optional[pulumi.Input[builtins.int]] = None,
                 shuffle_at_event_start: Optional[pulumi.Input[builtins.bool]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None,
                 total_active_users: Optional[pulumi.Input[builtins.int]] = None,
                 turnstile_action: Optional[pulumi.Input[builtins.str]] = None,
                 turnstile_mode: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a WaitingRoomEvent resource.
        :param pulumi.Input[builtins.str] event_end_time: An ISO 8601 timestamp that marks the end of the event.
        :param pulumi.Input[builtins.str] event_start_time: An ISO 8601 timestamp that marks the start of the event. At this time, queued users will be processed with the event's configuration. The start time must be at least one minute before `event_end_time`.
        :param pulumi.Input[builtins.str] name: A unique name to identify the event. Only alphanumeric characters, hyphens and underscores are allowed.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        :param pulumi.Input[builtins.str] custom_page_html: If set, the event will override the waiting room's `custom_page_html` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.str] description: A note that you can use to add more details about the event.
        :param pulumi.Input[builtins.bool] disable_session_renewal: If set, the event will override the waiting room's `disable_session_renewal` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.int] new_users_per_minute: If set, the event will override the waiting room's `new_users_per_minute` property while it is active. If null, the event will inherit it. This can only be set if the event's `total_active_users` property is also set.
        :param pulumi.Input[builtins.str] prequeue_start_time: An ISO 8601 timestamp that marks when to begin queueing all users before the event starts. The prequeue must start at least five minutes before `event_start_time`.
        :param pulumi.Input[builtins.str] queueing_method: If set, the event will override the waiting room's `queueing_method` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.int] session_duration: If set, the event will override the waiting room's `session_duration` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.bool] shuffle_at_event_start: If enabled, users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. This is useful for situations when many users will join the event prequeue at the same time and you want to shuffle them to ensure fairness. Naturally, it makes the most sense to enable this feature when the `queueing_method` during the event respects ordering such as **fifo**, or else the shuffling may be unnecessary.
        :param pulumi.Input[builtins.bool] suspended: Suspends or allows an event. If set to `true`, the event is ignored and traffic will be handled based on the waiting room configuration.
        :param pulumi.Input[builtins.int] total_active_users: If set, the event will override the waiting room's `total_active_users` property while it is active. If null, the event will inherit it. This can only be set if the event's `new_users_per_minute` property is also set.
        :param pulumi.Input[builtins.str] turnstile_action: If set, the event will override the waiting room's `turnstile_action` property while it is active. If null, the event will inherit it.
               Available values: "log", "infinite_queue".
        :param pulumi.Input[builtins.str] turnstile_mode: If set, the event will override the waiting room's `turnstile_mode` property while it is active. If null, the event will inherit it.
               Available values: "off", "invisible", "visible*non*interactive", "visible_managed".
        """
        pulumi.set(__self__, "event_end_time", event_end_time)
        pulumi.set(__self__, "event_start_time", event_start_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "waiting_room_id", waiting_room_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if custom_page_html is not None:
            pulumi.set(__self__, "custom_page_html", custom_page_html)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_session_renewal is not None:
            pulumi.set(__self__, "disable_session_renewal", disable_session_renewal)
        if new_users_per_minute is not None:
            pulumi.set(__self__, "new_users_per_minute", new_users_per_minute)
        if prequeue_start_time is not None:
            pulumi.set(__self__, "prequeue_start_time", prequeue_start_time)
        if queueing_method is not None:
            pulumi.set(__self__, "queueing_method", queueing_method)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if shuffle_at_event_start is not None:
            pulumi.set(__self__, "shuffle_at_event_start", shuffle_at_event_start)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if total_active_users is not None:
            pulumi.set(__self__, "total_active_users", total_active_users)
        if turnstile_action is not None:
            pulumi.set(__self__, "turnstile_action", turnstile_action)
        if turnstile_mode is not None:
            pulumi.set(__self__, "turnstile_mode", turnstile_mode)

    @property
    @pulumi.getter(name="eventEndTime")
    def event_end_time(self) -> pulumi.Input[builtins.str]:
        """
        An ISO 8601 timestamp that marks the end of the event.
        """
        return pulumi.get(self, "event_end_time")

    @event_end_time.setter
    def event_end_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "event_end_time", value)

    @property
    @pulumi.getter(name="eventStartTime")
    def event_start_time(self) -> pulumi.Input[builtins.str]:
        """
        An ISO 8601 timestamp that marks the start of the event. At this time, queued users will be processed with the event's configuration. The start time must be at least one minute before `event_end_time`.
        """
        return pulumi.get(self, "event_start_time")

    @event_start_time.setter
    def event_start_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "event_start_time", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        A unique name to identify the event. Only alphanumeric characters, hyphens and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "waiting_room_id")

    @waiting_room_id.setter
    def waiting_room_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "waiting_room_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If set, the event will override the waiting room's `custom_page_html` property while it is active. If null, the event will inherit it.
        """
        return pulumi.get(self, "custom_page_html")

    @custom_page_html.setter
    def custom_page_html(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_page_html", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A note that you can use to add more details about the event.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set, the event will override the waiting room's `disable_session_renewal` property while it is active. If null, the event will inherit it.
        """
        return pulumi.get(self, "disable_session_renewal")

    @disable_session_renewal.setter
    def disable_session_renewal(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_session_renewal", value)

    @property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If set, the event will override the waiting room's `new_users_per_minute` property while it is active. If null, the event will inherit it. This can only be set if the event's `total_active_users` property is also set.
        """
        return pulumi.get(self, "new_users_per_minute")

    @new_users_per_minute.setter
    def new_users_per_minute(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "new_users_per_minute", value)

    @property
    @pulumi.getter(name="prequeueStartTime")
    def prequeue_start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An ISO 8601 timestamp that marks when to begin queueing all users before the event starts. The prequeue must start at least five minutes before `event_start_time`.
        """
        return pulumi.get(self, "prequeue_start_time")

    @prequeue_start_time.setter
    def prequeue_start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prequeue_start_time", value)

    @property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If set, the event will override the waiting room's `queueing_method` property while it is active. If null, the event will inherit it.
        """
        return pulumi.get(self, "queueing_method")

    @queueing_method.setter
    def queueing_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "queueing_method", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If set, the event will override the waiting room's `session_duration` property while it is active. If null, the event will inherit it.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter(name="shuffleAtEventStart")
    def shuffle_at_event_start(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. This is useful for situations when many users will join the event prequeue at the same time and you want to shuffle them to ensure fairness. Naturally, it makes the most sense to enable this feature when the `queueing_method` during the event respects ordering such as **fifo**, or else the shuffling may be unnecessary.
        """
        return pulumi.get(self, "shuffle_at_event_start")

    @shuffle_at_event_start.setter
    def shuffle_at_event_start(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shuffle_at_event_start", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Suspends or allows an event. If set to `true`, the event is ignored and traffic will be handled based on the waiting room configuration.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If set, the event will override the waiting room's `total_active_users` property while it is active. If null, the event will inherit it. This can only be set if the event's `new_users_per_minute` property is also set.
        """
        return pulumi.get(self, "total_active_users")

    @total_active_users.setter
    def total_active_users(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_active_users", value)

    @property
    @pulumi.getter(name="turnstileAction")
    def turnstile_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If set, the event will override the waiting room's `turnstile_action` property while it is active. If null, the event will inherit it.
        Available values: "log", "infinite_queue".
        """
        return pulumi.get(self, "turnstile_action")

    @turnstile_action.setter
    def turnstile_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "turnstile_action", value)

    @property
    @pulumi.getter(name="turnstileMode")
    def turnstile_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If set, the event will override the waiting room's `turnstile_mode` property while it is active. If null, the event will inherit it.
        Available values: "off", "invisible", "visible*non*interactive", "visible_managed".
        """
        return pulumi.get(self, "turnstile_mode")

    @turnstile_mode.setter
    def turnstile_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "turnstile_mode", value)


@pulumi.input_type
class _WaitingRoomEventState:
    def __init__(__self__, *,
                 created_on: Optional[pulumi.Input[builtins.str]] = None,
                 custom_page_html: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[builtins.bool]] = None,
                 event_end_time: Optional[pulumi.Input[builtins.str]] = None,
                 event_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[builtins.int]] = None,
                 prequeue_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 queueing_method: Optional[pulumi.Input[builtins.str]] = None,
                 session_duration: Optional[pulumi.Input[builtins.int]] = None,
                 shuffle_at_event_start: Optional[pulumi.Input[builtins.bool]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None,
                 total_active_users: Optional[pulumi.Input[builtins.int]] = None,
                 turnstile_action: Optional[pulumi.Input[builtins.str]] = None,
                 turnstile_mode: Optional[pulumi.Input[builtins.str]] = None,
                 waiting_room_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WaitingRoomEvent resources.
        :param pulumi.Input[builtins.str] custom_page_html: If set, the event will override the waiting room's `custom_page_html` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.str] description: A note that you can use to add more details about the event.
        :param pulumi.Input[builtins.bool] disable_session_renewal: If set, the event will override the waiting room's `disable_session_renewal` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.str] event_end_time: An ISO 8601 timestamp that marks the end of the event.
        :param pulumi.Input[builtins.str] event_start_time: An ISO 8601 timestamp that marks the start of the event. At this time, queued users will be processed with the event's configuration. The start time must be at least one minute before `event_end_time`.
        :param pulumi.Input[builtins.str] name: A unique name to identify the event. Only alphanumeric characters, hyphens and underscores are allowed.
        :param pulumi.Input[builtins.int] new_users_per_minute: If set, the event will override the waiting room's `new_users_per_minute` property while it is active. If null, the event will inherit it. This can only be set if the event's `total_active_users` property is also set.
        :param pulumi.Input[builtins.str] prequeue_start_time: An ISO 8601 timestamp that marks when to begin queueing all users before the event starts. The prequeue must start at least five minutes before `event_start_time`.
        :param pulumi.Input[builtins.str] queueing_method: If set, the event will override the waiting room's `queueing_method` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.int] session_duration: If set, the event will override the waiting room's `session_duration` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.bool] shuffle_at_event_start: If enabled, users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. This is useful for situations when many users will join the event prequeue at the same time and you want to shuffle them to ensure fairness. Naturally, it makes the most sense to enable this feature when the `queueing_method` during the event respects ordering such as **fifo**, or else the shuffling may be unnecessary.
        :param pulumi.Input[builtins.bool] suspended: Suspends or allows an event. If set to `true`, the event is ignored and traffic will be handled based on the waiting room configuration.
        :param pulumi.Input[builtins.int] total_active_users: If set, the event will override the waiting room's `total_active_users` property while it is active. If null, the event will inherit it. This can only be set if the event's `new_users_per_minute` property is also set.
        :param pulumi.Input[builtins.str] turnstile_action: If set, the event will override the waiting room's `turnstile_action` property while it is active. If null, the event will inherit it.
               Available values: "log", "infinite_queue".
        :param pulumi.Input[builtins.str] turnstile_mode: If set, the event will override the waiting room's `turnstile_mode` property while it is active. If null, the event will inherit it.
               Available values: "off", "invisible", "visible*non*interactive", "visible_managed".
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if custom_page_html is not None:
            pulumi.set(__self__, "custom_page_html", custom_page_html)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_session_renewal is not None:
            pulumi.set(__self__, "disable_session_renewal", disable_session_renewal)
        if event_end_time is not None:
            pulumi.set(__self__, "event_end_time", event_end_time)
        if event_start_time is not None:
            pulumi.set(__self__, "event_start_time", event_start_time)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_users_per_minute is not None:
            pulumi.set(__self__, "new_users_per_minute", new_users_per_minute)
        if prequeue_start_time is not None:
            pulumi.set(__self__, "prequeue_start_time", prequeue_start_time)
        if queueing_method is not None:
            pulumi.set(__self__, "queueing_method", queueing_method)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if shuffle_at_event_start is not None:
            pulumi.set(__self__, "shuffle_at_event_start", shuffle_at_event_start)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if total_active_users is not None:
            pulumi.set(__self__, "total_active_users", total_active_users)
        if turnstile_action is not None:
            pulumi.set(__self__, "turnstile_action", turnstile_action)
        if turnstile_mode is not None:
            pulumi.set(__self__, "turnstile_mode", turnstile_mode)
        if waiting_room_id is not None:
            pulumi.set(__self__, "waiting_room_id", waiting_room_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If set, the event will override the waiting room's `custom_page_html` property while it is active. If null, the event will inherit it.
        """
        return pulumi.get(self, "custom_page_html")

    @custom_page_html.setter
    def custom_page_html(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_page_html", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A note that you can use to add more details about the event.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set, the event will override the waiting room's `disable_session_renewal` property while it is active. If null, the event will inherit it.
        """
        return pulumi.get(self, "disable_session_renewal")

    @disable_session_renewal.setter
    def disable_session_renewal(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_session_renewal", value)

    @property
    @pulumi.getter(name="eventEndTime")
    def event_end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An ISO 8601 timestamp that marks the end of the event.
        """
        return pulumi.get(self, "event_end_time")

    @event_end_time.setter
    def event_end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_end_time", value)

    @property
    @pulumi.getter(name="eventStartTime")
    def event_start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An ISO 8601 timestamp that marks the start of the event. At this time, queued users will be processed with the event's configuration. The start time must be at least one minute before `event_end_time`.
        """
        return pulumi.get(self, "event_start_time")

    @event_start_time.setter
    def event_start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_start_time", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name to identify the event. Only alphanumeric characters, hyphens and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If set, the event will override the waiting room's `new_users_per_minute` property while it is active. If null, the event will inherit it. This can only be set if the event's `total_active_users` property is also set.
        """
        return pulumi.get(self, "new_users_per_minute")

    @new_users_per_minute.setter
    def new_users_per_minute(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "new_users_per_minute", value)

    @property
    @pulumi.getter(name="prequeueStartTime")
    def prequeue_start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An ISO 8601 timestamp that marks when to begin queueing all users before the event starts. The prequeue must start at least five minutes before `event_start_time`.
        """
        return pulumi.get(self, "prequeue_start_time")

    @prequeue_start_time.setter
    def prequeue_start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prequeue_start_time", value)

    @property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If set, the event will override the waiting room's `queueing_method` property while it is active. If null, the event will inherit it.
        """
        return pulumi.get(self, "queueing_method")

    @queueing_method.setter
    def queueing_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "queueing_method", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If set, the event will override the waiting room's `session_duration` property while it is active. If null, the event will inherit it.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter(name="shuffleAtEventStart")
    def shuffle_at_event_start(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If enabled, users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. This is useful for situations when many users will join the event prequeue at the same time and you want to shuffle them to ensure fairness. Naturally, it makes the most sense to enable this feature when the `queueing_method` during the event respects ordering such as **fifo**, or else the shuffling may be unnecessary.
        """
        return pulumi.get(self, "shuffle_at_event_start")

    @shuffle_at_event_start.setter
    def shuffle_at_event_start(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shuffle_at_event_start", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Suspends or allows an event. If set to `true`, the event is ignored and traffic will be handled based on the waiting room configuration.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If set, the event will override the waiting room's `total_active_users` property while it is active. If null, the event will inherit it. This can only be set if the event's `new_users_per_minute` property is also set.
        """
        return pulumi.get(self, "total_active_users")

    @total_active_users.setter
    def total_active_users(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_active_users", value)

    @property
    @pulumi.getter(name="turnstileAction")
    def turnstile_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If set, the event will override the waiting room's `turnstile_action` property while it is active. If null, the event will inherit it.
        Available values: "log", "infinite_queue".
        """
        return pulumi.get(self, "turnstile_action")

    @turnstile_action.setter
    def turnstile_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "turnstile_action", value)

    @property
    @pulumi.getter(name="turnstileMode")
    def turnstile_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If set, the event will override the waiting room's `turnstile_mode` property while it is active. If null, the event will inherit it.
        Available values: "off", "invisible", "visible*non*interactive", "visible_managed".
        """
        return pulumi.get(self, "turnstile_mode")

    @turnstile_mode.setter
    def turnstile_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "turnstile_mode", value)

    @property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "waiting_room_id")

    @waiting_room_id.setter
    def waiting_room_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "waiting_room_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/waitingRoomEvent:WaitingRoomEvent")
class WaitingRoomEvent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_page_html: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[builtins.bool]] = None,
                 event_end_time: Optional[pulumi.Input[builtins.str]] = None,
                 event_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[builtins.int]] = None,
                 prequeue_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 queueing_method: Optional[pulumi.Input[builtins.str]] = None,
                 session_duration: Optional[pulumi.Input[builtins.int]] = None,
                 shuffle_at_event_start: Optional[pulumi.Input[builtins.bool]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None,
                 total_active_users: Optional[pulumi.Input[builtins.int]] = None,
                 turnstile_action: Optional[pulumi.Input[builtins.str]] = None,
                 turnstile_mode: Optional[pulumi.Input[builtins.str]] = None,
                 waiting_room_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_waiting_room_event = cloudflare.WaitingRoomEvent("example_waiting_room_event",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            waiting_room_id="699d98642c564d2e855e9661899b7252",
            event_end_time="2021-09-28T17:00:00.000Z",
            event_start_time="2021-09-28T15:30:00.000Z",
            name="production_webinar_event",
            custom_page_html="{{#waitTimeKnown}} {{waitTime}} mins {{/waitTimeKnown}} {{^waitTimeKnown}} Event is prequeueing / Queue all enabled {{/waitTimeKnown}}",
            description="Production event - DO NOT MODIFY",
            disable_session_renewal=True,
            new_users_per_minute=200,
            prequeue_start_time="2021-09-28T15:00:00.000Z",
            queueing_method="random",
            session_duration=1,
            shuffle_at_event_start=True,
            suspended=True,
            total_active_users=200,
            turnstile_action="log",
            turnstile_mode="off")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/waitingRoomEvent:WaitingRoomEvent example '<zone_id>/<waiting_room_id>/<event_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] custom_page_html: If set, the event will override the waiting room's `custom_page_html` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.str] description: A note that you can use to add more details about the event.
        :param pulumi.Input[builtins.bool] disable_session_renewal: If set, the event will override the waiting room's `disable_session_renewal` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.str] event_end_time: An ISO 8601 timestamp that marks the end of the event.
        :param pulumi.Input[builtins.str] event_start_time: An ISO 8601 timestamp that marks the start of the event. At this time, queued users will be processed with the event's configuration. The start time must be at least one minute before `event_end_time`.
        :param pulumi.Input[builtins.str] name: A unique name to identify the event. Only alphanumeric characters, hyphens and underscores are allowed.
        :param pulumi.Input[builtins.int] new_users_per_minute: If set, the event will override the waiting room's `new_users_per_minute` property while it is active. If null, the event will inherit it. This can only be set if the event's `total_active_users` property is also set.
        :param pulumi.Input[builtins.str] prequeue_start_time: An ISO 8601 timestamp that marks when to begin queueing all users before the event starts. The prequeue must start at least five minutes before `event_start_time`.
        :param pulumi.Input[builtins.str] queueing_method: If set, the event will override the waiting room's `queueing_method` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.int] session_duration: If set, the event will override the waiting room's `session_duration` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.bool] shuffle_at_event_start: If enabled, users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. This is useful for situations when many users will join the event prequeue at the same time and you want to shuffle them to ensure fairness. Naturally, it makes the most sense to enable this feature when the `queueing_method` during the event respects ordering such as **fifo**, or else the shuffling may be unnecessary.
        :param pulumi.Input[builtins.bool] suspended: Suspends or allows an event. If set to `true`, the event is ignored and traffic will be handled based on the waiting room configuration.
        :param pulumi.Input[builtins.int] total_active_users: If set, the event will override the waiting room's `total_active_users` property while it is active. If null, the event will inherit it. This can only be set if the event's `new_users_per_minute` property is also set.
        :param pulumi.Input[builtins.str] turnstile_action: If set, the event will override the waiting room's `turnstile_action` property while it is active. If null, the event will inherit it.
               Available values: "log", "infinite_queue".
        :param pulumi.Input[builtins.str] turnstile_mode: If set, the event will override the waiting room's `turnstile_mode` property while it is active. If null, the event will inherit it.
               Available values: "off", "invisible", "visible*non*interactive", "visible_managed".
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WaitingRoomEventArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_waiting_room_event = cloudflare.WaitingRoomEvent("example_waiting_room_event",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            waiting_room_id="699d98642c564d2e855e9661899b7252",
            event_end_time="2021-09-28T17:00:00.000Z",
            event_start_time="2021-09-28T15:30:00.000Z",
            name="production_webinar_event",
            custom_page_html="{{#waitTimeKnown}} {{waitTime}} mins {{/waitTimeKnown}} {{^waitTimeKnown}} Event is prequeueing / Queue all enabled {{/waitTimeKnown}}",
            description="Production event - DO NOT MODIFY",
            disable_session_renewal=True,
            new_users_per_minute=200,
            prequeue_start_time="2021-09-28T15:00:00.000Z",
            queueing_method="random",
            session_duration=1,
            shuffle_at_event_start=True,
            suspended=True,
            total_active_users=200,
            turnstile_action="log",
            turnstile_mode="off")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/waitingRoomEvent:WaitingRoomEvent example '<zone_id>/<waiting_room_id>/<event_id>'
        ```

        :param str resource_name: The name of the resource.
        :param WaitingRoomEventArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WaitingRoomEventArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_page_html: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[builtins.bool]] = None,
                 event_end_time: Optional[pulumi.Input[builtins.str]] = None,
                 event_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[builtins.int]] = None,
                 prequeue_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 queueing_method: Optional[pulumi.Input[builtins.str]] = None,
                 session_duration: Optional[pulumi.Input[builtins.int]] = None,
                 shuffle_at_event_start: Optional[pulumi.Input[builtins.bool]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None,
                 total_active_users: Optional[pulumi.Input[builtins.int]] = None,
                 turnstile_action: Optional[pulumi.Input[builtins.str]] = None,
                 turnstile_mode: Optional[pulumi.Input[builtins.str]] = None,
                 waiting_room_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WaitingRoomEventArgs.__new__(WaitingRoomEventArgs)

            __props__.__dict__["custom_page_html"] = custom_page_html
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_session_renewal"] = disable_session_renewal
            if event_end_time is None and not opts.urn:
                raise TypeError("Missing required property 'event_end_time'")
            __props__.__dict__["event_end_time"] = event_end_time
            if event_start_time is None and not opts.urn:
                raise TypeError("Missing required property 'event_start_time'")
            __props__.__dict__["event_start_time"] = event_start_time
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["new_users_per_minute"] = new_users_per_minute
            __props__.__dict__["prequeue_start_time"] = prequeue_start_time
            __props__.__dict__["queueing_method"] = queueing_method
            __props__.__dict__["session_duration"] = session_duration
            __props__.__dict__["shuffle_at_event_start"] = shuffle_at_event_start
            __props__.__dict__["suspended"] = suspended
            __props__.__dict__["total_active_users"] = total_active_users
            __props__.__dict__["turnstile_action"] = turnstile_action
            __props__.__dict__["turnstile_mode"] = turnstile_mode
            if waiting_room_id is None and not opts.urn:
                raise TypeError("Missing required property 'waiting_room_id'")
            __props__.__dict__["waiting_room_id"] = waiting_room_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        super(WaitingRoomEvent, __self__).__init__(
            'cloudflare:index/waitingRoomEvent:WaitingRoomEvent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_on: Optional[pulumi.Input[builtins.str]] = None,
            custom_page_html: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disable_session_renewal: Optional[pulumi.Input[builtins.bool]] = None,
            event_end_time: Optional[pulumi.Input[builtins.str]] = None,
            event_start_time: Optional[pulumi.Input[builtins.str]] = None,
            modified_on: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            new_users_per_minute: Optional[pulumi.Input[builtins.int]] = None,
            prequeue_start_time: Optional[pulumi.Input[builtins.str]] = None,
            queueing_method: Optional[pulumi.Input[builtins.str]] = None,
            session_duration: Optional[pulumi.Input[builtins.int]] = None,
            shuffle_at_event_start: Optional[pulumi.Input[builtins.bool]] = None,
            suspended: Optional[pulumi.Input[builtins.bool]] = None,
            total_active_users: Optional[pulumi.Input[builtins.int]] = None,
            turnstile_action: Optional[pulumi.Input[builtins.str]] = None,
            turnstile_mode: Optional[pulumi.Input[builtins.str]] = None,
            waiting_room_id: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'WaitingRoomEvent':
        """
        Get an existing WaitingRoomEvent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] custom_page_html: If set, the event will override the waiting room's `custom_page_html` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.str] description: A note that you can use to add more details about the event.
        :param pulumi.Input[builtins.bool] disable_session_renewal: If set, the event will override the waiting room's `disable_session_renewal` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.str] event_end_time: An ISO 8601 timestamp that marks the end of the event.
        :param pulumi.Input[builtins.str] event_start_time: An ISO 8601 timestamp that marks the start of the event. At this time, queued users will be processed with the event's configuration. The start time must be at least one minute before `event_end_time`.
        :param pulumi.Input[builtins.str] name: A unique name to identify the event. Only alphanumeric characters, hyphens and underscores are allowed.
        :param pulumi.Input[builtins.int] new_users_per_minute: If set, the event will override the waiting room's `new_users_per_minute` property while it is active. If null, the event will inherit it. This can only be set if the event's `total_active_users` property is also set.
        :param pulumi.Input[builtins.str] prequeue_start_time: An ISO 8601 timestamp that marks when to begin queueing all users before the event starts. The prequeue must start at least five minutes before `event_start_time`.
        :param pulumi.Input[builtins.str] queueing_method: If set, the event will override the waiting room's `queueing_method` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.int] session_duration: If set, the event will override the waiting room's `session_duration` property while it is active. If null, the event will inherit it.
        :param pulumi.Input[builtins.bool] shuffle_at_event_start: If enabled, users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. This is useful for situations when many users will join the event prequeue at the same time and you want to shuffle them to ensure fairness. Naturally, it makes the most sense to enable this feature when the `queueing_method` during the event respects ordering such as **fifo**, or else the shuffling may be unnecessary.
        :param pulumi.Input[builtins.bool] suspended: Suspends or allows an event. If set to `true`, the event is ignored and traffic will be handled based on the waiting room configuration.
        :param pulumi.Input[builtins.int] total_active_users: If set, the event will override the waiting room's `total_active_users` property while it is active. If null, the event will inherit it. This can only be set if the event's `new_users_per_minute` property is also set.
        :param pulumi.Input[builtins.str] turnstile_action: If set, the event will override the waiting room's `turnstile_action` property while it is active. If null, the event will inherit it.
               Available values: "log", "infinite_queue".
        :param pulumi.Input[builtins.str] turnstile_mode: If set, the event will override the waiting room's `turnstile_mode` property while it is active. If null, the event will inherit it.
               Available values: "off", "invisible", "visible*non*interactive", "visible_managed".
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WaitingRoomEventState.__new__(_WaitingRoomEventState)

        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["custom_page_html"] = custom_page_html
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_session_renewal"] = disable_session_renewal
        __props__.__dict__["event_end_time"] = event_end_time
        __props__.__dict__["event_start_time"] = event_start_time
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["new_users_per_minute"] = new_users_per_minute
        __props__.__dict__["prequeue_start_time"] = prequeue_start_time
        __props__.__dict__["queueing_method"] = queueing_method
        __props__.__dict__["session_duration"] = session_duration
        __props__.__dict__["shuffle_at_event_start"] = shuffle_at_event_start
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["total_active_users"] = total_active_users
        __props__.__dict__["turnstile_action"] = turnstile_action
        __props__.__dict__["turnstile_mode"] = turnstile_mode
        __props__.__dict__["waiting_room_id"] = waiting_room_id
        __props__.__dict__["zone_id"] = zone_id
        return WaitingRoomEvent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If set, the event will override the waiting room's `custom_page_html` property while it is active. If null, the event will inherit it.
        """
        return pulumi.get(self, "custom_page_html")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        A note that you can use to add more details about the event.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set, the event will override the waiting room's `disable_session_renewal` property while it is active. If null, the event will inherit it.
        """
        return pulumi.get(self, "disable_session_renewal")

    @property
    @pulumi.getter(name="eventEndTime")
    def event_end_time(self) -> pulumi.Output[builtins.str]:
        """
        An ISO 8601 timestamp that marks the end of the event.
        """
        return pulumi.get(self, "event_end_time")

    @property
    @pulumi.getter(name="eventStartTime")
    def event_start_time(self) -> pulumi.Output[builtins.str]:
        """
        An ISO 8601 timestamp that marks the start of the event. At this time, queued users will be processed with the event's configuration. The start time must be at least one minute before `event_end_time`.
        """
        return pulumi.get(self, "event_start_time")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique name to identify the event. Only alphanumeric characters, hyphens and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        If set, the event will override the waiting room's `new_users_per_minute` property while it is active. If null, the event will inherit it. This can only be set if the event's `total_active_users` property is also set.
        """
        return pulumi.get(self, "new_users_per_minute")

    @property
    @pulumi.getter(name="prequeueStartTime")
    def prequeue_start_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An ISO 8601 timestamp that marks when to begin queueing all users before the event starts. The prequeue must start at least five minutes before `event_start_time`.
        """
        return pulumi.get(self, "prequeue_start_time")

    @property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If set, the event will override the waiting room's `queueing_method` property while it is active. If null, the event will inherit it.
        """
        return pulumi.get(self, "queueing_method")

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        If set, the event will override the waiting room's `session_duration` property while it is active. If null, the event will inherit it.
        """
        return pulumi.get(self, "session_duration")

    @property
    @pulumi.getter(name="shuffleAtEventStart")
    def shuffle_at_event_start(self) -> pulumi.Output[builtins.bool]:
        """
        If enabled, users in the prequeue will be shuffled randomly at the `event_start_time`. Requires that `prequeue_start_time` is not null. This is useful for situations when many users will join the event prequeue at the same time and you want to shuffle them to ensure fairness. Naturally, it makes the most sense to enable this feature when the `queueing_method` during the event respects ordering such as **fifo**, or else the shuffling may be unnecessary.
        """
        return pulumi.get(self, "shuffle_at_event_start")

    @property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[builtins.bool]:
        """
        Suspends or allows an event. If set to `true`, the event is ignored and traffic will be handled based on the waiting room configuration.
        """
        return pulumi.get(self, "suspended")

    @property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        If set, the event will override the waiting room's `total_active_users` property while it is active. If null, the event will inherit it. This can only be set if the event's `new_users_per_minute` property is also set.
        """
        return pulumi.get(self, "total_active_users")

    @property
    @pulumi.getter(name="turnstileAction")
    def turnstile_action(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If set, the event will override the waiting room's `turnstile_action` property while it is active. If null, the event will inherit it.
        Available values: "log", "infinite_queue".
        """
        return pulumi.get(self, "turnstile_action")

    @property
    @pulumi.getter(name="turnstileMode")
    def turnstile_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If set, the event will override the waiting room's `turnstile_mode` property while it is active. If null, the event will inherit it.
        Available values: "off", "invisible", "visible*non*interactive", "visible_managed".
        """
        return pulumi.get(self, "turnstile_mode")

    @property
    @pulumi.getter(name="waitingRoomId")
    def waiting_room_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "waiting_room_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

