# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WorkerDomainArgs', 'WorkerDomain']

@pulumi.input_type
class WorkerDomainArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 environment: pulumi.Input[builtins.str],
                 hostname: pulumi.Input[builtins.str],
                 service: pulumi.Input[builtins.str],
                 zone_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a WorkerDomain resource.
        :param pulumi.Input[builtins.str] account_id: Identifer of the account.
        :param pulumi.Input[builtins.str] environment: Worker environment associated with the zone and hostname.
        :param pulumi.Input[builtins.str] hostname: Hostname of the Worker Domain.
        :param pulumi.Input[builtins.str] service: Worker service associated with the zone and hostname.
        :param pulumi.Input[builtins.str] zone_id: Identifier of the zone.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifer of the account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Input[builtins.str]:
        """
        Worker environment associated with the zone and hostname.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        Hostname of the Worker Domain.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[builtins.str]:
        """
        Worker service associated with the zone and hostname.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _WorkerDomainState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkerDomain resources.
        :param pulumi.Input[builtins.str] account_id: Identifer of the account.
        :param pulumi.Input[builtins.str] environment: Worker environment associated with the zone and hostname.
        :param pulumi.Input[builtins.str] hostname: Hostname of the Worker Domain.
        :param pulumi.Input[builtins.str] service: Worker service associated with the zone and hostname.
        :param pulumi.Input[builtins.str] zone_id: Identifier of the zone.
        :param pulumi.Input[builtins.str] zone_name: Name of the zone.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)
        if zone_name is not None:
            pulumi.set(__self__, "zone_name", zone_name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifer of the account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Worker environment associated with the zone and hostname.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hostname of the Worker Domain.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Worker service associated with the zone and hostname.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the zone.
        """
        return pulumi.get(self, "zone_name")

    @zone_name.setter
    def zone_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_name", value)


warnings.warn("""cloudflare.index/workerdomain.WorkerDomain has been deprecated in favor of cloudflare.index/workerscustomdomain.WorkersCustomDomain""", DeprecationWarning)


@pulumi.type_token("cloudflare:index/workerDomain:WorkerDomain")
class WorkerDomain(pulumi.CustomResource):
    warnings.warn("""cloudflare.index/workerdomain.WorkerDomain has been deprecated in favor of cloudflare.index/workerscustomdomain.WorkersCustomDomain""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_workers_custom_domain = cloudflare.WorkersCustomDomain("example_workers_custom_domain",
            account_id="9a7806061c88ada191ed06f989cc3dac",
            environment="production",
            hostname="foo.example.com",
            service="foo",
            zone_id="593c9c94de529bbbfaac7c53ced0447d")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/workerDomain:WorkerDomain example '<account_id>/<domain_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifer of the account.
        :param pulumi.Input[builtins.str] environment: Worker environment associated with the zone and hostname.
        :param pulumi.Input[builtins.str] hostname: Hostname of the Worker Domain.
        :param pulumi.Input[builtins.str] service: Worker service associated with the zone and hostname.
        :param pulumi.Input[builtins.str] zone_id: Identifier of the zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkerDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_workers_custom_domain = cloudflare.WorkersCustomDomain("example_workers_custom_domain",
            account_id="9a7806061c88ada191ed06f989cc3dac",
            environment="production",
            hostname="foo.example.com",
            service="foo",
            zone_id="593c9c94de529bbbfaac7c53ced0447d")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/workerDomain:WorkerDomain example '<account_id>/<domain_id>'
        ```

        :param str resource_name: The name of the resource.
        :param WorkerDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkerDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""WorkerDomain is deprecated: cloudflare.index/workerdomain.WorkerDomain has been deprecated in favor of cloudflare.index/workerscustomdomain.WorkersCustomDomain""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkerDomainArgs.__new__(WorkerDomainArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["zone_name"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/workerDomain:WorkerDomain")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(WorkerDomain, __self__).__init__(
            'cloudflare:index/workerDomain:WorkerDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            environment: Optional[pulumi.Input[builtins.str]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            service: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None,
            zone_name: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkerDomain':
        """
        Get an existing WorkerDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifer of the account.
        :param pulumi.Input[builtins.str] environment: Worker environment associated with the zone and hostname.
        :param pulumi.Input[builtins.str] hostname: Hostname of the Worker Domain.
        :param pulumi.Input[builtins.str] service: Worker service associated with the zone and hostname.
        :param pulumi.Input[builtins.str] zone_id: Identifier of the zone.
        :param pulumi.Input[builtins.str] zone_name: Name of the zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkerDomainState.__new__(_WorkerDomainState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["environment"] = environment
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["service"] = service
        __props__.__dict__["zone_id"] = zone_id
        __props__.__dict__["zone_name"] = zone_name
        return WorkerDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifer of the account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[builtins.str]:
        """
        Worker environment associated with the zone and hostname.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[builtins.str]:
        """
        Hostname of the Worker Domain.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[builtins.str]:
        """
        Worker service associated with the zone and hostname.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of the zone.
        """
        return pulumi.get(self, "zone_id")

    @property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the zone.
        """
        return pulumi.get(self, "zone_name")

