# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WorkersKvNamespaceArgs', 'WorkersKvNamespace']

@pulumi.input_type
class WorkersKvNamespaceArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a WorkersKvNamespace resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] title: A human-readable string name for a Namespace.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        A human-readable string name for a Namespace.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class _WorkersKvNamespaceState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 beta: Optional[pulumi.Input[builtins.bool]] = None,
                 supports_url_encoding: Optional[pulumi.Input[builtins.bool]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkersKvNamespace resources.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.bool] beta: True if new beta namespace, with additional preview features.
        :param pulumi.Input[builtins.bool] supports_url_encoding: True if keys written on the URL will be URL-decoded before storing. For example, if set to "true", a key written on the URL as "%3F" will be stored as "?".
        :param pulumi.Input[builtins.str] title: A human-readable string name for a Namespace.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if beta is not None:
            pulumi.set(__self__, "beta", beta)
        if supports_url_encoding is not None:
            pulumi.set(__self__, "supports_url_encoding", supports_url_encoding)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def beta(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        True if new beta namespace, with additional preview features.
        """
        return pulumi.get(self, "beta")

    @beta.setter
    def beta(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "beta", value)

    @property
    @pulumi.getter(name="supportsUrlEncoding")
    def supports_url_encoding(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        True if keys written on the URL will be URL-decoded before storing. For example, if set to "true", a key written on the URL as "%3F" will be stored as "?".
        """
        return pulumi.get(self, "supports_url_encoding")

    @supports_url_encoding.setter
    def supports_url_encoding(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "supports_url_encoding", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable string name for a Namespace.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)


@pulumi.type_token("cloudflare:index/workersKvNamespace:WorkersKvNamespace")
class WorkersKvNamespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_workers_kv_namespace = cloudflare.WorkersKvNamespace("example_workers_kv_namespace",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            title="My Own Namespace")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/workersKvNamespace:WorkersKvNamespace example '<account_id>/<namespace_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.str] title: A human-readable string name for a Namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkersKvNamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_workers_kv_namespace = cloudflare.WorkersKvNamespace("example_workers_kv_namespace",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            title="My Own Namespace")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/workersKvNamespace:WorkersKvNamespace example '<account_id>/<namespace_id>'
        ```

        :param str resource_name: The name of the resource.
        :param WorkersKvNamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkersKvNamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkersKvNamespaceArgs.__new__(WorkersKvNamespaceArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["beta"] = None
            __props__.__dict__["supports_url_encoding"] = None
        super(WorkersKvNamespace, __self__).__init__(
            'cloudflare:index/workersKvNamespace:WorkersKvNamespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            beta: Optional[pulumi.Input[builtins.bool]] = None,
            supports_url_encoding: Optional[pulumi.Input[builtins.bool]] = None,
            title: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkersKvNamespace':
        """
        Get an existing WorkersKvNamespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier
        :param pulumi.Input[builtins.bool] beta: True if new beta namespace, with additional preview features.
        :param pulumi.Input[builtins.bool] supports_url_encoding: True if keys written on the URL will be URL-decoded before storing. For example, if set to "true", a key written on the URL as "%3F" will be stored as "?".
        :param pulumi.Input[builtins.str] title: A human-readable string name for a Namespace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkersKvNamespaceState.__new__(_WorkersKvNamespaceState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["beta"] = beta
        __props__.__dict__["supports_url_encoding"] = supports_url_encoding
        __props__.__dict__["title"] = title
        return WorkersKvNamespace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def beta(self) -> pulumi.Output[builtins.bool]:
        """
        True if new beta namespace, with additional preview features.
        """
        return pulumi.get(self, "beta")

    @property
    @pulumi.getter(name="supportsUrlEncoding")
    def supports_url_encoding(self) -> pulumi.Output[builtins.bool]:
        """
        True if keys written on the URL will be URL-decoded before storing. For example, if set to "true", a key written on the URL as "%3F" will be stored as "?".
        """
        return pulumi.get(self, "supports_url_encoding")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[builtins.str]:
        """
        A human-readable string name for a Namespace.
        """
        return pulumi.get(self, "title")

