# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkersScriptArgs', 'WorkersScript']

@pulumi.input_type
class WorkersScriptArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 content: pulumi.Input[builtins.str],
                 script_name: pulumi.Input[builtins.str],
                 assets: Optional[pulumi.Input['WorkersScriptAssetsArgs']] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['WorkersScriptBindingArgs']]]] = None,
                 body_part: Optional[pulumi.Input[builtins.str]] = None,
                 compatibility_date: Optional[pulumi.Input[builtins.str]] = None,
                 compatibility_flags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 keep_assets: Optional[pulumi.Input[builtins.bool]] = None,
                 keep_bindings: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logpush: Optional[pulumi.Input[builtins.bool]] = None,
                 main_module: Optional[pulumi.Input[builtins.str]] = None,
                 migrations: Optional[pulumi.Input['WorkersScriptMigrationsArgs']] = None,
                 observability: Optional[pulumi.Input['WorkersScriptObservabilityArgs']] = None,
                 placement: Optional[pulumi.Input['WorkersScriptPlacementArgs']] = None,
                 tail_consumers: Optional[pulumi.Input[Sequence[pulumi.Input['WorkersScriptTailConsumerArgs']]]] = None,
                 usage_model: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a WorkersScript resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.str] content: Module or Service Worker contents of the Worker.
        :param pulumi.Input[builtins.str] script_name: Name of the script, used in URLs and route configuration.
        :param pulumi.Input['WorkersScriptAssetsArgs'] assets: Configuration for assets within a Worker
        :param pulumi.Input[Sequence[pulumi.Input['WorkersScriptBindingArgs']]] bindings: List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        :param pulumi.Input[builtins.str] body_part: Name of the part in the multipart request that contains the script (e.g. the file adding a listener to the `fetch` event). Indicates a `service worker syntax` Worker.
        :param pulumi.Input[builtins.str] compatibility_date: Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] compatibility_flags: Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        :param pulumi.Input[builtins.bool] keep_assets: Retain assets which exist for a previously uploaded Worker version; used in lieu of providing a completion token.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] keep_bindings: List of binding types to keep from previous_upload.
        :param pulumi.Input[builtins.bool] logpush: Whether Logpush is turned on for the Worker.
        :param pulumi.Input[builtins.str] main_module: Name of the part in the multipart request that contains the main module (e.g. the file exporting a `fetch` handler). Indicates a `module syntax` Worker.
        :param pulumi.Input['WorkersScriptMigrationsArgs'] migrations: Migrations to apply for Durable Objects associated with this Worker.
        :param pulumi.Input['WorkersScriptObservabilityArgs'] observability: Observability settings for the Worker.
        :param pulumi.Input['WorkersScriptPlacementArgs'] placement: Configuration for [Smart Placement](https://developers.cloudflare.com/workers/configuration/smart-placement).
        :param pulumi.Input[Sequence[pulumi.Input['WorkersScriptTailConsumerArgs']]] tail_consumers: List of Workers that will consume logs from the attached Worker.
        :param pulumi.Input[builtins.str] usage_model: Usage model for the Worker invocations.
               Available values: "standard".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "script_name", script_name)
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if body_part is not None:
            pulumi.set(__self__, "body_part", body_part)
        if compatibility_date is not None:
            pulumi.set(__self__, "compatibility_date", compatibility_date)
        if compatibility_flags is not None:
            pulumi.set(__self__, "compatibility_flags", compatibility_flags)
        if keep_assets is not None:
            pulumi.set(__self__, "keep_assets", keep_assets)
        if keep_bindings is not None:
            pulumi.set(__self__, "keep_bindings", keep_bindings)
        if logpush is not None:
            pulumi.set(__self__, "logpush", logpush)
        if main_module is not None:
            pulumi.set(__self__, "main_module", main_module)
        if migrations is not None:
            pulumi.set(__self__, "migrations", migrations)
        if observability is not None:
            pulumi.set(__self__, "observability", observability)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if tail_consumers is not None:
            pulumi.set(__self__, "tail_consumers", tail_consumers)
        if usage_model is not None:
            pulumi.set(__self__, "usage_model", usage_model)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[builtins.str]:
        """
        Module or Service Worker contents of the Worker.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the script, used in URLs and route configuration.
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "script_name", value)

    @property
    @pulumi.getter
    def assets(self) -> Optional[pulumi.Input['WorkersScriptAssetsArgs']]:
        """
        Configuration for assets within a Worker
        """
        return pulumi.get(self, "assets")

    @assets.setter
    def assets(self, value: Optional[pulumi.Input['WorkersScriptAssetsArgs']]):
        pulumi.set(self, "assets", value)

    @property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkersScriptBindingArgs']]]]:
        """
        List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        """
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkersScriptBindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @property
    @pulumi.getter(name="bodyPart")
    def body_part(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the part in the multipart request that contains the script (e.g. the file adding a listener to the `fetch` event). Indicates a `service worker syntax` Worker.
        """
        return pulumi.get(self, "body_part")

    @body_part.setter
    def body_part(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "body_part", value)

    @property
    @pulumi.getter(name="compatibilityDate")
    def compatibility_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        """
        return pulumi.get(self, "compatibility_date")

    @compatibility_date.setter
    def compatibility_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compatibility_date", value)

    @property
    @pulumi.getter(name="compatibilityFlags")
    def compatibility_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        """
        return pulumi.get(self, "compatibility_flags")

    @compatibility_flags.setter
    def compatibility_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "compatibility_flags", value)

    @property
    @pulumi.getter(name="keepAssets")
    def keep_assets(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Retain assets which exist for a previously uploaded Worker version; used in lieu of providing a completion token.
        """
        return pulumi.get(self, "keep_assets")

    @keep_assets.setter
    def keep_assets(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "keep_assets", value)

    @property
    @pulumi.getter(name="keepBindings")
    def keep_bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of binding types to keep from previous_upload.
        """
        return pulumi.get(self, "keep_bindings")

    @keep_bindings.setter
    def keep_bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "keep_bindings", value)

    @property
    @pulumi.getter
    def logpush(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether Logpush is turned on for the Worker.
        """
        return pulumi.get(self, "logpush")

    @logpush.setter
    def logpush(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "logpush", value)

    @property
    @pulumi.getter(name="mainModule")
    def main_module(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the part in the multipart request that contains the main module (e.g. the file exporting a `fetch` handler). Indicates a `module syntax` Worker.
        """
        return pulumi.get(self, "main_module")

    @main_module.setter
    def main_module(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "main_module", value)

    @property
    @pulumi.getter
    def migrations(self) -> Optional[pulumi.Input['WorkersScriptMigrationsArgs']]:
        """
        Migrations to apply for Durable Objects associated with this Worker.
        """
        return pulumi.get(self, "migrations")

    @migrations.setter
    def migrations(self, value: Optional[pulumi.Input['WorkersScriptMigrationsArgs']]):
        pulumi.set(self, "migrations", value)

    @property
    @pulumi.getter
    def observability(self) -> Optional[pulumi.Input['WorkersScriptObservabilityArgs']]:
        """
        Observability settings for the Worker.
        """
        return pulumi.get(self, "observability")

    @observability.setter
    def observability(self, value: Optional[pulumi.Input['WorkersScriptObservabilityArgs']]):
        pulumi.set(self, "observability", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input['WorkersScriptPlacementArgs']]:
        """
        Configuration for [Smart Placement](https://developers.cloudflare.com/workers/configuration/smart-placement).
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input['WorkersScriptPlacementArgs']]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="tailConsumers")
    def tail_consumers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkersScriptTailConsumerArgs']]]]:
        """
        List of Workers that will consume logs from the attached Worker.
        """
        return pulumi.get(self, "tail_consumers")

    @tail_consumers.setter
    def tail_consumers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkersScriptTailConsumerArgs']]]]):
        pulumi.set(self, "tail_consumers", value)

    @property
    @pulumi.getter(name="usageModel")
    def usage_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Usage model for the Worker invocations.
        Available values: "standard".
        """
        return pulumi.get(self, "usage_model")

    @usage_model.setter
    def usage_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "usage_model", value)


@pulumi.input_type
class _WorkersScriptState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 assets: Optional[pulumi.Input['WorkersScriptAssetsArgs']] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['WorkersScriptBindingArgs']]]] = None,
                 body_part: Optional[pulumi.Input[builtins.str]] = None,
                 compatibility_date: Optional[pulumi.Input[builtins.str]] = None,
                 compatibility_flags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 created_on: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 has_assets: Optional[pulumi.Input[builtins.bool]] = None,
                 has_modules: Optional[pulumi.Input[builtins.bool]] = None,
                 keep_assets: Optional[pulumi.Input[builtins.bool]] = None,
                 keep_bindings: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logpush: Optional[pulumi.Input[builtins.bool]] = None,
                 main_module: Optional[pulumi.Input[builtins.str]] = None,
                 migrations: Optional[pulumi.Input['WorkersScriptMigrationsArgs']] = None,
                 modified_on: Optional[pulumi.Input[builtins.str]] = None,
                 observability: Optional[pulumi.Input['WorkersScriptObservabilityArgs']] = None,
                 placement: Optional[pulumi.Input['WorkersScriptPlacementArgs']] = None,
                 script_name: Optional[pulumi.Input[builtins.str]] = None,
                 startup_time_ms: Optional[pulumi.Input[builtins.int]] = None,
                 tail_consumers: Optional[pulumi.Input[Sequence[pulumi.Input['WorkersScriptTailConsumerArgs']]]] = None,
                 usage_model: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkersScript resources.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input['WorkersScriptAssetsArgs'] assets: Configuration for assets within a Worker
        :param pulumi.Input[Sequence[pulumi.Input['WorkersScriptBindingArgs']]] bindings: List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        :param pulumi.Input[builtins.str] body_part: Name of the part in the multipart request that contains the script (e.g. the file adding a listener to the `fetch` event). Indicates a `service worker syntax` Worker.
        :param pulumi.Input[builtins.str] compatibility_date: Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] compatibility_flags: Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        :param pulumi.Input[builtins.str] content: Module or Service Worker contents of the Worker.
        :param pulumi.Input[builtins.str] created_on: When the script was created.
        :param pulumi.Input[builtins.str] etag: Hashed script content, can be used in a If-None-Match header when updating.
        :param pulumi.Input[builtins.bool] has_assets: Whether a Worker contains assets.
        :param pulumi.Input[builtins.bool] has_modules: Whether a Worker contains modules.
        :param pulumi.Input[builtins.bool] keep_assets: Retain assets which exist for a previously uploaded Worker version; used in lieu of providing a completion token.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] keep_bindings: List of binding types to keep from previous_upload.
        :param pulumi.Input[builtins.bool] logpush: Whether Logpush is turned on for the Worker.
        :param pulumi.Input[builtins.str] main_module: Name of the part in the multipart request that contains the main module (e.g. the file exporting a `fetch` handler). Indicates a `module syntax` Worker.
        :param pulumi.Input['WorkersScriptMigrationsArgs'] migrations: Migrations to apply for Durable Objects associated with this Worker.
        :param pulumi.Input[builtins.str] modified_on: When the script was last modified.
        :param pulumi.Input['WorkersScriptObservabilityArgs'] observability: Observability settings for the Worker.
        :param pulumi.Input['WorkersScriptPlacementArgs'] placement: Configuration for [Smart Placement](https://developers.cloudflare.com/workers/configuration/smart-placement).
        :param pulumi.Input[builtins.str] script_name: Name of the script, used in URLs and route configuration.
        :param pulumi.Input[Sequence[pulumi.Input['WorkersScriptTailConsumerArgs']]] tail_consumers: List of Workers that will consume logs from the attached Worker.
        :param pulumi.Input[builtins.str] usage_model: Usage model for the Worker invocations.
               Available values: "standard".
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if body_part is not None:
            pulumi.set(__self__, "body_part", body_part)
        if compatibility_date is not None:
            pulumi.set(__self__, "compatibility_date", compatibility_date)
        if compatibility_flags is not None:
            pulumi.set(__self__, "compatibility_flags", compatibility_flags)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if has_assets is not None:
            pulumi.set(__self__, "has_assets", has_assets)
        if has_modules is not None:
            pulumi.set(__self__, "has_modules", has_modules)
        if keep_assets is not None:
            pulumi.set(__self__, "keep_assets", keep_assets)
        if keep_bindings is not None:
            pulumi.set(__self__, "keep_bindings", keep_bindings)
        if logpush is not None:
            pulumi.set(__self__, "logpush", logpush)
        if main_module is not None:
            pulumi.set(__self__, "main_module", main_module)
        if migrations is not None:
            pulumi.set(__self__, "migrations", migrations)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if observability is not None:
            pulumi.set(__self__, "observability", observability)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if script_name is not None:
            pulumi.set(__self__, "script_name", script_name)
        if startup_time_ms is not None:
            pulumi.set(__self__, "startup_time_ms", startup_time_ms)
        if tail_consumers is not None:
            pulumi.set(__self__, "tail_consumers", tail_consumers)
        if usage_model is not None:
            pulumi.set(__self__, "usage_model", usage_model)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def assets(self) -> Optional[pulumi.Input['WorkersScriptAssetsArgs']]:
        """
        Configuration for assets within a Worker
        """
        return pulumi.get(self, "assets")

    @assets.setter
    def assets(self, value: Optional[pulumi.Input['WorkersScriptAssetsArgs']]):
        pulumi.set(self, "assets", value)

    @property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkersScriptBindingArgs']]]]:
        """
        List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        """
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkersScriptBindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @property
    @pulumi.getter(name="bodyPart")
    def body_part(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the part in the multipart request that contains the script (e.g. the file adding a listener to the `fetch` event). Indicates a `service worker syntax` Worker.
        """
        return pulumi.get(self, "body_part")

    @body_part.setter
    def body_part(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "body_part", value)

    @property
    @pulumi.getter(name="compatibilityDate")
    def compatibility_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        """
        return pulumi.get(self, "compatibility_date")

    @compatibility_date.setter
    def compatibility_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compatibility_date", value)

    @property
    @pulumi.getter(name="compatibilityFlags")
    def compatibility_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        """
        return pulumi.get(self, "compatibility_flags")

    @compatibility_flags.setter
    def compatibility_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "compatibility_flags", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Module or Service Worker contents of the Worker.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the script was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hashed script content, can be used in a If-None-Match header when updating.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="hasAssets")
    def has_assets(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether a Worker contains assets.
        """
        return pulumi.get(self, "has_assets")

    @has_assets.setter
    def has_assets(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "has_assets", value)

    @property
    @pulumi.getter(name="hasModules")
    def has_modules(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether a Worker contains modules.
        """
        return pulumi.get(self, "has_modules")

    @has_modules.setter
    def has_modules(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "has_modules", value)

    @property
    @pulumi.getter(name="keepAssets")
    def keep_assets(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Retain assets which exist for a previously uploaded Worker version; used in lieu of providing a completion token.
        """
        return pulumi.get(self, "keep_assets")

    @keep_assets.setter
    def keep_assets(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "keep_assets", value)

    @property
    @pulumi.getter(name="keepBindings")
    def keep_bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of binding types to keep from previous_upload.
        """
        return pulumi.get(self, "keep_bindings")

    @keep_bindings.setter
    def keep_bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "keep_bindings", value)

    @property
    @pulumi.getter
    def logpush(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether Logpush is turned on for the Worker.
        """
        return pulumi.get(self, "logpush")

    @logpush.setter
    def logpush(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "logpush", value)

    @property
    @pulumi.getter(name="mainModule")
    def main_module(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the part in the multipart request that contains the main module (e.g. the file exporting a `fetch` handler). Indicates a `module syntax` Worker.
        """
        return pulumi.get(self, "main_module")

    @main_module.setter
    def main_module(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "main_module", value)

    @property
    @pulumi.getter
    def migrations(self) -> Optional[pulumi.Input['WorkersScriptMigrationsArgs']]:
        """
        Migrations to apply for Durable Objects associated with this Worker.
        """
        return pulumi.get(self, "migrations")

    @migrations.setter
    def migrations(self, value: Optional[pulumi.Input['WorkersScriptMigrationsArgs']]):
        pulumi.set(self, "migrations", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the script was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter
    def observability(self) -> Optional[pulumi.Input['WorkersScriptObservabilityArgs']]:
        """
        Observability settings for the Worker.
        """
        return pulumi.get(self, "observability")

    @observability.setter
    def observability(self, value: Optional[pulumi.Input['WorkersScriptObservabilityArgs']]):
        pulumi.set(self, "observability", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input['WorkersScriptPlacementArgs']]:
        """
        Configuration for [Smart Placement](https://developers.cloudflare.com/workers/configuration/smart-placement).
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input['WorkersScriptPlacementArgs']]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the script, used in URLs and route configuration.
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "script_name", value)

    @property
    @pulumi.getter(name="startupTimeMs")
    def startup_time_ms(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "startup_time_ms")

    @startup_time_ms.setter
    def startup_time_ms(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "startup_time_ms", value)

    @property
    @pulumi.getter(name="tailConsumers")
    def tail_consumers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkersScriptTailConsumerArgs']]]]:
        """
        List of Workers that will consume logs from the attached Worker.
        """
        return pulumi.get(self, "tail_consumers")

    @tail_consumers.setter
    def tail_consumers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkersScriptTailConsumerArgs']]]]):
        pulumi.set(self, "tail_consumers", value)

    @property
    @pulumi.getter(name="usageModel")
    def usage_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Usage model for the Worker invocations.
        Available values: "standard".
        """
        return pulumi.get(self, "usage_model")

    @usage_model.setter
    def usage_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "usage_model", value)


@pulumi.type_token("cloudflare:index/workersScript:WorkersScript")
class WorkersScript(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 assets: Optional[pulumi.Input[Union['WorkersScriptAssetsArgs', 'WorkersScriptAssetsArgsDict']]] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkersScriptBindingArgs', 'WorkersScriptBindingArgsDict']]]]] = None,
                 body_part: Optional[pulumi.Input[builtins.str]] = None,
                 compatibility_date: Optional[pulumi.Input[builtins.str]] = None,
                 compatibility_flags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 keep_assets: Optional[pulumi.Input[builtins.bool]] = None,
                 keep_bindings: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logpush: Optional[pulumi.Input[builtins.bool]] = None,
                 main_module: Optional[pulumi.Input[builtins.str]] = None,
                 migrations: Optional[pulumi.Input[Union['WorkersScriptMigrationsArgs', 'WorkersScriptMigrationsArgsDict']]] = None,
                 observability: Optional[pulumi.Input[Union['WorkersScriptObservabilityArgs', 'WorkersScriptObservabilityArgsDict']]] = None,
                 placement: Optional[pulumi.Input[Union['WorkersScriptPlacementArgs', 'WorkersScriptPlacementArgsDict']]] = None,
                 script_name: Optional[pulumi.Input[builtins.str]] = None,
                 tail_consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkersScriptTailConsumerArgs', 'WorkersScriptTailConsumerArgsDict']]]]] = None,
                 usage_model: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/workersScript:WorkersScript example '<account_id>/<script_name>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[Union['WorkersScriptAssetsArgs', 'WorkersScriptAssetsArgsDict']] assets: Configuration for assets within a Worker
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkersScriptBindingArgs', 'WorkersScriptBindingArgsDict']]]] bindings: List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        :param pulumi.Input[builtins.str] body_part: Name of the part in the multipart request that contains the script (e.g. the file adding a listener to the `fetch` event). Indicates a `service worker syntax` Worker.
        :param pulumi.Input[builtins.str] compatibility_date: Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] compatibility_flags: Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        :param pulumi.Input[builtins.str] content: Module or Service Worker contents of the Worker.
        :param pulumi.Input[builtins.bool] keep_assets: Retain assets which exist for a previously uploaded Worker version; used in lieu of providing a completion token.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] keep_bindings: List of binding types to keep from previous_upload.
        :param pulumi.Input[builtins.bool] logpush: Whether Logpush is turned on for the Worker.
        :param pulumi.Input[builtins.str] main_module: Name of the part in the multipart request that contains the main module (e.g. the file exporting a `fetch` handler). Indicates a `module syntax` Worker.
        :param pulumi.Input[Union['WorkersScriptMigrationsArgs', 'WorkersScriptMigrationsArgsDict']] migrations: Migrations to apply for Durable Objects associated with this Worker.
        :param pulumi.Input[Union['WorkersScriptObservabilityArgs', 'WorkersScriptObservabilityArgsDict']] observability: Observability settings for the Worker.
        :param pulumi.Input[Union['WorkersScriptPlacementArgs', 'WorkersScriptPlacementArgsDict']] placement: Configuration for [Smart Placement](https://developers.cloudflare.com/workers/configuration/smart-placement).
        :param pulumi.Input[builtins.str] script_name: Name of the script, used in URLs and route configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkersScriptTailConsumerArgs', 'WorkersScriptTailConsumerArgsDict']]]] tail_consumers: List of Workers that will consume logs from the attached Worker.
        :param pulumi.Input[builtins.str] usage_model: Usage model for the Worker invocations.
               Available values: "standard".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkersScriptArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/workersScript:WorkersScript example '<account_id>/<script_name>'
        ```

        :param str resource_name: The name of the resource.
        :param WorkersScriptArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkersScriptArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 assets: Optional[pulumi.Input[Union['WorkersScriptAssetsArgs', 'WorkersScriptAssetsArgsDict']]] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkersScriptBindingArgs', 'WorkersScriptBindingArgsDict']]]]] = None,
                 body_part: Optional[pulumi.Input[builtins.str]] = None,
                 compatibility_date: Optional[pulumi.Input[builtins.str]] = None,
                 compatibility_flags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 keep_assets: Optional[pulumi.Input[builtins.bool]] = None,
                 keep_bindings: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logpush: Optional[pulumi.Input[builtins.bool]] = None,
                 main_module: Optional[pulumi.Input[builtins.str]] = None,
                 migrations: Optional[pulumi.Input[Union['WorkersScriptMigrationsArgs', 'WorkersScriptMigrationsArgsDict']]] = None,
                 observability: Optional[pulumi.Input[Union['WorkersScriptObservabilityArgs', 'WorkersScriptObservabilityArgsDict']]] = None,
                 placement: Optional[pulumi.Input[Union['WorkersScriptPlacementArgs', 'WorkersScriptPlacementArgsDict']]] = None,
                 script_name: Optional[pulumi.Input[builtins.str]] = None,
                 tail_consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkersScriptTailConsumerArgs', 'WorkersScriptTailConsumerArgsDict']]]]] = None,
                 usage_model: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkersScriptArgs.__new__(WorkersScriptArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["assets"] = assets
            __props__.__dict__["bindings"] = bindings
            __props__.__dict__["body_part"] = body_part
            __props__.__dict__["compatibility_date"] = compatibility_date
            __props__.__dict__["compatibility_flags"] = compatibility_flags
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["keep_assets"] = keep_assets
            __props__.__dict__["keep_bindings"] = keep_bindings
            __props__.__dict__["logpush"] = logpush
            __props__.__dict__["main_module"] = main_module
            __props__.__dict__["migrations"] = migrations
            __props__.__dict__["observability"] = observability
            __props__.__dict__["placement"] = placement
            if script_name is None and not opts.urn:
                raise TypeError("Missing required property 'script_name'")
            __props__.__dict__["script_name"] = script_name
            __props__.__dict__["tail_consumers"] = tail_consumers
            __props__.__dict__["usage_model"] = usage_model
            __props__.__dict__["created_on"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["has_assets"] = None
            __props__.__dict__["has_modules"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["startup_time_ms"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/workerScript:WorkerScript")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(WorkersScript, __self__).__init__(
            'cloudflare:index/workersScript:WorkersScript',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            assets: Optional[pulumi.Input[Union['WorkersScriptAssetsArgs', 'WorkersScriptAssetsArgsDict']]] = None,
            bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkersScriptBindingArgs', 'WorkersScriptBindingArgsDict']]]]] = None,
            body_part: Optional[pulumi.Input[builtins.str]] = None,
            compatibility_date: Optional[pulumi.Input[builtins.str]] = None,
            compatibility_flags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            content: Optional[pulumi.Input[builtins.str]] = None,
            created_on: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            has_assets: Optional[pulumi.Input[builtins.bool]] = None,
            has_modules: Optional[pulumi.Input[builtins.bool]] = None,
            keep_assets: Optional[pulumi.Input[builtins.bool]] = None,
            keep_bindings: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            logpush: Optional[pulumi.Input[builtins.bool]] = None,
            main_module: Optional[pulumi.Input[builtins.str]] = None,
            migrations: Optional[pulumi.Input[Union['WorkersScriptMigrationsArgs', 'WorkersScriptMigrationsArgsDict']]] = None,
            modified_on: Optional[pulumi.Input[builtins.str]] = None,
            observability: Optional[pulumi.Input[Union['WorkersScriptObservabilityArgs', 'WorkersScriptObservabilityArgsDict']]] = None,
            placement: Optional[pulumi.Input[Union['WorkersScriptPlacementArgs', 'WorkersScriptPlacementArgsDict']]] = None,
            script_name: Optional[pulumi.Input[builtins.str]] = None,
            startup_time_ms: Optional[pulumi.Input[builtins.int]] = None,
            tail_consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkersScriptTailConsumerArgs', 'WorkersScriptTailConsumerArgsDict']]]]] = None,
            usage_model: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkersScript':
        """
        Get an existing WorkersScript resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[Union['WorkersScriptAssetsArgs', 'WorkersScriptAssetsArgsDict']] assets: Configuration for assets within a Worker
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkersScriptBindingArgs', 'WorkersScriptBindingArgsDict']]]] bindings: List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        :param pulumi.Input[builtins.str] body_part: Name of the part in the multipart request that contains the script (e.g. the file adding a listener to the `fetch` event). Indicates a `service worker syntax` Worker.
        :param pulumi.Input[builtins.str] compatibility_date: Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] compatibility_flags: Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        :param pulumi.Input[builtins.str] content: Module or Service Worker contents of the Worker.
        :param pulumi.Input[builtins.str] created_on: When the script was created.
        :param pulumi.Input[builtins.str] etag: Hashed script content, can be used in a If-None-Match header when updating.
        :param pulumi.Input[builtins.bool] has_assets: Whether a Worker contains assets.
        :param pulumi.Input[builtins.bool] has_modules: Whether a Worker contains modules.
        :param pulumi.Input[builtins.bool] keep_assets: Retain assets which exist for a previously uploaded Worker version; used in lieu of providing a completion token.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] keep_bindings: List of binding types to keep from previous_upload.
        :param pulumi.Input[builtins.bool] logpush: Whether Logpush is turned on for the Worker.
        :param pulumi.Input[builtins.str] main_module: Name of the part in the multipart request that contains the main module (e.g. the file exporting a `fetch` handler). Indicates a `module syntax` Worker.
        :param pulumi.Input[Union['WorkersScriptMigrationsArgs', 'WorkersScriptMigrationsArgsDict']] migrations: Migrations to apply for Durable Objects associated with this Worker.
        :param pulumi.Input[builtins.str] modified_on: When the script was last modified.
        :param pulumi.Input[Union['WorkersScriptObservabilityArgs', 'WorkersScriptObservabilityArgsDict']] observability: Observability settings for the Worker.
        :param pulumi.Input[Union['WorkersScriptPlacementArgs', 'WorkersScriptPlacementArgsDict']] placement: Configuration for [Smart Placement](https://developers.cloudflare.com/workers/configuration/smart-placement).
        :param pulumi.Input[builtins.str] script_name: Name of the script, used in URLs and route configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkersScriptTailConsumerArgs', 'WorkersScriptTailConsumerArgsDict']]]] tail_consumers: List of Workers that will consume logs from the attached Worker.
        :param pulumi.Input[builtins.str] usage_model: Usage model for the Worker invocations.
               Available values: "standard".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkersScriptState.__new__(_WorkersScriptState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["assets"] = assets
        __props__.__dict__["bindings"] = bindings
        __props__.__dict__["body_part"] = body_part
        __props__.__dict__["compatibility_date"] = compatibility_date
        __props__.__dict__["compatibility_flags"] = compatibility_flags
        __props__.__dict__["content"] = content
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["etag"] = etag
        __props__.__dict__["has_assets"] = has_assets
        __props__.__dict__["has_modules"] = has_modules
        __props__.__dict__["keep_assets"] = keep_assets
        __props__.__dict__["keep_bindings"] = keep_bindings
        __props__.__dict__["logpush"] = logpush
        __props__.__dict__["main_module"] = main_module
        __props__.__dict__["migrations"] = migrations
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["observability"] = observability
        __props__.__dict__["placement"] = placement
        __props__.__dict__["script_name"] = script_name
        __props__.__dict__["startup_time_ms"] = startup_time_ms
        __props__.__dict__["tail_consumers"] = tail_consumers
        __props__.__dict__["usage_model"] = usage_model
        return WorkersScript(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def assets(self) -> pulumi.Output[Optional['outputs.WorkersScriptAssets']]:
        """
        Configuration for assets within a Worker
        """
        return pulumi.get(self, "assets")

    @property
    @pulumi.getter
    def bindings(self) -> pulumi.Output[Sequence['outputs.WorkersScriptBinding']]:
        """
        List of bindings attached to a Worker. You can find more about bindings on our docs: https://developers.cloudflare.com/workers/configuration/multipart-upload-metadata/#bindings.
        """
        return pulumi.get(self, "bindings")

    @property
    @pulumi.getter(name="bodyPart")
    def body_part(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the part in the multipart request that contains the script (e.g. the file adding a listener to the `fetch` event). Indicates a `service worker syntax` Worker.
        """
        return pulumi.get(self, "body_part")

    @property
    @pulumi.getter(name="compatibilityDate")
    def compatibility_date(self) -> pulumi.Output[builtins.str]:
        """
        Date indicating targeted support in the Workers runtime. Backwards incompatible fixes to the runtime following this date will not affect this Worker.
        """
        return pulumi.get(self, "compatibility_date")

    @property
    @pulumi.getter(name="compatibilityFlags")
    def compatibility_flags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Flags that enable or disable certain features in the Workers runtime. Used to enable upcoming features or opt in or out of specific changes not included in a `compatibility_date`.
        """
        return pulumi.get(self, "compatibility_flags")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[builtins.str]:
        """
        Module or Service Worker contents of the Worker.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[builtins.str]:
        """
        When the script was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Hashed script content, can be used in a If-None-Match header when updating.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="hasAssets")
    def has_assets(self) -> pulumi.Output[builtins.bool]:
        """
        Whether a Worker contains assets.
        """
        return pulumi.get(self, "has_assets")

    @property
    @pulumi.getter(name="hasModules")
    def has_modules(self) -> pulumi.Output[builtins.bool]:
        """
        Whether a Worker contains modules.
        """
        return pulumi.get(self, "has_modules")

    @property
    @pulumi.getter(name="keepAssets")
    def keep_assets(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Retain assets which exist for a previously uploaded Worker version; used in lieu of providing a completion token.
        """
        return pulumi.get(self, "keep_assets")

    @property
    @pulumi.getter(name="keepBindings")
    def keep_bindings(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of binding types to keep from previous_upload.
        """
        return pulumi.get(self, "keep_bindings")

    @property
    @pulumi.getter
    def logpush(self) -> pulumi.Output[builtins.bool]:
        """
        Whether Logpush is turned on for the Worker.
        """
        return pulumi.get(self, "logpush")

    @property
    @pulumi.getter(name="mainModule")
    def main_module(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of the part in the multipart request that contains the main module (e.g. the file exporting a `fetch` handler). Indicates a `module syntax` Worker.
        """
        return pulumi.get(self, "main_module")

    @property
    @pulumi.getter
    def migrations(self) -> pulumi.Output['outputs.WorkersScriptMigrations']:
        """
        Migrations to apply for Durable Objects associated with this Worker.
        """
        return pulumi.get(self, "migrations")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[builtins.str]:
        """
        When the script was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def observability(self) -> pulumi.Output[Optional['outputs.WorkersScriptObservability']]:
        """
        Observability settings for the Worker.
        """
        return pulumi.get(self, "observability")

    @property
    @pulumi.getter
    def placement(self) -> pulumi.Output['outputs.WorkersScriptPlacement']:
        """
        Configuration for [Smart Placement](https://developers.cloudflare.com/workers/configuration/smart-placement).
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the script, used in URLs and route configuration.
        """
        return pulumi.get(self, "script_name")

    @property
    @pulumi.getter(name="startupTimeMs")
    def startup_time_ms(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "startup_time_ms")

    @property
    @pulumi.getter(name="tailConsumers")
    def tail_consumers(self) -> pulumi.Output[Sequence['outputs.WorkersScriptTailConsumer']]:
        """
        List of Workers that will consume logs from the attached Worker.
        """
        return pulumi.get(self, "tail_consumers")

    @property
    @pulumi.getter(name="usageModel")
    def usage_model(self) -> pulumi.Output[builtins.str]:
        """
        Usage model for the Worker invocations.
        Available values: "standard".
        """
        return pulumi.get(self, "usage_model")

