# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustAccessApplicationArgs', 'ZeroTrustAccessApplication']

@pulumi.input_type
class ZeroTrustAccessApplicationArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 allow_authenticate_via_warp: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_iframe: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_idps: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 app_launcher_logo_url: Optional[pulumi.Input[builtins.str]] = None,
                 app_launcher_visible: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_redirect_to_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 bg_color: Optional[pulumi.Input[builtins.str]] = None,
                 cors_headers: Optional[pulumi.Input['ZeroTrustAccessApplicationCorsHeadersArgs']] = None,
                 custom_deny_message: Optional[pulumi.Input[builtins.str]] = None,
                 custom_deny_url: Optional[pulumi.Input[builtins.str]] = None,
                 custom_non_identity_deny_url: Optional[pulumi.Input[builtins.str]] = None,
                 custom_pages: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationDestinationArgs']]]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 enable_binding_cookie: Optional[pulumi.Input[builtins.bool]] = None,
                 footer_links: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]]] = None,
                 header_bg_color: Optional[pulumi.Input[builtins.str]] = None,
                 http_only_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None,
                 landing_page_design: Optional[pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs']] = None,
                 logo_url: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options_preflight_bypass: Optional[pulumi.Input[builtins.bool]] = None,
                 path_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationPolicyArgs']]]] = None,
                 read_service_tokens_from_header: Optional[pulumi.Input[builtins.str]] = None,
                 saas_app: Optional[pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs']] = None,
                 same_site_cookie_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 scim_config: Optional[pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs']] = None,
                 self_hosted_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 service_auth401_redirect: Optional[pulumi.Input[builtins.bool]] = None,
                 session_duration: Optional[pulumi.Input[builtins.str]] = None,
                 skip_app_launcher_login_page: Optional[pulumi.Input[builtins.bool]] = None,
                 skip_interstitial: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_criterias: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ZeroTrustAccessApplication resource.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[builtins.bool] allow_authenticate_via_warp: When set to true, users can authenticate to this application using their WARP session.  When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        :param pulumi.Input[builtins.bool] allow_iframe: Enables loading application content in an iFrame.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_idps: The identity providers your users can select when connecting to this application. Defaults to all IdPs configured in your account.
        :param pulumi.Input[builtins.str] app_launcher_logo_url: The image URL of the logo shown in the App Launcher header.
        :param pulumi.Input[builtins.bool] app_launcher_visible: Displays the application in the App Launcher.
        :param pulumi.Input[builtins.bool] auto_redirect_to_identity: When set to `true`, users skip the identity provider selection step during login. You must specify only one identity provider in allowed_idps.
        :param pulumi.Input[builtins.str] bg_color: The background color of the App Launcher page.
        :param pulumi.Input[builtins.str] custom_deny_message: The custom error message shown to a user when they are denied access to the application.
        :param pulumi.Input[builtins.str] custom_deny_url: The custom URL a user is redirected to when they are denied access to the application when failing identity-based rules.
        :param pulumi.Input[builtins.str] custom_non_identity_deny_url: The custom URL a user is redirected to when they are denied access to the application when failing non-identity rules.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_pages: The custom pages that will be displayed when applicable for this application
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationDestinationArgs']]] destinations: List of destinations secured by Access. This supersedes `self_hosted_domains` to allow for more flexibility in defining different types of domains. If `destinations` are provided, then `self_hosted_domains` will be ignored.
        :param pulumi.Input[builtins.str] domain: The primary hostname and path secured by Access. This domain will be displayed if the app is visible in the App Launcher.
        :param pulumi.Input[builtins.bool] enable_binding_cookie: Enables the binding cookie, which increases security against compromised authorization tokens and CSRF attacks.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]] footer_links: The links in the App Launcher footer.
        :param pulumi.Input[builtins.str] header_bg_color: The background color of the App Launcher header.
        :param pulumi.Input[builtins.bool] http_only_cookie_attribute: Enables the HttpOnly cookie attribute, which increases security against XSS attacks.
        :param pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs'] landing_page_design: The design of the App Launcher landing page shown to users when they log in.
        :param pulumi.Input[builtins.str] logo_url: The image URL for the logo shown in the App Launcher dashboard.
        :param pulumi.Input[builtins.str] name: The name of the application.
        :param pulumi.Input[builtins.bool] options_preflight_bypass: Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set.
        :param pulumi.Input[builtins.bool] path_cookie_attribute: Enables cookie paths to scope an application's JWT to the application path. If disabled, the JWT will scope to the hostname by default
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationPolicyArgs']]] policies: The policies that Access applies to the application, in ascending order of precedence. Items can reference existing policies or create new policies exclusive to the application.
        :param pulumi.Input[builtins.str] read_service_tokens_from_header: Allows matching Access Service Tokens passed HTTP in a single header with this name.
               This works as an alternative to the (CF-Access-Client-Id, CF-Access-Client-Secret) pair of headers.
               The header value will be interpreted as a json object similar to:
               {
               "cf-access-client-id": "88bf3b6d86161464f6509f7219099e57.access.example.com",
               "cf-access-client-secret": "bdd31cbc4dec990953e39163fbbb194c93313ca9f0a6e420346af9d326b1d2a5"
               }
        :param pulumi.Input[builtins.str] same_site_cookie_attribute: Sets the SameSite cookie setting, which provides increased security against CSRF attacks.
        :param pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs'] scim_config: Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] self_hosted_domains: List of public domains that Access will secure. This field is deprecated in favor of `destinations` and will be supported until **November 21, 2025.** If `destinations` are provided, then `self_hosted_domains` will be ignored.
        :param pulumi.Input[builtins.bool] service_auth401_redirect: Returns a 401 status code when the request is blocked by a Service Auth policy.
        :param pulumi.Input[builtins.str] session_duration: The amount of time that tokens issued for this application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h. Note: unsupported for infrastructure type applications.
        :param pulumi.Input[builtins.bool] skip_app_launcher_login_page: Determines when to skip the App Launcher landing page.
        :param pulumi.Input[builtins.bool] skip_interstitial: Enables automatic authentication through cloudflared.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags you want assigned to an application. Tags are used to filter applications in the App Launcher dashboard.
        :param pulumi.Input[builtins.str] type: The application type.
               Available values: "self*hosted", "saas", "ssh", "vnc", "app*launcher", "warp", "biso", "bookmark", "dash_sso", "infrastructure", "rdp".
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allow_authenticate_via_warp is not None:
            pulumi.set(__self__, "allow_authenticate_via_warp", allow_authenticate_via_warp)
        if allow_iframe is not None:
            pulumi.set(__self__, "allow_iframe", allow_iframe)
        if allowed_idps is not None:
            pulumi.set(__self__, "allowed_idps", allowed_idps)
        if app_launcher_logo_url is not None:
            pulumi.set(__self__, "app_launcher_logo_url", app_launcher_logo_url)
        if app_launcher_visible is not None:
            pulumi.set(__self__, "app_launcher_visible", app_launcher_visible)
        if auto_redirect_to_identity is not None:
            pulumi.set(__self__, "auto_redirect_to_identity", auto_redirect_to_identity)
        if bg_color is not None:
            pulumi.set(__self__, "bg_color", bg_color)
        if cors_headers is not None:
            pulumi.set(__self__, "cors_headers", cors_headers)
        if custom_deny_message is not None:
            pulumi.set(__self__, "custom_deny_message", custom_deny_message)
        if custom_deny_url is not None:
            pulumi.set(__self__, "custom_deny_url", custom_deny_url)
        if custom_non_identity_deny_url is not None:
            pulumi.set(__self__, "custom_non_identity_deny_url", custom_non_identity_deny_url)
        if custom_pages is not None:
            pulumi.set(__self__, "custom_pages", custom_pages)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if enable_binding_cookie is not None:
            pulumi.set(__self__, "enable_binding_cookie", enable_binding_cookie)
        if footer_links is not None:
            pulumi.set(__self__, "footer_links", footer_links)
        if header_bg_color is not None:
            pulumi.set(__self__, "header_bg_color", header_bg_color)
        if http_only_cookie_attribute is not None:
            pulumi.set(__self__, "http_only_cookie_attribute", http_only_cookie_attribute)
        if landing_page_design is not None:
            pulumi.set(__self__, "landing_page_design", landing_page_design)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options_preflight_bypass is not None:
            pulumi.set(__self__, "options_preflight_bypass", options_preflight_bypass)
        if path_cookie_attribute is not None:
            pulumi.set(__self__, "path_cookie_attribute", path_cookie_attribute)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if read_service_tokens_from_header is not None:
            pulumi.set(__self__, "read_service_tokens_from_header", read_service_tokens_from_header)
        if saas_app is not None:
            pulumi.set(__self__, "saas_app", saas_app)
        if same_site_cookie_attribute is not None:
            pulumi.set(__self__, "same_site_cookie_attribute", same_site_cookie_attribute)
        if scim_config is not None:
            pulumi.set(__self__, "scim_config", scim_config)
        if self_hosted_domains is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""self_hosted_domains is deprecated: This attribute is deprecated.""")
        if self_hosted_domains is not None:
            pulumi.set(__self__, "self_hosted_domains", self_hosted_domains)
        if service_auth401_redirect is not None:
            pulumi.set(__self__, "service_auth401_redirect", service_auth401_redirect)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if skip_app_launcher_login_page is not None:
            pulumi.set(__self__, "skip_app_launcher_login_page", skip_app_launcher_login_page)
        if skip_interstitial is not None:
            pulumi.set(__self__, "skip_interstitial", skip_interstitial)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_criterias is not None:
            pulumi.set(__self__, "target_criterias", target_criterias)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowAuthenticateViaWarp")
    def allow_authenticate_via_warp(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to true, users can authenticate to this application using their WARP session.  When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        """
        return pulumi.get(self, "allow_authenticate_via_warp")

    @allow_authenticate_via_warp.setter
    def allow_authenticate_via_warp(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_authenticate_via_warp", value)

    @property
    @pulumi.getter(name="allowIframe")
    def allow_iframe(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables loading application content in an iFrame.
        """
        return pulumi.get(self, "allow_iframe")

    @allow_iframe.setter
    def allow_iframe(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_iframe", value)

    @property
    @pulumi.getter(name="allowedIdps")
    def allowed_idps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The identity providers your users can select when connecting to this application. Defaults to all IdPs configured in your account.
        """
        return pulumi.get(self, "allowed_idps")

    @allowed_idps.setter
    def allowed_idps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_idps", value)

    @property
    @pulumi.getter(name="appLauncherLogoUrl")
    def app_launcher_logo_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The image URL of the logo shown in the App Launcher header.
        """
        return pulumi.get(self, "app_launcher_logo_url")

    @app_launcher_logo_url.setter
    def app_launcher_logo_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_launcher_logo_url", value)

    @property
    @pulumi.getter(name="appLauncherVisible")
    def app_launcher_visible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Displays the application in the App Launcher.
        """
        return pulumi.get(self, "app_launcher_visible")

    @app_launcher_visible.setter
    def app_launcher_visible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "app_launcher_visible", value)

    @property
    @pulumi.getter(name="autoRedirectToIdentity")
    def auto_redirect_to_identity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to `true`, users skip the identity provider selection step during login. You must specify only one identity provider in allowed_idps.
        """
        return pulumi.get(self, "auto_redirect_to_identity")

    @auto_redirect_to_identity.setter
    def auto_redirect_to_identity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_redirect_to_identity", value)

    @property
    @pulumi.getter(name="bgColor")
    def bg_color(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The background color of the App Launcher page.
        """
        return pulumi.get(self, "bg_color")

    @bg_color.setter
    def bg_color(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bg_color", value)

    @property
    @pulumi.getter(name="corsHeaders")
    def cors_headers(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationCorsHeadersArgs']]:
        return pulumi.get(self, "cors_headers")

    @cors_headers.setter
    def cors_headers(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationCorsHeadersArgs']]):
        pulumi.set(self, "cors_headers", value)

    @property
    @pulumi.getter(name="customDenyMessage")
    def custom_deny_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The custom error message shown to a user when they are denied access to the application.
        """
        return pulumi.get(self, "custom_deny_message")

    @custom_deny_message.setter
    def custom_deny_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_deny_message", value)

    @property
    @pulumi.getter(name="customDenyUrl")
    def custom_deny_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The custom URL a user is redirected to when they are denied access to the application when failing identity-based rules.
        """
        return pulumi.get(self, "custom_deny_url")

    @custom_deny_url.setter
    def custom_deny_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_deny_url", value)

    @property
    @pulumi.getter(name="customNonIdentityDenyUrl")
    def custom_non_identity_deny_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The custom URL a user is redirected to when they are denied access to the application when failing non-identity rules.
        """
        return pulumi.get(self, "custom_non_identity_deny_url")

    @custom_non_identity_deny_url.setter
    def custom_non_identity_deny_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_non_identity_deny_url", value)

    @property
    @pulumi.getter(name="customPages")
    def custom_pages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The custom pages that will be displayed when applicable for this application
        """
        return pulumi.get(self, "custom_pages")

    @custom_pages.setter
    def custom_pages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_pages", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationDestinationArgs']]]]:
        """
        List of destinations secured by Access. This supersedes `self_hosted_domains` to allow for more flexibility in defining different types of domains. If `destinations` are provided, then `self_hosted_domains` will be ignored.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary hostname and path secured by Access. This domain will be displayed if the app is visible in the App Launcher.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="enableBindingCookie")
    def enable_binding_cookie(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables the binding cookie, which increases security against compromised authorization tokens and CSRF attacks.
        """
        return pulumi.get(self, "enable_binding_cookie")

    @enable_binding_cookie.setter
    def enable_binding_cookie(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_binding_cookie", value)

    @property
    @pulumi.getter(name="footerLinks")
    def footer_links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]]]:
        """
        The links in the App Launcher footer.
        """
        return pulumi.get(self, "footer_links")

    @footer_links.setter
    def footer_links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]]]):
        pulumi.set(self, "footer_links", value)

    @property
    @pulumi.getter(name="headerBgColor")
    def header_bg_color(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The background color of the App Launcher header.
        """
        return pulumi.get(self, "header_bg_color")

    @header_bg_color.setter
    def header_bg_color(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "header_bg_color", value)

    @property
    @pulumi.getter(name="httpOnlyCookieAttribute")
    def http_only_cookie_attribute(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables the HttpOnly cookie attribute, which increases security against XSS attacks.
        """
        return pulumi.get(self, "http_only_cookie_attribute")

    @http_only_cookie_attribute.setter
    def http_only_cookie_attribute(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "http_only_cookie_attribute", value)

    @property
    @pulumi.getter(name="landingPageDesign")
    def landing_page_design(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs']]:
        """
        The design of the App Launcher landing page shown to users when they log in.
        """
        return pulumi.get(self, "landing_page_design")

    @landing_page_design.setter
    def landing_page_design(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs']]):
        pulumi.set(self, "landing_page_design", value)

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The image URL for the logo shown in the App Launcher dashboard.
        """
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logo_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optionsPreflightBypass")
    def options_preflight_bypass(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set.
        """
        return pulumi.get(self, "options_preflight_bypass")

    @options_preflight_bypass.setter
    def options_preflight_bypass(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "options_preflight_bypass", value)

    @property
    @pulumi.getter(name="pathCookieAttribute")
    def path_cookie_attribute(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables cookie paths to scope an application's JWT to the application path. If disabled, the JWT will scope to the hostname by default
        """
        return pulumi.get(self, "path_cookie_attribute")

    @path_cookie_attribute.setter
    def path_cookie_attribute(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "path_cookie_attribute", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationPolicyArgs']]]]:
        """
        The policies that Access applies to the application, in ascending order of precedence. Items can reference existing policies or create new policies exclusive to the application.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="readServiceTokensFromHeader")
    def read_service_tokens_from_header(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allows matching Access Service Tokens passed HTTP in a single header with this name.
        This works as an alternative to the (CF-Access-Client-Id, CF-Access-Client-Secret) pair of headers.
        The header value will be interpreted as a json object similar to:
        {
        "cf-access-client-id": "88bf3b6d86161464f6509f7219099e57.access.example.com",
        "cf-access-client-secret": "bdd31cbc4dec990953e39163fbbb194c93313ca9f0a6e420346af9d326b1d2a5"
        }
        """
        return pulumi.get(self, "read_service_tokens_from_header")

    @read_service_tokens_from_header.setter
    def read_service_tokens_from_header(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "read_service_tokens_from_header", value)

    @property
    @pulumi.getter(name="saasApp")
    def saas_app(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs']]:
        return pulumi.get(self, "saas_app")

    @saas_app.setter
    def saas_app(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs']]):
        pulumi.set(self, "saas_app", value)

    @property
    @pulumi.getter(name="sameSiteCookieAttribute")
    def same_site_cookie_attribute(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the SameSite cookie setting, which provides increased security against CSRF attacks.
        """
        return pulumi.get(self, "same_site_cookie_attribute")

    @same_site_cookie_attribute.setter
    def same_site_cookie_attribute(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "same_site_cookie_attribute", value)

    @property
    @pulumi.getter(name="scimConfig")
    def scim_config(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs']]:
        """
        Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        """
        return pulumi.get(self, "scim_config")

    @scim_config.setter
    def scim_config(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs']]):
        pulumi.set(self, "scim_config", value)

    @property
    @pulumi.getter(name="selfHostedDomains")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def self_hosted_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of public domains that Access will secure. This field is deprecated in favor of `destinations` and will be supported until **November 21, 2025.** If `destinations` are provided, then `self_hosted_domains` will be ignored.
        """
        return pulumi.get(self, "self_hosted_domains")

    @self_hosted_domains.setter
    def self_hosted_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "self_hosted_domains", value)

    @property
    @pulumi.getter(name="serviceAuth401Redirect")
    def service_auth401_redirect(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Returns a 401 status code when the request is blocked by a Service Auth policy.
        """
        return pulumi.get(self, "service_auth401_redirect")

    @service_auth401_redirect.setter
    def service_auth401_redirect(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "service_auth401_redirect", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The amount of time that tokens issued for this application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h. Note: unsupported for infrastructure type applications.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter(name="skipAppLauncherLoginPage")
    def skip_app_launcher_login_page(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines when to skip the App Launcher landing page.
        """
        return pulumi.get(self, "skip_app_launcher_login_page")

    @skip_app_launcher_login_page.setter
    def skip_app_launcher_login_page(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_app_launcher_login_page", value)

    @property
    @pulumi.getter(name="skipInterstitial")
    def skip_interstitial(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables automatic authentication through cloudflared.
        """
        return pulumi.get(self, "skip_interstitial")

    @skip_interstitial.setter
    def skip_interstitial(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_interstitial", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags you want assigned to an application. Tags are used to filter applications in the App Launcher dashboard.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetCriterias")
    def target_criterias(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]]]:
        return pulumi.get(self, "target_criterias")

    @target_criterias.setter
    def target_criterias(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]]]):
        pulumi.set(self, "target_criterias", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The application type.
        Available values: "self*hosted", "saas", "ssh", "vnc", "app*launcher", "warp", "biso", "bookmark", "dash_sso", "infrastructure", "rdp".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ZeroTrustAccessApplicationState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 allow_authenticate_via_warp: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_iframe: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_idps: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 app_launcher_logo_url: Optional[pulumi.Input[builtins.str]] = None,
                 app_launcher_visible: Optional[pulumi.Input[builtins.bool]] = None,
                 aud: Optional[pulumi.Input[builtins.str]] = None,
                 auto_redirect_to_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 bg_color: Optional[pulumi.Input[builtins.str]] = None,
                 cors_headers: Optional[pulumi.Input['ZeroTrustAccessApplicationCorsHeadersArgs']] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 custom_deny_message: Optional[pulumi.Input[builtins.str]] = None,
                 custom_deny_url: Optional[pulumi.Input[builtins.str]] = None,
                 custom_non_identity_deny_url: Optional[pulumi.Input[builtins.str]] = None,
                 custom_pages: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationDestinationArgs']]]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 enable_binding_cookie: Optional[pulumi.Input[builtins.bool]] = None,
                 footer_links: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]]] = None,
                 header_bg_color: Optional[pulumi.Input[builtins.str]] = None,
                 http_only_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None,
                 landing_page_design: Optional[pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs']] = None,
                 logo_url: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options_preflight_bypass: Optional[pulumi.Input[builtins.bool]] = None,
                 path_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationPolicyArgs']]]] = None,
                 read_service_tokens_from_header: Optional[pulumi.Input[builtins.str]] = None,
                 saas_app: Optional[pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs']] = None,
                 same_site_cookie_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 scim_config: Optional[pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs']] = None,
                 self_hosted_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 service_auth401_redirect: Optional[pulumi.Input[builtins.bool]] = None,
                 session_duration: Optional[pulumi.Input[builtins.str]] = None,
                 skip_app_launcher_login_page: Optional[pulumi.Input[builtins.bool]] = None,
                 skip_interstitial: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_criterias: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustAccessApplication resources.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[builtins.bool] allow_authenticate_via_warp: When set to true, users can authenticate to this application using their WARP session.  When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        :param pulumi.Input[builtins.bool] allow_iframe: Enables loading application content in an iFrame.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_idps: The identity providers your users can select when connecting to this application. Defaults to all IdPs configured in your account.
        :param pulumi.Input[builtins.str] app_launcher_logo_url: The image URL of the logo shown in the App Launcher header.
        :param pulumi.Input[builtins.bool] app_launcher_visible: Displays the application in the App Launcher.
        :param pulumi.Input[builtins.str] aud: Audience tag.
        :param pulumi.Input[builtins.bool] auto_redirect_to_identity: When set to `true`, users skip the identity provider selection step during login. You must specify only one identity provider in allowed_idps.
        :param pulumi.Input[builtins.str] bg_color: The background color of the App Launcher page.
        :param pulumi.Input[builtins.str] custom_deny_message: The custom error message shown to a user when they are denied access to the application.
        :param pulumi.Input[builtins.str] custom_deny_url: The custom URL a user is redirected to when they are denied access to the application when failing identity-based rules.
        :param pulumi.Input[builtins.str] custom_non_identity_deny_url: The custom URL a user is redirected to when they are denied access to the application when failing non-identity rules.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_pages: The custom pages that will be displayed when applicable for this application
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationDestinationArgs']]] destinations: List of destinations secured by Access. This supersedes `self_hosted_domains` to allow for more flexibility in defining different types of domains. If `destinations` are provided, then `self_hosted_domains` will be ignored.
        :param pulumi.Input[builtins.str] domain: The primary hostname and path secured by Access. This domain will be displayed if the app is visible in the App Launcher.
        :param pulumi.Input[builtins.bool] enable_binding_cookie: Enables the binding cookie, which increases security against compromised authorization tokens and CSRF attacks.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]] footer_links: The links in the App Launcher footer.
        :param pulumi.Input[builtins.str] header_bg_color: The background color of the App Launcher header.
        :param pulumi.Input[builtins.bool] http_only_cookie_attribute: Enables the HttpOnly cookie attribute, which increases security against XSS attacks.
        :param pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs'] landing_page_design: The design of the App Launcher landing page shown to users when they log in.
        :param pulumi.Input[builtins.str] logo_url: The image URL for the logo shown in the App Launcher dashboard.
        :param pulumi.Input[builtins.str] name: The name of the application.
        :param pulumi.Input[builtins.bool] options_preflight_bypass: Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set.
        :param pulumi.Input[builtins.bool] path_cookie_attribute: Enables cookie paths to scope an application's JWT to the application path. If disabled, the JWT will scope to the hostname by default
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationPolicyArgs']]] policies: The policies that Access applies to the application, in ascending order of precedence. Items can reference existing policies or create new policies exclusive to the application.
        :param pulumi.Input[builtins.str] read_service_tokens_from_header: Allows matching Access Service Tokens passed HTTP in a single header with this name.
               This works as an alternative to the (CF-Access-Client-Id, CF-Access-Client-Secret) pair of headers.
               The header value will be interpreted as a json object similar to:
               {
               "cf-access-client-id": "88bf3b6d86161464f6509f7219099e57.access.example.com",
               "cf-access-client-secret": "bdd31cbc4dec990953e39163fbbb194c93313ca9f0a6e420346af9d326b1d2a5"
               }
        :param pulumi.Input[builtins.str] same_site_cookie_attribute: Sets the SameSite cookie setting, which provides increased security against CSRF attacks.
        :param pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs'] scim_config: Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] self_hosted_domains: List of public domains that Access will secure. This field is deprecated in favor of `destinations` and will be supported until **November 21, 2025.** If `destinations` are provided, then `self_hosted_domains` will be ignored.
        :param pulumi.Input[builtins.bool] service_auth401_redirect: Returns a 401 status code when the request is blocked by a Service Auth policy.
        :param pulumi.Input[builtins.str] session_duration: The amount of time that tokens issued for this application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h. Note: unsupported for infrastructure type applications.
        :param pulumi.Input[builtins.bool] skip_app_launcher_login_page: Determines when to skip the App Launcher landing page.
        :param pulumi.Input[builtins.bool] skip_interstitial: Enables automatic authentication through cloudflared.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags you want assigned to an application. Tags are used to filter applications in the App Launcher dashboard.
        :param pulumi.Input[builtins.str] type: The application type.
               Available values: "self*hosted", "saas", "ssh", "vnc", "app*launcher", "warp", "biso", "bookmark", "dash_sso", "infrastructure", "rdp".
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allow_authenticate_via_warp is not None:
            pulumi.set(__self__, "allow_authenticate_via_warp", allow_authenticate_via_warp)
        if allow_iframe is not None:
            pulumi.set(__self__, "allow_iframe", allow_iframe)
        if allowed_idps is not None:
            pulumi.set(__self__, "allowed_idps", allowed_idps)
        if app_launcher_logo_url is not None:
            pulumi.set(__self__, "app_launcher_logo_url", app_launcher_logo_url)
        if app_launcher_visible is not None:
            pulumi.set(__self__, "app_launcher_visible", app_launcher_visible)
        if aud is not None:
            pulumi.set(__self__, "aud", aud)
        if auto_redirect_to_identity is not None:
            pulumi.set(__self__, "auto_redirect_to_identity", auto_redirect_to_identity)
        if bg_color is not None:
            pulumi.set(__self__, "bg_color", bg_color)
        if cors_headers is not None:
            pulumi.set(__self__, "cors_headers", cors_headers)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if custom_deny_message is not None:
            pulumi.set(__self__, "custom_deny_message", custom_deny_message)
        if custom_deny_url is not None:
            pulumi.set(__self__, "custom_deny_url", custom_deny_url)
        if custom_non_identity_deny_url is not None:
            pulumi.set(__self__, "custom_non_identity_deny_url", custom_non_identity_deny_url)
        if custom_pages is not None:
            pulumi.set(__self__, "custom_pages", custom_pages)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if enable_binding_cookie is not None:
            pulumi.set(__self__, "enable_binding_cookie", enable_binding_cookie)
        if footer_links is not None:
            pulumi.set(__self__, "footer_links", footer_links)
        if header_bg_color is not None:
            pulumi.set(__self__, "header_bg_color", header_bg_color)
        if http_only_cookie_attribute is not None:
            pulumi.set(__self__, "http_only_cookie_attribute", http_only_cookie_attribute)
        if landing_page_design is not None:
            pulumi.set(__self__, "landing_page_design", landing_page_design)
        if logo_url is not None:
            pulumi.set(__self__, "logo_url", logo_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options_preflight_bypass is not None:
            pulumi.set(__self__, "options_preflight_bypass", options_preflight_bypass)
        if path_cookie_attribute is not None:
            pulumi.set(__self__, "path_cookie_attribute", path_cookie_attribute)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if read_service_tokens_from_header is not None:
            pulumi.set(__self__, "read_service_tokens_from_header", read_service_tokens_from_header)
        if saas_app is not None:
            pulumi.set(__self__, "saas_app", saas_app)
        if same_site_cookie_attribute is not None:
            pulumi.set(__self__, "same_site_cookie_attribute", same_site_cookie_attribute)
        if scim_config is not None:
            pulumi.set(__self__, "scim_config", scim_config)
        if self_hosted_domains is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""self_hosted_domains is deprecated: This attribute is deprecated.""")
        if self_hosted_domains is not None:
            pulumi.set(__self__, "self_hosted_domains", self_hosted_domains)
        if service_auth401_redirect is not None:
            pulumi.set(__self__, "service_auth401_redirect", service_auth401_redirect)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if skip_app_launcher_login_page is not None:
            pulumi.set(__self__, "skip_app_launcher_login_page", skip_app_launcher_login_page)
        if skip_interstitial is not None:
            pulumi.set(__self__, "skip_interstitial", skip_interstitial)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_criterias is not None:
            pulumi.set(__self__, "target_criterias", target_criterias)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowAuthenticateViaWarp")
    def allow_authenticate_via_warp(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to true, users can authenticate to this application using their WARP session.  When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        """
        return pulumi.get(self, "allow_authenticate_via_warp")

    @allow_authenticate_via_warp.setter
    def allow_authenticate_via_warp(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_authenticate_via_warp", value)

    @property
    @pulumi.getter(name="allowIframe")
    def allow_iframe(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables loading application content in an iFrame.
        """
        return pulumi.get(self, "allow_iframe")

    @allow_iframe.setter
    def allow_iframe(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_iframe", value)

    @property
    @pulumi.getter(name="allowedIdps")
    def allowed_idps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The identity providers your users can select when connecting to this application. Defaults to all IdPs configured in your account.
        """
        return pulumi.get(self, "allowed_idps")

    @allowed_idps.setter
    def allowed_idps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_idps", value)

    @property
    @pulumi.getter(name="appLauncherLogoUrl")
    def app_launcher_logo_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The image URL of the logo shown in the App Launcher header.
        """
        return pulumi.get(self, "app_launcher_logo_url")

    @app_launcher_logo_url.setter
    def app_launcher_logo_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_launcher_logo_url", value)

    @property
    @pulumi.getter(name="appLauncherVisible")
    def app_launcher_visible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Displays the application in the App Launcher.
        """
        return pulumi.get(self, "app_launcher_visible")

    @app_launcher_visible.setter
    def app_launcher_visible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "app_launcher_visible", value)

    @property
    @pulumi.getter
    def aud(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Audience tag.
        """
        return pulumi.get(self, "aud")

    @aud.setter
    def aud(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aud", value)

    @property
    @pulumi.getter(name="autoRedirectToIdentity")
    def auto_redirect_to_identity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to `true`, users skip the identity provider selection step during login. You must specify only one identity provider in allowed_idps.
        """
        return pulumi.get(self, "auto_redirect_to_identity")

    @auto_redirect_to_identity.setter
    def auto_redirect_to_identity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_redirect_to_identity", value)

    @property
    @pulumi.getter(name="bgColor")
    def bg_color(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The background color of the App Launcher page.
        """
        return pulumi.get(self, "bg_color")

    @bg_color.setter
    def bg_color(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bg_color", value)

    @property
    @pulumi.getter(name="corsHeaders")
    def cors_headers(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationCorsHeadersArgs']]:
        return pulumi.get(self, "cors_headers")

    @cors_headers.setter
    def cors_headers(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationCorsHeadersArgs']]):
        pulumi.set(self, "cors_headers", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="customDenyMessage")
    def custom_deny_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The custom error message shown to a user when they are denied access to the application.
        """
        return pulumi.get(self, "custom_deny_message")

    @custom_deny_message.setter
    def custom_deny_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_deny_message", value)

    @property
    @pulumi.getter(name="customDenyUrl")
    def custom_deny_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The custom URL a user is redirected to when they are denied access to the application when failing identity-based rules.
        """
        return pulumi.get(self, "custom_deny_url")

    @custom_deny_url.setter
    def custom_deny_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_deny_url", value)

    @property
    @pulumi.getter(name="customNonIdentityDenyUrl")
    def custom_non_identity_deny_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The custom URL a user is redirected to when they are denied access to the application when failing non-identity rules.
        """
        return pulumi.get(self, "custom_non_identity_deny_url")

    @custom_non_identity_deny_url.setter
    def custom_non_identity_deny_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_non_identity_deny_url", value)

    @property
    @pulumi.getter(name="customPages")
    def custom_pages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The custom pages that will be displayed when applicable for this application
        """
        return pulumi.get(self, "custom_pages")

    @custom_pages.setter
    def custom_pages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_pages", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationDestinationArgs']]]]:
        """
        List of destinations secured by Access. This supersedes `self_hosted_domains` to allow for more flexibility in defining different types of domains. If `destinations` are provided, then `self_hosted_domains` will be ignored.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The primary hostname and path secured by Access. This domain will be displayed if the app is visible in the App Launcher.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="enableBindingCookie")
    def enable_binding_cookie(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables the binding cookie, which increases security against compromised authorization tokens and CSRF attacks.
        """
        return pulumi.get(self, "enable_binding_cookie")

    @enable_binding_cookie.setter
    def enable_binding_cookie(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_binding_cookie", value)

    @property
    @pulumi.getter(name="footerLinks")
    def footer_links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]]]:
        """
        The links in the App Launcher footer.
        """
        return pulumi.get(self, "footer_links")

    @footer_links.setter
    def footer_links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationFooterLinkArgs']]]]):
        pulumi.set(self, "footer_links", value)

    @property
    @pulumi.getter(name="headerBgColor")
    def header_bg_color(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The background color of the App Launcher header.
        """
        return pulumi.get(self, "header_bg_color")

    @header_bg_color.setter
    def header_bg_color(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "header_bg_color", value)

    @property
    @pulumi.getter(name="httpOnlyCookieAttribute")
    def http_only_cookie_attribute(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables the HttpOnly cookie attribute, which increases security against XSS attacks.
        """
        return pulumi.get(self, "http_only_cookie_attribute")

    @http_only_cookie_attribute.setter
    def http_only_cookie_attribute(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "http_only_cookie_attribute", value)

    @property
    @pulumi.getter(name="landingPageDesign")
    def landing_page_design(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs']]:
        """
        The design of the App Launcher landing page shown to users when they log in.
        """
        return pulumi.get(self, "landing_page_design")

    @landing_page_design.setter
    def landing_page_design(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationLandingPageDesignArgs']]):
        pulumi.set(self, "landing_page_design", value)

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The image URL for the logo shown in the App Launcher dashboard.
        """
        return pulumi.get(self, "logo_url")

    @logo_url.setter
    def logo_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logo_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optionsPreflightBypass")
    def options_preflight_bypass(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set.
        """
        return pulumi.get(self, "options_preflight_bypass")

    @options_preflight_bypass.setter
    def options_preflight_bypass(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "options_preflight_bypass", value)

    @property
    @pulumi.getter(name="pathCookieAttribute")
    def path_cookie_attribute(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables cookie paths to scope an application's JWT to the application path. If disabled, the JWT will scope to the hostname by default
        """
        return pulumi.get(self, "path_cookie_attribute")

    @path_cookie_attribute.setter
    def path_cookie_attribute(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "path_cookie_attribute", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationPolicyArgs']]]]:
        """
        The policies that Access applies to the application, in ascending order of precedence. Items can reference existing policies or create new policies exclusive to the application.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="readServiceTokensFromHeader")
    def read_service_tokens_from_header(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allows matching Access Service Tokens passed HTTP in a single header with this name.
        This works as an alternative to the (CF-Access-Client-Id, CF-Access-Client-Secret) pair of headers.
        The header value will be interpreted as a json object similar to:
        {
        "cf-access-client-id": "88bf3b6d86161464f6509f7219099e57.access.example.com",
        "cf-access-client-secret": "bdd31cbc4dec990953e39163fbbb194c93313ca9f0a6e420346af9d326b1d2a5"
        }
        """
        return pulumi.get(self, "read_service_tokens_from_header")

    @read_service_tokens_from_header.setter
    def read_service_tokens_from_header(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "read_service_tokens_from_header", value)

    @property
    @pulumi.getter(name="saasApp")
    def saas_app(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs']]:
        return pulumi.get(self, "saas_app")

    @saas_app.setter
    def saas_app(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationSaasAppArgs']]):
        pulumi.set(self, "saas_app", value)

    @property
    @pulumi.getter(name="sameSiteCookieAttribute")
    def same_site_cookie_attribute(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the SameSite cookie setting, which provides increased security against CSRF attacks.
        """
        return pulumi.get(self, "same_site_cookie_attribute")

    @same_site_cookie_attribute.setter
    def same_site_cookie_attribute(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "same_site_cookie_attribute", value)

    @property
    @pulumi.getter(name="scimConfig")
    def scim_config(self) -> Optional[pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs']]:
        """
        Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        """
        return pulumi.get(self, "scim_config")

    @scim_config.setter
    def scim_config(self, value: Optional[pulumi.Input['ZeroTrustAccessApplicationScimConfigArgs']]):
        pulumi.set(self, "scim_config", value)

    @property
    @pulumi.getter(name="selfHostedDomains")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def self_hosted_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of public domains that Access will secure. This field is deprecated in favor of `destinations` and will be supported until **November 21, 2025.** If `destinations` are provided, then `self_hosted_domains` will be ignored.
        """
        return pulumi.get(self, "self_hosted_domains")

    @self_hosted_domains.setter
    def self_hosted_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "self_hosted_domains", value)

    @property
    @pulumi.getter(name="serviceAuth401Redirect")
    def service_auth401_redirect(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Returns a 401 status code when the request is blocked by a Service Auth policy.
        """
        return pulumi.get(self, "service_auth401_redirect")

    @service_auth401_redirect.setter
    def service_auth401_redirect(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "service_auth401_redirect", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The amount of time that tokens issued for this application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h. Note: unsupported for infrastructure type applications.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter(name="skipAppLauncherLoginPage")
    def skip_app_launcher_login_page(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines when to skip the App Launcher landing page.
        """
        return pulumi.get(self, "skip_app_launcher_login_page")

    @skip_app_launcher_login_page.setter
    def skip_app_launcher_login_page(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_app_launcher_login_page", value)

    @property
    @pulumi.getter(name="skipInterstitial")
    def skip_interstitial(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables automatic authentication through cloudflared.
        """
        return pulumi.get(self, "skip_interstitial")

    @skip_interstitial.setter
    def skip_interstitial(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_interstitial", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags you want assigned to an application. Tags are used to filter applications in the App Launcher dashboard.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetCriterias")
    def target_criterias(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]]]:
        return pulumi.get(self, "target_criterias")

    @target_criterias.setter
    def target_criterias(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessApplicationTargetCriteriaArgs']]]]):
        pulumi.set(self, "target_criterias", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The application type.
        Available values: "self*hosted", "saas", "ssh", "vnc", "app*launcher", "warp", "biso", "bookmark", "dash_sso", "infrastructure", "rdp".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/zeroTrustAccessApplication:ZeroTrustAccessApplication")
class ZeroTrustAccessApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 allow_authenticate_via_warp: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_iframe: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_idps: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 app_launcher_logo_url: Optional[pulumi.Input[builtins.str]] = None,
                 app_launcher_visible: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_redirect_to_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 bg_color: Optional[pulumi.Input[builtins.str]] = None,
                 cors_headers: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationCorsHeadersArgs', 'ZeroTrustAccessApplicationCorsHeadersArgsDict']]] = None,
                 custom_deny_message: Optional[pulumi.Input[builtins.str]] = None,
                 custom_deny_url: Optional[pulumi.Input[builtins.str]] = None,
                 custom_non_identity_deny_url: Optional[pulumi.Input[builtins.str]] = None,
                 custom_pages: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationDestinationArgs', 'ZeroTrustAccessApplicationDestinationArgsDict']]]]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 enable_binding_cookie: Optional[pulumi.Input[builtins.bool]] = None,
                 footer_links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationFooterLinkArgs', 'ZeroTrustAccessApplicationFooterLinkArgsDict']]]]] = None,
                 header_bg_color: Optional[pulumi.Input[builtins.str]] = None,
                 http_only_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None,
                 landing_page_design: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationLandingPageDesignArgs', 'ZeroTrustAccessApplicationLandingPageDesignArgsDict']]] = None,
                 logo_url: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options_preflight_bypass: Optional[pulumi.Input[builtins.bool]] = None,
                 path_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationPolicyArgs', 'ZeroTrustAccessApplicationPolicyArgsDict']]]]] = None,
                 read_service_tokens_from_header: Optional[pulumi.Input[builtins.str]] = None,
                 saas_app: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationSaasAppArgs', 'ZeroTrustAccessApplicationSaasAppArgsDict']]] = None,
                 same_site_cookie_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 scim_config: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationScimConfigArgs', 'ZeroTrustAccessApplicationScimConfigArgsDict']]] = None,
                 self_hosted_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 service_auth401_redirect: Optional[pulumi.Input[builtins.bool]] = None,
                 session_duration: Optional[pulumi.Input[builtins.str]] = None,
                 skip_app_launcher_login_page: Optional[pulumi.Input[builtins.bool]] = None,
                 skip_interstitial: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationTargetCriteriaArgs', 'ZeroTrustAccessApplicationTargetCriteriaArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessApplication:ZeroTrustAccessApplication example '<{accounts|zones}/{account_id|zone_id}>/<app_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[builtins.bool] allow_authenticate_via_warp: When set to true, users can authenticate to this application using their WARP session.  When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        :param pulumi.Input[builtins.bool] allow_iframe: Enables loading application content in an iFrame.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_idps: The identity providers your users can select when connecting to this application. Defaults to all IdPs configured in your account.
        :param pulumi.Input[builtins.str] app_launcher_logo_url: The image URL of the logo shown in the App Launcher header.
        :param pulumi.Input[builtins.bool] app_launcher_visible: Displays the application in the App Launcher.
        :param pulumi.Input[builtins.bool] auto_redirect_to_identity: When set to `true`, users skip the identity provider selection step during login. You must specify only one identity provider in allowed_idps.
        :param pulumi.Input[builtins.str] bg_color: The background color of the App Launcher page.
        :param pulumi.Input[builtins.str] custom_deny_message: The custom error message shown to a user when they are denied access to the application.
        :param pulumi.Input[builtins.str] custom_deny_url: The custom URL a user is redirected to when they are denied access to the application when failing identity-based rules.
        :param pulumi.Input[builtins.str] custom_non_identity_deny_url: The custom URL a user is redirected to when they are denied access to the application when failing non-identity rules.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_pages: The custom pages that will be displayed when applicable for this application
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationDestinationArgs', 'ZeroTrustAccessApplicationDestinationArgsDict']]]] destinations: List of destinations secured by Access. This supersedes `self_hosted_domains` to allow for more flexibility in defining different types of domains. If `destinations` are provided, then `self_hosted_domains` will be ignored.
        :param pulumi.Input[builtins.str] domain: The primary hostname and path secured by Access. This domain will be displayed if the app is visible in the App Launcher.
        :param pulumi.Input[builtins.bool] enable_binding_cookie: Enables the binding cookie, which increases security against compromised authorization tokens and CSRF attacks.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationFooterLinkArgs', 'ZeroTrustAccessApplicationFooterLinkArgsDict']]]] footer_links: The links in the App Launcher footer.
        :param pulumi.Input[builtins.str] header_bg_color: The background color of the App Launcher header.
        :param pulumi.Input[builtins.bool] http_only_cookie_attribute: Enables the HttpOnly cookie attribute, which increases security against XSS attacks.
        :param pulumi.Input[Union['ZeroTrustAccessApplicationLandingPageDesignArgs', 'ZeroTrustAccessApplicationLandingPageDesignArgsDict']] landing_page_design: The design of the App Launcher landing page shown to users when they log in.
        :param pulumi.Input[builtins.str] logo_url: The image URL for the logo shown in the App Launcher dashboard.
        :param pulumi.Input[builtins.str] name: The name of the application.
        :param pulumi.Input[builtins.bool] options_preflight_bypass: Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set.
        :param pulumi.Input[builtins.bool] path_cookie_attribute: Enables cookie paths to scope an application's JWT to the application path. If disabled, the JWT will scope to the hostname by default
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationPolicyArgs', 'ZeroTrustAccessApplicationPolicyArgsDict']]]] policies: The policies that Access applies to the application, in ascending order of precedence. Items can reference existing policies or create new policies exclusive to the application.
        :param pulumi.Input[builtins.str] read_service_tokens_from_header: Allows matching Access Service Tokens passed HTTP in a single header with this name.
               This works as an alternative to the (CF-Access-Client-Id, CF-Access-Client-Secret) pair of headers.
               The header value will be interpreted as a json object similar to:
               {
               "cf-access-client-id": "88bf3b6d86161464f6509f7219099e57.access.example.com",
               "cf-access-client-secret": "bdd31cbc4dec990953e39163fbbb194c93313ca9f0a6e420346af9d326b1d2a5"
               }
        :param pulumi.Input[builtins.str] same_site_cookie_attribute: Sets the SameSite cookie setting, which provides increased security against CSRF attacks.
        :param pulumi.Input[Union['ZeroTrustAccessApplicationScimConfigArgs', 'ZeroTrustAccessApplicationScimConfigArgsDict']] scim_config: Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] self_hosted_domains: List of public domains that Access will secure. This field is deprecated in favor of `destinations` and will be supported until **November 21, 2025.** If `destinations` are provided, then `self_hosted_domains` will be ignored.
        :param pulumi.Input[builtins.bool] service_auth401_redirect: Returns a 401 status code when the request is blocked by a Service Auth policy.
        :param pulumi.Input[builtins.str] session_duration: The amount of time that tokens issued for this application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h. Note: unsupported for infrastructure type applications.
        :param pulumi.Input[builtins.bool] skip_app_launcher_login_page: Determines when to skip the App Launcher landing page.
        :param pulumi.Input[builtins.bool] skip_interstitial: Enables automatic authentication through cloudflared.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags you want assigned to an application. Tags are used to filter applications in the App Launcher dashboard.
        :param pulumi.Input[builtins.str] type: The application type.
               Available values: "self*hosted", "saas", "ssh", "vnc", "app*launcher", "warp", "biso", "bookmark", "dash_sso", "infrastructure", "rdp".
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ZeroTrustAccessApplicationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessApplication:ZeroTrustAccessApplication example '<{accounts|zones}/{account_id|zone_id}>/<app_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustAccessApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustAccessApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 allow_authenticate_via_warp: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_iframe: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_idps: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 app_launcher_logo_url: Optional[pulumi.Input[builtins.str]] = None,
                 app_launcher_visible: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_redirect_to_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 bg_color: Optional[pulumi.Input[builtins.str]] = None,
                 cors_headers: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationCorsHeadersArgs', 'ZeroTrustAccessApplicationCorsHeadersArgsDict']]] = None,
                 custom_deny_message: Optional[pulumi.Input[builtins.str]] = None,
                 custom_deny_url: Optional[pulumi.Input[builtins.str]] = None,
                 custom_non_identity_deny_url: Optional[pulumi.Input[builtins.str]] = None,
                 custom_pages: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationDestinationArgs', 'ZeroTrustAccessApplicationDestinationArgsDict']]]]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 enable_binding_cookie: Optional[pulumi.Input[builtins.bool]] = None,
                 footer_links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationFooterLinkArgs', 'ZeroTrustAccessApplicationFooterLinkArgsDict']]]]] = None,
                 header_bg_color: Optional[pulumi.Input[builtins.str]] = None,
                 http_only_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None,
                 landing_page_design: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationLandingPageDesignArgs', 'ZeroTrustAccessApplicationLandingPageDesignArgsDict']]] = None,
                 logo_url: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options_preflight_bypass: Optional[pulumi.Input[builtins.bool]] = None,
                 path_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationPolicyArgs', 'ZeroTrustAccessApplicationPolicyArgsDict']]]]] = None,
                 read_service_tokens_from_header: Optional[pulumi.Input[builtins.str]] = None,
                 saas_app: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationSaasAppArgs', 'ZeroTrustAccessApplicationSaasAppArgsDict']]] = None,
                 same_site_cookie_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 scim_config: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationScimConfigArgs', 'ZeroTrustAccessApplicationScimConfigArgsDict']]] = None,
                 self_hosted_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 service_auth401_redirect: Optional[pulumi.Input[builtins.bool]] = None,
                 session_duration: Optional[pulumi.Input[builtins.str]] = None,
                 skip_app_launcher_login_page: Optional[pulumi.Input[builtins.bool]] = None,
                 skip_interstitial: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationTargetCriteriaArgs', 'ZeroTrustAccessApplicationTargetCriteriaArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustAccessApplicationArgs.__new__(ZeroTrustAccessApplicationArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["allow_authenticate_via_warp"] = allow_authenticate_via_warp
            __props__.__dict__["allow_iframe"] = allow_iframe
            __props__.__dict__["allowed_idps"] = allowed_idps
            __props__.__dict__["app_launcher_logo_url"] = app_launcher_logo_url
            __props__.__dict__["app_launcher_visible"] = app_launcher_visible
            __props__.__dict__["auto_redirect_to_identity"] = auto_redirect_to_identity
            __props__.__dict__["bg_color"] = bg_color
            __props__.__dict__["cors_headers"] = cors_headers
            __props__.__dict__["custom_deny_message"] = custom_deny_message
            __props__.__dict__["custom_deny_url"] = custom_deny_url
            __props__.__dict__["custom_non_identity_deny_url"] = custom_non_identity_deny_url
            __props__.__dict__["custom_pages"] = custom_pages
            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["domain"] = domain
            __props__.__dict__["enable_binding_cookie"] = enable_binding_cookie
            __props__.__dict__["footer_links"] = footer_links
            __props__.__dict__["header_bg_color"] = header_bg_color
            __props__.__dict__["http_only_cookie_attribute"] = http_only_cookie_attribute
            __props__.__dict__["landing_page_design"] = landing_page_design
            __props__.__dict__["logo_url"] = logo_url
            __props__.__dict__["name"] = name
            __props__.__dict__["options_preflight_bypass"] = options_preflight_bypass
            __props__.__dict__["path_cookie_attribute"] = path_cookie_attribute
            __props__.__dict__["policies"] = policies
            __props__.__dict__["read_service_tokens_from_header"] = read_service_tokens_from_header
            __props__.__dict__["saas_app"] = saas_app
            __props__.__dict__["same_site_cookie_attribute"] = same_site_cookie_attribute
            __props__.__dict__["scim_config"] = scim_config
            __props__.__dict__["self_hosted_domains"] = self_hosted_domains
            __props__.__dict__["service_auth401_redirect"] = service_auth401_redirect
            __props__.__dict__["session_duration"] = session_duration
            __props__.__dict__["skip_app_launcher_login_page"] = skip_app_launcher_login_page
            __props__.__dict__["skip_interstitial"] = skip_interstitial
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_criterias"] = target_criterias
            __props__.__dict__["type"] = type
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["aud"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/accessApplication:AccessApplication")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ZeroTrustAccessApplication, __self__).__init__(
            'cloudflare:index/zeroTrustAccessApplication:ZeroTrustAccessApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            allow_authenticate_via_warp: Optional[pulumi.Input[builtins.bool]] = None,
            allow_iframe: Optional[pulumi.Input[builtins.bool]] = None,
            allowed_idps: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            app_launcher_logo_url: Optional[pulumi.Input[builtins.str]] = None,
            app_launcher_visible: Optional[pulumi.Input[builtins.bool]] = None,
            aud: Optional[pulumi.Input[builtins.str]] = None,
            auto_redirect_to_identity: Optional[pulumi.Input[builtins.bool]] = None,
            bg_color: Optional[pulumi.Input[builtins.str]] = None,
            cors_headers: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationCorsHeadersArgs', 'ZeroTrustAccessApplicationCorsHeadersArgsDict']]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            custom_deny_message: Optional[pulumi.Input[builtins.str]] = None,
            custom_deny_url: Optional[pulumi.Input[builtins.str]] = None,
            custom_non_identity_deny_url: Optional[pulumi.Input[builtins.str]] = None,
            custom_pages: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationDestinationArgs', 'ZeroTrustAccessApplicationDestinationArgsDict']]]]] = None,
            domain: Optional[pulumi.Input[builtins.str]] = None,
            enable_binding_cookie: Optional[pulumi.Input[builtins.bool]] = None,
            footer_links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationFooterLinkArgs', 'ZeroTrustAccessApplicationFooterLinkArgsDict']]]]] = None,
            header_bg_color: Optional[pulumi.Input[builtins.str]] = None,
            http_only_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None,
            landing_page_design: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationLandingPageDesignArgs', 'ZeroTrustAccessApplicationLandingPageDesignArgsDict']]] = None,
            logo_url: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            options_preflight_bypass: Optional[pulumi.Input[builtins.bool]] = None,
            path_cookie_attribute: Optional[pulumi.Input[builtins.bool]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationPolicyArgs', 'ZeroTrustAccessApplicationPolicyArgsDict']]]]] = None,
            read_service_tokens_from_header: Optional[pulumi.Input[builtins.str]] = None,
            saas_app: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationSaasAppArgs', 'ZeroTrustAccessApplicationSaasAppArgsDict']]] = None,
            same_site_cookie_attribute: Optional[pulumi.Input[builtins.str]] = None,
            scim_config: Optional[pulumi.Input[Union['ZeroTrustAccessApplicationScimConfigArgs', 'ZeroTrustAccessApplicationScimConfigArgsDict']]] = None,
            self_hosted_domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            service_auth401_redirect: Optional[pulumi.Input[builtins.bool]] = None,
            session_duration: Optional[pulumi.Input[builtins.str]] = None,
            skip_app_launcher_login_page: Optional[pulumi.Input[builtins.bool]] = None,
            skip_interstitial: Optional[pulumi.Input[builtins.bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            target_criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationTargetCriteriaArgs', 'ZeroTrustAccessApplicationTargetCriteriaArgsDict']]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ZeroTrustAccessApplication':
        """
        Get an existing ZeroTrustAccessApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[builtins.bool] allow_authenticate_via_warp: When set to true, users can authenticate to this application using their WARP session.  When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        :param pulumi.Input[builtins.bool] allow_iframe: Enables loading application content in an iFrame.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_idps: The identity providers your users can select when connecting to this application. Defaults to all IdPs configured in your account.
        :param pulumi.Input[builtins.str] app_launcher_logo_url: The image URL of the logo shown in the App Launcher header.
        :param pulumi.Input[builtins.bool] app_launcher_visible: Displays the application in the App Launcher.
        :param pulumi.Input[builtins.str] aud: Audience tag.
        :param pulumi.Input[builtins.bool] auto_redirect_to_identity: When set to `true`, users skip the identity provider selection step during login. You must specify only one identity provider in allowed_idps.
        :param pulumi.Input[builtins.str] bg_color: The background color of the App Launcher page.
        :param pulumi.Input[builtins.str] custom_deny_message: The custom error message shown to a user when they are denied access to the application.
        :param pulumi.Input[builtins.str] custom_deny_url: The custom URL a user is redirected to when they are denied access to the application when failing identity-based rules.
        :param pulumi.Input[builtins.str] custom_non_identity_deny_url: The custom URL a user is redirected to when they are denied access to the application when failing non-identity rules.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] custom_pages: The custom pages that will be displayed when applicable for this application
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationDestinationArgs', 'ZeroTrustAccessApplicationDestinationArgsDict']]]] destinations: List of destinations secured by Access. This supersedes `self_hosted_domains` to allow for more flexibility in defining different types of domains. If `destinations` are provided, then `self_hosted_domains` will be ignored.
        :param pulumi.Input[builtins.str] domain: The primary hostname and path secured by Access. This domain will be displayed if the app is visible in the App Launcher.
        :param pulumi.Input[builtins.bool] enable_binding_cookie: Enables the binding cookie, which increases security against compromised authorization tokens and CSRF attacks.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationFooterLinkArgs', 'ZeroTrustAccessApplicationFooterLinkArgsDict']]]] footer_links: The links in the App Launcher footer.
        :param pulumi.Input[builtins.str] header_bg_color: The background color of the App Launcher header.
        :param pulumi.Input[builtins.bool] http_only_cookie_attribute: Enables the HttpOnly cookie attribute, which increases security against XSS attacks.
        :param pulumi.Input[Union['ZeroTrustAccessApplicationLandingPageDesignArgs', 'ZeroTrustAccessApplicationLandingPageDesignArgsDict']] landing_page_design: The design of the App Launcher landing page shown to users when they log in.
        :param pulumi.Input[builtins.str] logo_url: The image URL for the logo shown in the App Launcher dashboard.
        :param pulumi.Input[builtins.str] name: The name of the application.
        :param pulumi.Input[builtins.bool] options_preflight_bypass: Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set.
        :param pulumi.Input[builtins.bool] path_cookie_attribute: Enables cookie paths to scope an application's JWT to the application path. If disabled, the JWT will scope to the hostname by default
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessApplicationPolicyArgs', 'ZeroTrustAccessApplicationPolicyArgsDict']]]] policies: The policies that Access applies to the application, in ascending order of precedence. Items can reference existing policies or create new policies exclusive to the application.
        :param pulumi.Input[builtins.str] read_service_tokens_from_header: Allows matching Access Service Tokens passed HTTP in a single header with this name.
               This works as an alternative to the (CF-Access-Client-Id, CF-Access-Client-Secret) pair of headers.
               The header value will be interpreted as a json object similar to:
               {
               "cf-access-client-id": "88bf3b6d86161464f6509f7219099e57.access.example.com",
               "cf-access-client-secret": "bdd31cbc4dec990953e39163fbbb194c93313ca9f0a6e420346af9d326b1d2a5"
               }
        :param pulumi.Input[builtins.str] same_site_cookie_attribute: Sets the SameSite cookie setting, which provides increased security against CSRF attacks.
        :param pulumi.Input[Union['ZeroTrustAccessApplicationScimConfigArgs', 'ZeroTrustAccessApplicationScimConfigArgsDict']] scim_config: Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] self_hosted_domains: List of public domains that Access will secure. This field is deprecated in favor of `destinations` and will be supported until **November 21, 2025.** If `destinations` are provided, then `self_hosted_domains` will be ignored.
        :param pulumi.Input[builtins.bool] service_auth401_redirect: Returns a 401 status code when the request is blocked by a Service Auth policy.
        :param pulumi.Input[builtins.str] session_duration: The amount of time that tokens issued for this application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h. Note: unsupported for infrastructure type applications.
        :param pulumi.Input[builtins.bool] skip_app_launcher_login_page: Determines when to skip the App Launcher landing page.
        :param pulumi.Input[builtins.bool] skip_interstitial: Enables automatic authentication through cloudflared.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags you want assigned to an application. Tags are used to filter applications in the App Launcher dashboard.
        :param pulumi.Input[builtins.str] type: The application type.
               Available values: "self*hosted", "saas", "ssh", "vnc", "app*launcher", "warp", "biso", "bookmark", "dash_sso", "infrastructure", "rdp".
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustAccessApplicationState.__new__(_ZeroTrustAccessApplicationState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["allow_authenticate_via_warp"] = allow_authenticate_via_warp
        __props__.__dict__["allow_iframe"] = allow_iframe
        __props__.__dict__["allowed_idps"] = allowed_idps
        __props__.__dict__["app_launcher_logo_url"] = app_launcher_logo_url
        __props__.__dict__["app_launcher_visible"] = app_launcher_visible
        __props__.__dict__["aud"] = aud
        __props__.__dict__["auto_redirect_to_identity"] = auto_redirect_to_identity
        __props__.__dict__["bg_color"] = bg_color
        __props__.__dict__["cors_headers"] = cors_headers
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["custom_deny_message"] = custom_deny_message
        __props__.__dict__["custom_deny_url"] = custom_deny_url
        __props__.__dict__["custom_non_identity_deny_url"] = custom_non_identity_deny_url
        __props__.__dict__["custom_pages"] = custom_pages
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["domain"] = domain
        __props__.__dict__["enable_binding_cookie"] = enable_binding_cookie
        __props__.__dict__["footer_links"] = footer_links
        __props__.__dict__["header_bg_color"] = header_bg_color
        __props__.__dict__["http_only_cookie_attribute"] = http_only_cookie_attribute
        __props__.__dict__["landing_page_design"] = landing_page_design
        __props__.__dict__["logo_url"] = logo_url
        __props__.__dict__["name"] = name
        __props__.__dict__["options_preflight_bypass"] = options_preflight_bypass
        __props__.__dict__["path_cookie_attribute"] = path_cookie_attribute
        __props__.__dict__["policies"] = policies
        __props__.__dict__["read_service_tokens_from_header"] = read_service_tokens_from_header
        __props__.__dict__["saas_app"] = saas_app
        __props__.__dict__["same_site_cookie_attribute"] = same_site_cookie_attribute
        __props__.__dict__["scim_config"] = scim_config
        __props__.__dict__["self_hosted_domains"] = self_hosted_domains
        __props__.__dict__["service_auth401_redirect"] = service_auth401_redirect
        __props__.__dict__["session_duration"] = session_duration
        __props__.__dict__["skip_app_launcher_login_page"] = skip_app_launcher_login_page
        __props__.__dict__["skip_interstitial"] = skip_interstitial
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_criterias"] = target_criterias
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["zone_id"] = zone_id
        return ZeroTrustAccessApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="allowAuthenticateViaWarp")
    def allow_authenticate_via_warp(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When set to true, users can authenticate to this application using their WARP session.  When set to false this application will always require direct IdP authentication. This setting always overrides the organization setting for WARP authentication.
        """
        return pulumi.get(self, "allow_authenticate_via_warp")

    @property
    @pulumi.getter(name="allowIframe")
    def allow_iframe(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enables loading application content in an iFrame.
        """
        return pulumi.get(self, "allow_iframe")

    @property
    @pulumi.getter(name="allowedIdps")
    def allowed_idps(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The identity providers your users can select when connecting to this application. Defaults to all IdPs configured in your account.
        """
        return pulumi.get(self, "allowed_idps")

    @property
    @pulumi.getter(name="appLauncherLogoUrl")
    def app_launcher_logo_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The image URL of the logo shown in the App Launcher header.
        """
        return pulumi.get(self, "app_launcher_logo_url")

    @property
    @pulumi.getter(name="appLauncherVisible")
    def app_launcher_visible(self) -> pulumi.Output[builtins.bool]:
        """
        Displays the application in the App Launcher.
        """
        return pulumi.get(self, "app_launcher_visible")

    @property
    @pulumi.getter
    def aud(self) -> pulumi.Output[builtins.str]:
        """
        Audience tag.
        """
        return pulumi.get(self, "aud")

    @property
    @pulumi.getter(name="autoRedirectToIdentity")
    def auto_redirect_to_identity(self) -> pulumi.Output[builtins.bool]:
        """
        When set to `true`, users skip the identity provider selection step during login. You must specify only one identity provider in allowed_idps.
        """
        return pulumi.get(self, "auto_redirect_to_identity")

    @property
    @pulumi.getter(name="bgColor")
    def bg_color(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The background color of the App Launcher page.
        """
        return pulumi.get(self, "bg_color")

    @property
    @pulumi.getter(name="corsHeaders")
    def cors_headers(self) -> pulumi.Output[Optional['outputs.ZeroTrustAccessApplicationCorsHeaders']]:
        return pulumi.get(self, "cors_headers")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customDenyMessage")
    def custom_deny_message(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The custom error message shown to a user when they are denied access to the application.
        """
        return pulumi.get(self, "custom_deny_message")

    @property
    @pulumi.getter(name="customDenyUrl")
    def custom_deny_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The custom URL a user is redirected to when they are denied access to the application when failing identity-based rules.
        """
        return pulumi.get(self, "custom_deny_url")

    @property
    @pulumi.getter(name="customNonIdentityDenyUrl")
    def custom_non_identity_deny_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The custom URL a user is redirected to when they are denied access to the application when failing non-identity rules.
        """
        return pulumi.get(self, "custom_non_identity_deny_url")

    @property
    @pulumi.getter(name="customPages")
    def custom_pages(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The custom pages that will be displayed when applicable for this application
        """
        return pulumi.get(self, "custom_pages")

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Sequence['outputs.ZeroTrustAccessApplicationDestination']]:
        """
        List of destinations secured by Access. This supersedes `self_hosted_domains` to allow for more flexibility in defining different types of domains. If `destinations` are provided, then `self_hosted_domains` will be ignored.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The primary hostname and path secured by Access. This domain will be displayed if the app is visible in the App Launcher.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="enableBindingCookie")
    def enable_binding_cookie(self) -> pulumi.Output[builtins.bool]:
        """
        Enables the binding cookie, which increases security against compromised authorization tokens and CSRF attacks.
        """
        return pulumi.get(self, "enable_binding_cookie")

    @property
    @pulumi.getter(name="footerLinks")
    def footer_links(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustAccessApplicationFooterLink']]]:
        """
        The links in the App Launcher footer.
        """
        return pulumi.get(self, "footer_links")

    @property
    @pulumi.getter(name="headerBgColor")
    def header_bg_color(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The background color of the App Launcher header.
        """
        return pulumi.get(self, "header_bg_color")

    @property
    @pulumi.getter(name="httpOnlyCookieAttribute")
    def http_only_cookie_attribute(self) -> pulumi.Output[builtins.bool]:
        """
        Enables the HttpOnly cookie attribute, which increases security against XSS attacks.
        """
        return pulumi.get(self, "http_only_cookie_attribute")

    @property
    @pulumi.getter(name="landingPageDesign")
    def landing_page_design(self) -> pulumi.Output['outputs.ZeroTrustAccessApplicationLandingPageDesign']:
        """
        The design of the App Launcher landing page shown to users when they log in.
        """
        return pulumi.get(self, "landing_page_design")

    @property
    @pulumi.getter(name="logoUrl")
    def logo_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The image URL for the logo shown in the App Launcher dashboard.
        """
        return pulumi.get(self, "logo_url")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="optionsPreflightBypass")
    def options_preflight_bypass(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Allows options preflight requests to bypass Access authentication and go directly to the origin. Cannot turn on if cors_headers is set.
        """
        return pulumi.get(self, "options_preflight_bypass")

    @property
    @pulumi.getter(name="pathCookieAttribute")
    def path_cookie_attribute(self) -> pulumi.Output[builtins.bool]:
        """
        Enables cookie paths to scope an application's JWT to the application path. If disabled, the JWT will scope to the hostname by default
        """
        return pulumi.get(self, "path_cookie_attribute")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Sequence['outputs.ZeroTrustAccessApplicationPolicy']]:
        """
        The policies that Access applies to the application, in ascending order of precedence. Items can reference existing policies or create new policies exclusive to the application.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="readServiceTokensFromHeader")
    def read_service_tokens_from_header(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Allows matching Access Service Tokens passed HTTP in a single header with this name.
        This works as an alternative to the (CF-Access-Client-Id, CF-Access-Client-Secret) pair of headers.
        The header value will be interpreted as a json object similar to:
        {
        "cf-access-client-id": "88bf3b6d86161464f6509f7219099e57.access.example.com",
        "cf-access-client-secret": "bdd31cbc4dec990953e39163fbbb194c93313ca9f0a6e420346af9d326b1d2a5"
        }
        """
        return pulumi.get(self, "read_service_tokens_from_header")

    @property
    @pulumi.getter(name="saasApp")
    def saas_app(self) -> pulumi.Output['outputs.ZeroTrustAccessApplicationSaasApp']:
        return pulumi.get(self, "saas_app")

    @property
    @pulumi.getter(name="sameSiteCookieAttribute")
    def same_site_cookie_attribute(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Sets the SameSite cookie setting, which provides increased security against CSRF attacks.
        """
        return pulumi.get(self, "same_site_cookie_attribute")

    @property
    @pulumi.getter(name="scimConfig")
    def scim_config(self) -> pulumi.Output[Optional['outputs.ZeroTrustAccessApplicationScimConfig']]:
        """
        Configuration for provisioning to this application via SCIM. This is currently in closed beta.
        """
        return pulumi.get(self, "scim_config")

    @property
    @pulumi.getter(name="selfHostedDomains")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def self_hosted_domains(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of public domains that Access will secure. This field is deprecated in favor of `destinations` and will be supported until **November 21, 2025.** If `destinations` are provided, then `self_hosted_domains` will be ignored.
        """
        return pulumi.get(self, "self_hosted_domains")

    @property
    @pulumi.getter(name="serviceAuth401Redirect")
    def service_auth401_redirect(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Returns a 401 status code when the request is blocked by a Service Auth policy.
        """
        return pulumi.get(self, "service_auth401_redirect")

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> pulumi.Output[builtins.str]:
        """
        The amount of time that tokens issued for this application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h. Note: unsupported for infrastructure type applications.
        """
        return pulumi.get(self, "session_duration")

    @property
    @pulumi.getter(name="skipAppLauncherLoginPage")
    def skip_app_launcher_login_page(self) -> pulumi.Output[builtins.bool]:
        """
        Determines when to skip the App Launcher landing page.
        """
        return pulumi.get(self, "skip_app_launcher_login_page")

    @property
    @pulumi.getter(name="skipInterstitial")
    def skip_interstitial(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enables automatic authentication through cloudflared.
        """
        return pulumi.get(self, "skip_interstitial")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The tags you want assigned to an application. Tags are used to filter applications in the App Launcher dashboard.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetCriterias")
    def target_criterias(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustAccessApplicationTargetCriteria']]]:
        return pulumi.get(self, "target_criterias")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The application type.
        Available values: "self*hosted", "saas", "ssh", "vnc", "app*launcher", "warp", "biso", "bookmark", "dash_sso", "infrastructure", "rdp".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

