# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustAccessGroupArgs', 'ZeroTrustAccessGroup']

@pulumi.input_type
class ZeroTrustAccessGroupArgs:
    def __init__(__self__, *,
                 includes: pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupIncludeArgs']]],
                 name: pulumi.Input[builtins.str],
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupExcludeArgs']]]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupRequireArgs']]]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ZeroTrustAccessGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupIncludeArgs']]] includes: Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        :param pulumi.Input[builtins.str] name: The name of the Access group.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupExcludeArgs']]] excludes: Rules evaluated with a NOT logical operator. To match a policy, a user cannot meet any of the Exclude rules.
        :param pulumi.Input[builtins.bool] is_default: Whether this is the default group
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupRequireArgs']]] requires: Rules evaluated with an AND logical operator. To match a policy, a user must meet all of the Require rules.
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        pulumi.set(__self__, "includes", includes)
        pulumi.set(__self__, "name", name)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if requires is not None:
            pulumi.set(__self__, "requires", requires)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def includes(self) -> pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupIncludeArgs']]]:
        """
        Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupIncludeArgs']]]):
        pulumi.set(self, "includes", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Access group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupExcludeArgs']]]]:
        """
        Rules evaluated with a NOT logical operator. To match a policy, a user cannot meet any of the Exclude rules.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupExcludeArgs']]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this is the default group
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def requires(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupRequireArgs']]]]:
        """
        Rules evaluated with an AND logical operator. To match a policy, a user must meet all of the Require rules.
        """
        return pulumi.get(self, "requires")

    @requires.setter
    def requires(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupRequireArgs']]]]):
        pulumi.set(self, "requires", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ZeroTrustAccessGroupState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupExcludeArgs']]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupIncludeArgs']]]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupRequireArgs']]]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustAccessGroup resources.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupExcludeArgs']]] excludes: Rules evaluated with a NOT logical operator. To match a policy, a user cannot meet any of the Exclude rules.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupIncludeArgs']]] includes: Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        :param pulumi.Input[builtins.bool] is_default: Whether this is the default group
        :param pulumi.Input[builtins.str] name: The name of the Access group.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupRequireArgs']]] requires: Rules evaluated with an AND logical operator. To match a policy, a user must meet all of the Require rules.
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if requires is not None:
            pulumi.set(__self__, "requires", requires)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupExcludeArgs']]]]:
        """
        Rules evaluated with a NOT logical operator. To match a policy, a user cannot meet any of the Exclude rules.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupExcludeArgs']]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupIncludeArgs']]]]:
        """
        Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupIncludeArgs']]]]):
        pulumi.set(self, "includes", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this is the default group
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Access group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def requires(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupRequireArgs']]]]:
        """
        Rules evaluated with an AND logical operator. To match a policy, a user must meet all of the Require rules.
        """
        return pulumi.get(self, "requires")

    @requires.setter
    def requires(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustAccessGroupRequireArgs']]]]):
        pulumi.set(self, "requires", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/zeroTrustAccessGroup:ZeroTrustAccessGroup")
class ZeroTrustAccessGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupExcludeArgs', 'ZeroTrustAccessGroupExcludeArgsDict']]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupIncludeArgs', 'ZeroTrustAccessGroupIncludeArgsDict']]]]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupRequireArgs', 'ZeroTrustAccessGroupRequireArgsDict']]]]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_access_group = cloudflare.ZeroTrustAccessGroup("example_zero_trust_access_group",
            includes=[{
                "group": {
                    "id": "aa0a4aab-672b-4bdb-bc33-a59f1130a11f",
                },
            }],
            name="Allow devs",
            zone_id="zone_id",
            excludes=[{
                "group": {
                    "id": "aa0a4aab-672b-4bdb-bc33-a59f1130a11f",
                },
            }],
            is_default=True,
            requires=[{
                "group": {
                    "id": "aa0a4aab-672b-4bdb-bc33-a59f1130a11f",
                },
            }])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessGroup:ZeroTrustAccessGroup example '<{accounts|zones}/{account_id|zone_id}>/<group_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupExcludeArgs', 'ZeroTrustAccessGroupExcludeArgsDict']]]] excludes: Rules evaluated with a NOT logical operator. To match a policy, a user cannot meet any of the Exclude rules.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupIncludeArgs', 'ZeroTrustAccessGroupIncludeArgsDict']]]] includes: Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        :param pulumi.Input[builtins.bool] is_default: Whether this is the default group
        :param pulumi.Input[builtins.str] name: The name of the Access group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupRequireArgs', 'ZeroTrustAccessGroupRequireArgsDict']]]] requires: Rules evaluated with an AND logical operator. To match a policy, a user must meet all of the Require rules.
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustAccessGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_access_group = cloudflare.ZeroTrustAccessGroup("example_zero_trust_access_group",
            includes=[{
                "group": {
                    "id": "aa0a4aab-672b-4bdb-bc33-a59f1130a11f",
                },
            }],
            name="Allow devs",
            zone_id="zone_id",
            excludes=[{
                "group": {
                    "id": "aa0a4aab-672b-4bdb-bc33-a59f1130a11f",
                },
            }],
            is_default=True,
            requires=[{
                "group": {
                    "id": "aa0a4aab-672b-4bdb-bc33-a59f1130a11f",
                },
            }])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessGroup:ZeroTrustAccessGroup example '<{accounts|zones}/{account_id|zone_id}>/<group_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustAccessGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustAccessGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupExcludeArgs', 'ZeroTrustAccessGroupExcludeArgsDict']]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupIncludeArgs', 'ZeroTrustAccessGroupIncludeArgsDict']]]]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupRequireArgs', 'ZeroTrustAccessGroupRequireArgsDict']]]]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustAccessGroupArgs.__new__(ZeroTrustAccessGroupArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["excludes"] = excludes
            if includes is None and not opts.urn:
                raise TypeError("Missing required property 'includes'")
            __props__.__dict__["includes"] = includes
            __props__.__dict__["is_default"] = is_default
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["requires"] = requires
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/accessGroup:AccessGroup")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ZeroTrustAccessGroup, __self__).__init__(
            'cloudflare:index/zeroTrustAccessGroup:ZeroTrustAccessGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupExcludeArgs', 'ZeroTrustAccessGroupExcludeArgsDict']]]]] = None,
            includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupIncludeArgs', 'ZeroTrustAccessGroupIncludeArgsDict']]]]] = None,
            is_default: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            requires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupRequireArgs', 'ZeroTrustAccessGroupRequireArgsDict']]]]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ZeroTrustAccessGroup':
        """
        Get an existing ZeroTrustAccessGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupExcludeArgs', 'ZeroTrustAccessGroupExcludeArgsDict']]]] excludes: Rules evaluated with a NOT logical operator. To match a policy, a user cannot meet any of the Exclude rules.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupIncludeArgs', 'ZeroTrustAccessGroupIncludeArgsDict']]]] includes: Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        :param pulumi.Input[builtins.bool] is_default: Whether this is the default group
        :param pulumi.Input[builtins.str] name: The name of the Access group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustAccessGroupRequireArgs', 'ZeroTrustAccessGroupRequireArgsDict']]]] requires: Rules evaluated with an AND logical operator. To match a policy, a user must meet all of the Require rules.
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustAccessGroupState.__new__(_ZeroTrustAccessGroupState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["excludes"] = excludes
        __props__.__dict__["includes"] = includes
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["requires"] = requires
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["zone_id"] = zone_id
        return ZeroTrustAccessGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def excludes(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustAccessGroupExclude']]]:
        """
        Rules evaluated with a NOT logical operator. To match a policy, a user cannot meet any of the Exclude rules.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> pulumi.Output[Sequence['outputs.ZeroTrustAccessGroupInclude']]:
        """
        Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        """
        return pulumi.get(self, "includes")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether this is the default group
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Access group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def requires(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustAccessGroupRequire']]]:
        """
        Rules evaluated with an AND logical operator. To match a policy, a user must meet all of the Require rules.
        """
        return pulumi.get(self, "requires")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

