# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustAccessInfrastructureTargetArgs', 'ZeroTrustAccessInfrastructureTarget']

@pulumi.input_type
class ZeroTrustAccessInfrastructureTargetArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 hostname: pulumi.Input[builtins.str],
                 ip: pulumi.Input['ZeroTrustAccessInfrastructureTargetIpArgs']):
        """
        The set of arguments for constructing a ZeroTrustAccessInfrastructureTarget resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier
        :param pulumi.Input[builtins.str] hostname: A non-unique field that refers to a target. Case insensitive, maximum
               length of 255 characters, supports the use of special characters dash
               and period, does not support spaces, and must start and end with an
               alphanumeric character.
        :param pulumi.Input['ZeroTrustAccessInfrastructureTargetIpArgs'] ip: The IPv4/IPv6 address that identifies where to reach a target
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Account identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        A non-unique field that refers to a target. Case insensitive, maximum
        length of 255 characters, supports the use of special characters dash
        and period, does not support spaces, and must start and end with an
        alphanumeric character.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input['ZeroTrustAccessInfrastructureTargetIpArgs']:
        """
        The IPv4/IPv6 address that identifies where to reach a target
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input['ZeroTrustAccessInfrastructureTargetIpArgs']):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class _ZeroTrustAccessInfrastructureTargetState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input['ZeroTrustAccessInfrastructureTargetIpArgs']] = None,
                 modified_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustAccessInfrastructureTarget resources.
        :param pulumi.Input[builtins.str] account_id: Account identifier
        :param pulumi.Input[builtins.str] created_at: Date and time at which the target was created
        :param pulumi.Input[builtins.str] hostname: A non-unique field that refers to a target. Case insensitive, maximum
               length of 255 characters, supports the use of special characters dash
               and period, does not support spaces, and must start and end with an
               alphanumeric character.
        :param pulumi.Input['ZeroTrustAccessInfrastructureTargetIpArgs'] ip: The IPv4/IPv6 address that identifies where to reach a target
        :param pulumi.Input[builtins.str] modified_at: Date and time at which the target was modified
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time at which the target was created
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A non-unique field that refers to a target. Case insensitive, maximum
        length of 255 characters, supports the use of special characters dash
        and period, does not support spaces, and must start and end with an
        alphanumeric character.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input['ZeroTrustAccessInfrastructureTargetIpArgs']]:
        """
        The IPv4/IPv6 address that identifies where to reach a target
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input['ZeroTrustAccessInfrastructureTargetIpArgs']]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time at which the target was modified
        """
        return pulumi.get(self, "modified_at")

    @modified_at.setter
    def modified_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "modified_at", value)


@pulumi.type_token("cloudflare:index/zeroTrustAccessInfrastructureTarget:ZeroTrustAccessInfrastructureTarget")
class ZeroTrustAccessInfrastructureTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[Union['ZeroTrustAccessInfrastructureTargetIpArgs', 'ZeroTrustAccessInfrastructureTargetIpArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_access_infrastructure_target = cloudflare.ZeroTrustAccessInfrastructureTarget("example_zero_trust_access_infrastructure_target",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            hostname="infra-access-target",
            ip={
                "ipv4": {
                    "ip_addr": "187.26.29.249",
                    "virtual_network_id": "c77b744e-acc8-428f-9257-6878c046ed55",
                },
                "ipv6": {
                    "ip_addr": "64c0:64e8:f0b4:8dbf:7104:72b0:ec8f:f5e0",
                    "virtual_network_id": "c77b744e-acc8-428f-9257-6878c046ed55",
                },
            })
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessInfrastructureTarget:ZeroTrustAccessInfrastructureTarget example '<account_id>/<target_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier
        :param pulumi.Input[builtins.str] hostname: A non-unique field that refers to a target. Case insensitive, maximum
               length of 255 characters, supports the use of special characters dash
               and period, does not support spaces, and must start and end with an
               alphanumeric character.
        :param pulumi.Input[Union['ZeroTrustAccessInfrastructureTargetIpArgs', 'ZeroTrustAccessInfrastructureTargetIpArgsDict']] ip: The IPv4/IPv6 address that identifies where to reach a target
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustAccessInfrastructureTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_access_infrastructure_target = cloudflare.ZeroTrustAccessInfrastructureTarget("example_zero_trust_access_infrastructure_target",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            hostname="infra-access-target",
            ip={
                "ipv4": {
                    "ip_addr": "187.26.29.249",
                    "virtual_network_id": "c77b744e-acc8-428f-9257-6878c046ed55",
                },
                "ipv6": {
                    "ip_addr": "64c0:64e8:f0b4:8dbf:7104:72b0:ec8f:f5e0",
                    "virtual_network_id": "c77b744e-acc8-428f-9257-6878c046ed55",
                },
            })
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessInfrastructureTarget:ZeroTrustAccessInfrastructureTarget example '<account_id>/<target_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustAccessInfrastructureTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustAccessInfrastructureTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[Union['ZeroTrustAccessInfrastructureTargetIpArgs', 'ZeroTrustAccessInfrastructureTargetIpArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustAccessInfrastructureTargetArgs.__new__(ZeroTrustAccessInfrastructureTargetArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            if ip is None and not opts.urn:
                raise TypeError("Missing required property 'ip'")
            __props__.__dict__["ip"] = ip
            __props__.__dict__["created_at"] = None
            __props__.__dict__["modified_at"] = None
        super(ZeroTrustAccessInfrastructureTarget, __self__).__init__(
            'cloudflare:index/zeroTrustAccessInfrastructureTarget:ZeroTrustAccessInfrastructureTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            ip: Optional[pulumi.Input[Union['ZeroTrustAccessInfrastructureTargetIpArgs', 'ZeroTrustAccessInfrastructureTargetIpArgsDict']]] = None,
            modified_at: Optional[pulumi.Input[builtins.str]] = None) -> 'ZeroTrustAccessInfrastructureTarget':
        """
        Get an existing ZeroTrustAccessInfrastructureTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier
        :param pulumi.Input[builtins.str] created_at: Date and time at which the target was created
        :param pulumi.Input[builtins.str] hostname: A non-unique field that refers to a target. Case insensitive, maximum
               length of 255 characters, supports the use of special characters dash
               and period, does not support spaces, and must start and end with an
               alphanumeric character.
        :param pulumi.Input[Union['ZeroTrustAccessInfrastructureTargetIpArgs', 'ZeroTrustAccessInfrastructureTargetIpArgsDict']] ip: The IPv4/IPv6 address that identifies where to reach a target
        :param pulumi.Input[builtins.str] modified_at: Date and time at which the target was modified
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustAccessInfrastructureTargetState.__new__(_ZeroTrustAccessInfrastructureTargetState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["ip"] = ip
        __props__.__dict__["modified_at"] = modified_at
        return ZeroTrustAccessInfrastructureTarget(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Account identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Date and time at which the target was created
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[builtins.str]:
        """
        A non-unique field that refers to a target. Case insensitive, maximum
        length of 255 characters, supports the use of special characters dash
        and period, does not support spaces, and must start and end with an
        alphanumeric character.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output['outputs.ZeroTrustAccessInfrastructureTargetIp']:
        """
        The IPv4/IPv6 address that identifies where to reach a target
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[builtins.str]:
        """
        Date and time at which the target was modified
        """
        return pulumi.get(self, "modified_at")

