# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ZeroTrustAccessKeyConfigurationArgs', 'ZeroTrustAccessKeyConfiguration']

@pulumi.input_type
class ZeroTrustAccessKeyConfigurationArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 key_rotation_interval_days: pulumi.Input[builtins.float]):
        """
        The set of arguments for constructing a ZeroTrustAccessKeyConfiguration resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.float] key_rotation_interval_days: The number of days between key rotations.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "key_rotation_interval_days", key_rotation_interval_days)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="keyRotationIntervalDays")
    def key_rotation_interval_days(self) -> pulumi.Input[builtins.float]:
        """
        The number of days between key rotations.
        """
        return pulumi.get(self, "key_rotation_interval_days")

    @key_rotation_interval_days.setter
    def key_rotation_interval_days(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "key_rotation_interval_days", value)


@pulumi.input_type
class _ZeroTrustAccessKeyConfigurationState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 days_until_next_rotation: Optional[pulumi.Input[builtins.float]] = None,
                 key_rotation_interval_days: Optional[pulumi.Input[builtins.float]] = None,
                 last_key_rotation_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustAccessKeyConfiguration resources.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.float] days_until_next_rotation: The number of days until the next key rotation.
        :param pulumi.Input[builtins.float] key_rotation_interval_days: The number of days between key rotations.
        :param pulumi.Input[builtins.str] last_key_rotation_at: The timestamp of the previous key rotation.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if days_until_next_rotation is not None:
            pulumi.set(__self__, "days_until_next_rotation", days_until_next_rotation)
        if key_rotation_interval_days is not None:
            pulumi.set(__self__, "key_rotation_interval_days", key_rotation_interval_days)
        if last_key_rotation_at is not None:
            pulumi.set(__self__, "last_key_rotation_at", last_key_rotation_at)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="daysUntilNextRotation")
    def days_until_next_rotation(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of days until the next key rotation.
        """
        return pulumi.get(self, "days_until_next_rotation")

    @days_until_next_rotation.setter
    def days_until_next_rotation(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "days_until_next_rotation", value)

    @property
    @pulumi.getter(name="keyRotationIntervalDays")
    def key_rotation_interval_days(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of days between key rotations.
        """
        return pulumi.get(self, "key_rotation_interval_days")

    @key_rotation_interval_days.setter
    def key_rotation_interval_days(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "key_rotation_interval_days", value)

    @property
    @pulumi.getter(name="lastKeyRotationAt")
    def last_key_rotation_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp of the previous key rotation.
        """
        return pulumi.get(self, "last_key_rotation_at")

    @last_key_rotation_at.setter
    def last_key_rotation_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_key_rotation_at", value)


@pulumi.type_token("cloudflare:index/zeroTrustAccessKeyConfiguration:ZeroTrustAccessKeyConfiguration")
class ZeroTrustAccessKeyConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_rotation_interval_days: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_access_key_configuration = cloudflare.ZeroTrustAccessKeyConfiguration("example_zero_trust_access_key_configuration",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            key_rotation_interval_days=30)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessKeyConfiguration:ZeroTrustAccessKeyConfiguration example '<account_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.float] key_rotation_interval_days: The number of days between key rotations.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustAccessKeyConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_access_key_configuration = cloudflare.ZeroTrustAccessKeyConfiguration("example_zero_trust_access_key_configuration",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            key_rotation_interval_days=30)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustAccessKeyConfiguration:ZeroTrustAccessKeyConfiguration example '<account_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustAccessKeyConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustAccessKeyConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_rotation_interval_days: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustAccessKeyConfigurationArgs.__new__(ZeroTrustAccessKeyConfigurationArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if key_rotation_interval_days is None and not opts.urn:
                raise TypeError("Missing required property 'key_rotation_interval_days'")
            __props__.__dict__["key_rotation_interval_days"] = key_rotation_interval_days
            __props__.__dict__["days_until_next_rotation"] = None
            __props__.__dict__["last_key_rotation_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/accessKeysConfiguration:AccessKeysConfiguration")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ZeroTrustAccessKeyConfiguration, __self__).__init__(
            'cloudflare:index/zeroTrustAccessKeyConfiguration:ZeroTrustAccessKeyConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            days_until_next_rotation: Optional[pulumi.Input[builtins.float]] = None,
            key_rotation_interval_days: Optional[pulumi.Input[builtins.float]] = None,
            last_key_rotation_at: Optional[pulumi.Input[builtins.str]] = None) -> 'ZeroTrustAccessKeyConfiguration':
        """
        Get an existing ZeroTrustAccessKeyConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.float] days_until_next_rotation: The number of days until the next key rotation.
        :param pulumi.Input[builtins.float] key_rotation_interval_days: The number of days between key rotations.
        :param pulumi.Input[builtins.str] last_key_rotation_at: The timestamp of the previous key rotation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustAccessKeyConfigurationState.__new__(_ZeroTrustAccessKeyConfigurationState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["days_until_next_rotation"] = days_until_next_rotation
        __props__.__dict__["key_rotation_interval_days"] = key_rotation_interval_days
        __props__.__dict__["last_key_rotation_at"] = last_key_rotation_at
        return ZeroTrustAccessKeyConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="daysUntilNextRotation")
    def days_until_next_rotation(self) -> pulumi.Output[builtins.float]:
        """
        The number of days until the next key rotation.
        """
        return pulumi.get(self, "days_until_next_rotation")

    @property
    @pulumi.getter(name="keyRotationIntervalDays")
    def key_rotation_interval_days(self) -> pulumi.Output[builtins.float]:
        """
        The number of days between key rotations.
        """
        return pulumi.get(self, "key_rotation_interval_days")

    @property
    @pulumi.getter(name="lastKeyRotationAt")
    def last_key_rotation_at(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of the previous key rotation.
        """
        return pulumi.get(self, "last_key_rotation_at")

