# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustDeviceDefaultProfileArgs', 'ZeroTrustDeviceDefaultProfile']

@pulumi.input_type
class ZeroTrustDeviceDefaultProfileArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 allow_mode_switch: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_updates: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_to_leave: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_connect: Optional[pulumi.Input[builtins.float]] = None,
                 captive_portal: Optional[pulumi.Input[builtins.float]] = None,
                 disable_auto_fallback: Optional[pulumi.Input[builtins.bool]] = None,
                 exclude_office_ips: Optional[pulumi.Input[builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileExcludeArgs']]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileIncludeArgs']]]] = None,
                 lan_allow_minutes: Optional[pulumi.Input[builtins.float]] = None,
                 lan_allow_subnet_size: Optional[pulumi.Input[builtins.float]] = None,
                 register_interface_ip_with_dns: Optional[pulumi.Input[builtins.bool]] = None,
                 sccm_vpn_boundary_support: Optional[pulumi.Input[builtins.bool]] = None,
                 service_mode_v2: Optional[pulumi.Input['ZeroTrustDeviceDefaultProfileServiceModeV2Args']] = None,
                 support_url: Optional[pulumi.Input[builtins.str]] = None,
                 switch_locked: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel_protocol: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ZeroTrustDeviceDefaultProfile resource.
        :param pulumi.Input[builtins.bool] allow_mode_switch: Whether to allow the user to switch WARP between modes.
        :param pulumi.Input[builtins.bool] allow_updates: Whether to receive update notifications when a new version of the client is available.
        :param pulumi.Input[builtins.bool] allowed_to_leave: Whether to allow devices to leave the organization.
        :param pulumi.Input[builtins.float] auto_connect: The amount of time in seconds to reconnect after having been disabled.
        :param pulumi.Input[builtins.float] captive_portal: Turn on the captive portal after the specified amount of time.
        :param pulumi.Input[builtins.bool] disable_auto_fallback: If the `dns_server` field of a fallback domain is not present, the client will fall back to a best guess of the default/system DNS resolvers unless this policy option is set to `true`.
        :param pulumi.Input[builtins.bool] exclude_office_ips: Whether to add Microsoft IPs to Split Tunnel exclusions.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileExcludeArgs']]] excludes: List of routes excluded in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileIncludeArgs']]] includes: List of routes included in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        :param pulumi.Input[builtins.float] lan_allow_minutes: The amount of time in minutes a user is allowed access to their LAN. A value of 0 will allow LAN access until the next WARP reconnection, such as a reboot or a laptop waking from sleep. Note that this field is omitted from the response if null or unset.
        :param pulumi.Input[builtins.float] lan_allow_subnet_size: The size of the subnet for the local access network. Note that this field is omitted from the response if null or unset.
        :param pulumi.Input[builtins.bool] register_interface_ip_with_dns: Determines if the operating system will register WARP's local interface IP with your on-premises DNS server.
        :param pulumi.Input[builtins.bool] sccm_vpn_boundary_support: Determines whether the WARP client indicates to SCCM that it is inside a VPN boundary. (Windows only).
        :param pulumi.Input[builtins.str] support_url: The URL to launch when the Send Feedback button is clicked.
        :param pulumi.Input[builtins.bool] switch_locked: Whether to allow the user to turn off the WARP switch and disconnect the client.
        :param pulumi.Input[builtins.str] tunnel_protocol: Determines which tunnel protocol to use.
        """
        pulumi.set(__self__, "account_id", account_id)
        if allow_mode_switch is not None:
            pulumi.set(__self__, "allow_mode_switch", allow_mode_switch)
        if allow_updates is not None:
            pulumi.set(__self__, "allow_updates", allow_updates)
        if allowed_to_leave is not None:
            pulumi.set(__self__, "allowed_to_leave", allowed_to_leave)
        if auto_connect is not None:
            pulumi.set(__self__, "auto_connect", auto_connect)
        if captive_portal is not None:
            pulumi.set(__self__, "captive_portal", captive_portal)
        if disable_auto_fallback is not None:
            pulumi.set(__self__, "disable_auto_fallback", disable_auto_fallback)
        if exclude_office_ips is not None:
            pulumi.set(__self__, "exclude_office_ips", exclude_office_ips)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)
        if lan_allow_minutes is not None:
            pulumi.set(__self__, "lan_allow_minutes", lan_allow_minutes)
        if lan_allow_subnet_size is not None:
            pulumi.set(__self__, "lan_allow_subnet_size", lan_allow_subnet_size)
        if register_interface_ip_with_dns is not None:
            pulumi.set(__self__, "register_interface_ip_with_dns", register_interface_ip_with_dns)
        if sccm_vpn_boundary_support is not None:
            pulumi.set(__self__, "sccm_vpn_boundary_support", sccm_vpn_boundary_support)
        if service_mode_v2 is not None:
            pulumi.set(__self__, "service_mode_v2", service_mode_v2)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)
        if switch_locked is not None:
            pulumi.set(__self__, "switch_locked", switch_locked)
        if tunnel_protocol is not None:
            pulumi.set(__self__, "tunnel_protocol", tunnel_protocol)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowModeSwitch")
    def allow_mode_switch(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow the user to switch WARP between modes.
        """
        return pulumi.get(self, "allow_mode_switch")

    @allow_mode_switch.setter
    def allow_mode_switch(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_mode_switch", value)

    @property
    @pulumi.getter(name="allowUpdates")
    def allow_updates(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to receive update notifications when a new version of the client is available.
        """
        return pulumi.get(self, "allow_updates")

    @allow_updates.setter
    def allow_updates(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_updates", value)

    @property
    @pulumi.getter(name="allowedToLeave")
    def allowed_to_leave(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow devices to leave the organization.
        """
        return pulumi.get(self, "allowed_to_leave")

    @allowed_to_leave.setter
    def allowed_to_leave(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allowed_to_leave", value)

    @property
    @pulumi.getter(name="autoConnect")
    def auto_connect(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The amount of time in seconds to reconnect after having been disabled.
        """
        return pulumi.get(self, "auto_connect")

    @auto_connect.setter
    def auto_connect(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "auto_connect", value)

    @property
    @pulumi.getter(name="captivePortal")
    def captive_portal(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Turn on the captive portal after the specified amount of time.
        """
        return pulumi.get(self, "captive_portal")

    @captive_portal.setter
    def captive_portal(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "captive_portal", value)

    @property
    @pulumi.getter(name="disableAutoFallback")
    def disable_auto_fallback(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If the `dns_server` field of a fallback domain is not present, the client will fall back to a best guess of the default/system DNS resolvers unless this policy option is set to `true`.
        """
        return pulumi.get(self, "disable_auto_fallback")

    @disable_auto_fallback.setter
    def disable_auto_fallback(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_auto_fallback", value)

    @property
    @pulumi.getter(name="excludeOfficeIps")
    def exclude_office_ips(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to add Microsoft IPs to Split Tunnel exclusions.
        """
        return pulumi.get(self, "exclude_office_ips")

    @exclude_office_ips.setter
    def exclude_office_ips(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "exclude_office_ips", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileExcludeArgs']]]]:
        """
        List of routes excluded in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileExcludeArgs']]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileIncludeArgs']]]]:
        """
        List of routes included in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileIncludeArgs']]]]):
        pulumi.set(self, "includes", value)

    @property
    @pulumi.getter(name="lanAllowMinutes")
    def lan_allow_minutes(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The amount of time in minutes a user is allowed access to their LAN. A value of 0 will allow LAN access until the next WARP reconnection, such as a reboot or a laptop waking from sleep. Note that this field is omitted from the response if null or unset.
        """
        return pulumi.get(self, "lan_allow_minutes")

    @lan_allow_minutes.setter
    def lan_allow_minutes(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "lan_allow_minutes", value)

    @property
    @pulumi.getter(name="lanAllowSubnetSize")
    def lan_allow_subnet_size(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The size of the subnet for the local access network. Note that this field is omitted from the response if null or unset.
        """
        return pulumi.get(self, "lan_allow_subnet_size")

    @lan_allow_subnet_size.setter
    def lan_allow_subnet_size(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "lan_allow_subnet_size", value)

    @property
    @pulumi.getter(name="registerInterfaceIpWithDns")
    def register_interface_ip_with_dns(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if the operating system will register WARP's local interface IP with your on-premises DNS server.
        """
        return pulumi.get(self, "register_interface_ip_with_dns")

    @register_interface_ip_with_dns.setter
    def register_interface_ip_with_dns(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "register_interface_ip_with_dns", value)

    @property
    @pulumi.getter(name="sccmVpnBoundarySupport")
    def sccm_vpn_boundary_support(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether the WARP client indicates to SCCM that it is inside a VPN boundary. (Windows only).
        """
        return pulumi.get(self, "sccm_vpn_boundary_support")

    @sccm_vpn_boundary_support.setter
    def sccm_vpn_boundary_support(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sccm_vpn_boundary_support", value)

    @property
    @pulumi.getter(name="serviceModeV2")
    def service_mode_v2(self) -> Optional[pulumi.Input['ZeroTrustDeviceDefaultProfileServiceModeV2Args']]:
        return pulumi.get(self, "service_mode_v2")

    @service_mode_v2.setter
    def service_mode_v2(self, value: Optional[pulumi.Input['ZeroTrustDeviceDefaultProfileServiceModeV2Args']]):
        pulumi.set(self, "service_mode_v2", value)

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL to launch when the Send Feedback button is clicked.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "support_url", value)

    @property
    @pulumi.getter(name="switchLocked")
    def switch_locked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow the user to turn off the WARP switch and disconnect the client.
        """
        return pulumi.get(self, "switch_locked")

    @switch_locked.setter
    def switch_locked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "switch_locked", value)

    @property
    @pulumi.getter(name="tunnelProtocol")
    def tunnel_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines which tunnel protocol to use.
        """
        return pulumi.get(self, "tunnel_protocol")

    @tunnel_protocol.setter
    def tunnel_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_protocol", value)


@pulumi.input_type
class _ZeroTrustDeviceDefaultProfileState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 allow_mode_switch: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_updates: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_to_leave: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_connect: Optional[pulumi.Input[builtins.float]] = None,
                 captive_portal: Optional[pulumi.Input[builtins.float]] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 disable_auto_fallback: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 exclude_office_ips: Optional[pulumi.Input[builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileExcludeArgs']]]] = None,
                 fallback_domains: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileFallbackDomainArgs']]]] = None,
                 gateway_unique_id: Optional[pulumi.Input[builtins.str]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileIncludeArgs']]]] = None,
                 lan_allow_minutes: Optional[pulumi.Input[builtins.float]] = None,
                 lan_allow_subnet_size: Optional[pulumi.Input[builtins.float]] = None,
                 register_interface_ip_with_dns: Optional[pulumi.Input[builtins.bool]] = None,
                 sccm_vpn_boundary_support: Optional[pulumi.Input[builtins.bool]] = None,
                 service_mode_v2: Optional[pulumi.Input['ZeroTrustDeviceDefaultProfileServiceModeV2Args']] = None,
                 support_url: Optional[pulumi.Input[builtins.str]] = None,
                 switch_locked: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel_protocol: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustDeviceDefaultProfile resources.
        :param pulumi.Input[builtins.bool] allow_mode_switch: Whether to allow the user to switch WARP between modes.
        :param pulumi.Input[builtins.bool] allow_updates: Whether to receive update notifications when a new version of the client is available.
        :param pulumi.Input[builtins.bool] allowed_to_leave: Whether to allow devices to leave the organization.
        :param pulumi.Input[builtins.float] auto_connect: The amount of time in seconds to reconnect after having been disabled.
        :param pulumi.Input[builtins.float] captive_portal: Turn on the captive portal after the specified amount of time.
        :param pulumi.Input[builtins.bool] default: Whether the policy will be applied to matching devices.
        :param pulumi.Input[builtins.bool] disable_auto_fallback: If the `dns_server` field of a fallback domain is not present, the client will fall back to a best guess of the default/system DNS resolvers unless this policy option is set to `true`.
        :param pulumi.Input[builtins.bool] enabled: Whether the policy will be applied to matching devices.
        :param pulumi.Input[builtins.bool] exclude_office_ips: Whether to add Microsoft IPs to Split Tunnel exclusions.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileExcludeArgs']]] excludes: List of routes excluded in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileIncludeArgs']]] includes: List of routes included in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        :param pulumi.Input[builtins.float] lan_allow_minutes: The amount of time in minutes a user is allowed access to their LAN. A value of 0 will allow LAN access until the next WARP reconnection, such as a reboot or a laptop waking from sleep. Note that this field is omitted from the response if null or unset.
        :param pulumi.Input[builtins.float] lan_allow_subnet_size: The size of the subnet for the local access network. Note that this field is omitted from the response if null or unset.
        :param pulumi.Input[builtins.bool] register_interface_ip_with_dns: Determines if the operating system will register WARP's local interface IP with your on-premises DNS server.
        :param pulumi.Input[builtins.bool] sccm_vpn_boundary_support: Determines whether the WARP client indicates to SCCM that it is inside a VPN boundary. (Windows only).
        :param pulumi.Input[builtins.str] support_url: The URL to launch when the Send Feedback button is clicked.
        :param pulumi.Input[builtins.bool] switch_locked: Whether to allow the user to turn off the WARP switch and disconnect the client.
        :param pulumi.Input[builtins.str] tunnel_protocol: Determines which tunnel protocol to use.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if allow_mode_switch is not None:
            pulumi.set(__self__, "allow_mode_switch", allow_mode_switch)
        if allow_updates is not None:
            pulumi.set(__self__, "allow_updates", allow_updates)
        if allowed_to_leave is not None:
            pulumi.set(__self__, "allowed_to_leave", allowed_to_leave)
        if auto_connect is not None:
            pulumi.set(__self__, "auto_connect", auto_connect)
        if captive_portal is not None:
            pulumi.set(__self__, "captive_portal", captive_portal)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if disable_auto_fallback is not None:
            pulumi.set(__self__, "disable_auto_fallback", disable_auto_fallback)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if exclude_office_ips is not None:
            pulumi.set(__self__, "exclude_office_ips", exclude_office_ips)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if fallback_domains is not None:
            pulumi.set(__self__, "fallback_domains", fallback_domains)
        if gateway_unique_id is not None:
            pulumi.set(__self__, "gateway_unique_id", gateway_unique_id)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)
        if lan_allow_minutes is not None:
            pulumi.set(__self__, "lan_allow_minutes", lan_allow_minutes)
        if lan_allow_subnet_size is not None:
            pulumi.set(__self__, "lan_allow_subnet_size", lan_allow_subnet_size)
        if register_interface_ip_with_dns is not None:
            pulumi.set(__self__, "register_interface_ip_with_dns", register_interface_ip_with_dns)
        if sccm_vpn_boundary_support is not None:
            pulumi.set(__self__, "sccm_vpn_boundary_support", sccm_vpn_boundary_support)
        if service_mode_v2 is not None:
            pulumi.set(__self__, "service_mode_v2", service_mode_v2)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)
        if switch_locked is not None:
            pulumi.set(__self__, "switch_locked", switch_locked)
        if tunnel_protocol is not None:
            pulumi.set(__self__, "tunnel_protocol", tunnel_protocol)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="allowModeSwitch")
    def allow_mode_switch(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow the user to switch WARP between modes.
        """
        return pulumi.get(self, "allow_mode_switch")

    @allow_mode_switch.setter
    def allow_mode_switch(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_mode_switch", value)

    @property
    @pulumi.getter(name="allowUpdates")
    def allow_updates(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to receive update notifications when a new version of the client is available.
        """
        return pulumi.get(self, "allow_updates")

    @allow_updates.setter
    def allow_updates(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_updates", value)

    @property
    @pulumi.getter(name="allowedToLeave")
    def allowed_to_leave(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow devices to leave the organization.
        """
        return pulumi.get(self, "allowed_to_leave")

    @allowed_to_leave.setter
    def allowed_to_leave(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allowed_to_leave", value)

    @property
    @pulumi.getter(name="autoConnect")
    def auto_connect(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The amount of time in seconds to reconnect after having been disabled.
        """
        return pulumi.get(self, "auto_connect")

    @auto_connect.setter
    def auto_connect(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "auto_connect", value)

    @property
    @pulumi.getter(name="captivePortal")
    def captive_portal(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Turn on the captive portal after the specified amount of time.
        """
        return pulumi.get(self, "captive_portal")

    @captive_portal.setter
    def captive_portal(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "captive_portal", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the policy will be applied to matching devices.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter(name="disableAutoFallback")
    def disable_auto_fallback(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If the `dns_server` field of a fallback domain is not present, the client will fall back to a best guess of the default/system DNS resolvers unless this policy option is set to `true`.
        """
        return pulumi.get(self, "disable_auto_fallback")

    @disable_auto_fallback.setter
    def disable_auto_fallback(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_auto_fallback", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the policy will be applied to matching devices.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="excludeOfficeIps")
    def exclude_office_ips(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to add Microsoft IPs to Split Tunnel exclusions.
        """
        return pulumi.get(self, "exclude_office_ips")

    @exclude_office_ips.setter
    def exclude_office_ips(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "exclude_office_ips", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileExcludeArgs']]]]:
        """
        List of routes excluded in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileExcludeArgs']]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter(name="fallbackDomains")
    def fallback_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileFallbackDomainArgs']]]]:
        return pulumi.get(self, "fallback_domains")

    @fallback_domains.setter
    def fallback_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileFallbackDomainArgs']]]]):
        pulumi.set(self, "fallback_domains", value)

    @property
    @pulumi.getter(name="gatewayUniqueId")
    def gateway_unique_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "gateway_unique_id")

    @gateway_unique_id.setter
    def gateway_unique_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gateway_unique_id", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileIncludeArgs']]]]:
        """
        List of routes included in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDeviceDefaultProfileIncludeArgs']]]]):
        pulumi.set(self, "includes", value)

    @property
    @pulumi.getter(name="lanAllowMinutes")
    def lan_allow_minutes(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The amount of time in minutes a user is allowed access to their LAN. A value of 0 will allow LAN access until the next WARP reconnection, such as a reboot or a laptop waking from sleep. Note that this field is omitted from the response if null or unset.
        """
        return pulumi.get(self, "lan_allow_minutes")

    @lan_allow_minutes.setter
    def lan_allow_minutes(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "lan_allow_minutes", value)

    @property
    @pulumi.getter(name="lanAllowSubnetSize")
    def lan_allow_subnet_size(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The size of the subnet for the local access network. Note that this field is omitted from the response if null or unset.
        """
        return pulumi.get(self, "lan_allow_subnet_size")

    @lan_allow_subnet_size.setter
    def lan_allow_subnet_size(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "lan_allow_subnet_size", value)

    @property
    @pulumi.getter(name="registerInterfaceIpWithDns")
    def register_interface_ip_with_dns(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if the operating system will register WARP's local interface IP with your on-premises DNS server.
        """
        return pulumi.get(self, "register_interface_ip_with_dns")

    @register_interface_ip_with_dns.setter
    def register_interface_ip_with_dns(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "register_interface_ip_with_dns", value)

    @property
    @pulumi.getter(name="sccmVpnBoundarySupport")
    def sccm_vpn_boundary_support(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether the WARP client indicates to SCCM that it is inside a VPN boundary. (Windows only).
        """
        return pulumi.get(self, "sccm_vpn_boundary_support")

    @sccm_vpn_boundary_support.setter
    def sccm_vpn_boundary_support(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sccm_vpn_boundary_support", value)

    @property
    @pulumi.getter(name="serviceModeV2")
    def service_mode_v2(self) -> Optional[pulumi.Input['ZeroTrustDeviceDefaultProfileServiceModeV2Args']]:
        return pulumi.get(self, "service_mode_v2")

    @service_mode_v2.setter
    def service_mode_v2(self, value: Optional[pulumi.Input['ZeroTrustDeviceDefaultProfileServiceModeV2Args']]):
        pulumi.set(self, "service_mode_v2", value)

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL to launch when the Send Feedback button is clicked.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "support_url", value)

    @property
    @pulumi.getter(name="switchLocked")
    def switch_locked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow the user to turn off the WARP switch and disconnect the client.
        """
        return pulumi.get(self, "switch_locked")

    @switch_locked.setter
    def switch_locked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "switch_locked", value)

    @property
    @pulumi.getter(name="tunnelProtocol")
    def tunnel_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines which tunnel protocol to use.
        """
        return pulumi.get(self, "tunnel_protocol")

    @tunnel_protocol.setter
    def tunnel_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_protocol", value)


@pulumi.type_token("cloudflare:index/zeroTrustDeviceDefaultProfile:ZeroTrustDeviceDefaultProfile")
class ZeroTrustDeviceDefaultProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 allow_mode_switch: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_updates: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_to_leave: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_connect: Optional[pulumi.Input[builtins.float]] = None,
                 captive_portal: Optional[pulumi.Input[builtins.float]] = None,
                 disable_auto_fallback: Optional[pulumi.Input[builtins.bool]] = None,
                 exclude_office_ips: Optional[pulumi.Input[builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileExcludeArgs', 'ZeroTrustDeviceDefaultProfileExcludeArgsDict']]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileIncludeArgs', 'ZeroTrustDeviceDefaultProfileIncludeArgsDict']]]]] = None,
                 lan_allow_minutes: Optional[pulumi.Input[builtins.float]] = None,
                 lan_allow_subnet_size: Optional[pulumi.Input[builtins.float]] = None,
                 register_interface_ip_with_dns: Optional[pulumi.Input[builtins.bool]] = None,
                 sccm_vpn_boundary_support: Optional[pulumi.Input[builtins.bool]] = None,
                 service_mode_v2: Optional[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileServiceModeV2Args', 'ZeroTrustDeviceDefaultProfileServiceModeV2ArgsDict']]] = None,
                 support_url: Optional[pulumi.Input[builtins.str]] = None,
                 switch_locked: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_device_default_profile = cloudflare.ZeroTrustDeviceDefaultProfile("example_zero_trust_device_default_profile",
            account_id="699d98642c564d2e855e9661899b7252",
            allow_mode_switch=True,
            allow_updates=True,
            allowed_to_leave=True,
            auto_connect=0,
            captive_portal=180,
            disable_auto_fallback=True,
            excludes=[{
                "address": "192.0.2.0/24",
                "description": "Exclude testing domains from the tunnel",
            }],
            exclude_office_ips=True,
            includes=[{
                "address": "192.0.2.0/24",
                "description": "Include testing domains in the tunnel",
            }],
            lan_allow_minutes=30,
            lan_allow_subnet_size=24,
            register_interface_ip_with_dns=True,
            sccm_vpn_boundary_support=False,
            service_mode_v2={
                "mode": "proxy",
                "port": 3000,
            },
            support_url="https://1.1.1.1/help",
            switch_locked=True,
            tunnel_protocol="wireguard")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDeviceDefaultProfile:ZeroTrustDeviceDefaultProfile example '<account_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_mode_switch: Whether to allow the user to switch WARP between modes.
        :param pulumi.Input[builtins.bool] allow_updates: Whether to receive update notifications when a new version of the client is available.
        :param pulumi.Input[builtins.bool] allowed_to_leave: Whether to allow devices to leave the organization.
        :param pulumi.Input[builtins.float] auto_connect: The amount of time in seconds to reconnect after having been disabled.
        :param pulumi.Input[builtins.float] captive_portal: Turn on the captive portal after the specified amount of time.
        :param pulumi.Input[builtins.bool] disable_auto_fallback: If the `dns_server` field of a fallback domain is not present, the client will fall back to a best guess of the default/system DNS resolvers unless this policy option is set to `true`.
        :param pulumi.Input[builtins.bool] exclude_office_ips: Whether to add Microsoft IPs to Split Tunnel exclusions.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileExcludeArgs', 'ZeroTrustDeviceDefaultProfileExcludeArgsDict']]]] excludes: List of routes excluded in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileIncludeArgs', 'ZeroTrustDeviceDefaultProfileIncludeArgsDict']]]] includes: List of routes included in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        :param pulumi.Input[builtins.float] lan_allow_minutes: The amount of time in minutes a user is allowed access to their LAN. A value of 0 will allow LAN access until the next WARP reconnection, such as a reboot or a laptop waking from sleep. Note that this field is omitted from the response if null or unset.
        :param pulumi.Input[builtins.float] lan_allow_subnet_size: The size of the subnet for the local access network. Note that this field is omitted from the response if null or unset.
        :param pulumi.Input[builtins.bool] register_interface_ip_with_dns: Determines if the operating system will register WARP's local interface IP with your on-premises DNS server.
        :param pulumi.Input[builtins.bool] sccm_vpn_boundary_support: Determines whether the WARP client indicates to SCCM that it is inside a VPN boundary. (Windows only).
        :param pulumi.Input[builtins.str] support_url: The URL to launch when the Send Feedback button is clicked.
        :param pulumi.Input[builtins.bool] switch_locked: Whether to allow the user to turn off the WARP switch and disconnect the client.
        :param pulumi.Input[builtins.str] tunnel_protocol: Determines which tunnel protocol to use.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustDeviceDefaultProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_device_default_profile = cloudflare.ZeroTrustDeviceDefaultProfile("example_zero_trust_device_default_profile",
            account_id="699d98642c564d2e855e9661899b7252",
            allow_mode_switch=True,
            allow_updates=True,
            allowed_to_leave=True,
            auto_connect=0,
            captive_portal=180,
            disable_auto_fallback=True,
            excludes=[{
                "address": "192.0.2.0/24",
                "description": "Exclude testing domains from the tunnel",
            }],
            exclude_office_ips=True,
            includes=[{
                "address": "192.0.2.0/24",
                "description": "Include testing domains in the tunnel",
            }],
            lan_allow_minutes=30,
            lan_allow_subnet_size=24,
            register_interface_ip_with_dns=True,
            sccm_vpn_boundary_support=False,
            service_mode_v2={
                "mode": "proxy",
                "port": 3000,
            },
            support_url="https://1.1.1.1/help",
            switch_locked=True,
            tunnel_protocol="wireguard")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDeviceDefaultProfile:ZeroTrustDeviceDefaultProfile example '<account_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustDeviceDefaultProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustDeviceDefaultProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 allow_mode_switch: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_updates: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_to_leave: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_connect: Optional[pulumi.Input[builtins.float]] = None,
                 captive_portal: Optional[pulumi.Input[builtins.float]] = None,
                 disable_auto_fallback: Optional[pulumi.Input[builtins.bool]] = None,
                 exclude_office_ips: Optional[pulumi.Input[builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileExcludeArgs', 'ZeroTrustDeviceDefaultProfileExcludeArgsDict']]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileIncludeArgs', 'ZeroTrustDeviceDefaultProfileIncludeArgsDict']]]]] = None,
                 lan_allow_minutes: Optional[pulumi.Input[builtins.float]] = None,
                 lan_allow_subnet_size: Optional[pulumi.Input[builtins.float]] = None,
                 register_interface_ip_with_dns: Optional[pulumi.Input[builtins.bool]] = None,
                 sccm_vpn_boundary_support: Optional[pulumi.Input[builtins.bool]] = None,
                 service_mode_v2: Optional[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileServiceModeV2Args', 'ZeroTrustDeviceDefaultProfileServiceModeV2ArgsDict']]] = None,
                 support_url: Optional[pulumi.Input[builtins.str]] = None,
                 switch_locked: Optional[pulumi.Input[builtins.bool]] = None,
                 tunnel_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustDeviceDefaultProfileArgs.__new__(ZeroTrustDeviceDefaultProfileArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["allow_mode_switch"] = allow_mode_switch
            __props__.__dict__["allow_updates"] = allow_updates
            __props__.__dict__["allowed_to_leave"] = allowed_to_leave
            __props__.__dict__["auto_connect"] = auto_connect
            __props__.__dict__["captive_portal"] = captive_portal
            __props__.__dict__["disable_auto_fallback"] = disable_auto_fallback
            __props__.__dict__["exclude_office_ips"] = exclude_office_ips
            __props__.__dict__["excludes"] = excludes
            __props__.__dict__["includes"] = includes
            __props__.__dict__["lan_allow_minutes"] = lan_allow_minutes
            __props__.__dict__["lan_allow_subnet_size"] = lan_allow_subnet_size
            __props__.__dict__["register_interface_ip_with_dns"] = register_interface_ip_with_dns
            __props__.__dict__["sccm_vpn_boundary_support"] = sccm_vpn_boundary_support
            __props__.__dict__["service_mode_v2"] = service_mode_v2
            __props__.__dict__["support_url"] = support_url
            __props__.__dict__["switch_locked"] = switch_locked
            __props__.__dict__["tunnel_protocol"] = tunnel_protocol
            __props__.__dict__["default"] = None
            __props__.__dict__["enabled"] = None
            __props__.__dict__["fallback_domains"] = None
            __props__.__dict__["gateway_unique_id"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/deviceSettingsPolicy:DeviceSettingsPolicy"), pulumi.Alias(type_="cloudflare:index/splitTunnel:SplitTunnel")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ZeroTrustDeviceDefaultProfile, __self__).__init__(
            'cloudflare:index/zeroTrustDeviceDefaultProfile:ZeroTrustDeviceDefaultProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            allow_mode_switch: Optional[pulumi.Input[builtins.bool]] = None,
            allow_updates: Optional[pulumi.Input[builtins.bool]] = None,
            allowed_to_leave: Optional[pulumi.Input[builtins.bool]] = None,
            auto_connect: Optional[pulumi.Input[builtins.float]] = None,
            captive_portal: Optional[pulumi.Input[builtins.float]] = None,
            default: Optional[pulumi.Input[builtins.bool]] = None,
            disable_auto_fallback: Optional[pulumi.Input[builtins.bool]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            exclude_office_ips: Optional[pulumi.Input[builtins.bool]] = None,
            excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileExcludeArgs', 'ZeroTrustDeviceDefaultProfileExcludeArgsDict']]]]] = None,
            fallback_domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileFallbackDomainArgs', 'ZeroTrustDeviceDefaultProfileFallbackDomainArgsDict']]]]] = None,
            gateway_unique_id: Optional[pulumi.Input[builtins.str]] = None,
            includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileIncludeArgs', 'ZeroTrustDeviceDefaultProfileIncludeArgsDict']]]]] = None,
            lan_allow_minutes: Optional[pulumi.Input[builtins.float]] = None,
            lan_allow_subnet_size: Optional[pulumi.Input[builtins.float]] = None,
            register_interface_ip_with_dns: Optional[pulumi.Input[builtins.bool]] = None,
            sccm_vpn_boundary_support: Optional[pulumi.Input[builtins.bool]] = None,
            service_mode_v2: Optional[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileServiceModeV2Args', 'ZeroTrustDeviceDefaultProfileServiceModeV2ArgsDict']]] = None,
            support_url: Optional[pulumi.Input[builtins.str]] = None,
            switch_locked: Optional[pulumi.Input[builtins.bool]] = None,
            tunnel_protocol: Optional[pulumi.Input[builtins.str]] = None) -> 'ZeroTrustDeviceDefaultProfile':
        """
        Get an existing ZeroTrustDeviceDefaultProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_mode_switch: Whether to allow the user to switch WARP between modes.
        :param pulumi.Input[builtins.bool] allow_updates: Whether to receive update notifications when a new version of the client is available.
        :param pulumi.Input[builtins.bool] allowed_to_leave: Whether to allow devices to leave the organization.
        :param pulumi.Input[builtins.float] auto_connect: The amount of time in seconds to reconnect after having been disabled.
        :param pulumi.Input[builtins.float] captive_portal: Turn on the captive portal after the specified amount of time.
        :param pulumi.Input[builtins.bool] default: Whether the policy will be applied to matching devices.
        :param pulumi.Input[builtins.bool] disable_auto_fallback: If the `dns_server` field of a fallback domain is not present, the client will fall back to a best guess of the default/system DNS resolvers unless this policy option is set to `true`.
        :param pulumi.Input[builtins.bool] enabled: Whether the policy will be applied to matching devices.
        :param pulumi.Input[builtins.bool] exclude_office_ips: Whether to add Microsoft IPs to Split Tunnel exclusions.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileExcludeArgs', 'ZeroTrustDeviceDefaultProfileExcludeArgsDict']]]] excludes: List of routes excluded in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDeviceDefaultProfileIncludeArgs', 'ZeroTrustDeviceDefaultProfileIncludeArgsDict']]]] includes: List of routes included in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        :param pulumi.Input[builtins.float] lan_allow_minutes: The amount of time in minutes a user is allowed access to their LAN. A value of 0 will allow LAN access until the next WARP reconnection, such as a reboot or a laptop waking from sleep. Note that this field is omitted from the response if null or unset.
        :param pulumi.Input[builtins.float] lan_allow_subnet_size: The size of the subnet for the local access network. Note that this field is omitted from the response if null or unset.
        :param pulumi.Input[builtins.bool] register_interface_ip_with_dns: Determines if the operating system will register WARP's local interface IP with your on-premises DNS server.
        :param pulumi.Input[builtins.bool] sccm_vpn_boundary_support: Determines whether the WARP client indicates to SCCM that it is inside a VPN boundary. (Windows only).
        :param pulumi.Input[builtins.str] support_url: The URL to launch when the Send Feedback button is clicked.
        :param pulumi.Input[builtins.bool] switch_locked: Whether to allow the user to turn off the WARP switch and disconnect the client.
        :param pulumi.Input[builtins.str] tunnel_protocol: Determines which tunnel protocol to use.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustDeviceDefaultProfileState.__new__(_ZeroTrustDeviceDefaultProfileState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["allow_mode_switch"] = allow_mode_switch
        __props__.__dict__["allow_updates"] = allow_updates
        __props__.__dict__["allowed_to_leave"] = allowed_to_leave
        __props__.__dict__["auto_connect"] = auto_connect
        __props__.__dict__["captive_portal"] = captive_portal
        __props__.__dict__["default"] = default
        __props__.__dict__["disable_auto_fallback"] = disable_auto_fallback
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["exclude_office_ips"] = exclude_office_ips
        __props__.__dict__["excludes"] = excludes
        __props__.__dict__["fallback_domains"] = fallback_domains
        __props__.__dict__["gateway_unique_id"] = gateway_unique_id
        __props__.__dict__["includes"] = includes
        __props__.__dict__["lan_allow_minutes"] = lan_allow_minutes
        __props__.__dict__["lan_allow_subnet_size"] = lan_allow_subnet_size
        __props__.__dict__["register_interface_ip_with_dns"] = register_interface_ip_with_dns
        __props__.__dict__["sccm_vpn_boundary_support"] = sccm_vpn_boundary_support
        __props__.__dict__["service_mode_v2"] = service_mode_v2
        __props__.__dict__["support_url"] = support_url
        __props__.__dict__["switch_locked"] = switch_locked
        __props__.__dict__["tunnel_protocol"] = tunnel_protocol
        return ZeroTrustDeviceDefaultProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="allowModeSwitch")
    def allow_mode_switch(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to allow the user to switch WARP between modes.
        """
        return pulumi.get(self, "allow_mode_switch")

    @property
    @pulumi.getter(name="allowUpdates")
    def allow_updates(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to receive update notifications when a new version of the client is available.
        """
        return pulumi.get(self, "allow_updates")

    @property
    @pulumi.getter(name="allowedToLeave")
    def allowed_to_leave(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to allow devices to leave the organization.
        """
        return pulumi.get(self, "allowed_to_leave")

    @property
    @pulumi.getter(name="autoConnect")
    def auto_connect(self) -> pulumi.Output[builtins.float]:
        """
        The amount of time in seconds to reconnect after having been disabled.
        """
        return pulumi.get(self, "auto_connect")

    @property
    @pulumi.getter(name="captivePortal")
    def captive_portal(self) -> pulumi.Output[builtins.float]:
        """
        Turn on the captive portal after the specified amount of time.
        """
        return pulumi.get(self, "captive_portal")

    @property
    @pulumi.getter
    def default(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the policy will be applied to matching devices.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter(name="disableAutoFallback")
    def disable_auto_fallback(self) -> pulumi.Output[builtins.bool]:
        """
        If the `dns_server` field of a fallback domain is not present, the client will fall back to a best guess of the default/system DNS resolvers unless this policy option is set to `true`.
        """
        return pulumi.get(self, "disable_auto_fallback")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the policy will be applied to matching devices.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="excludeOfficeIps")
    def exclude_office_ips(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to add Microsoft IPs to Split Tunnel exclusions.
        """
        return pulumi.get(self, "exclude_office_ips")

    @property
    @pulumi.getter
    def excludes(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustDeviceDefaultProfileExclude']]]:
        """
        List of routes excluded in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="fallbackDomains")
    def fallback_domains(self) -> pulumi.Output[Sequence['outputs.ZeroTrustDeviceDefaultProfileFallbackDomain']]:
        return pulumi.get(self, "fallback_domains")

    @property
    @pulumi.getter(name="gatewayUniqueId")
    def gateway_unique_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "gateway_unique_id")

    @property
    @pulumi.getter
    def includes(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustDeviceDefaultProfileInclude']]]:
        """
        List of routes included in the WARP client's tunnel. Both 'exclude' and 'include' cannot be set in the same request.
        """
        return pulumi.get(self, "includes")

    @property
    @pulumi.getter(name="lanAllowMinutes")
    def lan_allow_minutes(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The amount of time in minutes a user is allowed access to their LAN. A value of 0 will allow LAN access until the next WARP reconnection, such as a reboot or a laptop waking from sleep. Note that this field is omitted from the response if null or unset.
        """
        return pulumi.get(self, "lan_allow_minutes")

    @property
    @pulumi.getter(name="lanAllowSubnetSize")
    def lan_allow_subnet_size(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The size of the subnet for the local access network. Note that this field is omitted from the response if null or unset.
        """
        return pulumi.get(self, "lan_allow_subnet_size")

    @property
    @pulumi.getter(name="registerInterfaceIpWithDns")
    def register_interface_ip_with_dns(self) -> pulumi.Output[builtins.bool]:
        """
        Determines if the operating system will register WARP's local interface IP with your on-premises DNS server.
        """
        return pulumi.get(self, "register_interface_ip_with_dns")

    @property
    @pulumi.getter(name="sccmVpnBoundarySupport")
    def sccm_vpn_boundary_support(self) -> pulumi.Output[builtins.bool]:
        """
        Determines whether the WARP client indicates to SCCM that it is inside a VPN boundary. (Windows only).
        """
        return pulumi.get(self, "sccm_vpn_boundary_support")

    @property
    @pulumi.getter(name="serviceModeV2")
    def service_mode_v2(self) -> pulumi.Output[Optional['outputs.ZeroTrustDeviceDefaultProfileServiceModeV2']]:
        return pulumi.get(self, "service_mode_v2")

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL to launch when the Send Feedback button is clicked.
        """
        return pulumi.get(self, "support_url")

    @property
    @pulumi.getter(name="switchLocked")
    def switch_locked(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to allow the user to turn off the WARP switch and disconnect the client.
        """
        return pulumi.get(self, "switch_locked")

    @property
    @pulumi.getter(name="tunnelProtocol")
    def tunnel_protocol(self) -> pulumi.Output[builtins.str]:
        """
        Determines which tunnel protocol to use.
        """
        return pulumi.get(self, "tunnel_protocol")

