# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ZeroTrustDeviceSettingsArgs', 'ZeroTrustDeviceSettings']

@pulumi.input_type
class ZeroTrustDeviceSettingsArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 disable_for_time: Optional[pulumi.Input[builtins.float]] = None,
                 gateway_proxy_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_udp_proxy_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 root_certificate_installation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 use_zt_virtual_ip: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ZeroTrustDeviceSettings resource.
        :param pulumi.Input[builtins.float] disable_for_time: Sets the time limit, in seconds, that a user can use an override code to bypass WARP.
        :param pulumi.Input[builtins.bool] gateway_proxy_enabled: Enable gateway proxy filtering on TCP.
        :param pulumi.Input[builtins.bool] gateway_udp_proxy_enabled: Enable gateway proxy filtering on UDP.
        :param pulumi.Input[builtins.bool] root_certificate_installation_enabled: Enable installation of cloudflare managed root certificate.
        :param pulumi.Input[builtins.bool] use_zt_virtual_ip: Enable using CGNAT virtual IPv4.
        """
        pulumi.set(__self__, "account_id", account_id)
        if disable_for_time is not None:
            pulumi.set(__self__, "disable_for_time", disable_for_time)
        if gateway_proxy_enabled is not None:
            pulumi.set(__self__, "gateway_proxy_enabled", gateway_proxy_enabled)
        if gateway_udp_proxy_enabled is not None:
            pulumi.set(__self__, "gateway_udp_proxy_enabled", gateway_udp_proxy_enabled)
        if root_certificate_installation_enabled is not None:
            pulumi.set(__self__, "root_certificate_installation_enabled", root_certificate_installation_enabled)
        if use_zt_virtual_ip is not None:
            pulumi.set(__self__, "use_zt_virtual_ip", use_zt_virtual_ip)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="disableForTime")
    def disable_for_time(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Sets the time limit, in seconds, that a user can use an override code to bypass WARP.
        """
        return pulumi.get(self, "disable_for_time")

    @disable_for_time.setter
    def disable_for_time(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "disable_for_time", value)

    @property
    @pulumi.getter(name="gatewayProxyEnabled")
    def gateway_proxy_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable gateway proxy filtering on TCP.
        """
        return pulumi.get(self, "gateway_proxy_enabled")

    @gateway_proxy_enabled.setter
    def gateway_proxy_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "gateway_proxy_enabled", value)

    @property
    @pulumi.getter(name="gatewayUdpProxyEnabled")
    def gateway_udp_proxy_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable gateway proxy filtering on UDP.
        """
        return pulumi.get(self, "gateway_udp_proxy_enabled")

    @gateway_udp_proxy_enabled.setter
    def gateway_udp_proxy_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "gateway_udp_proxy_enabled", value)

    @property
    @pulumi.getter(name="rootCertificateInstallationEnabled")
    def root_certificate_installation_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable installation of cloudflare managed root certificate.
        """
        return pulumi.get(self, "root_certificate_installation_enabled")

    @root_certificate_installation_enabled.setter
    def root_certificate_installation_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "root_certificate_installation_enabled", value)

    @property
    @pulumi.getter(name="useZtVirtualIp")
    def use_zt_virtual_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable using CGNAT virtual IPv4.
        """
        return pulumi.get(self, "use_zt_virtual_ip")

    @use_zt_virtual_ip.setter
    def use_zt_virtual_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_zt_virtual_ip", value)


@pulumi.input_type
class _ZeroTrustDeviceSettingsState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 disable_for_time: Optional[pulumi.Input[builtins.float]] = None,
                 gateway_proxy_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_udp_proxy_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 root_certificate_installation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 use_zt_virtual_ip: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustDeviceSettings resources.
        :param pulumi.Input[builtins.float] disable_for_time: Sets the time limit, in seconds, that a user can use an override code to bypass WARP.
        :param pulumi.Input[builtins.bool] gateway_proxy_enabled: Enable gateway proxy filtering on TCP.
        :param pulumi.Input[builtins.bool] gateway_udp_proxy_enabled: Enable gateway proxy filtering on UDP.
        :param pulumi.Input[builtins.bool] root_certificate_installation_enabled: Enable installation of cloudflare managed root certificate.
        :param pulumi.Input[builtins.bool] use_zt_virtual_ip: Enable using CGNAT virtual IPv4.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if disable_for_time is not None:
            pulumi.set(__self__, "disable_for_time", disable_for_time)
        if gateway_proxy_enabled is not None:
            pulumi.set(__self__, "gateway_proxy_enabled", gateway_proxy_enabled)
        if gateway_udp_proxy_enabled is not None:
            pulumi.set(__self__, "gateway_udp_proxy_enabled", gateway_udp_proxy_enabled)
        if root_certificate_installation_enabled is not None:
            pulumi.set(__self__, "root_certificate_installation_enabled", root_certificate_installation_enabled)
        if use_zt_virtual_ip is not None:
            pulumi.set(__self__, "use_zt_virtual_ip", use_zt_virtual_ip)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="disableForTime")
    def disable_for_time(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Sets the time limit, in seconds, that a user can use an override code to bypass WARP.
        """
        return pulumi.get(self, "disable_for_time")

    @disable_for_time.setter
    def disable_for_time(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "disable_for_time", value)

    @property
    @pulumi.getter(name="gatewayProxyEnabled")
    def gateway_proxy_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable gateway proxy filtering on TCP.
        """
        return pulumi.get(self, "gateway_proxy_enabled")

    @gateway_proxy_enabled.setter
    def gateway_proxy_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "gateway_proxy_enabled", value)

    @property
    @pulumi.getter(name="gatewayUdpProxyEnabled")
    def gateway_udp_proxy_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable gateway proxy filtering on UDP.
        """
        return pulumi.get(self, "gateway_udp_proxy_enabled")

    @gateway_udp_proxy_enabled.setter
    def gateway_udp_proxy_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "gateway_udp_proxy_enabled", value)

    @property
    @pulumi.getter(name="rootCertificateInstallationEnabled")
    def root_certificate_installation_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable installation of cloudflare managed root certificate.
        """
        return pulumi.get(self, "root_certificate_installation_enabled")

    @root_certificate_installation_enabled.setter
    def root_certificate_installation_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "root_certificate_installation_enabled", value)

    @property
    @pulumi.getter(name="useZtVirtualIp")
    def use_zt_virtual_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable using CGNAT virtual IPv4.
        """
        return pulumi.get(self, "use_zt_virtual_ip")

    @use_zt_virtual_ip.setter
    def use_zt_virtual_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_zt_virtual_ip", value)


@pulumi.type_token("cloudflare:index/zeroTrustDeviceSettings:ZeroTrustDeviceSettings")
class ZeroTrustDeviceSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 disable_for_time: Optional[pulumi.Input[builtins.float]] = None,
                 gateway_proxy_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_udp_proxy_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 root_certificate_installation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 use_zt_virtual_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_device_settings = cloudflare.ZeroTrustDeviceSettings("example_zero_trust_device_settings",
            account_id="699d98642c564d2e855e9661899b7252",
            disable_for_time=0,
            gateway_proxy_enabled=True,
            gateway_udp_proxy_enabled=True,
            root_certificate_installation_enabled=True,
            use_zt_virtual_ip=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.float] disable_for_time: Sets the time limit, in seconds, that a user can use an override code to bypass WARP.
        :param pulumi.Input[builtins.bool] gateway_proxy_enabled: Enable gateway proxy filtering on TCP.
        :param pulumi.Input[builtins.bool] gateway_udp_proxy_enabled: Enable gateway proxy filtering on UDP.
        :param pulumi.Input[builtins.bool] root_certificate_installation_enabled: Enable installation of cloudflare managed root certificate.
        :param pulumi.Input[builtins.bool] use_zt_virtual_ip: Enable using CGNAT virtual IPv4.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustDeviceSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_device_settings = cloudflare.ZeroTrustDeviceSettings("example_zero_trust_device_settings",
            account_id="699d98642c564d2e855e9661899b7252",
            disable_for_time=0,
            gateway_proxy_enabled=True,
            gateway_udp_proxy_enabled=True,
            root_certificate_installation_enabled=True,
            use_zt_virtual_ip=True)
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustDeviceSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustDeviceSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 disable_for_time: Optional[pulumi.Input[builtins.float]] = None,
                 gateway_proxy_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_udp_proxy_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 root_certificate_installation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 use_zt_virtual_ip: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustDeviceSettingsArgs.__new__(ZeroTrustDeviceSettingsArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["disable_for_time"] = disable_for_time
            __props__.__dict__["gateway_proxy_enabled"] = gateway_proxy_enabled
            __props__.__dict__["gateway_udp_proxy_enabled"] = gateway_udp_proxy_enabled
            __props__.__dict__["root_certificate_installation_enabled"] = root_certificate_installation_enabled
            __props__.__dict__["use_zt_virtual_ip"] = use_zt_virtual_ip
        super(ZeroTrustDeviceSettings, __self__).__init__(
            'cloudflare:index/zeroTrustDeviceSettings:ZeroTrustDeviceSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            disable_for_time: Optional[pulumi.Input[builtins.float]] = None,
            gateway_proxy_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            gateway_udp_proxy_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            root_certificate_installation_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            use_zt_virtual_ip: Optional[pulumi.Input[builtins.bool]] = None) -> 'ZeroTrustDeviceSettings':
        """
        Get an existing ZeroTrustDeviceSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.float] disable_for_time: Sets the time limit, in seconds, that a user can use an override code to bypass WARP.
        :param pulumi.Input[builtins.bool] gateway_proxy_enabled: Enable gateway proxy filtering on TCP.
        :param pulumi.Input[builtins.bool] gateway_udp_proxy_enabled: Enable gateway proxy filtering on UDP.
        :param pulumi.Input[builtins.bool] root_certificate_installation_enabled: Enable installation of cloudflare managed root certificate.
        :param pulumi.Input[builtins.bool] use_zt_virtual_ip: Enable using CGNAT virtual IPv4.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustDeviceSettingsState.__new__(_ZeroTrustDeviceSettingsState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["disable_for_time"] = disable_for_time
        __props__.__dict__["gateway_proxy_enabled"] = gateway_proxy_enabled
        __props__.__dict__["gateway_udp_proxy_enabled"] = gateway_udp_proxy_enabled
        __props__.__dict__["root_certificate_installation_enabled"] = root_certificate_installation_enabled
        __props__.__dict__["use_zt_virtual_ip"] = use_zt_virtual_ip
        return ZeroTrustDeviceSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="disableForTime")
    def disable_for_time(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        Sets the time limit, in seconds, that a user can use an override code to bypass WARP.
        """
        return pulumi.get(self, "disable_for_time")

    @property
    @pulumi.getter(name="gatewayProxyEnabled")
    def gateway_proxy_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable gateway proxy filtering on TCP.
        """
        return pulumi.get(self, "gateway_proxy_enabled")

    @property
    @pulumi.getter(name="gatewayUdpProxyEnabled")
    def gateway_udp_proxy_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable gateway proxy filtering on UDP.
        """
        return pulumi.get(self, "gateway_udp_proxy_enabled")

    @property
    @pulumi.getter(name="rootCertificateInstallationEnabled")
    def root_certificate_installation_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable installation of cloudflare managed root certificate.
        """
        return pulumi.get(self, "root_certificate_installation_enabled")

    @property
    @pulumi.getter(name="useZtVirtualIp")
    def use_zt_virtual_ip(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable using CGNAT virtual IPv4.
        """
        return pulumi.get(self, "use_zt_virtual_ip")

