# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustDlpEntryArgs', 'ZeroTrustDlpEntry']

@pulumi.input_type
class ZeroTrustDlpEntryArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 enabled: pulumi.Input[builtins.bool],
                 name: pulumi.Input[builtins.str],
                 pattern: pulumi.Input['ZeroTrustDlpEntryPatternArgs'],
                 profile_id: pulumi.Input[builtins.str],
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ZeroTrustDlpEntry resource.
        :param pulumi.Input[builtins.str] type: Available values: "custom", "predefined", "integration".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pattern", pattern)
        pulumi.set(__self__, "profile_id", profile_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pattern(self) -> pulumi.Input['ZeroTrustDlpEntryPatternArgs']:
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: pulumi.Input['ZeroTrustDlpEntryPatternArgs']):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Available values: "custom", "predefined", "integration".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ZeroTrustDlpEntryState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 case_sensitive: Optional[pulumi.Input[builtins.bool]] = None,
                 confidence: Optional[pulumi.Input['ZeroTrustDlpEntryConfidenceArgs']] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pattern: Optional[pulumi.Input['ZeroTrustDlpEntryPatternArgs']] = None,
                 profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 secret: Optional[pulumi.Input[builtins.bool]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 word_list: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustDlpEntry resources.
        :param pulumi.Input[builtins.bool] case_sensitive: Only applies to custom word lists.
               Determines if the words should be matched in a case-sensitive manner
               Cannot be set to false if secret is true
        :param pulumi.Input[builtins.str] type: Available values: "custom", "predefined", "integration".
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if confidence is not None:
            pulumi.set(__self__, "confidence", confidence)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if word_list is not None:
            pulumi.set(__self__, "word_list", word_list)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Only applies to custom word lists.
        Determines if the words should be matched in a case-sensitive manner
        Cannot be set to false if secret is true
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "case_sensitive", value)

    @property
    @pulumi.getter
    def confidence(self) -> Optional[pulumi.Input['ZeroTrustDlpEntryConfidenceArgs']]:
        return pulumi.get(self, "confidence")

    @confidence.setter
    def confidence(self, value: Optional[pulumi.Input['ZeroTrustDlpEntryConfidenceArgs']]):
        pulumi.set(self, "confidence", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input['ZeroTrustDlpEntryPatternArgs']]:
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input['ZeroTrustDlpEntryPatternArgs']]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Available values: "custom", "predefined", "integration".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="wordList")
    def word_list(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "word_list")

    @word_list.setter
    def word_list(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "word_list", value)


@pulumi.type_token("cloudflare:index/zeroTrustDlpEntry:ZeroTrustDlpEntry")
class ZeroTrustDlpEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pattern: Optional[pulumi.Input[Union['ZeroTrustDlpEntryPatternArgs', 'ZeroTrustDlpEntryPatternArgsDict']]] = None,
                 profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_dlp_entry = cloudflare.ZeroTrustDlpEntry("example_zero_trust_dlp_entry",
            account_id="account_id",
            enabled=True,
            name="name",
            pattern={
                "regex": "regex",
                "validation": "luhn",
            },
            profile_id="182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDlpEntry:ZeroTrustDlpEntry example '<account_id>/<entry_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] type: Available values: "custom", "predefined", "integration".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustDlpEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_dlp_entry = cloudflare.ZeroTrustDlpEntry("example_zero_trust_dlp_entry",
            account_id="account_id",
            enabled=True,
            name="name",
            pattern={
                "regex": "regex",
                "validation": "luhn",
            },
            profile_id="182bd5e5-6e1a-4fe4-a799-aa6d9a6ab26e")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDlpEntry:ZeroTrustDlpEntry example '<account_id>/<entry_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustDlpEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustDlpEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pattern: Optional[pulumi.Input[Union['ZeroTrustDlpEntryPatternArgs', 'ZeroTrustDlpEntryPatternArgsDict']]] = None,
                 profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustDlpEntryArgs.__new__(ZeroTrustDlpEntryArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if pattern is None and not opts.urn:
                raise TypeError("Missing required property 'pattern'")
            __props__.__dict__["pattern"] = pattern
            if profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'profile_id'")
            __props__.__dict__["profile_id"] = profile_id
            __props__.__dict__["type"] = type
            __props__.__dict__["case_sensitive"] = None
            __props__.__dict__["confidence"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["secret"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["word_list"] = None
        super(ZeroTrustDlpEntry, __self__).__init__(
            'cloudflare:index/zeroTrustDlpEntry:ZeroTrustDlpEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            case_sensitive: Optional[pulumi.Input[builtins.bool]] = None,
            confidence: Optional[pulumi.Input[Union['ZeroTrustDlpEntryConfidenceArgs', 'ZeroTrustDlpEntryConfidenceArgsDict']]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            pattern: Optional[pulumi.Input[Union['ZeroTrustDlpEntryPatternArgs', 'ZeroTrustDlpEntryPatternArgsDict']]] = None,
            profile_id: Optional[pulumi.Input[builtins.str]] = None,
            secret: Optional[pulumi.Input[builtins.bool]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            word_list: Optional[pulumi.Input[builtins.str]] = None) -> 'ZeroTrustDlpEntry':
        """
        Get an existing ZeroTrustDlpEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] case_sensitive: Only applies to custom word lists.
               Determines if the words should be matched in a case-sensitive manner
               Cannot be set to false if secret is true
        :param pulumi.Input[builtins.str] type: Available values: "custom", "predefined", "integration".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustDlpEntryState.__new__(_ZeroTrustDlpEntryState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["case_sensitive"] = case_sensitive
        __props__.__dict__["confidence"] = confidence
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["pattern"] = pattern
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["secret"] = secret
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["word_list"] = word_list
        return ZeroTrustDlpEntry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> pulumi.Output[builtins.bool]:
        """
        Only applies to custom word lists.
        Determines if the words should be matched in a case-sensitive manner
        Cannot be set to false if secret is true
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter
    def confidence(self) -> pulumi.Output['outputs.ZeroTrustDlpEntryConfidence']:
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def pattern(self) -> pulumi.Output['outputs.ZeroTrustDlpEntryPattern']:
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Available values: "custom", "predefined", "integration".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="wordList")
    def word_list(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "word_list")

