# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustRiskBehaviorArgs', 'ZeroTrustRiskBehavior']

@pulumi.input_type
class ZeroTrustRiskBehaviorArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 behaviors: pulumi.Input[Mapping[str, pulumi.Input['ZeroTrustRiskBehaviorBehaviorsArgs']]]):
        """
        The set of arguments for constructing a ZeroTrustRiskBehavior resource.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "behaviors", behaviors)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def behaviors(self) -> pulumi.Input[Mapping[str, pulumi.Input['ZeroTrustRiskBehaviorBehaviorsArgs']]]:
        return pulumi.get(self, "behaviors")

    @behaviors.setter
    def behaviors(self, value: pulumi.Input[Mapping[str, pulumi.Input['ZeroTrustRiskBehaviorBehaviorsArgs']]]):
        pulumi.set(self, "behaviors", value)


@pulumi.input_type
class _ZeroTrustRiskBehaviorState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 behaviors: Optional[pulumi.Input[Mapping[str, pulumi.Input['ZeroTrustRiskBehaviorBehaviorsArgs']]]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustRiskBehavior resources.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if behaviors is not None:
            pulumi.set(__self__, "behaviors", behaviors)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def behaviors(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['ZeroTrustRiskBehaviorBehaviorsArgs']]]]:
        return pulumi.get(self, "behaviors")

    @behaviors.setter
    def behaviors(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['ZeroTrustRiskBehaviorBehaviorsArgs']]]]):
        pulumi.set(self, "behaviors", value)


@pulumi.type_token("cloudflare:index/zeroTrustRiskBehavior:ZeroTrustRiskBehavior")
class ZeroTrustRiskBehavior(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 behaviors: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['ZeroTrustRiskBehaviorBehaviorsArgs', 'ZeroTrustRiskBehaviorBehaviorsArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_risk_behavior = cloudflare.ZeroTrustRiskBehavior("example_zero_trust_risk_behavior",
            account_id="account_id",
            behaviors={
                "foo": {
                    "enabled": True,
                    "risk_level": "low",
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustRiskBehaviorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_risk_behavior = cloudflare.ZeroTrustRiskBehavior("example_zero_trust_risk_behavior",
            account_id="account_id",
            behaviors={
                "foo": {
                    "enabled": True,
                    "risk_level": "low",
                },
            })
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustRiskBehaviorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustRiskBehaviorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 behaviors: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['ZeroTrustRiskBehaviorBehaviorsArgs', 'ZeroTrustRiskBehaviorBehaviorsArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustRiskBehaviorArgs.__new__(ZeroTrustRiskBehaviorArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if behaviors is None and not opts.urn:
                raise TypeError("Missing required property 'behaviors'")
            __props__.__dict__["behaviors"] = behaviors
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/riskBehavior:RiskBehavior")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ZeroTrustRiskBehavior, __self__).__init__(
            'cloudflare:index/zeroTrustRiskBehavior:ZeroTrustRiskBehavior',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            behaviors: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['ZeroTrustRiskBehaviorBehaviorsArgs', 'ZeroTrustRiskBehaviorBehaviorsArgsDict']]]]] = None) -> 'ZeroTrustRiskBehavior':
        """
        Get an existing ZeroTrustRiskBehavior resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustRiskBehaviorState.__new__(_ZeroTrustRiskBehaviorState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["behaviors"] = behaviors
        return ZeroTrustRiskBehavior(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def behaviors(self) -> pulumi.Output[Mapping[str, 'outputs.ZeroTrustRiskBehaviorBehaviors']]:
        return pulumi.get(self, "behaviors")

