# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ZeroTrustTunnelCloudflaredRouteArgs', 'ZeroTrustTunnelCloudflaredRoute']

@pulumi.input_type
class ZeroTrustTunnelCloudflaredRouteArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 network: pulumi.Input[builtins.str],
                 tunnel_id: pulumi.Input[builtins.str],
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ZeroTrustTunnelCloudflaredRoute resource.
        :param pulumi.Input[builtins.str] account_id: Cloudflare account ID
        :param pulumi.Input[builtins.str] network: The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        :param pulumi.Input[builtins.str] tunnel_id: UUID of the tunnel.
        :param pulumi.Input[builtins.str] comment: Optional remark describing the route.
        :param pulumi.Input[builtins.str] virtual_network_id: UUID of the virtual network.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "tunnel_id", tunnel_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> pulumi.Input[builtins.str]:
        """
        UUID of the tunnel.
        """
        return pulumi.get(self, "tunnel_id")

    @tunnel_id.setter
    def tunnel_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tunnel_id", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional remark describing the route.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UUID of the virtual network.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.input_type
class _ZeroTrustTunnelCloudflaredRouteState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 deleted_at: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_id: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustTunnelCloudflaredRoute resources.
        :param pulumi.Input[builtins.str] account_id: Cloudflare account ID
        :param pulumi.Input[builtins.str] comment: Optional remark describing the route.
        :param pulumi.Input[builtins.str] created_at: Timestamp of when the resource was created.
        :param pulumi.Input[builtins.str] deleted_at: Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        :param pulumi.Input[builtins.str] network: The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        :param pulumi.Input[builtins.str] tunnel_id: UUID of the tunnel.
        :param pulumi.Input[builtins.str] virtual_network_id: UUID of the virtual network.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deleted_at is not None:
            pulumi.set(__self__, "deleted_at", deleted_at)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if tunnel_id is not None:
            pulumi.set(__self__, "tunnel_id", tunnel_id)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional remark describing the route.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp of when the resource was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deletedAt")
    def deleted_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        """
        return pulumi.get(self, "deleted_at")

    @deleted_at.setter
    def deleted_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deleted_at", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UUID of the tunnel.
        """
        return pulumi.get(self, "tunnel_id")

    @tunnel_id.setter
    def tunnel_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tunnel_id", value)

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UUID of the virtual network.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.type_token("cloudflare:index/zeroTrustTunnelCloudflaredRoute:ZeroTrustTunnelCloudflaredRoute")
class ZeroTrustTunnelCloudflaredRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_id: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_tunnel_cloudflared_route = cloudflare.ZeroTrustTunnelCloudflaredRoute("example_zero_trust_tunnel_cloudflared_route",
            account_id="699d98642c564d2e855e9661899b7252",
            network="172.16.0.0/16",
            tunnel_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
            comment="Example comment for this route.",
            virtual_network_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustTunnelCloudflaredRoute:ZeroTrustTunnelCloudflaredRoute example '<account_id>/<route_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Cloudflare account ID
        :param pulumi.Input[builtins.str] comment: Optional remark describing the route.
        :param pulumi.Input[builtins.str] network: The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        :param pulumi.Input[builtins.str] tunnel_id: UUID of the tunnel.
        :param pulumi.Input[builtins.str] virtual_network_id: UUID of the virtual network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustTunnelCloudflaredRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_tunnel_cloudflared_route = cloudflare.ZeroTrustTunnelCloudflaredRoute("example_zero_trust_tunnel_cloudflared_route",
            account_id="699d98642c564d2e855e9661899b7252",
            network="172.16.0.0/16",
            tunnel_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
            comment="Example comment for this route.",
            virtual_network_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustTunnelCloudflaredRoute:ZeroTrustTunnelCloudflaredRoute example '<account_id>/<route_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustTunnelCloudflaredRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustTunnelCloudflaredRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 comment: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_id: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustTunnelCloudflaredRouteArgs.__new__(ZeroTrustTunnelCloudflaredRouteArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["comment"] = comment
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            if tunnel_id is None and not opts.urn:
                raise TypeError("Missing required property 'tunnel_id'")
            __props__.__dict__["tunnel_id"] = tunnel_id
            __props__.__dict__["virtual_network_id"] = virtual_network_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["deleted_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/tunnelRoute:TunnelRoute")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ZeroTrustTunnelCloudflaredRoute, __self__).__init__(
            'cloudflare:index/zeroTrustTunnelCloudflaredRoute:ZeroTrustTunnelCloudflaredRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            comment: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            deleted_at: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_id: Optional[pulumi.Input[builtins.str]] = None,
            virtual_network_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ZeroTrustTunnelCloudflaredRoute':
        """
        Get an existing ZeroTrustTunnelCloudflaredRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Cloudflare account ID
        :param pulumi.Input[builtins.str] comment: Optional remark describing the route.
        :param pulumi.Input[builtins.str] created_at: Timestamp of when the resource was created.
        :param pulumi.Input[builtins.str] deleted_at: Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        :param pulumi.Input[builtins.str] network: The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        :param pulumi.Input[builtins.str] tunnel_id: UUID of the tunnel.
        :param pulumi.Input[builtins.str] virtual_network_id: UUID of the virtual network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustTunnelCloudflaredRouteState.__new__(_ZeroTrustTunnelCloudflaredRouteState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deleted_at"] = deleted_at
        __props__.__dict__["network"] = network
        __props__.__dict__["tunnel_id"] = tunnel_id
        __props__.__dict__["virtual_network_id"] = virtual_network_id
        return ZeroTrustTunnelCloudflaredRoute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional remark describing the route.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp of when the resource was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deletedAt")
    def deleted_at(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        """
        return pulumi.get(self, "deleted_at")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> pulumi.Output[builtins.str]:
        """
        UUID of the tunnel.
        """
        return pulumi.get(self, "tunnel_id")

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> pulumi.Output[builtins.str]:
        """
        UUID of the virtual network.
        """
        return pulumi.get(self, "virtual_network_id")

