# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZoneDnsSettingsArgs', 'ZoneDnsSettings']

@pulumi.input_type
class ZoneDnsSettingsArgs:
    def __init__(__self__, *,
                 zone_id: pulumi.Input[builtins.str],
                 flatten_all_cnames: Optional[pulumi.Input[builtins.bool]] = None,
                 foundation_dns: Optional[pulumi.Input[builtins.bool]] = None,
                 internal_dns: Optional[pulumi.Input['ZoneDnsSettingsInternalDnsArgs']] = None,
                 multi_provider: Optional[pulumi.Input[builtins.bool]] = None,
                 nameservers: Optional[pulumi.Input['ZoneDnsSettingsNameserversArgs']] = None,
                 ns_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 secondary_overrides: Optional[pulumi.Input[builtins.bool]] = None,
                 soa: Optional[pulumi.Input['ZoneDnsSettingsSoaArgs']] = None,
                 zone_mode: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ZoneDnsSettings resource.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        :param pulumi.Input[builtins.bool] flatten_all_cnames: Whether to flatten all CNAME records in the zone. Note that, due to DNS limitations, a CNAME record at the zone apex will always be flattened.
        :param pulumi.Input[builtins.bool] foundation_dns: Whether to enable Foundation DNS Advanced Nameservers on the zone.
        :param pulumi.Input['ZoneDnsSettingsInternalDnsArgs'] internal_dns: Settings for this internal zone.
        :param pulumi.Input[builtins.bool] multi_provider: Whether to enable multi-provider DNS, which causes Cloudflare to activate the zone even when non-Cloudflare NS records exist, and to respect NS records at the zone apex during outbound zone transfers.
        :param pulumi.Input['ZoneDnsSettingsNameserversArgs'] nameservers: Settings determining the nameservers through which the zone should be available.
        :param pulumi.Input[builtins.float] ns_ttl: The time to live (TTL) of the zone's nameserver (NS) records.
        :param pulumi.Input[builtins.bool] secondary_overrides: Allows a Secondary DNS zone to use (proxied) override records and CNAME flattening at the zone apex.
        :param pulumi.Input['ZoneDnsSettingsSoaArgs'] soa: Components of the zone's SOA record.
        :param pulumi.Input[builtins.str] zone_mode: Whether the zone mode is a regular or CDN/DNS only zone.
               Available values: "standard", "cdn*only", "dns*only".
        """
        pulumi.set(__self__, "zone_id", zone_id)
        if flatten_all_cnames is not None:
            pulumi.set(__self__, "flatten_all_cnames", flatten_all_cnames)
        if foundation_dns is not None:
            pulumi.set(__self__, "foundation_dns", foundation_dns)
        if internal_dns is not None:
            pulumi.set(__self__, "internal_dns", internal_dns)
        if multi_provider is not None:
            pulumi.set(__self__, "multi_provider", multi_provider)
        if nameservers is not None:
            pulumi.set(__self__, "nameservers", nameservers)
        if ns_ttl is not None:
            pulumi.set(__self__, "ns_ttl", ns_ttl)
        if secondary_overrides is not None:
            pulumi.set(__self__, "secondary_overrides", secondary_overrides)
        if soa is not None:
            pulumi.set(__self__, "soa", soa)
        if zone_mode is not None:
            pulumi.set(__self__, "zone_mode", zone_mode)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="flattenAllCnames")
    def flatten_all_cnames(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to flatten all CNAME records in the zone. Note that, due to DNS limitations, a CNAME record at the zone apex will always be flattened.
        """
        return pulumi.get(self, "flatten_all_cnames")

    @flatten_all_cnames.setter
    def flatten_all_cnames(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "flatten_all_cnames", value)

    @property
    @pulumi.getter(name="foundationDns")
    def foundation_dns(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable Foundation DNS Advanced Nameservers on the zone.
        """
        return pulumi.get(self, "foundation_dns")

    @foundation_dns.setter
    def foundation_dns(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "foundation_dns", value)

    @property
    @pulumi.getter(name="internalDns")
    def internal_dns(self) -> Optional[pulumi.Input['ZoneDnsSettingsInternalDnsArgs']]:
        """
        Settings for this internal zone.
        """
        return pulumi.get(self, "internal_dns")

    @internal_dns.setter
    def internal_dns(self, value: Optional[pulumi.Input['ZoneDnsSettingsInternalDnsArgs']]):
        pulumi.set(self, "internal_dns", value)

    @property
    @pulumi.getter(name="multiProvider")
    def multi_provider(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable multi-provider DNS, which causes Cloudflare to activate the zone even when non-Cloudflare NS records exist, and to respect NS records at the zone apex during outbound zone transfers.
        """
        return pulumi.get(self, "multi_provider")

    @multi_provider.setter
    def multi_provider(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multi_provider", value)

    @property
    @pulumi.getter
    def nameservers(self) -> Optional[pulumi.Input['ZoneDnsSettingsNameserversArgs']]:
        """
        Settings determining the nameservers through which the zone should be available.
        """
        return pulumi.get(self, "nameservers")

    @nameservers.setter
    def nameservers(self, value: Optional[pulumi.Input['ZoneDnsSettingsNameserversArgs']]):
        pulumi.set(self, "nameservers", value)

    @property
    @pulumi.getter(name="nsTtl")
    def ns_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The time to live (TTL) of the zone's nameserver (NS) records.
        """
        return pulumi.get(self, "ns_ttl")

    @ns_ttl.setter
    def ns_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "ns_ttl", value)

    @property
    @pulumi.getter(name="secondaryOverrides")
    def secondary_overrides(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows a Secondary DNS zone to use (proxied) override records and CNAME flattening at the zone apex.
        """
        return pulumi.get(self, "secondary_overrides")

    @secondary_overrides.setter
    def secondary_overrides(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "secondary_overrides", value)

    @property
    @pulumi.getter
    def soa(self) -> Optional[pulumi.Input['ZoneDnsSettingsSoaArgs']]:
        """
        Components of the zone's SOA record.
        """
        return pulumi.get(self, "soa")

    @soa.setter
    def soa(self, value: Optional[pulumi.Input['ZoneDnsSettingsSoaArgs']]):
        pulumi.set(self, "soa", value)

    @property
    @pulumi.getter(name="zoneMode")
    def zone_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether the zone mode is a regular or CDN/DNS only zone.
        Available values: "standard", "cdn*only", "dns*only".
        """
        return pulumi.get(self, "zone_mode")

    @zone_mode.setter
    def zone_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_mode", value)


@pulumi.input_type
class _ZoneDnsSettingsState:
    def __init__(__self__, *,
                 flatten_all_cnames: Optional[pulumi.Input[builtins.bool]] = None,
                 foundation_dns: Optional[pulumi.Input[builtins.bool]] = None,
                 internal_dns: Optional[pulumi.Input['ZoneDnsSettingsInternalDnsArgs']] = None,
                 multi_provider: Optional[pulumi.Input[builtins.bool]] = None,
                 nameservers: Optional[pulumi.Input['ZoneDnsSettingsNameserversArgs']] = None,
                 ns_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 secondary_overrides: Optional[pulumi.Input[builtins.bool]] = None,
                 soa: Optional[pulumi.Input['ZoneDnsSettingsSoaArgs']] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_mode: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZoneDnsSettings resources.
        :param pulumi.Input[builtins.bool] flatten_all_cnames: Whether to flatten all CNAME records in the zone. Note that, due to DNS limitations, a CNAME record at the zone apex will always be flattened.
        :param pulumi.Input[builtins.bool] foundation_dns: Whether to enable Foundation DNS Advanced Nameservers on the zone.
        :param pulumi.Input['ZoneDnsSettingsInternalDnsArgs'] internal_dns: Settings for this internal zone.
        :param pulumi.Input[builtins.bool] multi_provider: Whether to enable multi-provider DNS, which causes Cloudflare to activate the zone even when non-Cloudflare NS records exist, and to respect NS records at the zone apex during outbound zone transfers.
        :param pulumi.Input['ZoneDnsSettingsNameserversArgs'] nameservers: Settings determining the nameservers through which the zone should be available.
        :param pulumi.Input[builtins.float] ns_ttl: The time to live (TTL) of the zone's nameserver (NS) records.
        :param pulumi.Input[builtins.bool] secondary_overrides: Allows a Secondary DNS zone to use (proxied) override records and CNAME flattening at the zone apex.
        :param pulumi.Input['ZoneDnsSettingsSoaArgs'] soa: Components of the zone's SOA record.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        :param pulumi.Input[builtins.str] zone_mode: Whether the zone mode is a regular or CDN/DNS only zone.
               Available values: "standard", "cdn*only", "dns*only".
        """
        if flatten_all_cnames is not None:
            pulumi.set(__self__, "flatten_all_cnames", flatten_all_cnames)
        if foundation_dns is not None:
            pulumi.set(__self__, "foundation_dns", foundation_dns)
        if internal_dns is not None:
            pulumi.set(__self__, "internal_dns", internal_dns)
        if multi_provider is not None:
            pulumi.set(__self__, "multi_provider", multi_provider)
        if nameservers is not None:
            pulumi.set(__self__, "nameservers", nameservers)
        if ns_ttl is not None:
            pulumi.set(__self__, "ns_ttl", ns_ttl)
        if secondary_overrides is not None:
            pulumi.set(__self__, "secondary_overrides", secondary_overrides)
        if soa is not None:
            pulumi.set(__self__, "soa", soa)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)
        if zone_mode is not None:
            pulumi.set(__self__, "zone_mode", zone_mode)

    @property
    @pulumi.getter(name="flattenAllCnames")
    def flatten_all_cnames(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to flatten all CNAME records in the zone. Note that, due to DNS limitations, a CNAME record at the zone apex will always be flattened.
        """
        return pulumi.get(self, "flatten_all_cnames")

    @flatten_all_cnames.setter
    def flatten_all_cnames(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "flatten_all_cnames", value)

    @property
    @pulumi.getter(name="foundationDns")
    def foundation_dns(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable Foundation DNS Advanced Nameservers on the zone.
        """
        return pulumi.get(self, "foundation_dns")

    @foundation_dns.setter
    def foundation_dns(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "foundation_dns", value)

    @property
    @pulumi.getter(name="internalDns")
    def internal_dns(self) -> Optional[pulumi.Input['ZoneDnsSettingsInternalDnsArgs']]:
        """
        Settings for this internal zone.
        """
        return pulumi.get(self, "internal_dns")

    @internal_dns.setter
    def internal_dns(self, value: Optional[pulumi.Input['ZoneDnsSettingsInternalDnsArgs']]):
        pulumi.set(self, "internal_dns", value)

    @property
    @pulumi.getter(name="multiProvider")
    def multi_provider(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable multi-provider DNS, which causes Cloudflare to activate the zone even when non-Cloudflare NS records exist, and to respect NS records at the zone apex during outbound zone transfers.
        """
        return pulumi.get(self, "multi_provider")

    @multi_provider.setter
    def multi_provider(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multi_provider", value)

    @property
    @pulumi.getter
    def nameservers(self) -> Optional[pulumi.Input['ZoneDnsSettingsNameserversArgs']]:
        """
        Settings determining the nameservers through which the zone should be available.
        """
        return pulumi.get(self, "nameservers")

    @nameservers.setter
    def nameservers(self, value: Optional[pulumi.Input['ZoneDnsSettingsNameserversArgs']]):
        pulumi.set(self, "nameservers", value)

    @property
    @pulumi.getter(name="nsTtl")
    def ns_ttl(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The time to live (TTL) of the zone's nameserver (NS) records.
        """
        return pulumi.get(self, "ns_ttl")

    @ns_ttl.setter
    def ns_ttl(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "ns_ttl", value)

    @property
    @pulumi.getter(name="secondaryOverrides")
    def secondary_overrides(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows a Secondary DNS zone to use (proxied) override records and CNAME flattening at the zone apex.
        """
        return pulumi.get(self, "secondary_overrides")

    @secondary_overrides.setter
    def secondary_overrides(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "secondary_overrides", value)

    @property
    @pulumi.getter
    def soa(self) -> Optional[pulumi.Input['ZoneDnsSettingsSoaArgs']]:
        """
        Components of the zone's SOA record.
        """
        return pulumi.get(self, "soa")

    @soa.setter
    def soa(self, value: Optional[pulumi.Input['ZoneDnsSettingsSoaArgs']]):
        pulumi.set(self, "soa", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="zoneMode")
    def zone_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether the zone mode is a regular or CDN/DNS only zone.
        Available values: "standard", "cdn*only", "dns*only".
        """
        return pulumi.get(self, "zone_mode")

    @zone_mode.setter
    def zone_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_mode", value)


@pulumi.type_token("cloudflare:index/zoneDnsSettings:ZoneDnsSettings")
class ZoneDnsSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 flatten_all_cnames: Optional[pulumi.Input[builtins.bool]] = None,
                 foundation_dns: Optional[pulumi.Input[builtins.bool]] = None,
                 internal_dns: Optional[pulumi.Input[Union['ZoneDnsSettingsInternalDnsArgs', 'ZoneDnsSettingsInternalDnsArgsDict']]] = None,
                 multi_provider: Optional[pulumi.Input[builtins.bool]] = None,
                 nameservers: Optional[pulumi.Input[Union['ZoneDnsSettingsNameserversArgs', 'ZoneDnsSettingsNameserversArgsDict']]] = None,
                 ns_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 secondary_overrides: Optional[pulumi.Input[builtins.bool]] = None,
                 soa: Optional[pulumi.Input[Union['ZoneDnsSettingsSoaArgs', 'ZoneDnsSettingsSoaArgsDict']]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_mode: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] flatten_all_cnames: Whether to flatten all CNAME records in the zone. Note that, due to DNS limitations, a CNAME record at the zone apex will always be flattened.
        :param pulumi.Input[builtins.bool] foundation_dns: Whether to enable Foundation DNS Advanced Nameservers on the zone.
        :param pulumi.Input[Union['ZoneDnsSettingsInternalDnsArgs', 'ZoneDnsSettingsInternalDnsArgsDict']] internal_dns: Settings for this internal zone.
        :param pulumi.Input[builtins.bool] multi_provider: Whether to enable multi-provider DNS, which causes Cloudflare to activate the zone even when non-Cloudflare NS records exist, and to respect NS records at the zone apex during outbound zone transfers.
        :param pulumi.Input[Union['ZoneDnsSettingsNameserversArgs', 'ZoneDnsSettingsNameserversArgsDict']] nameservers: Settings determining the nameservers through which the zone should be available.
        :param pulumi.Input[builtins.float] ns_ttl: The time to live (TTL) of the zone's nameserver (NS) records.
        :param pulumi.Input[builtins.bool] secondary_overrides: Allows a Secondary DNS zone to use (proxied) override records and CNAME flattening at the zone apex.
        :param pulumi.Input[Union['ZoneDnsSettingsSoaArgs', 'ZoneDnsSettingsSoaArgsDict']] soa: Components of the zone's SOA record.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        :param pulumi.Input[builtins.str] zone_mode: Whether the zone mode is a regular or CDN/DNS only zone.
               Available values: "standard", "cdn*only", "dns*only".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneDnsSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param ZoneDnsSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneDnsSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 flatten_all_cnames: Optional[pulumi.Input[builtins.bool]] = None,
                 foundation_dns: Optional[pulumi.Input[builtins.bool]] = None,
                 internal_dns: Optional[pulumi.Input[Union['ZoneDnsSettingsInternalDnsArgs', 'ZoneDnsSettingsInternalDnsArgsDict']]] = None,
                 multi_provider: Optional[pulumi.Input[builtins.bool]] = None,
                 nameservers: Optional[pulumi.Input[Union['ZoneDnsSettingsNameserversArgs', 'ZoneDnsSettingsNameserversArgsDict']]] = None,
                 ns_ttl: Optional[pulumi.Input[builtins.float]] = None,
                 secondary_overrides: Optional[pulumi.Input[builtins.bool]] = None,
                 soa: Optional[pulumi.Input[Union['ZoneDnsSettingsSoaArgs', 'ZoneDnsSettingsSoaArgsDict']]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_mode: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneDnsSettingsArgs.__new__(ZoneDnsSettingsArgs)

            __props__.__dict__["flatten_all_cnames"] = flatten_all_cnames
            __props__.__dict__["foundation_dns"] = foundation_dns
            __props__.__dict__["internal_dns"] = internal_dns
            __props__.__dict__["multi_provider"] = multi_provider
            __props__.__dict__["nameservers"] = nameservers
            __props__.__dict__["ns_ttl"] = ns_ttl
            __props__.__dict__["secondary_overrides"] = secondary_overrides
            __props__.__dict__["soa"] = soa
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["zone_mode"] = zone_mode
        super(ZoneDnsSettings, __self__).__init__(
            'cloudflare:index/zoneDnsSettings:ZoneDnsSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            flatten_all_cnames: Optional[pulumi.Input[builtins.bool]] = None,
            foundation_dns: Optional[pulumi.Input[builtins.bool]] = None,
            internal_dns: Optional[pulumi.Input[Union['ZoneDnsSettingsInternalDnsArgs', 'ZoneDnsSettingsInternalDnsArgsDict']]] = None,
            multi_provider: Optional[pulumi.Input[builtins.bool]] = None,
            nameservers: Optional[pulumi.Input[Union['ZoneDnsSettingsNameserversArgs', 'ZoneDnsSettingsNameserversArgsDict']]] = None,
            ns_ttl: Optional[pulumi.Input[builtins.float]] = None,
            secondary_overrides: Optional[pulumi.Input[builtins.bool]] = None,
            soa: Optional[pulumi.Input[Union['ZoneDnsSettingsSoaArgs', 'ZoneDnsSettingsSoaArgsDict']]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None,
            zone_mode: Optional[pulumi.Input[builtins.str]] = None) -> 'ZoneDnsSettings':
        """
        Get an existing ZoneDnsSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] flatten_all_cnames: Whether to flatten all CNAME records in the zone. Note that, due to DNS limitations, a CNAME record at the zone apex will always be flattened.
        :param pulumi.Input[builtins.bool] foundation_dns: Whether to enable Foundation DNS Advanced Nameservers on the zone.
        :param pulumi.Input[Union['ZoneDnsSettingsInternalDnsArgs', 'ZoneDnsSettingsInternalDnsArgsDict']] internal_dns: Settings for this internal zone.
        :param pulumi.Input[builtins.bool] multi_provider: Whether to enable multi-provider DNS, which causes Cloudflare to activate the zone even when non-Cloudflare NS records exist, and to respect NS records at the zone apex during outbound zone transfers.
        :param pulumi.Input[Union['ZoneDnsSettingsNameserversArgs', 'ZoneDnsSettingsNameserversArgsDict']] nameservers: Settings determining the nameservers through which the zone should be available.
        :param pulumi.Input[builtins.float] ns_ttl: The time to live (TTL) of the zone's nameserver (NS) records.
        :param pulumi.Input[builtins.bool] secondary_overrides: Allows a Secondary DNS zone to use (proxied) override records and CNAME flattening at the zone apex.
        :param pulumi.Input[Union['ZoneDnsSettingsSoaArgs', 'ZoneDnsSettingsSoaArgsDict']] soa: Components of the zone's SOA record.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        :param pulumi.Input[builtins.str] zone_mode: Whether the zone mode is a regular or CDN/DNS only zone.
               Available values: "standard", "cdn*only", "dns*only".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneDnsSettingsState.__new__(_ZoneDnsSettingsState)

        __props__.__dict__["flatten_all_cnames"] = flatten_all_cnames
        __props__.__dict__["foundation_dns"] = foundation_dns
        __props__.__dict__["internal_dns"] = internal_dns
        __props__.__dict__["multi_provider"] = multi_provider
        __props__.__dict__["nameservers"] = nameservers
        __props__.__dict__["ns_ttl"] = ns_ttl
        __props__.__dict__["secondary_overrides"] = secondary_overrides
        __props__.__dict__["soa"] = soa
        __props__.__dict__["zone_id"] = zone_id
        __props__.__dict__["zone_mode"] = zone_mode
        return ZoneDnsSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="flattenAllCnames")
    def flatten_all_cnames(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to flatten all CNAME records in the zone. Note that, due to DNS limitations, a CNAME record at the zone apex will always be flattened.
        """
        return pulumi.get(self, "flatten_all_cnames")

    @property
    @pulumi.getter(name="foundationDns")
    def foundation_dns(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable Foundation DNS Advanced Nameservers on the zone.
        """
        return pulumi.get(self, "foundation_dns")

    @property
    @pulumi.getter(name="internalDns")
    def internal_dns(self) -> pulumi.Output[Optional['outputs.ZoneDnsSettingsInternalDns']]:
        """
        Settings for this internal zone.
        """
        return pulumi.get(self, "internal_dns")

    @property
    @pulumi.getter(name="multiProvider")
    def multi_provider(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable multi-provider DNS, which causes Cloudflare to activate the zone even when non-Cloudflare NS records exist, and to respect NS records at the zone apex during outbound zone transfers.
        """
        return pulumi.get(self, "multi_provider")

    @property
    @pulumi.getter
    def nameservers(self) -> pulumi.Output[Optional['outputs.ZoneDnsSettingsNameservers']]:
        """
        Settings determining the nameservers through which the zone should be available.
        """
        return pulumi.get(self, "nameservers")

    @property
    @pulumi.getter(name="nsTtl")
    def ns_ttl(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The time to live (TTL) of the zone's nameserver (NS) records.
        """
        return pulumi.get(self, "ns_ttl")

    @property
    @pulumi.getter(name="secondaryOverrides")
    def secondary_overrides(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Allows a Secondary DNS zone to use (proxied) override records and CNAME flattening at the zone apex.
        """
        return pulumi.get(self, "secondary_overrides")

    @property
    @pulumi.getter
    def soa(self) -> pulumi.Output[Optional['outputs.ZoneDnsSettingsSoa']]:
        """
        Components of the zone's SOA record.
        """
        return pulumi.get(self, "soa")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @property
    @pulumi.getter(name="zoneMode")
    def zone_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Whether the zone mode is a regular or CDN/DNS only zone.
        Available values: "standard", "cdn*only", "dns*only".
        """
        return pulumi.get(self, "zone_mode")

