# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZoneLockdownArgs', 'ZoneLockdown']

@pulumi.input_type
class ZoneLockdownArgs:
    def __init__(__self__, *,
                 configurations: pulumi.Input[Sequence[pulumi.Input['ZoneLockdownConfigurationArgs']]],
                 urls: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 zone_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 paused: Optional[pulumi.Input[builtins.bool]] = None,
                 priority: Optional[pulumi.Input[builtins.float]] = None):
        """
        The set of arguments for constructing a ZoneLockdown resource.
        :param pulumi.Input[Sequence[pulumi.Input['ZoneLockdownConfigurationArgs']]] configurations: A list of IP addresses or CIDR ranges that will be allowed to access the URLs specified in the Zone Lockdown rule. You can include any number of `ip` or `ip_range` configurations.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] urls: The URLs to include in the current WAF override. You can use wildcards. Each entered URL will be escaped before use, which means you can only use simple wildcard patterns.
        :param pulumi.Input[builtins.str] zone_id: Defines an identifier.
        :param pulumi.Input[builtins.str] description: An informative summary of the rate limit. This value is sanitized and any tags will be removed.
        :param pulumi.Input[builtins.bool] paused: When true, indicates that the rule is currently paused.
        :param pulumi.Input[builtins.float] priority: The priority of the rule to control the processing order. A lower number indicates higher priority. If not provided, any rules with a configured priority will be processed before rules without a priority.
        """
        pulumi.set(__self__, "configurations", configurations)
        pulumi.set(__self__, "urls", urls)
        pulumi.set(__self__, "zone_id", zone_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def configurations(self) -> pulumi.Input[Sequence[pulumi.Input['ZoneLockdownConfigurationArgs']]]:
        """
        A list of IP addresses or CIDR ranges that will be allowed to access the URLs specified in the Zone Lockdown rule. You can include any number of `ip` or `ip_range` configurations.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: pulumi.Input[Sequence[pulumi.Input['ZoneLockdownConfigurationArgs']]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter
    def urls(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The URLs to include in the current WAF override. You can use wildcards. Each entered URL will be escaped before use, which means you can only use simple wildcard patterns.
        """
        return pulumi.get(self, "urls")

    @urls.setter
    def urls(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "urls", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An informative summary of the rate limit. This value is sanitized and any tags will be removed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When true, indicates that the rule is currently paused.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The priority of the rule to control the processing order. A lower number indicates higher priority. If not provided, any rules with a configured priority will be processed before rules without a priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "priority", value)


@pulumi.input_type
class _ZoneLockdownState:
    def __init__(__self__, *,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneLockdownConfigurationArgs']]]] = None,
                 created_on: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 modified_on: Optional[pulumi.Input[builtins.str]] = None,
                 paused: Optional[pulumi.Input[builtins.bool]] = None,
                 priority: Optional[pulumi.Input[builtins.float]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZoneLockdown resources.
        :param pulumi.Input[Sequence[pulumi.Input['ZoneLockdownConfigurationArgs']]] configurations: A list of IP addresses or CIDR ranges that will be allowed to access the URLs specified in the Zone Lockdown rule. You can include any number of `ip` or `ip_range` configurations.
        :param pulumi.Input[builtins.str] created_on: The timestamp of when the rule was created.
        :param pulumi.Input[builtins.str] description: An informative summary of the rate limit. This value is sanitized and any tags will be removed.
        :param pulumi.Input[builtins.str] modified_on: The timestamp of when the rule was last modified.
        :param pulumi.Input[builtins.bool] paused: When true, indicates that the rule is currently paused.
        :param pulumi.Input[builtins.float] priority: The priority of the rule to control the processing order. A lower number indicates higher priority. If not provided, any rules with a configured priority will be processed before rules without a priority.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] urls: The URLs to include in the current WAF override. You can use wildcards. Each entered URL will be escaped before use, which means you can only use simple wildcard patterns.
        :param pulumi.Input[builtins.str] zone_id: Defines an identifier.
        """
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if urls is not None:
            pulumi.set(__self__, "urls", urls)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZoneLockdownConfigurationArgs']]]]:
        """
        A list of IP addresses or CIDR ranges that will be allowed to access the URLs specified in the Zone Lockdown rule. You can include any number of `ip` or `ip_range` configurations.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneLockdownConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp of when the rule was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An informative summary of the rate limit. This value is sanitized and any tags will be removed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timestamp of when the rule was last modified.
        """
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When true, indicates that the rule is currently paused.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The priority of the rule to control the processing order. A lower number indicates higher priority. If not provided, any rules with a configured priority will be processed before rules without a priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The URLs to include in the current WAF override. You can use wildcards. Each entered URL will be escaped before use, which means you can only use simple wildcard patterns.
        """
        return pulumi.get(self, "urls")

    @urls.setter
    def urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "urls", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/zoneLockdown:ZoneLockdown")
class ZoneLockdown(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneLockdownConfigurationArgs', 'ZoneLockdownConfigurationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 paused: Optional[pulumi.Input[builtins.bool]] = None,
                 priority: Optional[pulumi.Input[builtins.float]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zone_lockdown = cloudflare.ZoneLockdown("example_zone_lockdown",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            configurations=[{
                "target": "ip",
                "value": "198.51.100.4",
            }],
            urls=["shop.example.com/*"],
            description="Prevent multiple login failures to mitigate brute force attacks",
            paused=False,
            priority=5)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zoneLockdown:ZoneLockdown example '<zone_id>/<lock_downs_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZoneLockdownConfigurationArgs', 'ZoneLockdownConfigurationArgsDict']]]] configurations: A list of IP addresses or CIDR ranges that will be allowed to access the URLs specified in the Zone Lockdown rule. You can include any number of `ip` or `ip_range` configurations.
        :param pulumi.Input[builtins.str] description: An informative summary of the rate limit. This value is sanitized and any tags will be removed.
        :param pulumi.Input[builtins.bool] paused: When true, indicates that the rule is currently paused.
        :param pulumi.Input[builtins.float] priority: The priority of the rule to control the processing order. A lower number indicates higher priority. If not provided, any rules with a configured priority will be processed before rules without a priority.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] urls: The URLs to include in the current WAF override. You can use wildcards. Each entered URL will be escaped before use, which means you can only use simple wildcard patterns.
        :param pulumi.Input[builtins.str] zone_id: Defines an identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneLockdownArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zone_lockdown = cloudflare.ZoneLockdown("example_zone_lockdown",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            configurations=[{
                "target": "ip",
                "value": "198.51.100.4",
            }],
            urls=["shop.example.com/*"],
            description="Prevent multiple login failures to mitigate brute force attacks",
            paused=False,
            priority=5)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zoneLockdown:ZoneLockdown example '<zone_id>/<lock_downs_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZoneLockdownArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneLockdownArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneLockdownConfigurationArgs', 'ZoneLockdownConfigurationArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 paused: Optional[pulumi.Input[builtins.bool]] = None,
                 priority: Optional[pulumi.Input[builtins.float]] = None,
                 urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneLockdownArgs.__new__(ZoneLockdownArgs)

            if configurations is None and not opts.urn:
                raise TypeError("Missing required property 'configurations'")
            __props__.__dict__["configurations"] = configurations
            __props__.__dict__["description"] = description
            __props__.__dict__["paused"] = paused
            __props__.__dict__["priority"] = priority
            if urls is None and not opts.urn:
                raise TypeError("Missing required property 'urls'")
            __props__.__dict__["urls"] = urls
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
        super(ZoneLockdown, __self__).__init__(
            'cloudflare:index/zoneLockdown:ZoneLockdown',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneLockdownConfigurationArgs', 'ZoneLockdownConfigurationArgsDict']]]]] = None,
            created_on: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            modified_on: Optional[pulumi.Input[builtins.str]] = None,
            paused: Optional[pulumi.Input[builtins.bool]] = None,
            priority: Optional[pulumi.Input[builtins.float]] = None,
            urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ZoneLockdown':
        """
        Get an existing ZoneLockdown resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZoneLockdownConfigurationArgs', 'ZoneLockdownConfigurationArgsDict']]]] configurations: A list of IP addresses or CIDR ranges that will be allowed to access the URLs specified in the Zone Lockdown rule. You can include any number of `ip` or `ip_range` configurations.
        :param pulumi.Input[builtins.str] created_on: The timestamp of when the rule was created.
        :param pulumi.Input[builtins.str] description: An informative summary of the rate limit. This value is sanitized and any tags will be removed.
        :param pulumi.Input[builtins.str] modified_on: The timestamp of when the rule was last modified.
        :param pulumi.Input[builtins.bool] paused: When true, indicates that the rule is currently paused.
        :param pulumi.Input[builtins.float] priority: The priority of the rule to control the processing order. A lower number indicates higher priority. If not provided, any rules with a configured priority will be processed before rules without a priority.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] urls: The URLs to include in the current WAF override. You can use wildcards. Each entered URL will be escaped before use, which means you can only use simple wildcard patterns.
        :param pulumi.Input[builtins.str] zone_id: Defines an identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneLockdownState.__new__(_ZoneLockdownState)

        __props__.__dict__["configurations"] = configurations
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["description"] = description
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["paused"] = paused
        __props__.__dict__["priority"] = priority
        __props__.__dict__["urls"] = urls
        __props__.__dict__["zone_id"] = zone_id
        return ZoneLockdown(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def configurations(self) -> pulumi.Output[Sequence['outputs.ZoneLockdownConfiguration']]:
        """
        A list of IP addresses or CIDR ranges that will be allowed to access the URLs specified in the Zone Lockdown rule. You can include any number of `ip` or `ip_range` configurations.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of when the rule was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An informative summary of the rate limit. This value is sanitized and any tags will be removed.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp of when the rule was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def paused(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When true, indicates that the rule is currently paused.
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The priority of the rule to control the processing order. A lower number indicates higher priority. If not provided, any rules with a configured priority will be processed before rules without a priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def urls(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The URLs to include in the current WAF override. You can use wildcards. Each entered URL will be escaped before use, which means you can only use simple wildcard patterns.
        """
        return pulumi.get(self, "urls")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")

