# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DatabaseKafkaSchemaRegistryArgs', 'DatabaseKafkaSchemaRegistry']

@pulumi.input_type
class DatabaseKafkaSchemaRegistryArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 schema_type: pulumi.Input[_builtins.str],
                 subject_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a DatabaseKafkaSchemaRegistry resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target Kafka cluster.
        :param pulumi.Input[_builtins.str] schema: The schema definition as a string.
        :param pulumi.Input[_builtins.str] schema_type: The schema type. Available values are: avro, json, or protobuf.
        :param pulumi.Input[_builtins.str] subject_name: The name of the schema subject.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "schema_type", schema_type)
        pulumi.set(__self__, "subject_name", subject_name)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the target Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema definition as a string.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> pulumi.Input[_builtins.str]:
        """
        The schema type. Available values are: avro, json, or protobuf.
        """
        return pulumi.get(self, "schema_type")

    @schema_type.setter
    def schema_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema_type", value)

    @_builtins.property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the schema subject.
        """
        return pulumi.get(self, "subject_name")

    @subject_name.setter
    def subject_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subject_name", value)


@pulumi.input_type
class _DatabaseKafkaSchemaRegistryState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseKafkaSchemaRegistry resources.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target Kafka cluster.
        :param pulumi.Input[_builtins.str] schema: The schema definition as a string.
        :param pulumi.Input[_builtins.str] schema_type: The schema type. Available values are: avro, json, or protobuf.
        :param pulumi.Input[_builtins.str] subject_name: The name of the schema subject.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if schema_type is not None:
            pulumi.set(__self__, "schema_type", schema_type)
        if subject_name is not None:
            pulumi.set(__self__, "subject_name", subject_name)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the target Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema definition as a string.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema type. Available values are: avro, json, or protobuf.
        """
        return pulumi.get(self, "schema_type")

    @schema_type.setter
    def schema_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_type", value)

    @_builtins.property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the schema subject.
        """
        return pulumi.get(self, "subject_name")

    @subject_name.setter
    def subject_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_name", value)


@pulumi.type_token("digitalocean:index/databaseKafkaSchemaRegistry:DatabaseKafkaSchemaRegistry")
class DatabaseKafkaSchemaRegistry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DigitalOcean Kafka schema registry for Kafka clusters.

        ## Example Usage

        ### Create a new Kafka Schema Registry
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        kafka_example = digitalocean.DatabaseCluster("kafka-example",
            name="example-kafka-cluster",
            engine="kafka",
            version="3.5",
            size="gd-2vcpu-8gb",
            region=digitalocean.Region.BLR1,
            node_count=3,
            tags=["production"])
        schema_01 = digitalocean.DatabaseKafkaSchemaRegistry("schema-01",
            cluster_id=kafka_example.id,
            subject_name="test-schema",
            schema_type="avro",
            schema=\"\"\"{
          "type": "record",
          "namespace": "example",
          "name": "TestRecord",
          "fields": [
            {"name": "id", "type": "string"},
            {"name": "name", "type": "string"},
            {"name": "value", "type": "int"}
          ]
        }
        \"\"\")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target Kafka cluster.
        :param pulumi.Input[_builtins.str] schema: The schema definition as a string.
        :param pulumi.Input[_builtins.str] schema_type: The schema type. Available values are: avro, json, or protobuf.
        :param pulumi.Input[_builtins.str] subject_name: The name of the schema subject.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseKafkaSchemaRegistryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DigitalOcean Kafka schema registry for Kafka clusters.

        ## Example Usage

        ### Create a new Kafka Schema Registry
        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        kafka_example = digitalocean.DatabaseCluster("kafka-example",
            name="example-kafka-cluster",
            engine="kafka",
            version="3.5",
            size="gd-2vcpu-8gb",
            region=digitalocean.Region.BLR1,
            node_count=3,
            tags=["production"])
        schema_01 = digitalocean.DatabaseKafkaSchemaRegistry("schema-01",
            cluster_id=kafka_example.id,
            subject_name="test-schema",
            schema_type="avro",
            schema=\"\"\"{
          "type": "record",
          "namespace": "example",
          "name": "TestRecord",
          "fields": [
            {"name": "id", "type": "string"},
            {"name": "name", "type": "string"},
            {"name": "value", "type": "int"}
          ]
        }
        \"\"\")
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseKafkaSchemaRegistryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseKafkaSchemaRegistryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseKafkaSchemaRegistryArgs.__new__(DatabaseKafkaSchemaRegistryArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            if schema_type is None and not opts.urn:
                raise TypeError("Missing required property 'schema_type'")
            __props__.__dict__["schema_type"] = schema_type
            if subject_name is None and not opts.urn:
                raise TypeError("Missing required property 'subject_name'")
            __props__.__dict__["subject_name"] = subject_name
        super(DatabaseKafkaSchemaRegistry, __self__).__init__(
            'digitalocean:index/databaseKafkaSchemaRegistry:DatabaseKafkaSchemaRegistry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            schema_type: Optional[pulumi.Input[_builtins.str]] = None,
            subject_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseKafkaSchemaRegistry':
        """
        Get an existing DatabaseKafkaSchemaRegistry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the target Kafka cluster.
        :param pulumi.Input[_builtins.str] schema: The schema definition as a string.
        :param pulumi.Input[_builtins.str] schema_type: The schema type. Available values are: avro, json, or protobuf.
        :param pulumi.Input[_builtins.str] subject_name: The name of the schema subject.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseKafkaSchemaRegistryState.__new__(_DatabaseKafkaSchemaRegistryState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["schema"] = schema
        __props__.__dict__["schema_type"] = schema_type
        __props__.__dict__["subject_name"] = subject_name
        return DatabaseKafkaSchemaRegistry(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the target Kafka cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema definition as a string.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> pulumi.Output[_builtins.str]:
        """
        The schema type. Available values are: avro, json, or protobuf.
        """
        return pulumi.get(self, "schema_type")

    @_builtins.property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the schema subject.
        """
        return pulumi.get(self, "subject_name")

