# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['DropletArgs', 'Droplet']

@pulumi.input_type
class DropletArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[_builtins.str],
                 size: pulumi.Input[Union[_builtins.str, 'DropletSlug']],
                 backup_policy: Optional[pulumi.Input['DropletBackupPolicyArgs']] = None,
                 backups: Optional[pulumi.Input[_builtins.bool]] = None,
                 droplet_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 graceful_shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_networking: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[Union[_builtins.str, 'Region']]] = None,
                 resize_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Droplet resource.
        :param pulumi.Input[_builtins.str] image: The Droplet image ID or slug. This could be either image ID or droplet snapshot ID. You can find image IDs and slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Images).
        :param pulumi.Input[Union[_builtins.str, 'DropletSlug']] size: The unique slug that identifies the type of Droplet. You may list the available slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Sizes).
        :param pulumi.Input['DropletBackupPolicyArgs'] backup_policy: An object specifying the backup policy for the Droplet. If omitted and `backups` is `true`, the backup plan will default to daily.
        :param pulumi.Input[_builtins.bool] backups: Boolean controlling if backups are made. Defaults to
               false.
        :param pulumi.Input[_builtins.bool] droplet_agent: A boolean indicating whether to install the
               DigitalOcean agent used for providing access to the Droplet web console in
               the control panel. By default, the agent is installed on new Droplets but
               installation errors (i.e. OS not supported) are ignored. To prevent it from
               being installed, set to `false`. To make installation errors fatal, explicitly
               set it to `true`.
        :param pulumi.Input[_builtins.bool] graceful_shutdown: A boolean indicating whether the droplet
               should be gracefully shut down before it is deleted.
               
               > **NOTE:** If you use `volume_ids` on a Droplet, this provider will assume management over the full set volumes for the instance, and treat additional volumes as a drift. For this reason, `volume_ids` must not be mixed with external `VolumeAttachment` resources for a given instance.
        :param pulumi.Input[_builtins.bool] ipv6: Boolean controlling if IPv6 is enabled. Defaults to false.
               Once enabled for a Droplet, IPv6 can not be disabled. When enabling IPv6 on
               an existing Droplet, [additional OS-level configuration](https://docs.digitalocean.com/products/networking/ipv6/how-to/enable/#on-existing-droplets)
               is required.
        :param pulumi.Input[_builtins.str] ipv6_address: The IPv6 address
        :param pulumi.Input[_builtins.bool] monitoring: Boolean controlling whether monitoring agent is installed.
               Defaults to false. If set to `true`, you can configure monitor alert policies
               [monitor alert resource](https://www.terraform.io/providers/digitalocean/digitalocean/latest/docs/resources/monitor_alert)
        :param pulumi.Input[_builtins.str] name: The Droplet name.
        :param pulumi.Input[_builtins.bool] private_networking: **Deprecated** Boolean controlling if private networking
               is enabled. This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.
        :param pulumi.Input[Union[_builtins.str, 'Region']] region: The region where the Droplet will be created.
        :param pulumi.Input[_builtins.bool] resize_disk: Boolean controlling whether to increase the disk
               size when resizing a Droplet. It defaults to `true`. When set to `false`,
               only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
               size is a permanent change**. Increasing only RAM and CPU is reversible.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_keys: A list of SSH key IDs or fingerprints to enable in
               the format `[12345, 123456]`. To retrieve this info, use the
               [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/SSH-Keys)
               or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
               be added or removed via this provider. Modifying this field will prompt you
               to destroy and recreate the Droplet.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of the tags to be applied to this Droplet.
        :param pulumi.Input[_builtins.str] user_data: A string of the desired User Data provided [during Droplet creation](https://docs.digitalocean.com/products/droplets/how-to/provide-user-data/). Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] volume_ids: A list of the IDs of each block storage volume to be attached to the Droplet.
        :param pulumi.Input[_builtins.str] vpc_uuid: The ID of the VPC where the Droplet will be located.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "size", size)
        if backup_policy is not None:
            pulumi.set(__self__, "backup_policy", backup_policy)
        if backups is not None:
            pulumi.set(__self__, "backups", backups)
        if droplet_agent is not None:
            pulumi.set(__self__, "droplet_agent", droplet_agent)
        if graceful_shutdown is not None:
            pulumi.set(__self__, "graceful_shutdown", graceful_shutdown)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_networking is not None:
            warnings.warn("""This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.""", DeprecationWarning)
            pulumi.log.warn("""private_networking is deprecated: This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.""")
        if private_networking is not None:
            pulumi.set(__self__, "private_networking", private_networking)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resize_disk is not None:
            pulumi.set(__self__, "resize_disk", resize_disk)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if volume_ids is not None:
            pulumi.set(__self__, "volume_ids", volume_ids)
        if vpc_uuid is not None:
            pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Input[_builtins.str]:
        """
        The Droplet image ID or slug. This could be either image ID or droplet snapshot ID. You can find image IDs and slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Images).
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[Union[_builtins.str, 'DropletSlug']]:
        """
        The unique slug that identifies the type of Droplet. You may list the available slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Sizes).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[Union[_builtins.str, 'DropletSlug']]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional[pulumi.Input['DropletBackupPolicyArgs']]:
        """
        An object specifying the backup policy for the Droplet. If omitted and `backups` is `true`, the backup plan will default to daily.
        """
        return pulumi.get(self, "backup_policy")

    @backup_policy.setter
    def backup_policy(self, value: Optional[pulumi.Input['DropletBackupPolicyArgs']]):
        pulumi.set(self, "backup_policy", value)

    @_builtins.property
    @pulumi.getter
    def backups(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean controlling if backups are made. Defaults to
        false.
        """
        return pulumi.get(self, "backups")

    @backups.setter
    def backups(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "backups", value)

    @_builtins.property
    @pulumi.getter(name="dropletAgent")
    def droplet_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean indicating whether to install the
        DigitalOcean agent used for providing access to the Droplet web console in
        the control panel. By default, the agent is installed on new Droplets but
        installation errors (i.e. OS not supported) are ignored. To prevent it from
        being installed, set to `false`. To make installation errors fatal, explicitly
        set it to `true`.
        """
        return pulumi.get(self, "droplet_agent")

    @droplet_agent.setter
    def droplet_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "droplet_agent", value)

    @_builtins.property
    @pulumi.getter(name="gracefulShutdown")
    def graceful_shutdown(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean indicating whether the droplet
        should be gracefully shut down before it is deleted.

        > **NOTE:** If you use `volume_ids` on a Droplet, this provider will assume management over the full set volumes for the instance, and treat additional volumes as a drift. For this reason, `volume_ids` must not be mixed with external `VolumeAttachment` resources for a given instance.
        """
        return pulumi.get(self, "graceful_shutdown")

    @graceful_shutdown.setter
    def graceful_shutdown(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "graceful_shutdown", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean controlling if IPv6 is enabled. Defaults to false.
        Once enabled for a Droplet, IPv6 can not be disabled. When enabling IPv6 on
        an existing Droplet, [additional OS-level configuration](https://docs.digitalocean.com/products/networking/ipv6/how-to/enable/#on-existing-droplets)
        is required.
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean controlling whether monitoring agent is installed.
        Defaults to false. If set to `true`, you can configure monitor alert policies
        [monitor alert resource](https://www.terraform.io/providers/digitalocean/digitalocean/latest/docs/resources/monitor_alert)
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Droplet name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateNetworking")
    @_utilities.deprecated("""This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.""")
    def private_networking(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        **Deprecated** Boolean controlling if private networking
        is enabled. This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.
        """
        return pulumi.get(self, "private_networking")

    @private_networking.setter
    def private_networking(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_networking", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[Union[_builtins.str, 'Region']]]:
        """
        The region where the Droplet will be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[Union[_builtins.str, 'Region']]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resizeDisk")
    def resize_disk(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean controlling whether to increase the disk
        size when resizing a Droplet. It defaults to `true`. When set to `false`,
        only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
        size is a permanent change**. Increasing only RAM and CPU is reversible.
        """
        return pulumi.get(self, "resize_disk")

    @resize_disk.setter
    def resize_disk(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resize_disk", value)

    @_builtins.property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SSH key IDs or fingerprints to enable in
        the format `[12345, 123456]`. To retrieve this info, use the
        [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/SSH-Keys)
        or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
        be added or removed via this provider. Modifying this field will prompt you
        to destroy and recreate the Droplet.
        """
        return pulumi.get(self, "ssh_keys")

    @ssh_keys.setter
    def ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ssh_keys", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the tags to be applied to this Droplet.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string of the desired User Data provided [during Droplet creation](https://docs.digitalocean.com/products/droplets/how-to/provide-user-data/). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the IDs of each block storage volume to be attached to the Droplet.
        """
        return pulumi.get(self, "volume_ids")

    @volume_ids.setter
    def volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "volume_ids", value)

    @_builtins.property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC where the Droplet will be located.
        """
        return pulumi.get(self, "vpc_uuid")

    @vpc_uuid.setter
    def vpc_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_uuid", value)


@pulumi.input_type
class _DropletState:
    def __init__(__self__, *,
                 backup_policy: Optional[pulumi.Input['DropletBackupPolicyArgs']] = None,
                 backups: Optional[pulumi.Input[_builtins.bool]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 disk: Optional[pulumi.Input[_builtins.int]] = None,
                 droplet_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 droplet_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 graceful_shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address_private: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 price_hourly: Optional[pulumi.Input[_builtins.float]] = None,
                 price_monthly: Optional[pulumi.Input[_builtins.float]] = None,
                 private_networking: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[Union[_builtins.str, 'Region']]] = None,
                 resize_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 size: Optional[pulumi.Input[Union[_builtins.str, 'DropletSlug']]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vcpus: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Droplet resources.
        :param pulumi.Input['DropletBackupPolicyArgs'] backup_policy: An object specifying the backup policy for the Droplet. If omitted and `backups` is `true`, the backup plan will default to daily.
        :param pulumi.Input[_builtins.bool] backups: Boolean controlling if backups are made. Defaults to
               false.
        :param pulumi.Input[_builtins.int] disk: The size of the instance's disk in GB
        :param pulumi.Input[_builtins.bool] droplet_agent: A boolean indicating whether to install the
               DigitalOcean agent used for providing access to the Droplet web console in
               the control panel. By default, the agent is installed on new Droplets but
               installation errors (i.e. OS not supported) are ignored. To prevent it from
               being installed, set to `false`. To make installation errors fatal, explicitly
               set it to `true`.
        :param pulumi.Input[_builtins.str] droplet_urn: The uniform resource name of the Droplet
        :param pulumi.Input[_builtins.bool] graceful_shutdown: A boolean indicating whether the droplet
               should be gracefully shut down before it is deleted.
               
               > **NOTE:** If you use `volume_ids` on a Droplet, this provider will assume management over the full set volumes for the instance, and treat additional volumes as a drift. For this reason, `volume_ids` must not be mixed with external `VolumeAttachment` resources for a given instance.
        :param pulumi.Input[_builtins.str] image: The Droplet image ID or slug. This could be either image ID or droplet snapshot ID. You can find image IDs and slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Images).
        :param pulumi.Input[_builtins.str] ipv4_address: The IPv4 address
        :param pulumi.Input[_builtins.str] ipv4_address_private: The private networking IPv4 address
        :param pulumi.Input[_builtins.bool] ipv6: Boolean controlling if IPv6 is enabled. Defaults to false.
               Once enabled for a Droplet, IPv6 can not be disabled. When enabling IPv6 on
               an existing Droplet, [additional OS-level configuration](https://docs.digitalocean.com/products/networking/ipv6/how-to/enable/#on-existing-droplets)
               is required.
        :param pulumi.Input[_builtins.str] ipv6_address: The IPv6 address
        :param pulumi.Input[_builtins.bool] locked: Is the Droplet locked
        :param pulumi.Input[_builtins.bool] monitoring: Boolean controlling whether monitoring agent is installed.
               Defaults to false. If set to `true`, you can configure monitor alert policies
               [monitor alert resource](https://www.terraform.io/providers/digitalocean/digitalocean/latest/docs/resources/monitor_alert)
        :param pulumi.Input[_builtins.str] name: The Droplet name.
        :param pulumi.Input[_builtins.float] price_hourly: Droplet hourly price
        :param pulumi.Input[_builtins.float] price_monthly: Droplet monthly price
        :param pulumi.Input[_builtins.bool] private_networking: **Deprecated** Boolean controlling if private networking
               is enabled. This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.
        :param pulumi.Input[Union[_builtins.str, 'Region']] region: The region where the Droplet will be created.
        :param pulumi.Input[_builtins.bool] resize_disk: Boolean controlling whether to increase the disk
               size when resizing a Droplet. It defaults to `true`. When set to `false`,
               only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
               size is a permanent change**. Increasing only RAM and CPU is reversible.
        :param pulumi.Input[Union[_builtins.str, 'DropletSlug']] size: The unique slug that identifies the type of Droplet. You may list the available slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Sizes).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_keys: A list of SSH key IDs or fingerprints to enable in
               the format `[12345, 123456]`. To retrieve this info, use the
               [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/SSH-Keys)
               or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
               be added or removed via this provider. Modifying this field will prompt you
               to destroy and recreate the Droplet.
        :param pulumi.Input[_builtins.str] status: The status of the Droplet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of the tags to be applied to this Droplet.
        :param pulumi.Input[_builtins.str] user_data: A string of the desired User Data provided [during Droplet creation](https://docs.digitalocean.com/products/droplets/how-to/provide-user-data/). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] vcpus: The number of the instance's virtual CPUs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] volume_ids: A list of the IDs of each block storage volume to be attached to the Droplet.
        :param pulumi.Input[_builtins.str] vpc_uuid: The ID of the VPC where the Droplet will be located.
        """
        if backup_policy is not None:
            pulumi.set(__self__, "backup_policy", backup_policy)
        if backups is not None:
            pulumi.set(__self__, "backups", backups)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if droplet_agent is not None:
            pulumi.set(__self__, "droplet_agent", droplet_agent)
        if droplet_urn is not None:
            pulumi.set(__self__, "droplet_urn", droplet_urn)
        if graceful_shutdown is not None:
            pulumi.set(__self__, "graceful_shutdown", graceful_shutdown)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_address_private is not None:
            pulumi.set(__self__, "ipv4_address_private", ipv4_address_private)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if price_hourly is not None:
            pulumi.set(__self__, "price_hourly", price_hourly)
        if price_monthly is not None:
            pulumi.set(__self__, "price_monthly", price_monthly)
        if private_networking is not None:
            warnings.warn("""This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.""", DeprecationWarning)
            pulumi.log.warn("""private_networking is deprecated: This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.""")
        if private_networking is not None:
            pulumi.set(__self__, "private_networking", private_networking)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resize_disk is not None:
            pulumi.set(__self__, "resize_disk", resize_disk)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vcpus is not None:
            pulumi.set(__self__, "vcpus", vcpus)
        if volume_ids is not None:
            pulumi.set(__self__, "volume_ids", volume_ids)
        if vpc_uuid is not None:
            pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @_builtins.property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional[pulumi.Input['DropletBackupPolicyArgs']]:
        """
        An object specifying the backup policy for the Droplet. If omitted and `backups` is `true`, the backup plan will default to daily.
        """
        return pulumi.get(self, "backup_policy")

    @backup_policy.setter
    def backup_policy(self, value: Optional[pulumi.Input['DropletBackupPolicyArgs']]):
        pulumi.set(self, "backup_policy", value)

    @_builtins.property
    @pulumi.getter
    def backups(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean controlling if backups are made. Defaults to
        false.
        """
        return pulumi.get(self, "backups")

    @backups.setter
    def backups(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "backups", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def disk(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the instance's disk in GB
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk", value)

    @_builtins.property
    @pulumi.getter(name="dropletAgent")
    def droplet_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean indicating whether to install the
        DigitalOcean agent used for providing access to the Droplet web console in
        the control panel. By default, the agent is installed on new Droplets but
        installation errors (i.e. OS not supported) are ignored. To prevent it from
        being installed, set to `false`. To make installation errors fatal, explicitly
        set it to `true`.
        """
        return pulumi.get(self, "droplet_agent")

    @droplet_agent.setter
    def droplet_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "droplet_agent", value)

    @_builtins.property
    @pulumi.getter(name="dropletUrn")
    def droplet_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The uniform resource name of the Droplet
        """
        return pulumi.get(self, "droplet_urn")

    @droplet_urn.setter
    def droplet_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "droplet_urn", value)

    @_builtins.property
    @pulumi.getter(name="gracefulShutdown")
    def graceful_shutdown(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean indicating whether the droplet
        should be gracefully shut down before it is deleted.

        > **NOTE:** If you use `volume_ids` on a Droplet, this provider will assume management over the full set volumes for the instance, and treat additional volumes as a drift. For this reason, `volume_ids` must not be mixed with external `VolumeAttachment` resources for a given instance.
        """
        return pulumi.get(self, "graceful_shutdown")

    @graceful_shutdown.setter
    def graceful_shutdown(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "graceful_shutdown", value)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Droplet image ID or slug. This could be either image ID or droplet snapshot ID. You can find image IDs and slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Images).
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv4AddressPrivate")
    def ipv4_address_private(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private networking IPv4 address
        """
        return pulumi.get(self, "ipv4_address_private")

    @ipv4_address_private.setter
    def ipv4_address_private(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address_private", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean controlling if IPv6 is enabled. Defaults to false.
        Once enabled for a Droplet, IPv6 can not be disabled. When enabling IPv6 on
        an existing Droplet, [additional OS-level configuration](https://docs.digitalocean.com/products/networking/ipv6/how-to/enable/#on-existing-droplets)
        is required.
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Droplet locked
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "locked", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean controlling whether monitoring agent is installed.
        Defaults to false. If set to `true`, you can configure monitor alert policies
        [monitor alert resource](https://www.terraform.io/providers/digitalocean/digitalocean/latest/docs/resources/monitor_alert)
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Droplet name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="priceHourly")
    def price_hourly(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Droplet hourly price
        """
        return pulumi.get(self, "price_hourly")

    @price_hourly.setter
    def price_hourly(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "price_hourly", value)

    @_builtins.property
    @pulumi.getter(name="priceMonthly")
    def price_monthly(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Droplet monthly price
        """
        return pulumi.get(self, "price_monthly")

    @price_monthly.setter
    def price_monthly(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "price_monthly", value)

    @_builtins.property
    @pulumi.getter(name="privateNetworking")
    @_utilities.deprecated("""This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.""")
    def private_networking(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        **Deprecated** Boolean controlling if private networking
        is enabled. This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.
        """
        return pulumi.get(self, "private_networking")

    @private_networking.setter
    def private_networking(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_networking", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[Union[_builtins.str, 'Region']]]:
        """
        The region where the Droplet will be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[Union[_builtins.str, 'Region']]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resizeDisk")
    def resize_disk(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean controlling whether to increase the disk
        size when resizing a Droplet. It defaults to `true`. When set to `false`,
        only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
        size is a permanent change**. Increasing only RAM and CPU is reversible.
        """
        return pulumi.get(self, "resize_disk")

    @resize_disk.setter
    def resize_disk(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resize_disk", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[Union[_builtins.str, 'DropletSlug']]]:
        """
        The unique slug that identifies the type of Droplet. You may list the available slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Sizes).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[Union[_builtins.str, 'DropletSlug']]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of SSH key IDs or fingerprints to enable in
        the format `[12345, 123456]`. To retrieve this info, use the
        [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/SSH-Keys)
        or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
        be added or removed via this provider. Modifying this field will prompt you
        to destroy and recreate the Droplet.
        """
        return pulumi.get(self, "ssh_keys")

    @ssh_keys.setter
    def ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ssh_keys", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Droplet
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the tags to be applied to this Droplet.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string of the desired User Data provided [during Droplet creation](https://docs.digitalocean.com/products/droplets/how-to/provide-user-data/). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter
    def vcpus(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of the instance's virtual CPUs
        """
        return pulumi.get(self, "vcpus")

    @vcpus.setter
    def vcpus(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vcpus", value)

    @_builtins.property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the IDs of each block storage volume to be attached to the Droplet.
        """
        return pulumi.get(self, "volume_ids")

    @volume_ids.setter
    def volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "volume_ids", value)

    @_builtins.property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC where the Droplet will be located.
        """
        return pulumi.get(self, "vpc_uuid")

    @vpc_uuid.setter
    def vpc_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_uuid", value)


@pulumi.type_token("digitalocean:index/droplet:Droplet")
class Droplet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_policy: Optional[pulumi.Input[Union['DropletBackupPolicyArgs', 'DropletBackupPolicyArgsDict']]] = None,
                 backups: Optional[pulumi.Input[_builtins.bool]] = None,
                 droplet_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 graceful_shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_networking: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[Union[_builtins.str, 'Region']]] = None,
                 resize_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 size: Optional[pulumi.Input[Union[_builtins.str, 'DropletSlug']]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DigitalOcean Droplet resource. This can be used to create,
        modify, and delete Droplets.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        # Create a new Web Droplet in the nyc2 region
        web = digitalocean.Droplet("web",
            image="ubuntu-20-04-x64",
            name="web-1",
            region=digitalocean.Region.NYC2,
            size=digitalocean.DropletSlug.DROPLET_S1_VCPU1_GB,
            backups=True,
            backup_policy={
                "plan": "weekly",
                "weekday": "TUE",
                "hour": 8,
            })
        ```

        ## Import

        Droplets can be imported using the Droplet `id`, e.g.

        ```sh
        $ pulumi import digitalocean:index/droplet:Droplet mydroplet 100823
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DropletBackupPolicyArgs', 'DropletBackupPolicyArgsDict']] backup_policy: An object specifying the backup policy for the Droplet. If omitted and `backups` is `true`, the backup plan will default to daily.
        :param pulumi.Input[_builtins.bool] backups: Boolean controlling if backups are made. Defaults to
               false.
        :param pulumi.Input[_builtins.bool] droplet_agent: A boolean indicating whether to install the
               DigitalOcean agent used for providing access to the Droplet web console in
               the control panel. By default, the agent is installed on new Droplets but
               installation errors (i.e. OS not supported) are ignored. To prevent it from
               being installed, set to `false`. To make installation errors fatal, explicitly
               set it to `true`.
        :param pulumi.Input[_builtins.bool] graceful_shutdown: A boolean indicating whether the droplet
               should be gracefully shut down before it is deleted.
               
               > **NOTE:** If you use `volume_ids` on a Droplet, this provider will assume management over the full set volumes for the instance, and treat additional volumes as a drift. For this reason, `volume_ids` must not be mixed with external `VolumeAttachment` resources for a given instance.
        :param pulumi.Input[_builtins.str] image: The Droplet image ID or slug. This could be either image ID or droplet snapshot ID. You can find image IDs and slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Images).
        :param pulumi.Input[_builtins.bool] ipv6: Boolean controlling if IPv6 is enabled. Defaults to false.
               Once enabled for a Droplet, IPv6 can not be disabled. When enabling IPv6 on
               an existing Droplet, [additional OS-level configuration](https://docs.digitalocean.com/products/networking/ipv6/how-to/enable/#on-existing-droplets)
               is required.
        :param pulumi.Input[_builtins.str] ipv6_address: The IPv6 address
        :param pulumi.Input[_builtins.bool] monitoring: Boolean controlling whether monitoring agent is installed.
               Defaults to false. If set to `true`, you can configure monitor alert policies
               [monitor alert resource](https://www.terraform.io/providers/digitalocean/digitalocean/latest/docs/resources/monitor_alert)
        :param pulumi.Input[_builtins.str] name: The Droplet name.
        :param pulumi.Input[_builtins.bool] private_networking: **Deprecated** Boolean controlling if private networking
               is enabled. This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.
        :param pulumi.Input[Union[_builtins.str, 'Region']] region: The region where the Droplet will be created.
        :param pulumi.Input[_builtins.bool] resize_disk: Boolean controlling whether to increase the disk
               size when resizing a Droplet. It defaults to `true`. When set to `false`,
               only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
               size is a permanent change**. Increasing only RAM and CPU is reversible.
        :param pulumi.Input[Union[_builtins.str, 'DropletSlug']] size: The unique slug that identifies the type of Droplet. You may list the available slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Sizes).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_keys: A list of SSH key IDs or fingerprints to enable in
               the format `[12345, 123456]`. To retrieve this info, use the
               [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/SSH-Keys)
               or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
               be added or removed via this provider. Modifying this field will prompt you
               to destroy and recreate the Droplet.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of the tags to be applied to this Droplet.
        :param pulumi.Input[_builtins.str] user_data: A string of the desired User Data provided [during Droplet creation](https://docs.digitalocean.com/products/droplets/how-to/provide-user-data/). Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] volume_ids: A list of the IDs of each block storage volume to be attached to the Droplet.
        :param pulumi.Input[_builtins.str] vpc_uuid: The ID of the VPC where the Droplet will be located.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DropletArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DigitalOcean Droplet resource. This can be used to create,
        modify, and delete Droplets.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        # Create a new Web Droplet in the nyc2 region
        web = digitalocean.Droplet("web",
            image="ubuntu-20-04-x64",
            name="web-1",
            region=digitalocean.Region.NYC2,
            size=digitalocean.DropletSlug.DROPLET_S1_VCPU1_GB,
            backups=True,
            backup_policy={
                "plan": "weekly",
                "weekday": "TUE",
                "hour": 8,
            })
        ```

        ## Import

        Droplets can be imported using the Droplet `id`, e.g.

        ```sh
        $ pulumi import digitalocean:index/droplet:Droplet mydroplet 100823
        ```

        :param str resource_name: The name of the resource.
        :param DropletArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DropletArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_policy: Optional[pulumi.Input[Union['DropletBackupPolicyArgs', 'DropletBackupPolicyArgsDict']]] = None,
                 backups: Optional[pulumi.Input[_builtins.bool]] = None,
                 droplet_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 graceful_shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 image: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_networking: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[Union[_builtins.str, 'Region']]] = None,
                 resize_disk: Optional[pulumi.Input[_builtins.bool]] = None,
                 size: Optional[pulumi.Input[Union[_builtins.str, 'DropletSlug']]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DropletArgs.__new__(DropletArgs)

            __props__.__dict__["backup_policy"] = backup_policy
            __props__.__dict__["backups"] = backups
            __props__.__dict__["droplet_agent"] = droplet_agent
            __props__.__dict__["graceful_shutdown"] = graceful_shutdown
            if image is None and not opts.urn:
                raise TypeError("Missing required property 'image'")
            __props__.__dict__["image"] = image
            __props__.__dict__["ipv6"] = ipv6
            __props__.__dict__["ipv6_address"] = ipv6_address
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["name"] = name
            __props__.__dict__["private_networking"] = private_networking
            __props__.__dict__["region"] = region
            __props__.__dict__["resize_disk"] = resize_disk
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["ssh_keys"] = ssh_keys
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["volume_ids"] = volume_ids
            __props__.__dict__["vpc_uuid"] = vpc_uuid
            __props__.__dict__["created_at"] = None
            __props__.__dict__["disk"] = None
            __props__.__dict__["droplet_urn"] = None
            __props__.__dict__["ipv4_address"] = None
            __props__.__dict__["ipv4_address_private"] = None
            __props__.__dict__["locked"] = None
            __props__.__dict__["memory"] = None
            __props__.__dict__["price_hourly"] = None
            __props__.__dict__["price_monthly"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vcpus"] = None
        super(Droplet, __self__).__init__(
            'digitalocean:index/droplet:Droplet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_policy: Optional[pulumi.Input[Union['DropletBackupPolicyArgs', 'DropletBackupPolicyArgsDict']]] = None,
            backups: Optional[pulumi.Input[_builtins.bool]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            disk: Optional[pulumi.Input[_builtins.int]] = None,
            droplet_agent: Optional[pulumi.Input[_builtins.bool]] = None,
            droplet_urn: Optional[pulumi.Input[_builtins.str]] = None,
            graceful_shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
            image: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_address_private: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
            ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
            locked: Optional[pulumi.Input[_builtins.bool]] = None,
            memory: Optional[pulumi.Input[_builtins.int]] = None,
            monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            price_hourly: Optional[pulumi.Input[_builtins.float]] = None,
            price_monthly: Optional[pulumi.Input[_builtins.float]] = None,
            private_networking: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[Union[_builtins.str, 'Region']]] = None,
            resize_disk: Optional[pulumi.Input[_builtins.bool]] = None,
            size: Optional[pulumi.Input[Union[_builtins.str, 'DropletSlug']]] = None,
            ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            vcpus: Optional[pulumi.Input[_builtins.int]] = None,
            volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vpc_uuid: Optional[pulumi.Input[_builtins.str]] = None) -> 'Droplet':
        """
        Get an existing Droplet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DropletBackupPolicyArgs', 'DropletBackupPolicyArgsDict']] backup_policy: An object specifying the backup policy for the Droplet. If omitted and `backups` is `true`, the backup plan will default to daily.
        :param pulumi.Input[_builtins.bool] backups: Boolean controlling if backups are made. Defaults to
               false.
        :param pulumi.Input[_builtins.int] disk: The size of the instance's disk in GB
        :param pulumi.Input[_builtins.bool] droplet_agent: A boolean indicating whether to install the
               DigitalOcean agent used for providing access to the Droplet web console in
               the control panel. By default, the agent is installed on new Droplets but
               installation errors (i.e. OS not supported) are ignored. To prevent it from
               being installed, set to `false`. To make installation errors fatal, explicitly
               set it to `true`.
        :param pulumi.Input[_builtins.str] droplet_urn: The uniform resource name of the Droplet
        :param pulumi.Input[_builtins.bool] graceful_shutdown: A boolean indicating whether the droplet
               should be gracefully shut down before it is deleted.
               
               > **NOTE:** If you use `volume_ids` on a Droplet, this provider will assume management over the full set volumes for the instance, and treat additional volumes as a drift. For this reason, `volume_ids` must not be mixed with external `VolumeAttachment` resources for a given instance.
        :param pulumi.Input[_builtins.str] image: The Droplet image ID or slug. This could be either image ID or droplet snapshot ID. You can find image IDs and slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Images).
        :param pulumi.Input[_builtins.str] ipv4_address: The IPv4 address
        :param pulumi.Input[_builtins.str] ipv4_address_private: The private networking IPv4 address
        :param pulumi.Input[_builtins.bool] ipv6: Boolean controlling if IPv6 is enabled. Defaults to false.
               Once enabled for a Droplet, IPv6 can not be disabled. When enabling IPv6 on
               an existing Droplet, [additional OS-level configuration](https://docs.digitalocean.com/products/networking/ipv6/how-to/enable/#on-existing-droplets)
               is required.
        :param pulumi.Input[_builtins.str] ipv6_address: The IPv6 address
        :param pulumi.Input[_builtins.bool] locked: Is the Droplet locked
        :param pulumi.Input[_builtins.bool] monitoring: Boolean controlling whether monitoring agent is installed.
               Defaults to false. If set to `true`, you can configure monitor alert policies
               [monitor alert resource](https://www.terraform.io/providers/digitalocean/digitalocean/latest/docs/resources/monitor_alert)
        :param pulumi.Input[_builtins.str] name: The Droplet name.
        :param pulumi.Input[_builtins.float] price_hourly: Droplet hourly price
        :param pulumi.Input[_builtins.float] price_monthly: Droplet monthly price
        :param pulumi.Input[_builtins.bool] private_networking: **Deprecated** Boolean controlling if private networking
               is enabled. This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.
        :param pulumi.Input[Union[_builtins.str, 'Region']] region: The region where the Droplet will be created.
        :param pulumi.Input[_builtins.bool] resize_disk: Boolean controlling whether to increase the disk
               size when resizing a Droplet. It defaults to `true`. When set to `false`,
               only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
               size is a permanent change**. Increasing only RAM and CPU is reversible.
        :param pulumi.Input[Union[_builtins.str, 'DropletSlug']] size: The unique slug that identifies the type of Droplet. You may list the available slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Sizes).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_keys: A list of SSH key IDs or fingerprints to enable in
               the format `[12345, 123456]`. To retrieve this info, use the
               [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/SSH-Keys)
               or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
               be added or removed via this provider. Modifying this field will prompt you
               to destroy and recreate the Droplet.
        :param pulumi.Input[_builtins.str] status: The status of the Droplet
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of the tags to be applied to this Droplet.
        :param pulumi.Input[_builtins.str] user_data: A string of the desired User Data provided [during Droplet creation](https://docs.digitalocean.com/products/droplets/how-to/provide-user-data/). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] vcpus: The number of the instance's virtual CPUs
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] volume_ids: A list of the IDs of each block storage volume to be attached to the Droplet.
        :param pulumi.Input[_builtins.str] vpc_uuid: The ID of the VPC where the Droplet will be located.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DropletState.__new__(_DropletState)

        __props__.__dict__["backup_policy"] = backup_policy
        __props__.__dict__["backups"] = backups
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["disk"] = disk
        __props__.__dict__["droplet_agent"] = droplet_agent
        __props__.__dict__["droplet_urn"] = droplet_urn
        __props__.__dict__["graceful_shutdown"] = graceful_shutdown
        __props__.__dict__["image"] = image
        __props__.__dict__["ipv4_address"] = ipv4_address
        __props__.__dict__["ipv4_address_private"] = ipv4_address_private
        __props__.__dict__["ipv6"] = ipv6
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["locked"] = locked
        __props__.__dict__["memory"] = memory
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["name"] = name
        __props__.__dict__["price_hourly"] = price_hourly
        __props__.__dict__["price_monthly"] = price_monthly
        __props__.__dict__["private_networking"] = private_networking
        __props__.__dict__["region"] = region
        __props__.__dict__["resize_disk"] = resize_disk
        __props__.__dict__["size"] = size
        __props__.__dict__["ssh_keys"] = ssh_keys
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["vcpus"] = vcpus
        __props__.__dict__["volume_ids"] = volume_ids
        __props__.__dict__["vpc_uuid"] = vpc_uuid
        return Droplet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> pulumi.Output[Optional['outputs.DropletBackupPolicy']]:
        """
        An object specifying the backup policy for the Droplet. If omitted and `backups` is `true`, the backup plan will default to daily.
        """
        return pulumi.get(self, "backup_policy")

    @_builtins.property
    @pulumi.getter
    def backups(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean controlling if backups are made. Defaults to
        false.
        """
        return pulumi.get(self, "backups")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def disk(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the instance's disk in GB
        """
        return pulumi.get(self, "disk")

    @_builtins.property
    @pulumi.getter(name="dropletAgent")
    def droplet_agent(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean indicating whether to install the
        DigitalOcean agent used for providing access to the Droplet web console in
        the control panel. By default, the agent is installed on new Droplets but
        installation errors (i.e. OS not supported) are ignored. To prevent it from
        being installed, set to `false`. To make installation errors fatal, explicitly
        set it to `true`.
        """
        return pulumi.get(self, "droplet_agent")

    @_builtins.property
    @pulumi.getter(name="dropletUrn")
    def droplet_urn(self) -> pulumi.Output[_builtins.str]:
        """
        The uniform resource name of the Droplet
        """
        return pulumi.get(self, "droplet_urn")

    @_builtins.property
    @pulumi.getter(name="gracefulShutdown")
    def graceful_shutdown(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean indicating whether the droplet
        should be gracefully shut down before it is deleted.

        > **NOTE:** If you use `volume_ids` on a Droplet, this provider will assume management over the full set volumes for the instance, and treat additional volumes as a drift. For this reason, `volume_ids` must not be mixed with external `VolumeAttachment` resources for a given instance.
        """
        return pulumi.get(self, "graceful_shutdown")

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Output[_builtins.str]:
        """
        The Droplet image ID or slug. This could be either image ID or droplet snapshot ID. You can find image IDs and slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Images).
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @_builtins.property
    @pulumi.getter(name="ipv4AddressPrivate")
    def ipv4_address_private(self) -> pulumi.Output[_builtins.str]:
        """
        The private networking IPv4 address
        """
        return pulumi.get(self, "ipv4_address_private")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean controlling if IPv6 is enabled. Defaults to false.
        Once enabled for a Droplet, IPv6 can not be disabled. When enabling IPv6 on
        an existing Droplet, [additional OS-level configuration](https://docs.digitalocean.com/products/networking/ipv6/how-to/enable/#on-existing-droplets)
        is required.
        """
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter
    def locked(self) -> pulumi.Output[_builtins.bool]:
        """
        Is the Droplet locked
        """
        return pulumi.get(self, "locked")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean controlling whether monitoring agent is installed.
        Defaults to false. If set to `true`, you can configure monitor alert policies
        [monitor alert resource](https://www.terraform.io/providers/digitalocean/digitalocean/latest/docs/resources/monitor_alert)
        """
        return pulumi.get(self, "monitoring")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The Droplet name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="priceHourly")
    def price_hourly(self) -> pulumi.Output[_builtins.float]:
        """
        Droplet hourly price
        """
        return pulumi.get(self, "price_hourly")

    @_builtins.property
    @pulumi.getter(name="priceMonthly")
    def price_monthly(self) -> pulumi.Output[_builtins.float]:
        """
        Droplet monthly price
        """
        return pulumi.get(self, "price_monthly")

    @_builtins.property
    @pulumi.getter(name="privateNetworking")
    @_utilities.deprecated("""This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.""")
    def private_networking(self) -> pulumi.Output[_builtins.bool]:
        """
        **Deprecated** Boolean controlling if private networking
        is enabled. This parameter has been deprecated. Use `vpc_uuid` instead to specify a VPC network for the Droplet. If no `vpc_uuid` is provided, the Droplet will be placed in your account's default VPC for the region.
        """
        return pulumi.get(self, "private_networking")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the Droplet will be created.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resizeDisk")
    def resize_disk(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean controlling whether to increase the disk
        size when resizing a Droplet. It defaults to `true`. When set to `false`,
        only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
        size is a permanent change**. Increasing only RAM and CPU is reversible.
        """
        return pulumi.get(self, "resize_disk")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.str]:
        """
        The unique slug that identifies the type of Droplet. You may list the available slugs using the [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/Sizes).
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of SSH key IDs or fingerprints to enable in
        the format `[12345, 123456]`. To retrieve this info, use the
        [DigitalOcean API](https://docs.digitalocean.com/reference/api/digitalocean/#tag/SSH-Keys)
        or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
        be added or removed via this provider. Modifying this field will prompt you
        to destroy and recreate the Droplet.
        """
        return pulumi.get(self, "ssh_keys")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Droplet
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of the tags to be applied to this Droplet.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A string of the desired User Data provided [during Droplet creation](https://docs.digitalocean.com/products/droplets/how-to/provide-user-data/). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter
    def vcpus(self) -> pulumi.Output[_builtins.int]:
        """
        The number of the instance's virtual CPUs
        """
        return pulumi.get(self, "vcpus")

    @_builtins.property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of the IDs of each block storage volume to be attached to the Droplet.
        """
        return pulumi.get(self, "volume_ids")

    @_builtins.property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC where the Droplet will be located.
        """
        return pulumi.get(self, "vpc_uuid")

