# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GenaiAgentArgs', 'GenaiAgent']

@pulumi.input_type
class GenaiAgentArgs:
    def __init__(__self__, *,
                 instruction: pulumi.Input[_builtins.str],
                 model_uuid: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 agent_guardrails: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentAgentGuardrailArgs']]]] = None,
                 anthropic_api_keys: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentAnthropicApiKeyArgs']]]] = None,
                 anthropic_key_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key_infos: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyInfoArgs']]]] = None,
                 api_keys: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyArgs']]]] = None,
                 chatbot_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotIdentifierArgs']]]] = None,
                 chatbots: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotArgs']]]] = None,
                 child_agents: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChildAgentArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deployments: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentDeploymentArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 functions: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentFunctionArgs']]]] = None,
                 if_case: Optional[pulumi.Input[_builtins.str]] = None,
                 k: Optional[pulumi.Input[_builtins.int]] = None,
                 knowledge_base_uuids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 knowledge_bases: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentKnowledgeBaseArgs']]]] = None,
                 max_tokens: Optional[pulumi.Input[_builtins.int]] = None,
                 models: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentModelArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_ai_api_keys: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentOpenAiApiKeyArgs']]]] = None,
                 open_ai_key_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_agents: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentParentAgentArgs']]]] = None,
                 provide_citations: Optional[pulumi.Input[_builtins.bool]] = None,
                 retrieval_method: Optional[pulumi.Input[_builtins.str]] = None,
                 route_created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 route_name: Optional[pulumi.Input[_builtins.str]] = None,
                 route_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 temperature: Optional[pulumi.Input[_builtins.float]] = None,
                 templates: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentTemplateArgs']]]] = None,
                 top_p: Optional[pulumi.Input[_builtins.float]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GenaiAgent resource.
        :param pulumi.Input[_builtins.str] instruction: Instruction for the Agent
        :param pulumi.Input[_builtins.str] model_uuid: Model UUID of the Agent
        :param pulumi.Input[_builtins.str] project_id: Project ID of the Agent
        :param pulumi.Input[_builtins.str] region: Region where the Agent is deployed
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentAgentGuardrailArgs']]] agent_guardrails: AgentGuardrail represents a Guardrail attached to Gen AI Agent
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentAnthropicApiKeyArgs']]] anthropic_api_keys: Anthropic API Key information
        :param pulumi.Input[_builtins.str] anthropic_key_uuid: Optional Anthropic API key ID to use with Anthropic models
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyInfoArgs']]] api_key_infos: List of API Key Infos
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyArgs']]] api_keys: List of API Keys
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotIdentifierArgs']]] chatbot_identifiers: List of Chatbot Identifiers
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotArgs']]] chatbots: ChatBot configuration
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentChildAgentArgs']]] child_agents: List of child agents
        :param pulumi.Input[_builtins.str] created_at: Timestamp when the Agent was created
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentDeploymentArgs']]] deployments: List of API Key Infos
        :param pulumi.Input[_builtins.str] description: Description for the Agent
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentFunctionArgs']]] functions: List of Functions
        :param pulumi.Input[_builtins.str] if_case: If case condition
        :param pulumi.Input[_builtins.int] k: K value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] knowledge_base_uuids: Ids of the knowledge base(s) to attach to the agent
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentKnowledgeBaseArgs']]] knowledge_bases: List of Knowledge Bases
        :param pulumi.Input[_builtins.int] max_tokens: Maximum tokens allowed
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentModelArgs']]] models: Model of the Agent
        :param pulumi.Input[_builtins.str] name: Name of the Agent
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentOpenAiApiKeyArgs']]] open_ai_api_keys: OpenAI API Key information
        :param pulumi.Input[_builtins.str] open_ai_key_uuid: Optional OpenAI API key ID to use with OpenAI models
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentParentAgentArgs']]] parent_agents: List of child agents
        :param pulumi.Input[_builtins.bool] provide_citations: Indicates if the agent should provide citations in responses
        :param pulumi.Input[_builtins.str] retrieval_method: Retrieval method used
        :param pulumi.Input[_builtins.str] route_created_by: User who created the route
        :param pulumi.Input[_builtins.str] route_name: Route name
        :param pulumi.Input[_builtins.str] route_uuid: Route UUID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of Tags
        :param pulumi.Input[_builtins.float] temperature: Agent temperature setting
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentTemplateArgs']]] templates: Agent Template
        :param pulumi.Input[_builtins.float] top_p: Top P sampling parameter
        :param pulumi.Input[_builtins.str] url: URL for the Agent
        :param pulumi.Input[_builtins.str] user_id: User ID linked with the Agent
        """
        pulumi.set(__self__, "instruction", instruction)
        pulumi.set(__self__, "model_uuid", model_uuid)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "region", region)
        if agent_guardrails is not None:
            pulumi.set(__self__, "agent_guardrails", agent_guardrails)
        if anthropic_api_keys is not None:
            pulumi.set(__self__, "anthropic_api_keys", anthropic_api_keys)
        if anthropic_key_uuid is not None:
            pulumi.set(__self__, "anthropic_key_uuid", anthropic_key_uuid)
        if api_key_infos is not None:
            pulumi.set(__self__, "api_key_infos", api_key_infos)
        if api_keys is not None:
            pulumi.set(__self__, "api_keys", api_keys)
        if chatbot_identifiers is not None:
            pulumi.set(__self__, "chatbot_identifiers", chatbot_identifiers)
        if chatbots is not None:
            pulumi.set(__self__, "chatbots", chatbots)
        if child_agents is not None:
            pulumi.set(__self__, "child_agents", child_agents)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deployments is not None:
            pulumi.set(__self__, "deployments", deployments)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if functions is not None:
            pulumi.set(__self__, "functions", functions)
        if if_case is not None:
            pulumi.set(__self__, "if_case", if_case)
        if k is not None:
            pulumi.set(__self__, "k", k)
        if knowledge_base_uuids is not None:
            pulumi.set(__self__, "knowledge_base_uuids", knowledge_base_uuids)
        if knowledge_bases is not None:
            pulumi.set(__self__, "knowledge_bases", knowledge_bases)
        if max_tokens is not None:
            pulumi.set(__self__, "max_tokens", max_tokens)
        if models is not None:
            pulumi.set(__self__, "models", models)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_ai_api_keys is not None:
            pulumi.set(__self__, "open_ai_api_keys", open_ai_api_keys)
        if open_ai_key_uuid is not None:
            pulumi.set(__self__, "open_ai_key_uuid", open_ai_key_uuid)
        if parent_agents is not None:
            pulumi.set(__self__, "parent_agents", parent_agents)
        if provide_citations is not None:
            pulumi.set(__self__, "provide_citations", provide_citations)
        if retrieval_method is not None:
            pulumi.set(__self__, "retrieval_method", retrieval_method)
        if route_created_by is not None:
            pulumi.set(__self__, "route_created_by", route_created_by)
        if route_name is not None:
            pulumi.set(__self__, "route_name", route_name)
        if route_uuid is not None:
            pulumi.set(__self__, "route_uuid", route_uuid)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if temperature is not None:
            pulumi.set(__self__, "temperature", temperature)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)
        if top_p is not None:
            pulumi.set(__self__, "top_p", top_p)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def instruction(self) -> pulumi.Input[_builtins.str]:
        """
        Instruction for the Agent
        """
        return pulumi.get(self, "instruction")

    @instruction.setter
    def instruction(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instruction", value)

    @_builtins.property
    @pulumi.getter(name="modelUuid")
    def model_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        Model UUID of the Agent
        """
        return pulumi.get(self, "model_uuid")

    @model_uuid.setter
    def model_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "model_uuid", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Project ID of the Agent
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        Region where the Agent is deployed
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="agentGuardrails")
    def agent_guardrails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentAgentGuardrailArgs']]]]:
        """
        AgentGuardrail represents a Guardrail attached to Gen AI Agent
        """
        return pulumi.get(self, "agent_guardrails")

    @agent_guardrails.setter
    def agent_guardrails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentAgentGuardrailArgs']]]]):
        pulumi.set(self, "agent_guardrails", value)

    @_builtins.property
    @pulumi.getter(name="anthropicApiKeys")
    def anthropic_api_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentAnthropicApiKeyArgs']]]]:
        """
        Anthropic API Key information
        """
        return pulumi.get(self, "anthropic_api_keys")

    @anthropic_api_keys.setter
    def anthropic_api_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentAnthropicApiKeyArgs']]]]):
        pulumi.set(self, "anthropic_api_keys", value)

    @_builtins.property
    @pulumi.getter(name="anthropicKeyUuid")
    def anthropic_key_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional Anthropic API key ID to use with Anthropic models
        """
        return pulumi.get(self, "anthropic_key_uuid")

    @anthropic_key_uuid.setter
    def anthropic_key_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "anthropic_key_uuid", value)

    @_builtins.property
    @pulumi.getter(name="apiKeyInfos")
    def api_key_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyInfoArgs']]]]:
        """
        List of API Key Infos
        """
        return pulumi.get(self, "api_key_infos")

    @api_key_infos.setter
    def api_key_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyInfoArgs']]]]):
        pulumi.set(self, "api_key_infos", value)

    @_builtins.property
    @pulumi.getter(name="apiKeys")
    def api_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyArgs']]]]:
        """
        List of API Keys
        """
        return pulumi.get(self, "api_keys")

    @api_keys.setter
    def api_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyArgs']]]]):
        pulumi.set(self, "api_keys", value)

    @_builtins.property
    @pulumi.getter(name="chatbotIdentifiers")
    def chatbot_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotIdentifierArgs']]]]:
        """
        List of Chatbot Identifiers
        """
        return pulumi.get(self, "chatbot_identifiers")

    @chatbot_identifiers.setter
    def chatbot_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotIdentifierArgs']]]]):
        pulumi.set(self, "chatbot_identifiers", value)

    @_builtins.property
    @pulumi.getter
    def chatbots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotArgs']]]]:
        """
        ChatBot configuration
        """
        return pulumi.get(self, "chatbots")

    @chatbots.setter
    def chatbots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotArgs']]]]):
        pulumi.set(self, "chatbots", value)

    @_builtins.property
    @pulumi.getter(name="childAgents")
    def child_agents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChildAgentArgs']]]]:
        """
        List of child agents
        """
        return pulumi.get(self, "child_agents")

    @child_agents.setter
    def child_agents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChildAgentArgs']]]]):
        pulumi.set(self, "child_agents", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the Agent was created
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def deployments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentDeploymentArgs']]]]:
        """
        List of API Key Infos
        """
        return pulumi.get(self, "deployments")

    @deployments.setter
    def deployments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentDeploymentArgs']]]]):
        pulumi.set(self, "deployments", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the Agent
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def functions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentFunctionArgs']]]]:
        """
        List of Functions
        """
        return pulumi.get(self, "functions")

    @functions.setter
    def functions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentFunctionArgs']]]]):
        pulumi.set(self, "functions", value)

    @_builtins.property
    @pulumi.getter(name="ifCase")
    def if_case(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If case condition
        """
        return pulumi.get(self, "if_case")

    @if_case.setter
    def if_case(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "if_case", value)

    @_builtins.property
    @pulumi.getter
    def k(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        K value
        """
        return pulumi.get(self, "k")

    @k.setter
    def k(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "k", value)

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseUuids")
    def knowledge_base_uuids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Ids of the knowledge base(s) to attach to the agent
        """
        return pulumi.get(self, "knowledge_base_uuids")

    @knowledge_base_uuids.setter
    def knowledge_base_uuids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "knowledge_base_uuids", value)

    @_builtins.property
    @pulumi.getter(name="knowledgeBases")
    def knowledge_bases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentKnowledgeBaseArgs']]]]:
        """
        List of Knowledge Bases
        """
        return pulumi.get(self, "knowledge_bases")

    @knowledge_bases.setter
    def knowledge_bases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentKnowledgeBaseArgs']]]]):
        pulumi.set(self, "knowledge_bases", value)

    @_builtins.property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum tokens allowed
        """
        return pulumi.get(self, "max_tokens")

    @max_tokens.setter
    def max_tokens(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_tokens", value)

    @_builtins.property
    @pulumi.getter
    def models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentModelArgs']]]]:
        """
        Model of the Agent
        """
        return pulumi.get(self, "models")

    @models.setter
    def models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentModelArgs']]]]):
        pulumi.set(self, "models", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Agent
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openAiApiKeys")
    def open_ai_api_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentOpenAiApiKeyArgs']]]]:
        """
        OpenAI API Key information
        """
        return pulumi.get(self, "open_ai_api_keys")

    @open_ai_api_keys.setter
    def open_ai_api_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentOpenAiApiKeyArgs']]]]):
        pulumi.set(self, "open_ai_api_keys", value)

    @_builtins.property
    @pulumi.getter(name="openAiKeyUuid")
    def open_ai_key_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional OpenAI API key ID to use with OpenAI models
        """
        return pulumi.get(self, "open_ai_key_uuid")

    @open_ai_key_uuid.setter
    def open_ai_key_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "open_ai_key_uuid", value)

    @_builtins.property
    @pulumi.getter(name="parentAgents")
    def parent_agents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentParentAgentArgs']]]]:
        """
        List of child agents
        """
        return pulumi.get(self, "parent_agents")

    @parent_agents.setter
    def parent_agents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentParentAgentArgs']]]]):
        pulumi.set(self, "parent_agents", value)

    @_builtins.property
    @pulumi.getter(name="provideCitations")
    def provide_citations(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the agent should provide citations in responses
        """
        return pulumi.get(self, "provide_citations")

    @provide_citations.setter
    def provide_citations(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "provide_citations", value)

    @_builtins.property
    @pulumi.getter(name="retrievalMethod")
    def retrieval_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Retrieval method used
        """
        return pulumi.get(self, "retrieval_method")

    @retrieval_method.setter
    def retrieval_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retrieval_method", value)

    @_builtins.property
    @pulumi.getter(name="routeCreatedBy")
    def route_created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User who created the route
        """
        return pulumi.get(self, "route_created_by")

    @route_created_by.setter
    def route_created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_created_by", value)

    @_builtins.property
    @pulumi.getter(name="routeName")
    def route_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route name
        """
        return pulumi.get(self, "route_name")

    @route_name.setter
    def route_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_name", value)

    @_builtins.property
    @pulumi.getter(name="routeUuid")
    def route_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route UUID
        """
        return pulumi.get(self, "route_uuid")

    @route_uuid.setter
    def route_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_uuid", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def temperature(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Agent temperature setting
        """
        return pulumi.get(self, "temperature")

    @temperature.setter
    def temperature(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "temperature", value)

    @_builtins.property
    @pulumi.getter
    def templates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentTemplateArgs']]]]:
        """
        Agent Template
        """
        return pulumi.get(self, "templates")

    @templates.setter
    def templates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentTemplateArgs']]]]):
        pulumi.set(self, "templates", value)

    @_builtins.property
    @pulumi.getter(name="topP")
    def top_p(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Top P sampling parameter
        """
        return pulumi.get(self, "top_p")

    @top_p.setter
    def top_p(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "top_p", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL for the Agent
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User ID linked with the Agent
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _GenaiAgentState:
    def __init__(__self__, *,
                 agent_guardrails: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentAgentGuardrailArgs']]]] = None,
                 anthropic_api_keys: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentAnthropicApiKeyArgs']]]] = None,
                 anthropic_key_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key_infos: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyInfoArgs']]]] = None,
                 api_keys: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyArgs']]]] = None,
                 chatbot_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotIdentifierArgs']]]] = None,
                 chatbots: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotArgs']]]] = None,
                 child_agents: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChildAgentArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deployments: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentDeploymentArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 functions: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentFunctionArgs']]]] = None,
                 if_case: Optional[pulumi.Input[_builtins.str]] = None,
                 instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 k: Optional[pulumi.Input[_builtins.int]] = None,
                 knowledge_base_uuids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 knowledge_bases: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentKnowledgeBaseArgs']]]] = None,
                 max_tokens: Optional[pulumi.Input[_builtins.int]] = None,
                 model_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 models: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentModelArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_ai_api_keys: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentOpenAiApiKeyArgs']]]] = None,
                 open_ai_key_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_agents: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentParentAgentArgs']]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provide_citations: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retrieval_method: Optional[pulumi.Input[_builtins.str]] = None,
                 route_created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 route_created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 route_name: Optional[pulumi.Input[_builtins.str]] = None,
                 route_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 temperature: Optional[pulumi.Input[_builtins.float]] = None,
                 templates: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentTemplateArgs']]]] = None,
                 top_p: Optional[pulumi.Input[_builtins.float]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GenaiAgent resources.
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentAgentGuardrailArgs']]] agent_guardrails: AgentGuardrail represents a Guardrail attached to Gen AI Agent
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentAnthropicApiKeyArgs']]] anthropic_api_keys: Anthropic API Key information
        :param pulumi.Input[_builtins.str] anthropic_key_uuid: Optional Anthropic API key ID to use with Anthropic models
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyInfoArgs']]] api_key_infos: List of API Key Infos
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyArgs']]] api_keys: List of API Keys
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotIdentifierArgs']]] chatbot_identifiers: List of Chatbot Identifiers
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotArgs']]] chatbots: ChatBot configuration
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentChildAgentArgs']]] child_agents: List of child agents
        :param pulumi.Input[_builtins.str] created_at: Timestamp when the Agent was created
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentDeploymentArgs']]] deployments: List of API Key Infos
        :param pulumi.Input[_builtins.str] description: Description for the Agent
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentFunctionArgs']]] functions: List of Functions
        :param pulumi.Input[_builtins.str] if_case: If case condition
        :param pulumi.Input[_builtins.str] instruction: Instruction for the Agent
        :param pulumi.Input[_builtins.int] k: K value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] knowledge_base_uuids: Ids of the knowledge base(s) to attach to the agent
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentKnowledgeBaseArgs']]] knowledge_bases: List of Knowledge Bases
        :param pulumi.Input[_builtins.int] max_tokens: Maximum tokens allowed
        :param pulumi.Input[_builtins.str] model_uuid: Model UUID of the Agent
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentModelArgs']]] models: Model of the Agent
        :param pulumi.Input[_builtins.str] name: Name of the Agent
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentOpenAiApiKeyArgs']]] open_ai_api_keys: OpenAI API Key information
        :param pulumi.Input[_builtins.str] open_ai_key_uuid: Optional OpenAI API key ID to use with OpenAI models
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentParentAgentArgs']]] parent_agents: List of child agents
        :param pulumi.Input[_builtins.str] project_id: Project ID of the Agent
        :param pulumi.Input[_builtins.bool] provide_citations: Indicates if the agent should provide citations in responses
        :param pulumi.Input[_builtins.str] region: Region where the Agent is deployed
        :param pulumi.Input[_builtins.str] retrieval_method: Retrieval method used
        :param pulumi.Input[_builtins.str] route_created_at: Timestamp when the route was created
        :param pulumi.Input[_builtins.str] route_created_by: User who created the route
        :param pulumi.Input[_builtins.str] route_name: Route name
        :param pulumi.Input[_builtins.str] route_uuid: Route UUID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of Tags
        :param pulumi.Input[_builtins.float] temperature: Agent temperature setting
        :param pulumi.Input[Sequence[pulumi.Input['GenaiAgentTemplateArgs']]] templates: Agent Template
        :param pulumi.Input[_builtins.float] top_p: Top P sampling parameter
        :param pulumi.Input[_builtins.str] updated_at: Timestamp when the Agent was updated
        :param pulumi.Input[_builtins.str] url: URL for the Agent
        :param pulumi.Input[_builtins.str] user_id: User ID linked with the Agent
        """
        if agent_guardrails is not None:
            pulumi.set(__self__, "agent_guardrails", agent_guardrails)
        if anthropic_api_keys is not None:
            pulumi.set(__self__, "anthropic_api_keys", anthropic_api_keys)
        if anthropic_key_uuid is not None:
            pulumi.set(__self__, "anthropic_key_uuid", anthropic_key_uuid)
        if api_key_infos is not None:
            pulumi.set(__self__, "api_key_infos", api_key_infos)
        if api_keys is not None:
            pulumi.set(__self__, "api_keys", api_keys)
        if chatbot_identifiers is not None:
            pulumi.set(__self__, "chatbot_identifiers", chatbot_identifiers)
        if chatbots is not None:
            pulumi.set(__self__, "chatbots", chatbots)
        if child_agents is not None:
            pulumi.set(__self__, "child_agents", child_agents)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deployments is not None:
            pulumi.set(__self__, "deployments", deployments)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if functions is not None:
            pulumi.set(__self__, "functions", functions)
        if if_case is not None:
            pulumi.set(__self__, "if_case", if_case)
        if instruction is not None:
            pulumi.set(__self__, "instruction", instruction)
        if k is not None:
            pulumi.set(__self__, "k", k)
        if knowledge_base_uuids is not None:
            pulumi.set(__self__, "knowledge_base_uuids", knowledge_base_uuids)
        if knowledge_bases is not None:
            pulumi.set(__self__, "knowledge_bases", knowledge_bases)
        if max_tokens is not None:
            pulumi.set(__self__, "max_tokens", max_tokens)
        if model_uuid is not None:
            pulumi.set(__self__, "model_uuid", model_uuid)
        if models is not None:
            pulumi.set(__self__, "models", models)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if open_ai_api_keys is not None:
            pulumi.set(__self__, "open_ai_api_keys", open_ai_api_keys)
        if open_ai_key_uuid is not None:
            pulumi.set(__self__, "open_ai_key_uuid", open_ai_key_uuid)
        if parent_agents is not None:
            pulumi.set(__self__, "parent_agents", parent_agents)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if provide_citations is not None:
            pulumi.set(__self__, "provide_citations", provide_citations)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retrieval_method is not None:
            pulumi.set(__self__, "retrieval_method", retrieval_method)
        if route_created_at is not None:
            pulumi.set(__self__, "route_created_at", route_created_at)
        if route_created_by is not None:
            pulumi.set(__self__, "route_created_by", route_created_by)
        if route_name is not None:
            pulumi.set(__self__, "route_name", route_name)
        if route_uuid is not None:
            pulumi.set(__self__, "route_uuid", route_uuid)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if temperature is not None:
            pulumi.set(__self__, "temperature", temperature)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)
        if top_p is not None:
            pulumi.set(__self__, "top_p", top_p)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="agentGuardrails")
    def agent_guardrails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentAgentGuardrailArgs']]]]:
        """
        AgentGuardrail represents a Guardrail attached to Gen AI Agent
        """
        return pulumi.get(self, "agent_guardrails")

    @agent_guardrails.setter
    def agent_guardrails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentAgentGuardrailArgs']]]]):
        pulumi.set(self, "agent_guardrails", value)

    @_builtins.property
    @pulumi.getter(name="anthropicApiKeys")
    def anthropic_api_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentAnthropicApiKeyArgs']]]]:
        """
        Anthropic API Key information
        """
        return pulumi.get(self, "anthropic_api_keys")

    @anthropic_api_keys.setter
    def anthropic_api_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentAnthropicApiKeyArgs']]]]):
        pulumi.set(self, "anthropic_api_keys", value)

    @_builtins.property
    @pulumi.getter(name="anthropicKeyUuid")
    def anthropic_key_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional Anthropic API key ID to use with Anthropic models
        """
        return pulumi.get(self, "anthropic_key_uuid")

    @anthropic_key_uuid.setter
    def anthropic_key_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "anthropic_key_uuid", value)

    @_builtins.property
    @pulumi.getter(name="apiKeyInfos")
    def api_key_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyInfoArgs']]]]:
        """
        List of API Key Infos
        """
        return pulumi.get(self, "api_key_infos")

    @api_key_infos.setter
    def api_key_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyInfoArgs']]]]):
        pulumi.set(self, "api_key_infos", value)

    @_builtins.property
    @pulumi.getter(name="apiKeys")
    def api_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyArgs']]]]:
        """
        List of API Keys
        """
        return pulumi.get(self, "api_keys")

    @api_keys.setter
    def api_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentApiKeyArgs']]]]):
        pulumi.set(self, "api_keys", value)

    @_builtins.property
    @pulumi.getter(name="chatbotIdentifiers")
    def chatbot_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotIdentifierArgs']]]]:
        """
        List of Chatbot Identifiers
        """
        return pulumi.get(self, "chatbot_identifiers")

    @chatbot_identifiers.setter
    def chatbot_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotIdentifierArgs']]]]):
        pulumi.set(self, "chatbot_identifiers", value)

    @_builtins.property
    @pulumi.getter
    def chatbots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotArgs']]]]:
        """
        ChatBot configuration
        """
        return pulumi.get(self, "chatbots")

    @chatbots.setter
    def chatbots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChatbotArgs']]]]):
        pulumi.set(self, "chatbots", value)

    @_builtins.property
    @pulumi.getter(name="childAgents")
    def child_agents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChildAgentArgs']]]]:
        """
        List of child agents
        """
        return pulumi.get(self, "child_agents")

    @child_agents.setter
    def child_agents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentChildAgentArgs']]]]):
        pulumi.set(self, "child_agents", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the Agent was created
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def deployments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentDeploymentArgs']]]]:
        """
        List of API Key Infos
        """
        return pulumi.get(self, "deployments")

    @deployments.setter
    def deployments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentDeploymentArgs']]]]):
        pulumi.set(self, "deployments", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the Agent
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def functions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentFunctionArgs']]]]:
        """
        List of Functions
        """
        return pulumi.get(self, "functions")

    @functions.setter
    def functions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentFunctionArgs']]]]):
        pulumi.set(self, "functions", value)

    @_builtins.property
    @pulumi.getter(name="ifCase")
    def if_case(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If case condition
        """
        return pulumi.get(self, "if_case")

    @if_case.setter
    def if_case(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "if_case", value)

    @_builtins.property
    @pulumi.getter
    def instruction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instruction for the Agent
        """
        return pulumi.get(self, "instruction")

    @instruction.setter
    def instruction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instruction", value)

    @_builtins.property
    @pulumi.getter
    def k(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        K value
        """
        return pulumi.get(self, "k")

    @k.setter
    def k(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "k", value)

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseUuids")
    def knowledge_base_uuids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Ids of the knowledge base(s) to attach to the agent
        """
        return pulumi.get(self, "knowledge_base_uuids")

    @knowledge_base_uuids.setter
    def knowledge_base_uuids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "knowledge_base_uuids", value)

    @_builtins.property
    @pulumi.getter(name="knowledgeBases")
    def knowledge_bases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentKnowledgeBaseArgs']]]]:
        """
        List of Knowledge Bases
        """
        return pulumi.get(self, "knowledge_bases")

    @knowledge_bases.setter
    def knowledge_bases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentKnowledgeBaseArgs']]]]):
        pulumi.set(self, "knowledge_bases", value)

    @_builtins.property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum tokens allowed
        """
        return pulumi.get(self, "max_tokens")

    @max_tokens.setter
    def max_tokens(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_tokens", value)

    @_builtins.property
    @pulumi.getter(name="modelUuid")
    def model_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Model UUID of the Agent
        """
        return pulumi.get(self, "model_uuid")

    @model_uuid.setter
    def model_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "model_uuid", value)

    @_builtins.property
    @pulumi.getter
    def models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentModelArgs']]]]:
        """
        Model of the Agent
        """
        return pulumi.get(self, "models")

    @models.setter
    def models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentModelArgs']]]]):
        pulumi.set(self, "models", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Agent
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openAiApiKeys")
    def open_ai_api_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentOpenAiApiKeyArgs']]]]:
        """
        OpenAI API Key information
        """
        return pulumi.get(self, "open_ai_api_keys")

    @open_ai_api_keys.setter
    def open_ai_api_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentOpenAiApiKeyArgs']]]]):
        pulumi.set(self, "open_ai_api_keys", value)

    @_builtins.property
    @pulumi.getter(name="openAiKeyUuid")
    def open_ai_key_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional OpenAI API key ID to use with OpenAI models
        """
        return pulumi.get(self, "open_ai_key_uuid")

    @open_ai_key_uuid.setter
    def open_ai_key_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "open_ai_key_uuid", value)

    @_builtins.property
    @pulumi.getter(name="parentAgents")
    def parent_agents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentParentAgentArgs']]]]:
        """
        List of child agents
        """
        return pulumi.get(self, "parent_agents")

    @parent_agents.setter
    def parent_agents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentParentAgentArgs']]]]):
        pulumi.set(self, "parent_agents", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project ID of the Agent
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="provideCitations")
    def provide_citations(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if the agent should provide citations in responses
        """
        return pulumi.get(self, "provide_citations")

    @provide_citations.setter
    def provide_citations(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "provide_citations", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where the Agent is deployed
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="retrievalMethod")
    def retrieval_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Retrieval method used
        """
        return pulumi.get(self, "retrieval_method")

    @retrieval_method.setter
    def retrieval_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retrieval_method", value)

    @_builtins.property
    @pulumi.getter(name="routeCreatedAt")
    def route_created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the route was created
        """
        return pulumi.get(self, "route_created_at")

    @route_created_at.setter
    def route_created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_created_at", value)

    @_builtins.property
    @pulumi.getter(name="routeCreatedBy")
    def route_created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User who created the route
        """
        return pulumi.get(self, "route_created_by")

    @route_created_by.setter
    def route_created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_created_by", value)

    @_builtins.property
    @pulumi.getter(name="routeName")
    def route_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route name
        """
        return pulumi.get(self, "route_name")

    @route_name.setter
    def route_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_name", value)

    @_builtins.property
    @pulumi.getter(name="routeUuid")
    def route_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Route UUID
        """
        return pulumi.get(self, "route_uuid")

    @route_uuid.setter
    def route_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_uuid", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def temperature(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Agent temperature setting
        """
        return pulumi.get(self, "temperature")

    @temperature.setter
    def temperature(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "temperature", value)

    @_builtins.property
    @pulumi.getter
    def templates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentTemplateArgs']]]]:
        """
        Agent Template
        """
        return pulumi.get(self, "templates")

    @templates.setter
    def templates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GenaiAgentTemplateArgs']]]]):
        pulumi.set(self, "templates", value)

    @_builtins.property
    @pulumi.getter(name="topP")
    def top_p(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Top P sampling parameter
        """
        return pulumi.get(self, "top_p")

    @top_p.setter
    def top_p(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "top_p", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the Agent was updated
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL for the Agent
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User ID linked with the Agent
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("digitalocean:index/genaiAgent:GenaiAgent")
class GenaiAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_guardrails: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentAgentGuardrailArgs', 'GenaiAgentAgentGuardrailArgsDict']]]]] = None,
                 anthropic_api_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentAnthropicApiKeyArgs', 'GenaiAgentAnthropicApiKeyArgsDict']]]]] = None,
                 anthropic_key_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentApiKeyInfoArgs', 'GenaiAgentApiKeyInfoArgsDict']]]]] = None,
                 api_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentApiKeyArgs', 'GenaiAgentApiKeyArgsDict']]]]] = None,
                 chatbot_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChatbotIdentifierArgs', 'GenaiAgentChatbotIdentifierArgsDict']]]]] = None,
                 chatbots: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChatbotArgs', 'GenaiAgentChatbotArgsDict']]]]] = None,
                 child_agents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChildAgentArgs', 'GenaiAgentChildAgentArgsDict']]]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deployments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentDeploymentArgs', 'GenaiAgentDeploymentArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 functions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentFunctionArgs', 'GenaiAgentFunctionArgsDict']]]]] = None,
                 if_case: Optional[pulumi.Input[_builtins.str]] = None,
                 instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 k: Optional[pulumi.Input[_builtins.int]] = None,
                 knowledge_base_uuids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 knowledge_bases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentKnowledgeBaseArgs', 'GenaiAgentKnowledgeBaseArgsDict']]]]] = None,
                 max_tokens: Optional[pulumi.Input[_builtins.int]] = None,
                 model_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 models: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentModelArgs', 'GenaiAgentModelArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_ai_api_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentOpenAiApiKeyArgs', 'GenaiAgentOpenAiApiKeyArgsDict']]]]] = None,
                 open_ai_key_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_agents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentParentAgentArgs', 'GenaiAgentParentAgentArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provide_citations: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retrieval_method: Optional[pulumi.Input[_builtins.str]] = None,
                 route_created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 route_name: Optional[pulumi.Input[_builtins.str]] = None,
                 route_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 temperature: Optional[pulumi.Input[_builtins.float]] = None,
                 templates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentTemplateArgs', 'GenaiAgentTemplateArgsDict']]]]] = None,
                 top_p: Optional[pulumi.Input[_builtins.float]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a GenaiAgent resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentAgentGuardrailArgs', 'GenaiAgentAgentGuardrailArgsDict']]]] agent_guardrails: AgentGuardrail represents a Guardrail attached to Gen AI Agent
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentAnthropicApiKeyArgs', 'GenaiAgentAnthropicApiKeyArgsDict']]]] anthropic_api_keys: Anthropic API Key information
        :param pulumi.Input[_builtins.str] anthropic_key_uuid: Optional Anthropic API key ID to use with Anthropic models
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentApiKeyInfoArgs', 'GenaiAgentApiKeyInfoArgsDict']]]] api_key_infos: List of API Key Infos
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentApiKeyArgs', 'GenaiAgentApiKeyArgsDict']]]] api_keys: List of API Keys
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChatbotIdentifierArgs', 'GenaiAgentChatbotIdentifierArgsDict']]]] chatbot_identifiers: List of Chatbot Identifiers
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChatbotArgs', 'GenaiAgentChatbotArgsDict']]]] chatbots: ChatBot configuration
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChildAgentArgs', 'GenaiAgentChildAgentArgsDict']]]] child_agents: List of child agents
        :param pulumi.Input[_builtins.str] created_at: Timestamp when the Agent was created
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentDeploymentArgs', 'GenaiAgentDeploymentArgsDict']]]] deployments: List of API Key Infos
        :param pulumi.Input[_builtins.str] description: Description for the Agent
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentFunctionArgs', 'GenaiAgentFunctionArgsDict']]]] functions: List of Functions
        :param pulumi.Input[_builtins.str] if_case: If case condition
        :param pulumi.Input[_builtins.str] instruction: Instruction for the Agent
        :param pulumi.Input[_builtins.int] k: K value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] knowledge_base_uuids: Ids of the knowledge base(s) to attach to the agent
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentKnowledgeBaseArgs', 'GenaiAgentKnowledgeBaseArgsDict']]]] knowledge_bases: List of Knowledge Bases
        :param pulumi.Input[_builtins.int] max_tokens: Maximum tokens allowed
        :param pulumi.Input[_builtins.str] model_uuid: Model UUID of the Agent
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentModelArgs', 'GenaiAgentModelArgsDict']]]] models: Model of the Agent
        :param pulumi.Input[_builtins.str] name: Name of the Agent
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentOpenAiApiKeyArgs', 'GenaiAgentOpenAiApiKeyArgsDict']]]] open_ai_api_keys: OpenAI API Key information
        :param pulumi.Input[_builtins.str] open_ai_key_uuid: Optional OpenAI API key ID to use with OpenAI models
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentParentAgentArgs', 'GenaiAgentParentAgentArgsDict']]]] parent_agents: List of child agents
        :param pulumi.Input[_builtins.str] project_id: Project ID of the Agent
        :param pulumi.Input[_builtins.bool] provide_citations: Indicates if the agent should provide citations in responses
        :param pulumi.Input[_builtins.str] region: Region where the Agent is deployed
        :param pulumi.Input[_builtins.str] retrieval_method: Retrieval method used
        :param pulumi.Input[_builtins.str] route_created_by: User who created the route
        :param pulumi.Input[_builtins.str] route_name: Route name
        :param pulumi.Input[_builtins.str] route_uuid: Route UUID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of Tags
        :param pulumi.Input[_builtins.float] temperature: Agent temperature setting
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentTemplateArgs', 'GenaiAgentTemplateArgsDict']]]] templates: Agent Template
        :param pulumi.Input[_builtins.float] top_p: Top P sampling parameter
        :param pulumi.Input[_builtins.str] url: URL for the Agent
        :param pulumi.Input[_builtins.str] user_id: User ID linked with the Agent
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GenaiAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a GenaiAgent resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GenaiAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GenaiAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_guardrails: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentAgentGuardrailArgs', 'GenaiAgentAgentGuardrailArgsDict']]]]] = None,
                 anthropic_api_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentAnthropicApiKeyArgs', 'GenaiAgentAnthropicApiKeyArgsDict']]]]] = None,
                 anthropic_key_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 api_key_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentApiKeyInfoArgs', 'GenaiAgentApiKeyInfoArgsDict']]]]] = None,
                 api_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentApiKeyArgs', 'GenaiAgentApiKeyArgsDict']]]]] = None,
                 chatbot_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChatbotIdentifierArgs', 'GenaiAgentChatbotIdentifierArgsDict']]]]] = None,
                 chatbots: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChatbotArgs', 'GenaiAgentChatbotArgsDict']]]]] = None,
                 child_agents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChildAgentArgs', 'GenaiAgentChildAgentArgsDict']]]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deployments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentDeploymentArgs', 'GenaiAgentDeploymentArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 functions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentFunctionArgs', 'GenaiAgentFunctionArgsDict']]]]] = None,
                 if_case: Optional[pulumi.Input[_builtins.str]] = None,
                 instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 k: Optional[pulumi.Input[_builtins.int]] = None,
                 knowledge_base_uuids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 knowledge_bases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentKnowledgeBaseArgs', 'GenaiAgentKnowledgeBaseArgsDict']]]]] = None,
                 max_tokens: Optional[pulumi.Input[_builtins.int]] = None,
                 model_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 models: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentModelArgs', 'GenaiAgentModelArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 open_ai_api_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentOpenAiApiKeyArgs', 'GenaiAgentOpenAiApiKeyArgsDict']]]]] = None,
                 open_ai_key_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_agents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentParentAgentArgs', 'GenaiAgentParentAgentArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 provide_citations: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retrieval_method: Optional[pulumi.Input[_builtins.str]] = None,
                 route_created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 route_name: Optional[pulumi.Input[_builtins.str]] = None,
                 route_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 temperature: Optional[pulumi.Input[_builtins.float]] = None,
                 templates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentTemplateArgs', 'GenaiAgentTemplateArgsDict']]]]] = None,
                 top_p: Optional[pulumi.Input[_builtins.float]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GenaiAgentArgs.__new__(GenaiAgentArgs)

            __props__.__dict__["agent_guardrails"] = agent_guardrails
            __props__.__dict__["anthropic_api_keys"] = anthropic_api_keys
            __props__.__dict__["anthropic_key_uuid"] = anthropic_key_uuid
            __props__.__dict__["api_key_infos"] = api_key_infos
            __props__.__dict__["api_keys"] = api_keys
            __props__.__dict__["chatbot_identifiers"] = chatbot_identifiers
            __props__.__dict__["chatbots"] = chatbots
            __props__.__dict__["child_agents"] = child_agents
            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["deployments"] = deployments
            __props__.__dict__["description"] = description
            __props__.__dict__["functions"] = functions
            __props__.__dict__["if_case"] = if_case
            if instruction is None and not opts.urn:
                raise TypeError("Missing required property 'instruction'")
            __props__.__dict__["instruction"] = instruction
            __props__.__dict__["k"] = k
            __props__.__dict__["knowledge_base_uuids"] = knowledge_base_uuids
            __props__.__dict__["knowledge_bases"] = knowledge_bases
            __props__.__dict__["max_tokens"] = max_tokens
            if model_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'model_uuid'")
            __props__.__dict__["model_uuid"] = model_uuid
            __props__.__dict__["models"] = models
            __props__.__dict__["name"] = name
            __props__.__dict__["open_ai_api_keys"] = open_ai_api_keys
            __props__.__dict__["open_ai_key_uuid"] = open_ai_key_uuid
            __props__.__dict__["parent_agents"] = parent_agents
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["provide_citations"] = provide_citations
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["retrieval_method"] = retrieval_method
            __props__.__dict__["route_created_by"] = route_created_by
            __props__.__dict__["route_name"] = route_name
            __props__.__dict__["route_uuid"] = route_uuid
            __props__.__dict__["tags"] = tags
            __props__.__dict__["temperature"] = temperature
            __props__.__dict__["templates"] = templates
            __props__.__dict__["top_p"] = top_p
            __props__.__dict__["url"] = url
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["route_created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(GenaiAgent, __self__).__init__(
            'digitalocean:index/genaiAgent:GenaiAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_guardrails: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentAgentGuardrailArgs', 'GenaiAgentAgentGuardrailArgsDict']]]]] = None,
            anthropic_api_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentAnthropicApiKeyArgs', 'GenaiAgentAnthropicApiKeyArgsDict']]]]] = None,
            anthropic_key_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            api_key_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentApiKeyInfoArgs', 'GenaiAgentApiKeyInfoArgsDict']]]]] = None,
            api_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentApiKeyArgs', 'GenaiAgentApiKeyArgsDict']]]]] = None,
            chatbot_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChatbotIdentifierArgs', 'GenaiAgentChatbotIdentifierArgsDict']]]]] = None,
            chatbots: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChatbotArgs', 'GenaiAgentChatbotArgsDict']]]]] = None,
            child_agents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChildAgentArgs', 'GenaiAgentChildAgentArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deployments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentDeploymentArgs', 'GenaiAgentDeploymentArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            functions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentFunctionArgs', 'GenaiAgentFunctionArgsDict']]]]] = None,
            if_case: Optional[pulumi.Input[_builtins.str]] = None,
            instruction: Optional[pulumi.Input[_builtins.str]] = None,
            k: Optional[pulumi.Input[_builtins.int]] = None,
            knowledge_base_uuids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            knowledge_bases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentKnowledgeBaseArgs', 'GenaiAgentKnowledgeBaseArgsDict']]]]] = None,
            max_tokens: Optional[pulumi.Input[_builtins.int]] = None,
            model_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            models: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentModelArgs', 'GenaiAgentModelArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            open_ai_api_keys: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentOpenAiApiKeyArgs', 'GenaiAgentOpenAiApiKeyArgsDict']]]]] = None,
            open_ai_key_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            parent_agents: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentParentAgentArgs', 'GenaiAgentParentAgentArgsDict']]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            provide_citations: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            retrieval_method: Optional[pulumi.Input[_builtins.str]] = None,
            route_created_at: Optional[pulumi.Input[_builtins.str]] = None,
            route_created_by: Optional[pulumi.Input[_builtins.str]] = None,
            route_name: Optional[pulumi.Input[_builtins.str]] = None,
            route_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            temperature: Optional[pulumi.Input[_builtins.float]] = None,
            templates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentTemplateArgs', 'GenaiAgentTemplateArgsDict']]]]] = None,
            top_p: Optional[pulumi.Input[_builtins.float]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'GenaiAgent':
        """
        Get an existing GenaiAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentAgentGuardrailArgs', 'GenaiAgentAgentGuardrailArgsDict']]]] agent_guardrails: AgentGuardrail represents a Guardrail attached to Gen AI Agent
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentAnthropicApiKeyArgs', 'GenaiAgentAnthropicApiKeyArgsDict']]]] anthropic_api_keys: Anthropic API Key information
        :param pulumi.Input[_builtins.str] anthropic_key_uuid: Optional Anthropic API key ID to use with Anthropic models
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentApiKeyInfoArgs', 'GenaiAgentApiKeyInfoArgsDict']]]] api_key_infos: List of API Key Infos
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentApiKeyArgs', 'GenaiAgentApiKeyArgsDict']]]] api_keys: List of API Keys
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChatbotIdentifierArgs', 'GenaiAgentChatbotIdentifierArgsDict']]]] chatbot_identifiers: List of Chatbot Identifiers
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChatbotArgs', 'GenaiAgentChatbotArgsDict']]]] chatbots: ChatBot configuration
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentChildAgentArgs', 'GenaiAgentChildAgentArgsDict']]]] child_agents: List of child agents
        :param pulumi.Input[_builtins.str] created_at: Timestamp when the Agent was created
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentDeploymentArgs', 'GenaiAgentDeploymentArgsDict']]]] deployments: List of API Key Infos
        :param pulumi.Input[_builtins.str] description: Description for the Agent
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentFunctionArgs', 'GenaiAgentFunctionArgsDict']]]] functions: List of Functions
        :param pulumi.Input[_builtins.str] if_case: If case condition
        :param pulumi.Input[_builtins.str] instruction: Instruction for the Agent
        :param pulumi.Input[_builtins.int] k: K value
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] knowledge_base_uuids: Ids of the knowledge base(s) to attach to the agent
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentKnowledgeBaseArgs', 'GenaiAgentKnowledgeBaseArgsDict']]]] knowledge_bases: List of Knowledge Bases
        :param pulumi.Input[_builtins.int] max_tokens: Maximum tokens allowed
        :param pulumi.Input[_builtins.str] model_uuid: Model UUID of the Agent
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentModelArgs', 'GenaiAgentModelArgsDict']]]] models: Model of the Agent
        :param pulumi.Input[_builtins.str] name: Name of the Agent
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentOpenAiApiKeyArgs', 'GenaiAgentOpenAiApiKeyArgsDict']]]] open_ai_api_keys: OpenAI API Key information
        :param pulumi.Input[_builtins.str] open_ai_key_uuid: Optional OpenAI API key ID to use with OpenAI models
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentParentAgentArgs', 'GenaiAgentParentAgentArgsDict']]]] parent_agents: List of child agents
        :param pulumi.Input[_builtins.str] project_id: Project ID of the Agent
        :param pulumi.Input[_builtins.bool] provide_citations: Indicates if the agent should provide citations in responses
        :param pulumi.Input[_builtins.str] region: Region where the Agent is deployed
        :param pulumi.Input[_builtins.str] retrieval_method: Retrieval method used
        :param pulumi.Input[_builtins.str] route_created_at: Timestamp when the route was created
        :param pulumi.Input[_builtins.str] route_created_by: User who created the route
        :param pulumi.Input[_builtins.str] route_name: Route name
        :param pulumi.Input[_builtins.str] route_uuid: Route UUID
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of Tags
        :param pulumi.Input[_builtins.float] temperature: Agent temperature setting
        :param pulumi.Input[Sequence[pulumi.Input[Union['GenaiAgentTemplateArgs', 'GenaiAgentTemplateArgsDict']]]] templates: Agent Template
        :param pulumi.Input[_builtins.float] top_p: Top P sampling parameter
        :param pulumi.Input[_builtins.str] updated_at: Timestamp when the Agent was updated
        :param pulumi.Input[_builtins.str] url: URL for the Agent
        :param pulumi.Input[_builtins.str] user_id: User ID linked with the Agent
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GenaiAgentState.__new__(_GenaiAgentState)

        __props__.__dict__["agent_guardrails"] = agent_guardrails
        __props__.__dict__["anthropic_api_keys"] = anthropic_api_keys
        __props__.__dict__["anthropic_key_uuid"] = anthropic_key_uuid
        __props__.__dict__["api_key_infos"] = api_key_infos
        __props__.__dict__["api_keys"] = api_keys
        __props__.__dict__["chatbot_identifiers"] = chatbot_identifiers
        __props__.__dict__["chatbots"] = chatbots
        __props__.__dict__["child_agents"] = child_agents
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deployments"] = deployments
        __props__.__dict__["description"] = description
        __props__.__dict__["functions"] = functions
        __props__.__dict__["if_case"] = if_case
        __props__.__dict__["instruction"] = instruction
        __props__.__dict__["k"] = k
        __props__.__dict__["knowledge_base_uuids"] = knowledge_base_uuids
        __props__.__dict__["knowledge_bases"] = knowledge_bases
        __props__.__dict__["max_tokens"] = max_tokens
        __props__.__dict__["model_uuid"] = model_uuid
        __props__.__dict__["models"] = models
        __props__.__dict__["name"] = name
        __props__.__dict__["open_ai_api_keys"] = open_ai_api_keys
        __props__.__dict__["open_ai_key_uuid"] = open_ai_key_uuid
        __props__.__dict__["parent_agents"] = parent_agents
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["provide_citations"] = provide_citations
        __props__.__dict__["region"] = region
        __props__.__dict__["retrieval_method"] = retrieval_method
        __props__.__dict__["route_created_at"] = route_created_at
        __props__.__dict__["route_created_by"] = route_created_by
        __props__.__dict__["route_name"] = route_name
        __props__.__dict__["route_uuid"] = route_uuid
        __props__.__dict__["tags"] = tags
        __props__.__dict__["temperature"] = temperature
        __props__.__dict__["templates"] = templates
        __props__.__dict__["top_p"] = top_p
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["url"] = url
        __props__.__dict__["user_id"] = user_id
        return GenaiAgent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentGuardrails")
    def agent_guardrails(self) -> pulumi.Output[Optional[Sequence['outputs.GenaiAgentAgentGuardrail']]]:
        """
        AgentGuardrail represents a Guardrail attached to Gen AI Agent
        """
        return pulumi.get(self, "agent_guardrails")

    @_builtins.property
    @pulumi.getter(name="anthropicApiKeys")
    def anthropic_api_keys(self) -> pulumi.Output[Optional[Sequence['outputs.GenaiAgentAnthropicApiKey']]]:
        """
        Anthropic API Key information
        """
        return pulumi.get(self, "anthropic_api_keys")

    @_builtins.property
    @pulumi.getter(name="anthropicKeyUuid")
    def anthropic_key_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional Anthropic API key ID to use with Anthropic models
        """
        return pulumi.get(self, "anthropic_key_uuid")

    @_builtins.property
    @pulumi.getter(name="apiKeyInfos")
    def api_key_infos(self) -> pulumi.Output[Optional[Sequence['outputs.GenaiAgentApiKeyInfo']]]:
        """
        List of API Key Infos
        """
        return pulumi.get(self, "api_key_infos")

    @_builtins.property
    @pulumi.getter(name="apiKeys")
    def api_keys(self) -> pulumi.Output[Optional[Sequence['outputs.GenaiAgentApiKey']]]:
        """
        List of API Keys
        """
        return pulumi.get(self, "api_keys")

    @_builtins.property
    @pulumi.getter(name="chatbotIdentifiers")
    def chatbot_identifiers(self) -> pulumi.Output[Optional[Sequence['outputs.GenaiAgentChatbotIdentifier']]]:
        """
        List of Chatbot Identifiers
        """
        return pulumi.get(self, "chatbot_identifiers")

    @_builtins.property
    @pulumi.getter
    def chatbots(self) -> pulumi.Output[Optional[Sequence['outputs.GenaiAgentChatbot']]]:
        """
        ChatBot configuration
        """
        return pulumi.get(self, "chatbots")

    @_builtins.property
    @pulumi.getter(name="childAgents")
    def child_agents(self) -> pulumi.Output[Sequence['outputs.GenaiAgentChildAgent']]:
        """
        List of child agents
        """
        return pulumi.get(self, "child_agents")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Timestamp when the Agent was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def deployments(self) -> pulumi.Output[Optional[Sequence['outputs.GenaiAgentDeployment']]]:
        """
        List of API Key Infos
        """
        return pulumi.get(self, "deployments")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description for the Agent
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def functions(self) -> pulumi.Output[Optional[Sequence['outputs.GenaiAgentFunction']]]:
        """
        List of Functions
        """
        return pulumi.get(self, "functions")

    @_builtins.property
    @pulumi.getter(name="ifCase")
    def if_case(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If case condition
        """
        return pulumi.get(self, "if_case")

    @_builtins.property
    @pulumi.getter
    def instruction(self) -> pulumi.Output[_builtins.str]:
        """
        Instruction for the Agent
        """
        return pulumi.get(self, "instruction")

    @_builtins.property
    @pulumi.getter
    def k(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        K value
        """
        return pulumi.get(self, "k")

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseUuids")
    def knowledge_base_uuids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Ids of the knowledge base(s) to attach to the agent
        """
        return pulumi.get(self, "knowledge_base_uuids")

    @_builtins.property
    @pulumi.getter(name="knowledgeBases")
    def knowledge_bases(self) -> pulumi.Output[Sequence['outputs.GenaiAgentKnowledgeBase']]:
        """
        List of Knowledge Bases
        """
        return pulumi.get(self, "knowledge_bases")

    @_builtins.property
    @pulumi.getter(name="maxTokens")
    def max_tokens(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum tokens allowed
        """
        return pulumi.get(self, "max_tokens")

    @_builtins.property
    @pulumi.getter(name="modelUuid")
    def model_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        Model UUID of the Agent
        """
        return pulumi.get(self, "model_uuid")

    @_builtins.property
    @pulumi.getter
    def models(self) -> pulumi.Output[Sequence['outputs.GenaiAgentModel']]:
        """
        Model of the Agent
        """
        return pulumi.get(self, "models")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Agent
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="openAiApiKeys")
    def open_ai_api_keys(self) -> pulumi.Output[Optional[Sequence['outputs.GenaiAgentOpenAiApiKey']]]:
        """
        OpenAI API Key information
        """
        return pulumi.get(self, "open_ai_api_keys")

    @_builtins.property
    @pulumi.getter(name="openAiKeyUuid")
    def open_ai_key_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional OpenAI API key ID to use with OpenAI models
        """
        return pulumi.get(self, "open_ai_key_uuid")

    @_builtins.property
    @pulumi.getter(name="parentAgents")
    def parent_agents(self) -> pulumi.Output[Sequence['outputs.GenaiAgentParentAgent']]:
        """
        List of child agents
        """
        return pulumi.get(self, "parent_agents")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Project ID of the Agent
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="provideCitations")
    def provide_citations(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if the agent should provide citations in responses
        """
        return pulumi.get(self, "provide_citations")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where the Agent is deployed
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="retrievalMethod")
    def retrieval_method(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Retrieval method used
        """
        return pulumi.get(self, "retrieval_method")

    @_builtins.property
    @pulumi.getter(name="routeCreatedAt")
    def route_created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the route was created
        """
        return pulumi.get(self, "route_created_at")

    @_builtins.property
    @pulumi.getter(name="routeCreatedBy")
    def route_created_by(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User who created the route
        """
        return pulumi.get(self, "route_created_by")

    @_builtins.property
    @pulumi.getter(name="routeName")
    def route_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Route name
        """
        return pulumi.get(self, "route_name")

    @_builtins.property
    @pulumi.getter(name="routeUuid")
    def route_uuid(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Route UUID
        """
        return pulumi.get(self, "route_uuid")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of Tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def temperature(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Agent temperature setting
        """
        return pulumi.get(self, "temperature")

    @_builtins.property
    @pulumi.getter
    def templates(self) -> pulumi.Output[Optional[Sequence['outputs.GenaiAgentTemplate']]]:
        """
        Agent Template
        """
        return pulumi.get(self, "templates")

    @_builtins.property
    @pulumi.getter(name="topP")
    def top_p(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        Top P sampling parameter
        """
        return pulumi.get(self, "top_p")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the Agent was updated
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL for the Agent
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User ID linked with the Agent
        """
        return pulumi.get(self, "user_id")

