# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GenaiFunctionArgs', 'GenaiFunction']

@pulumi.input_type
class GenaiFunctionArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[_builtins.str],
                 description: pulumi.Input[_builtins.str],
                 faas_namespace: pulumi.Input[_builtins.str],
                 function_name: pulumi.Input[_builtins.str],
                 input_schema: pulumi.Input[_builtins.str],
                 faas_name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_schema: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GenaiFunction resource.
        :param pulumi.Input[_builtins.str] agent_id: The name of the GenAI resource.
        :param pulumi.Input[_builtins.str] description: The region where the GenAI resource will be created.
        :param pulumi.Input[_builtins.str] faas_namespace: The current status of the GenAI resource.
        :param pulumi.Input[_builtins.str] function_name: The creation timestamp of the GenAI resource.
        :param pulumi.Input[_builtins.str] input_schema: The input schema of the GenAI resource.
        :param pulumi.Input[_builtins.str] faas_name: The model to use for the GenAI resource.
        :param pulumi.Input[_builtins.str] output_schema: The output schema of the GenAI resource.
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "faas_namespace", faas_namespace)
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "input_schema", input_schema)
        if faas_name is not None:
            pulumi.set(__self__, "faas_name", faas_name)
        if output_schema is not None:
            pulumi.set(__self__, "output_schema", output_schema)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the GenAI resource.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The region where the GenAI resource will be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="faasNamespace")
    def faas_namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The current status of the GenAI resource.
        """
        return pulumi.get(self, "faas_namespace")

    @faas_namespace.setter
    def faas_namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "faas_namespace", value)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[_builtins.str]:
        """
        The creation timestamp of the GenAI resource.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="inputSchema")
    def input_schema(self) -> pulumi.Input[_builtins.str]:
        """
        The input schema of the GenAI resource.
        """
        return pulumi.get(self, "input_schema")

    @input_schema.setter
    def input_schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "input_schema", value)

    @_builtins.property
    @pulumi.getter(name="faasName")
    def faas_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model to use for the GenAI resource.
        """
        return pulumi.get(self, "faas_name")

    @faas_name.setter
    def faas_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "faas_name", value)

    @_builtins.property
    @pulumi.getter(name="outputSchema")
    def output_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The output schema of the GenAI resource.
        """
        return pulumi.get(self, "output_schema")

    @output_schema.setter
    def output_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_schema", value)


@pulumi.input_type
class _GenaiFunctionState:
    def __init__(__self__, *,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 faas_name: Optional[pulumi.Input[_builtins.str]] = None,
                 faas_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 function_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 input_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 output_schema: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GenaiFunction resources.
        :param pulumi.Input[_builtins.str] agent_id: The name of the GenAI resource.
        :param pulumi.Input[_builtins.str] description: The region where the GenAI resource will be created.
        :param pulumi.Input[_builtins.str] faas_name: The model to use for the GenAI resource.
        :param pulumi.Input[_builtins.str] faas_namespace: The current status of the GenAI resource.
        :param pulumi.Input[_builtins.str] function_name: The creation timestamp of the GenAI resource.
        :param pulumi.Input[_builtins.str] function_uuid: The unique identifier of the GenAI function.
        :param pulumi.Input[_builtins.str] input_schema: The input schema of the GenAI resource.
        :param pulumi.Input[_builtins.str] output_schema: The output schema of the GenAI resource.
        """
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if faas_name is not None:
            pulumi.set(__self__, "faas_name", faas_name)
        if faas_namespace is not None:
            pulumi.set(__self__, "faas_namespace", faas_namespace)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if function_uuid is not None:
            pulumi.set(__self__, "function_uuid", function_uuid)
        if input_schema is not None:
            pulumi.set(__self__, "input_schema", input_schema)
        if output_schema is not None:
            pulumi.set(__self__, "output_schema", output_schema)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the GenAI resource.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the GenAI resource will be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="faasName")
    def faas_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model to use for the GenAI resource.
        """
        return pulumi.get(self, "faas_name")

    @faas_name.setter
    def faas_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "faas_name", value)

    @_builtins.property
    @pulumi.getter(name="faasNamespace")
    def faas_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the GenAI resource.
        """
        return pulumi.get(self, "faas_namespace")

    @faas_namespace.setter
    def faas_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "faas_namespace", value)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of the GenAI resource.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="functionUuid")
    def function_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the GenAI function.
        """
        return pulumi.get(self, "function_uuid")

    @function_uuid.setter
    def function_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_uuid", value)

    @_builtins.property
    @pulumi.getter(name="inputSchema")
    def input_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The input schema of the GenAI resource.
        """
        return pulumi.get(self, "input_schema")

    @input_schema.setter
    def input_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "input_schema", value)

    @_builtins.property
    @pulumi.getter(name="outputSchema")
    def output_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The output schema of the GenAI resource.
        """
        return pulumi.get(self, "output_schema")

    @output_schema.setter
    def output_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "output_schema", value)


@pulumi.type_token("digitalocean:index/genaiFunction:GenaiFunction")
class GenaiFunction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 faas_name: Optional[pulumi.Input[_builtins.str]] = None,
                 faas_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 input_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 output_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a GenaiFunction resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_id: The name of the GenAI resource.
        :param pulumi.Input[_builtins.str] description: The region where the GenAI resource will be created.
        :param pulumi.Input[_builtins.str] faas_name: The model to use for the GenAI resource.
        :param pulumi.Input[_builtins.str] faas_namespace: The current status of the GenAI resource.
        :param pulumi.Input[_builtins.str] function_name: The creation timestamp of the GenAI resource.
        :param pulumi.Input[_builtins.str] input_schema: The input schema of the GenAI resource.
        :param pulumi.Input[_builtins.str] output_schema: The output schema of the GenAI resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GenaiFunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a GenaiFunction resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GenaiFunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GenaiFunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 faas_name: Optional[pulumi.Input[_builtins.str]] = None,
                 faas_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 input_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 output_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GenaiFunctionArgs.__new__(GenaiFunctionArgs)

            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["faas_name"] = faas_name
            if faas_namespace is None and not opts.urn:
                raise TypeError("Missing required property 'faas_namespace'")
            __props__.__dict__["faas_namespace"] = faas_namespace
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            if input_schema is None and not opts.urn:
                raise TypeError("Missing required property 'input_schema'")
            __props__.__dict__["input_schema"] = input_schema
            __props__.__dict__["output_schema"] = output_schema
            __props__.__dict__["function_uuid"] = None
        super(GenaiFunction, __self__).__init__(
            'digitalocean:index/genaiFunction:GenaiFunction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            faas_name: Optional[pulumi.Input[_builtins.str]] = None,
            faas_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            function_name: Optional[pulumi.Input[_builtins.str]] = None,
            function_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            input_schema: Optional[pulumi.Input[_builtins.str]] = None,
            output_schema: Optional[pulumi.Input[_builtins.str]] = None) -> 'GenaiFunction':
        """
        Get an existing GenaiFunction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_id: The name of the GenAI resource.
        :param pulumi.Input[_builtins.str] description: The region where the GenAI resource will be created.
        :param pulumi.Input[_builtins.str] faas_name: The model to use for the GenAI resource.
        :param pulumi.Input[_builtins.str] faas_namespace: The current status of the GenAI resource.
        :param pulumi.Input[_builtins.str] function_name: The creation timestamp of the GenAI resource.
        :param pulumi.Input[_builtins.str] function_uuid: The unique identifier of the GenAI function.
        :param pulumi.Input[_builtins.str] input_schema: The input schema of the GenAI resource.
        :param pulumi.Input[_builtins.str] output_schema: The output schema of the GenAI resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GenaiFunctionState.__new__(_GenaiFunctionState)

        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["description"] = description
        __props__.__dict__["faas_name"] = faas_name
        __props__.__dict__["faas_namespace"] = faas_namespace
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["function_uuid"] = function_uuid
        __props__.__dict__["input_schema"] = input_schema
        __props__.__dict__["output_schema"] = output_schema
        return GenaiFunction(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the GenAI resource.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the GenAI resource will be created.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="faasName")
    def faas_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The model to use for the GenAI resource.
        """
        return pulumi.get(self, "faas_name")

    @_builtins.property
    @pulumi.getter(name="faasNamespace")
    def faas_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the GenAI resource.
        """
        return pulumi.get(self, "faas_namespace")

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of the GenAI resource.
        """
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter(name="functionUuid")
    def function_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the GenAI function.
        """
        return pulumi.get(self, "function_uuid")

    @_builtins.property
    @pulumi.getter(name="inputSchema")
    def input_schema(self) -> pulumi.Output[_builtins.str]:
        """
        The input schema of the GenAI resource.
        """
        return pulumi.get(self, "input_schema")

    @_builtins.property
    @pulumi.getter(name="outputSchema")
    def output_schema(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The output schema of the GenAI resource.
        """
        return pulumi.get(self, "output_schema")

