# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GenaiKnowledgeBaseDataSourceInitArgs', 'GenaiKnowledgeBaseDataSource']

@pulumi.input_type
class GenaiKnowledgeBaseDataSourceInitArgs:
    def __init__(__self__, *,
                 knowledge_base_uuid: pulumi.Input[_builtins.str],
                 spaces_data_source: Optional[pulumi.Input['GenaiKnowledgeBaseDataSourceSpacesDataSourceArgs']] = None,
                 web_crawler_data_source: Optional[pulumi.Input['GenaiKnowledgeBaseDataSourceWebCrawlerDataSourceArgs']] = None):
        """
        The set of arguments for constructing a GenaiKnowledgeBaseDataSource resource.
        :param pulumi.Input[_builtins.str] knowledge_base_uuid: UUID of the Knowledge Base
        """
        pulumi.set(__self__, "knowledge_base_uuid", knowledge_base_uuid)
        if spaces_data_source is not None:
            pulumi.set(__self__, "spaces_data_source", spaces_data_source)
        if web_crawler_data_source is not None:
            pulumi.set(__self__, "web_crawler_data_source", web_crawler_data_source)

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseUuid")
    def knowledge_base_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        UUID of the Knowledge Base
        """
        return pulumi.get(self, "knowledge_base_uuid")

    @knowledge_base_uuid.setter
    def knowledge_base_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "knowledge_base_uuid", value)

    @_builtins.property
    @pulumi.getter(name="spacesDataSource")
    def spaces_data_source(self) -> Optional[pulumi.Input['GenaiKnowledgeBaseDataSourceSpacesDataSourceArgs']]:
        return pulumi.get(self, "spaces_data_source")

    @spaces_data_source.setter
    def spaces_data_source(self, value: Optional[pulumi.Input['GenaiKnowledgeBaseDataSourceSpacesDataSourceArgs']]):
        pulumi.set(self, "spaces_data_source", value)

    @_builtins.property
    @pulumi.getter(name="webCrawlerDataSource")
    def web_crawler_data_source(self) -> Optional[pulumi.Input['GenaiKnowledgeBaseDataSourceWebCrawlerDataSourceArgs']]:
        return pulumi.get(self, "web_crawler_data_source")

    @web_crawler_data_source.setter
    def web_crawler_data_source(self, value: Optional[pulumi.Input['GenaiKnowledgeBaseDataSourceWebCrawlerDataSourceArgs']]):
        pulumi.set(self, "web_crawler_data_source", value)


@pulumi.input_type
class _GenaiKnowledgeBaseDataSourceState:
    def __init__(__self__, *,
                 knowledge_base_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 spaces_data_source: Optional[pulumi.Input['GenaiKnowledgeBaseDataSourceSpacesDataSourceArgs']] = None,
                 web_crawler_data_source: Optional[pulumi.Input['GenaiKnowledgeBaseDataSourceWebCrawlerDataSourceArgs']] = None):
        """
        Input properties used for looking up and filtering GenaiKnowledgeBaseDataSource resources.
        :param pulumi.Input[_builtins.str] knowledge_base_uuid: UUID of the Knowledge Base
        """
        if knowledge_base_uuid is not None:
            pulumi.set(__self__, "knowledge_base_uuid", knowledge_base_uuid)
        if spaces_data_source is not None:
            pulumi.set(__self__, "spaces_data_source", spaces_data_source)
        if web_crawler_data_source is not None:
            pulumi.set(__self__, "web_crawler_data_source", web_crawler_data_source)

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseUuid")
    def knowledge_base_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID of the Knowledge Base
        """
        return pulumi.get(self, "knowledge_base_uuid")

    @knowledge_base_uuid.setter
    def knowledge_base_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "knowledge_base_uuid", value)

    @_builtins.property
    @pulumi.getter(name="spacesDataSource")
    def spaces_data_source(self) -> Optional[pulumi.Input['GenaiKnowledgeBaseDataSourceSpacesDataSourceArgs']]:
        return pulumi.get(self, "spaces_data_source")

    @spaces_data_source.setter
    def spaces_data_source(self, value: Optional[pulumi.Input['GenaiKnowledgeBaseDataSourceSpacesDataSourceArgs']]):
        pulumi.set(self, "spaces_data_source", value)

    @_builtins.property
    @pulumi.getter(name="webCrawlerDataSource")
    def web_crawler_data_source(self) -> Optional[pulumi.Input['GenaiKnowledgeBaseDataSourceWebCrawlerDataSourceArgs']]:
        return pulumi.get(self, "web_crawler_data_source")

    @web_crawler_data_source.setter
    def web_crawler_data_source(self, value: Optional[pulumi.Input['GenaiKnowledgeBaseDataSourceWebCrawlerDataSourceArgs']]):
        pulumi.set(self, "web_crawler_data_source", value)


@pulumi.type_token("digitalocean:index/genaiKnowledgeBaseDataSource:GenaiKnowledgeBaseDataSource")
class GenaiKnowledgeBaseDataSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 knowledge_base_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 spaces_data_source: Optional[pulumi.Input[Union['GenaiKnowledgeBaseDataSourceSpacesDataSourceArgs', 'GenaiKnowledgeBaseDataSourceSpacesDataSourceArgsDict']]] = None,
                 web_crawler_data_source: Optional[pulumi.Input[Union['GenaiKnowledgeBaseDataSourceWebCrawlerDataSourceArgs', 'GenaiKnowledgeBaseDataSourceWebCrawlerDataSourceArgsDict']]] = None,
                 __props__=None):
        """
        Create a GenaiKnowledgeBaseDataSource resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] knowledge_base_uuid: UUID of the Knowledge Base
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GenaiKnowledgeBaseDataSourceInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a GenaiKnowledgeBaseDataSource resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GenaiKnowledgeBaseDataSourceInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GenaiKnowledgeBaseDataSourceInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 knowledge_base_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 spaces_data_source: Optional[pulumi.Input[Union['GenaiKnowledgeBaseDataSourceSpacesDataSourceArgs', 'GenaiKnowledgeBaseDataSourceSpacesDataSourceArgsDict']]] = None,
                 web_crawler_data_source: Optional[pulumi.Input[Union['GenaiKnowledgeBaseDataSourceWebCrawlerDataSourceArgs', 'GenaiKnowledgeBaseDataSourceWebCrawlerDataSourceArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GenaiKnowledgeBaseDataSourceInitArgs.__new__(GenaiKnowledgeBaseDataSourceInitArgs)

            if knowledge_base_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'knowledge_base_uuid'")
            __props__.__dict__["knowledge_base_uuid"] = knowledge_base_uuid
            __props__.__dict__["spaces_data_source"] = spaces_data_source
            __props__.__dict__["web_crawler_data_source"] = web_crawler_data_source
        super(GenaiKnowledgeBaseDataSource, __self__).__init__(
            'digitalocean:index/genaiKnowledgeBaseDataSource:GenaiKnowledgeBaseDataSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            knowledge_base_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            spaces_data_source: Optional[pulumi.Input[Union['GenaiKnowledgeBaseDataSourceSpacesDataSourceArgs', 'GenaiKnowledgeBaseDataSourceSpacesDataSourceArgsDict']]] = None,
            web_crawler_data_source: Optional[pulumi.Input[Union['GenaiKnowledgeBaseDataSourceWebCrawlerDataSourceArgs', 'GenaiKnowledgeBaseDataSourceWebCrawlerDataSourceArgsDict']]] = None) -> 'GenaiKnowledgeBaseDataSource':
        """
        Get an existing GenaiKnowledgeBaseDataSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] knowledge_base_uuid: UUID of the Knowledge Base
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GenaiKnowledgeBaseDataSourceState.__new__(_GenaiKnowledgeBaseDataSourceState)

        __props__.__dict__["knowledge_base_uuid"] = knowledge_base_uuid
        __props__.__dict__["spaces_data_source"] = spaces_data_source
        __props__.__dict__["web_crawler_data_source"] = web_crawler_data_source
        return GenaiKnowledgeBaseDataSource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="knowledgeBaseUuid")
    def knowledge_base_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        UUID of the Knowledge Base
        """
        return pulumi.get(self, "knowledge_base_uuid")

    @_builtins.property
    @pulumi.getter(name="spacesDataSource")
    def spaces_data_source(self) -> pulumi.Output[Optional['outputs.GenaiKnowledgeBaseDataSourceSpacesDataSource']]:
        return pulumi.get(self, "spaces_data_source")

    @_builtins.property
    @pulumi.getter(name="webCrawlerDataSource")
    def web_crawler_data_source(self) -> pulumi.Output[Optional['outputs.GenaiKnowledgeBaseDataSourceWebCrawlerDataSource']]:
        return pulumi.get(self, "web_crawler_data_source")

