# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDatabaseMetricsCredentialsResult',
    'AwaitableGetDatabaseMetricsCredentialsResult',
    'get_database_metrics_credentials',
    'get_database_metrics_credentials_output',
]

@pulumi.output_type
class GetDatabaseMetricsCredentialsResult:
    """
    A collection of values returned by getDatabaseMetricsCredentials.
    """
    def __init__(__self__, id=None, password=None, username=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for accessing database metrics. This is marked as sensitive.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username for accessing database metrics.
        """
        return pulumi.get(self, "username")


class AwaitableGetDatabaseMetricsCredentialsResult(GetDatabaseMetricsCredentialsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseMetricsCredentialsResult(
            id=self.id,
            password=self.password,
            username=self.username)


def get_database_metrics_credentials(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseMetricsCredentialsResult:
    """
    Provides access to the metrics credentials for DigitalOcean database clusters. These credentials are account-wide and can be used to access metrics for any database cluster in the account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    example = digitalocean.get_database_metrics_credentials()
    pulumi.export("metricsUsername", example.username)
    pulumi.export("metricsPassword", example.password)
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getDatabaseMetricsCredentials:getDatabaseMetricsCredentials', __args__, opts=opts, typ=GetDatabaseMetricsCredentialsResult).value

    return AwaitableGetDatabaseMetricsCredentialsResult(
        id=pulumi.get(__ret__, 'id'),
        password=pulumi.get(__ret__, 'password'),
        username=pulumi.get(__ret__, 'username'))
def get_database_metrics_credentials_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseMetricsCredentialsResult]:
    """
    Provides access to the metrics credentials for DigitalOcean database clusters. These credentials are account-wide and can be used to access metrics for any database cluster in the account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    example = digitalocean.get_database_metrics_credentials()
    pulumi.export("metricsUsername", example.username)
    pulumi.export("metricsPassword", example.password)
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('digitalocean:index/getDatabaseMetricsCredentials:getDatabaseMetricsCredentials', __args__, opts=opts, typ=GetDatabaseMetricsCredentialsResult)
    return __ret__.apply(lambda __response__: GetDatabaseMetricsCredentialsResult(
        id=pulumi.get(__response__, 'id'),
        password=pulumi.get(__response__, 'password'),
        username=pulumi.get(__response__, 'username')))
