# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSpacesKeyResult',
    'AwaitableGetSpacesKeyResult',
    'get_spaces_key',
    'get_spaces_key_output',
]

@pulumi.output_type
class GetSpacesKeyResult:
    """
    A collection of values returned by getSpacesKey.
    """
    def __init__(__self__, access_key=None, created_at=None, grants=None, id=None, name=None):
        if access_key and not isinstance(access_key, str):
            raise TypeError("Expected argument 'access_key' to be a str")
        pulumi.set(__self__, "access_key", access_key)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if grants and not isinstance(grants, list):
            raise TypeError("Expected argument 'grants' to be a list")
        pulumi.set(__self__, "grants", grants)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> _builtins.str:
        """
        The access key ID of the Spaces key
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation time of the Spaces key
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def grants(self) -> Sequence['outputs.GetSpacesKeyGrantResult']:
        """
        The list of grants associated with the Spaces key.
        """
        return pulumi.get(self, "grants")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Spaces key
        """
        return pulumi.get(self, "name")


class AwaitableGetSpacesKeyResult(GetSpacesKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSpacesKeyResult(
            access_key=self.access_key,
            created_at=self.created_at,
            grants=self.grants,
            id=self.id,
            name=self.name)


def get_spaces_key(access_key: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSpacesKeyResult:
    """
    ## Example Usage

    Get the key by access key ID:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    example = digitalocean.get_spaces_key(access_key="ACCESS_KEY_ID")
    pulumi.export("keyGrants", example.grants)
    ```


    :param _builtins.str access_key: The Access Key ID of the Spaces key.
    """
    __args__ = dict()
    __args__['accessKey'] = access_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getSpacesKey:getSpacesKey', __args__, opts=opts, typ=GetSpacesKeyResult).value

    return AwaitableGetSpacesKeyResult(
        access_key=pulumi.get(__ret__, 'access_key'),
        created_at=pulumi.get(__ret__, 'created_at'),
        grants=pulumi.get(__ret__, 'grants'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_spaces_key_output(access_key: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSpacesKeyResult]:
    """
    ## Example Usage

    Get the key by access key ID:

    ```python
    import pulumi
    import pulumi_digitalocean as digitalocean

    example = digitalocean.get_spaces_key(access_key="ACCESS_KEY_ID")
    pulumi.export("keyGrants", example.grants)
    ```


    :param _builtins.str access_key: The Access Key ID of the Spaces key.
    """
    __args__ = dict()
    __args__['accessKey'] = access_key
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('digitalocean:index/getSpacesKey:getSpacesKey', __args__, opts=opts, typ=GetSpacesKeyResult)
    return __ret__.apply(lambda __response__: GetSpacesKeyResult(
        access_key=pulumi.get(__response__, 'access_key'),
        created_at=pulumi.get(__response__, 'created_at'),
        grants=pulumi.get(__response__, 'grants'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
