# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VpcPeeringArgs', 'VpcPeering']

@pulumi.input_type
class VpcPeeringArgs:
    def __init__(__self__, *,
                 vpc_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VpcPeering resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_ids: A set of two VPC IDs to be peered.
        :param pulumi.Input[_builtins.str] name: A name for the VPC Peering. Must be unique and contain alphanumeric characters, dashes, and periods only.
        """
        pulumi.set(__self__, "vpc_ids", vpc_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A set of two VPC IDs to be peered.
        """
        return pulumi.get(self, "vpc_ids")

    @vpc_ids.setter
    def vpc_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "vpc_ids", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the VPC Peering. Must be unique and contain alphanumeric characters, dashes, and periods only.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _VpcPeeringState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering VpcPeering resources.
        :param pulumi.Input[_builtins.str] created_at: The date and time of when the VPC Peering was created.
        :param pulumi.Input[_builtins.str] name: A name for the VPC Peering. Must be unique and contain alphanumeric characters, dashes, and periods only.
        :param pulumi.Input[_builtins.str] status: The status of the VPC Peering.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_ids: A set of two VPC IDs to be peered.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_ids is not None:
            pulumi.set(__self__, "vpc_ids", vpc_ids)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of when the VPC Peering was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A name for the VPC Peering. Must be unique and contain alphanumeric characters, dashes, and periods only.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the VPC Peering.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of two VPC IDs to be peered.
        """
        return pulumi.get(self, "vpc_ids")

    @vpc_ids.setter
    def vpc_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vpc_ids", value)


@pulumi.type_token("digitalocean:index/vpcPeering:VpcPeering")
class VpcPeering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a DigitalOcean VPC Peering resource.

        VPC Peerings are used to connect two VPC networks allowing resources in each
        VPC to communicate with each other privately.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        example = digitalocean.VpcPeering("example",
            name="example-peering",
            vpc_ids=[
                vpc1["id"],
                vpc2["id"],
            ])
        ```

        ### Resource Assignment

        You can use the VPC Peering resource to allow communication between resources
        in different VPCs. For example:

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        vpc1 = digitalocean.Vpc("vpc1",
            name="vpc1",
            region="nyc3")
        vpc2 = digitalocean.Vpc("vpc2",
            name="vpc2",
            region="nyc3")
        example = digitalocean.VpcPeering("example",
            name="example-peering",
            vpc_ids=[
                vpc1.id,
                vpc2.id,
            ])
        example1 = digitalocean.Droplet("example1",
            name="example1",
            size=digitalocean.DropletSlug.DROPLET_S1_VCPU1_GB,
            image="ubuntu-18-04-x64",
            region=digitalocean.Region.NYC3,
            vpc_uuid=vpc1.id)
        example2 = digitalocean.Droplet("example2",
            name="example2",
            size=digitalocean.DropletSlug.DROPLET_S1_VCPU1_GB,
            image="ubuntu-18-04-x64",
            region=digitalocean.Region.NYC3,
            vpc_uuid=vpc2.id)
        ```

        ## Import

        A VPC Peering can be imported using its `id`, e.g.

        ```sh
        $ pulumi import digitalocean:index/vpcPeering:VpcPeering example 771ad360-c017-4b4e-a34e-73934f5f0190
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: A name for the VPC Peering. Must be unique and contain alphanumeric characters, dashes, and periods only.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_ids: A set of two VPC IDs to be peered.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcPeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DigitalOcean VPC Peering resource.

        VPC Peerings are used to connect two VPC networks allowing resources in each
        VPC to communicate with each other privately.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        example = digitalocean.VpcPeering("example",
            name="example-peering",
            vpc_ids=[
                vpc1["id"],
                vpc2["id"],
            ])
        ```

        ### Resource Assignment

        You can use the VPC Peering resource to allow communication between resources
        in different VPCs. For example:

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        vpc1 = digitalocean.Vpc("vpc1",
            name="vpc1",
            region="nyc3")
        vpc2 = digitalocean.Vpc("vpc2",
            name="vpc2",
            region="nyc3")
        example = digitalocean.VpcPeering("example",
            name="example-peering",
            vpc_ids=[
                vpc1.id,
                vpc2.id,
            ])
        example1 = digitalocean.Droplet("example1",
            name="example1",
            size=digitalocean.DropletSlug.DROPLET_S1_VCPU1_GB,
            image="ubuntu-18-04-x64",
            region=digitalocean.Region.NYC3,
            vpc_uuid=vpc1.id)
        example2 = digitalocean.Droplet("example2",
            name="example2",
            size=digitalocean.DropletSlug.DROPLET_S1_VCPU1_GB,
            image="ubuntu-18-04-x64",
            region=digitalocean.Region.NYC3,
            vpc_uuid=vpc2.id)
        ```

        ## Import

        A VPC Peering can be imported using its `id`, e.g.

        ```sh
        $ pulumi import digitalocean:index/vpcPeering:VpcPeering example 771ad360-c017-4b4e-a34e-73934f5f0190
        ```

        :param str resource_name: The name of the resource.
        :param VpcPeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcPeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcPeeringArgs.__new__(VpcPeeringArgs)

            __props__.__dict__["name"] = name
            if vpc_ids is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_ids'")
            __props__.__dict__["vpc_ids"] = vpc_ids
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
        super(VpcPeering, __self__).__init__(
            'digitalocean:index/vpcPeering:VpcPeering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'VpcPeering':
        """
        Get an existing VpcPeering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The date and time of when the VPC Peering was created.
        :param pulumi.Input[_builtins.str] name: A name for the VPC Peering. Must be unique and contain alphanumeric characters, dashes, and periods only.
        :param pulumi.Input[_builtins.str] status: The status of the VPC Peering.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vpc_ids: A set of two VPC IDs to be peered.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcPeeringState.__new__(_VpcPeeringState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_ids"] = vpc_ids
        return VpcPeering(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of when the VPC Peering was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A name for the VPC Peering. Must be unique and contain alphanumeric characters, dashes, and periods only.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the VPC Peering.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A set of two VPC IDs to be peered.
        """
        return pulumi.get(self, "vpc_ids")

