## 2025-10-30 — Autonomy & Harness Refresh

- Routed every production response through a new `_finalize_interaction` helper so the agent always records conversation history, memory, workflow logs, and archive summaries (even when the backend returns the answer).
- Regenerated the beta showcase harness artifact. Twelve showcase scenarios now pass with a 100 % guardrail rate; conversation memory writes a JSON file again.
- Updated docs so the live commands match reality (`PYTHONPATH=. python3 -m scripts.run_beta_showcase`, `python3 -m cite_agent.cli --metrics/--token-report`, etc.).
- Local verification: `tests/enhanced/test_conversation_archive.py` and the full autonomy harness suite (`tests/enhanced/test_autonomy_harness.py`) pass once `pytest-asyncio` is installed. Full `python3 -m pytest` still requires the Heroku backend/Redis/Mongo stack.
- Windows installer polish: removed the legacy batch installer, added guard rails to `Install-CiteAgent.ps1`, updated shortcuts to use the smarter `cite-agent.bat`, and documented the Inno Setup flow (`windows_installer/README.md`).
- Next focus areas: automate the showcase run in CI, rebuild `Cite-Agent-Installer-v2.0.exe`, and smoke-test on a clean Windows VM.
